/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.telemetry.Bonn_shutter_DeviceTelemetry;
import org.lsst.sal.atcamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.atcamera.telemetry.PowerTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)1, (int)148515164);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)1, (int)840243423);
        double[] oDV = TestHelper.generateDoubleArray((int)1, (int)563761626);
        double[] oGV = TestHelper.generateDoubleArray((int)1, (int)759116416);
        double[] rDV = TestHelper.generateDoubleArray((int)1, (int)788596976);
        double[] temp = TestHelper.generateDoubleArray((int)1, (int)-1599934545);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)1, (int)1885039279);
        double[] anaV = TestHelper.generateDoubleArray((int)1, (int)-37150657);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)1, (int)1163260627);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)1, (int)780370091);
        double[] clkHI = TestHelper.generateDoubleArray((int)1, (int)395780755);
        double[] clkHV = TestHelper.generateDoubleArray((int)1, (int)1722735521);
        double[] clkLV = TestHelper.generateDoubleArray((int)1, (int)73798779);
        double[] digI = TestHelper.generateDoubleArray((int)1, (int)-1852944346);
        double[] digV = TestHelper.generateDoubleArray((int)1, (int)1287618989);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)1, (int)138701521);
        double[] htrPI = TestHelper.generateDoubleArray((int)1, (int)2005252235);
        double[] htrPV = TestHelper.generateDoubleArray((int)1, (int)-22611981);
        double[] htrV = TestHelper.generateDoubleArray((int)1, (int)-1551168816);
        double[] htrW = TestHelper.generateDoubleArray((int)1, (int)-1604215385);
        String location = "o";
        double[] oDI = TestHelper.generateDoubleArray((int)1, (int)829820962);
        double[] oDV = TestHelper.generateDoubleArray((int)1, (int)-1716621437);
        double[] pClk0 = TestHelper.generateDoubleArray((int)1, (int)-1539542638);
        double[] pClkL = TestHelper.generateDoubleArray((int)1, (int)-499654975);
        double[] pClkU = TestHelper.generateDoubleArray((int)1, (int)-1343083011);
        double[] power = TestHelper.generateDoubleArray((int)1, (int)1148400220);
        double[] rG0 = TestHelper.generateDoubleArray((int)1, (int)216951033);
        double[] rGL = TestHelper.generateDoubleArray((int)1, (int)-2080621705);
        double[] rGU = TestHelper.generateDoubleArray((int)1, (int)2069368857);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)1, (int)-1881680104);
        double[] sClk0 = TestHelper.generateDoubleArray((int)1, (int)235485938);
        double[] sClkL = TestHelper.generateDoubleArray((int)1, (int)-801173103);
        double[] sClkU = TestHelper.generateDoubleArray((int)1, (int)-682760982);
        double[] temp1 = TestHelper.generateDoubleArray((int)1, (int)1298065181);
        double[] temp2 = TestHelper.generateDoubleArray((int)1, (int)-1501822685);
        double[] temp3 = TestHelper.generateDoubleArray((int)1, (int)-177193494);
        double[] temp4 = TestHelper.generateDoubleArray((int)1, (int)-812178618);
        double[] temp5 = TestHelper.generateDoubleArray((int)1, (int)1966887);
        double[] temp6 = TestHelper.generateDoubleArray((int)1, (int)1206148091);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicu_Temp0, clkHI, clkHV, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClkL, pClkU, power, rG0, rGL, rGU, rTDTemp, sClk0, sClkL, sClkU, temp1, temp2, temp3, temp4, temp5, temp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.4031602740287781;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.4547199010848999;
        double freeFraction = 0.9335781931877136;
        double freeSpace = 0.6341502070426941;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePowerTelemetry() throws Exception {
        double analog_I = 0.9904511570930481;
        double analog_V = 0.30330485105514526;
        double aux_I = 0.9470493793487549;
        double aux_V = 0.9195677042007446;
        double clkhigh_I = 0.3380838632583618;
        double clkhigh_V = 0.3089866042137146;
        double clklow_I = 0.1393022f;
        double clklow_V = 0.2666983f;
        double dphi_I = 0.605151891708374;
        double dphi_V = 0.6058160662651062;
        double digital_I = 0.8867303133010864;
        double digital_V = 0.4610862731933594;
        double fan_I = 0.5934098958969116;
        double fan_V = 0.12129944562911987;
        double hvbias_I = 0.3975124955177307;
        double hvbias_V = 0.36742645502090454;
        double od_I = 0.6493446826934814;
        double od_V = 0.8481138944625854;
        double otm_I = 0.24405282735824585;
        double otm_V = 0.04184520244598389;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PowerTelemetry(analog_I, analog_V, aux_I, aux_V, clkhigh_I, clkhigh_V, clklow_I, clklow_V, dphi_I, dphi_V, digital_I, digital_V, fan_I, fan_V, hvbias_I, hvbias_V, od_I, od_V, otm_I, otm_V));
        Assert.assertTrue((boolean)(item instanceof PowerTelemetry));
        PowerTelemetry item_ = (PowerTelemetry)item;
        Assert.assertEquals((double)analog_I, (double)item_.getAnalog_I(), (double)1.0E-6f);
        Assert.assertEquals((double)analog_V, (double)item_.getAnalog_V(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_I, (double)item_.getAux_I(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_V, (double)item_.getAux_V(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhigh_I, (double)item_.getClkhigh_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhigh_V, (double)item_.getClkhigh_V(), (double)1.0E-6f);
        Assert.assertEquals((double)clklow_I, (double)item_.getClklow_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clklow_V, (double)item_.getClklow_V(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_I, (double)item_.getDphi_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_V, (double)item_.getDphi_V(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_I, (double)item_.getDigital_I(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_V, (double)item_.getDigital_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_I, (double)item_.getFan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_V, (double)item_.getFan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_I, (double)item_.getHvbias_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_V, (double)item_.getHvbias_V(), (double)1.0E-6f);
        Assert.assertEquals((double)od_I, (double)item_.getOd_I(), (double)1.0E-6f);
        Assert.assertEquals((double)od_V, (double)item_.getOd_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_I, (double)item_.getOtm_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_V, (double)item_.getOtm_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumTelemetry() throws Exception {
        double tempCCD = 0.553186297416687;
        double tempCCDSetPoint = 0.04808610677719116;
        double tempColdPlate = 0.8101748824119568;
        double tempCryoHead = 0.669546365737915;
        double vacuum = 0.6960483193397522;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumTelemetry(tempCCD, tempCCDSetPoint, tempColdPlate, tempCryoHead, vacuum));
        Assert.assertTrue((boolean)(item instanceof VacuumTelemetry));
        VacuumTelemetry item_ = (VacuumTelemetry)item;
        Assert.assertEquals((double)tempCCD, (double)item_.getTempCCD(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCCDSetPoint, (double)item_.getTempCCDSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempColdPlate, (double)item_.getTempColdPlate(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCryoHead, (double)item_.getTempCryoHead(), (double)1.0E-6f);
        Assert.assertEquals((double)vacuum, (double)item_.getVacuum(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_DeviceTelemetry() throws Exception {
        double bonn_V36 = 0.14659267663955688;
        double bonn_V5 = 0.8209753632545471;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Bonn_shutter_DeviceTelemetry(bonn_V36, bonn_V5));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_DeviceTelemetry));
        Bonn_shutter_DeviceTelemetry item_ = (Bonn_shutter_DeviceTelemetry)item;
        Assert.assertEquals((double)bonn_V36, (double)item_.getBonn_V36(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5, (double)item_.getBonn_V5(), (double)1.0E-6f);
    }
}

