/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.event.Ats_CryoCon_DeviceConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_CryoCon_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_Pfeiffer_DeviceConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_Pfeiffer_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_TempCCDSetPoint_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_TempCCD_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_TempColdPlate_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_TempCryoHead_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_Vacuum_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Analog_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Analog_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Aux_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Aux_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkHigh_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkHigh_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkLow_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkLow_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_DPHI_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_DPHI_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Digital_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Digital_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Fan_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Fan_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_HVBias_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_HVBias_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg1_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg1_PowerConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg2_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg2_PowerConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg3_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg3_PowerConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Keithley_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_Keithley_PowerConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_OD_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_OD_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_OTM_I_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_OTM_V_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.atcamera.event.Ats_power_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.atcamera.event.Bonn_shutter_Device_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Bonn_shutter_Device_GeneralConfigurationEvent;
import org.lsst.sal.atcamera.event.Bonn_shutter_Device_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Bonn_shutter_GeneralConfigurationEvent;
import org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.atcamera.event.Daq_monitor_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.atcamera.event.Daq_monitor_StoreConfigurationEvent;
import org.lsst.sal.atcamera.event.Daq_monitor_Store_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.FileCommandExecutionEvent;
import org.lsst.sal.atcamera.event.FitsFilesWrittenEvent;
import org.lsst.sal.atcamera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_ImageDatabaseService_GeneralConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_ImageNameService_GeneralConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Raft_HardwareIdConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_DevicesConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_HardwareIdConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_LimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_timersConfigurationEvent;
import org.lsst.sal.atcamera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent;
import org.lsst.sal.atcamera.event.ImageReadoutParametersEvent;
import org.lsst.sal.atcamera.event.ImageStoredEvent;
import org.lsst.sal.atcamera.event.ImageVisualizationEvent;
import org.lsst.sal.atcamera.event.Image_handling_ImageHandler_CommandsConfigurationEvent;
import org.lsst.sal.atcamera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent;
import org.lsst.sal.atcamera.event.Image_handling_Reb_GeneralConfigurationEvent;
import org.lsst.sal.atcamera.event.ShutterBladeMotionProfileEvent;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.event.AlertRaisedEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_Reb_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.SummaryStatusEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        String additionalKeys = "k";
        String additionalValues = "";
        int imagesInSequence = 544;
        String imageName = "hqqrlbzrtrai";
        int imageIndex = 677;
        String imageSource = "q";
        String imageController = "";
        String imageDate = "cbyru";
        int imageNumber = 574;
        double timestampAcquisitionStart = 0.18194597959518433;
        double requestedExposureTime = 0.1732344f;
        double timestampEndOfReadout = 0.40359628200531006;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        double timestampTransition = 0.0247975f;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.29134732484817505;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        double timestampTransition = 0.7575918436050415;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        double timestampTransition = 0.6763490438461304;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        String additionalKeys = "c";
        String additionalValues = "i";
        int imagesInSequence = 665;
        String imageName = "dfkpblbyqtupj";
        int imageIndex = 326;
        String imageSource = "x";
        String imageController = "u";
        String imageDate = "vcyqbqmx";
        int imageNumber = 856;
        double timestampAcquisitionStart = 0.9949959516525269;
        double exposureTime = 0.549616813659668;
        String imageTag = "eiwvykbcoctqqvphg";
        double timestampDateObs = 0.12901544570922852;
        double timestampDateEnd = 0.3369273f;
        double measuredShutterOpenTime = 0.8710718750953674;
        double darkTime = 0.6991051435470581;
        String emulatedImage = "";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.00786501169204712;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        double timestampTransition = 0.6597763895988464;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        double timestampTransition = 0.051329731941223145;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 63;
        String imageName = "nfutaei";
        int imageIndex = 672;
        String imageSource = "";
        String imageController = "";
        String imageDate = "qqznge";
        int imageNumber = 879;
        double timestampAcquisitionStart = 0.7202387452125549;
        double exposureTime = 0.022544145584106445;
        String mode = "o";
        double timeout = 0.9011256694793701;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, mode, timeout));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((double)timeout, (double)item_.getTimeout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        double timestampTransition = 0.5664383172988892;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        String additionalKeys = "f";
        String additionalValues = "g";
        int imagesInSequence = 125;
        String imageName = "ehxuortnjimmdxoxtkqi";
        int imageIndex = 237;
        String imageSource = "p";
        String imageController = "n";
        String imageDate = "oiybb";
        int imageNumber = 940;
        double timestampAcquisitionStart = 0.764613151550293;
        double exposureTime = 0.8012044429779053;
        double timestampStartOfReadout = 0.27334141731262207;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveShutterMotionProfileEvent() throws Exception {
        double measuredExposureTime = 0.5021170973777771;
        SALEvent item = this.testSendReceive((SALEvent)new ShutterMotionProfileEvent(measuredExposureTime));
        Assert.assertTrue((boolean)(item instanceof ShutterMotionProfileEvent));
        ShutterMotionProfileEvent item_ = (ShutterMotionProfileEvent)item;
        Assert.assertEquals((double)measuredExposureTime, (double)item_.getMeasuredExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        String imageName = "";
        String ccdLocation = "f";
        String raftBay = "";
        String ccdSlot = "";
        ImageReadoutParametersEvent.CcdType ccdType = ImageReadoutParametersEvent.CcdType.ITL;
        int overRows = 172;
        int overCols = 321;
        int readRows = 175;
        int readCols = 585;
        int readCols2 = 770;
        int preCols = 981;
        int preRows = 60;
        int postCols = 224;
        int underCols = 484;
        String daqFolder = "";
        String daqAnnotation = "w";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(imageName, ccdLocation, raftBay, ccdSlot, ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        String ccdLocation = "";
        String raftBay = "";
        String ccdSlot = "r";
        String rebSerialNumber = "m";
        String rebLSSTName = "";
        String ccdLSSTName = "c";
        String raftLSSTName = "u";
        String ccdManSerNum = "";
        String ccdManufacturer = "l";
        FocalPlaneSummaryInfoEvent.CcdType ccdType = FocalPlaneSummaryInfoEvent.CcdType.ITL;
        double ccdTempSetPoint = 0.06372588872909546;
        String sequencerKey = "v";
        String sequencerChecksum = "x";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((double)ccdTempSetPoint, (double)item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        String manSerNum = "";
        String name = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdConfigurationEvent(version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdConfigurationEvent));
        Focal_plane_Ccd_HardwareIdConfigurationEvent item_ = (Focal_plane_Ccd_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsConfigurationEvent() throws Exception {
        String version = "l";
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1991756781);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)1, (int)598897808);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-112743658);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1829040536);
        String location = "";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)1, (int)1251359113);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)1, (int)227473748);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)1, (int)321690976);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1218616460);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-296427284);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)1, (int)2121234753);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)1, (int)1660858439);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1218917431);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)1, (int)1683701218);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)1, (int)-392731427);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-940382637);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1423060993);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1367920983);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)1, (int)-557424792);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-264279916);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)1, (int)1423469236);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1457672976);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)1, (int)1975378217);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)1, (int)-642849686);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1174462524);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsConfigurationEvent(version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsConfigurationEvent));
        Focal_plane_Ccd_LimitsConfigurationEvent item_ = (Focal_plane_Ccd_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_RaftsConfigurationEvent() throws Exception {
        String version = "t";
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_RaftsConfigurationEvent(version, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_RaftsConfigurationEvent));
        Focal_plane_Ccd_RaftsConfigurationEvent item_ = (Focal_plane_Ccd_RaftsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseService_GeneralConfigurationEvent() throws Exception {
        String version = "v";
        String dbURL = "r";
        boolean enabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseService_GeneralConfigurationEvent(version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseService_GeneralConfigurationEvent));
        Focal_plane_ImageDatabaseService_GeneralConfigurationEvent item_ = (Focal_plane_ImageDatabaseService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameService_GeneralConfigurationEvent() throws Exception {
        String version = "y";
        String controller = "l";
        String dbURL = "";
        String offset = "";
        String source = "";
        String timeZoneId = "h";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameService_GeneralConfigurationEvent(version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameService_GeneralConfigurationEvent));
        Focal_plane_ImageNameService_GeneralConfigurationEvent item_ = (Focal_plane_ImageNameService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentConfigurationEvent() throws Exception {
        String version = "f";
        String instrument = "z";
        String telescope = "v";
        String testStand = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentConfigurationEvent(version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentConfigurationEvent));
        Focal_plane_InstrumentConfig_InstrumentConfigurationEvent item_ = (Focal_plane_InstrumentConfig_InstrumentConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 137;
        int schedulers_default_nThreads = 133;
        int schedulers_monitor_check_scheduler_nTasks = 654;
        int schedulers_monitor_check_scheduler_nThreads = 195;
        int schedulers_monitor_update_publish_scheduler_nTasks = 388;
        int schedulers_monitor_update_publish_scheduler_nThreads = 28;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_GeneralConfigurationEvent));
        Focal_plane_PeriodicTasks_GeneralConfigurationEvent item_ = (Focal_plane_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "k";
        long agentmonitorservice_taskPeriodMillis = 111L;
        long heartbeat_taskPeriodMillis = 236L;
        long monitor_publish_taskPeriodMillis = 914L;
        long monitor_update_taskPeriodMillis = 763L;
        long runtimeinfo_taskPeriodMillis = 638L;
        long tempcontrol_R00_taskPeriodMillis = 207L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R00_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersConfigurationEvent));
        Focal_plane_PeriodicTasks_timersConfigurationEvent item_ = (Focal_plane_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R00_taskPeriodMillis, (long)item_.getTempcontrol_R00_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        String name = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdConfigurationEvent));
        Focal_plane_Raft_HardwareIdConfigurationEvent item_ = (Focal_plane_Raft_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlConfigurationEvent() throws Exception {
        String version = "";
        String location = "l";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)1, (int)1909953860);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)1, (int)-1417221407);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)1, (int)823326195);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)1, (int)780688061);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)1, (int)-1397766369);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)1, (int)1535902079);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)1, (int)-699331790);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)1, (int)-1933500658);
        String tempcontrol_rebs = "";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)1, (int)115767502);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)1, (int)-106587538);
        String tempcontrol_tempChans = "e";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)1, (int)920838193);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlConfigurationEvent(version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlConfigurationEvent));
        Focal_plane_Raft_RaftTempControlConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusConfigurationEvent() throws Exception {
        String version = "r";
        String location = "";
        boolean[] tempcontrol_active = new boolean[]{true};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusConfigurationEvent(version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusConfigurationEvent));
        Focal_plane_Raft_RaftTempControlStatusConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlStatusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        String version = "u";
        double warnHi = 0.40296316146850586;
        double warnLo = 0.7144854664802551;
        double limitHi = 0.28438347578048706;
        double limitLo = 0.45325231552124023;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsConfigurationEvent));
        Focal_plane_RebTotalPower_LimitsConfigurationEvent item_ = (Focal_plane_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_DevicesConfigurationEvent() throws Exception {
        String version = "f";
        boolean[] disabled = new boolean[]{true};
        String location = "c";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_DevicesConfigurationEvent(version, disabled, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_DevicesConfigurationEvent));
        Focal_plane_Reb_DevicesConfigurationEvent item_ = (Focal_plane_Reb_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])disabled, (boolean[])item_.getDisabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdConfigurationEvent() throws Exception {
        String version = "";
        String location = "j";
        String name = "j";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdConfigurationEvent));
        Focal_plane_Reb_HardwareIdConfigurationEvent item_ = (Focal_plane_Reb_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsConfigurationEvent() throws Exception {
        String version = "j";
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)1, (int)-2113753870);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1053293722);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)1, (int)1491601708);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)1, (int)1885977511);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1059209602);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)1, (int)281041328);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)1, (int)2013935682);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)1, (int)1929143819);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)1, (int)1740515410);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)1, (int)1798882863);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)1, (int)371044287);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)1, (int)655825201);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)1, (int)-414893779);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)1, (int)-682822203);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)1, (int)-285564450);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)1, (int)-2128996900);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1411552849);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)1, (int)988845720);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)1, (int)1574326162);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)1, (int)-405620869);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)1, (int)380063568);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)1, (int)-881196557);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)1, (int)1668298390);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)1, (int)1066273454);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)1, (int)558779028);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1818025879);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)1, (int)177966273);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-958412791);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)1, (int)1220371580);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1603146689);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)1, (int)1486134430);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)1, (int)-862472425);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)1, (int)1027608383);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)1, (int)708589067);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1518938308);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1250181728);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)1, (int)-2027831750);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1139765352);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)1, (int)-383668415);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1526915281);
        double[] htrpi_warnHi = TestHelper.generateDoubleArray((int)1, (int)949651748);
        double[] htrpi_warnLo = TestHelper.generateDoubleArray((int)1, (int)470319372);
        double[] htrpi_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1222143675);
        double[] htrpi_limitLo = TestHelper.generateDoubleArray((int)1, (int)981709006);
        double[] htrpv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-939110779);
        double[] htrpv_warnLo = TestHelper.generateDoubleArray((int)1, (int)413559884);
        double[] htrpv_limitHi = TestHelper.generateDoubleArray((int)1, (int)1648594268);
        double[] htrpv_limitLo = TestHelper.generateDoubleArray((int)1, (int)223479059);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-616101528);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1801207137);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-225999372);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-5122976);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1375056305);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)1, (int)1236955281);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)1, (int)977139681);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)1, (int)-951573147);
        String location = "i";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1315459146);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)1, (int)-2006648343);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1036474372);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)1, (int)-284405506);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1175519146);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)1, (int)-2061859894);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)1, (int)1615150894);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)1, (int)966662005);
        double[] pclk0_warnHi = TestHelper.generateDoubleArray((int)1, (int)871321290);
        double[] pclk0_warnLo = TestHelper.generateDoubleArray((int)1, (int)1394878018);
        double[] pclk0_limitHi = TestHelper.generateDoubleArray((int)1, (int)-696700444);
        double[] pclk0_limitLo = TestHelper.generateDoubleArray((int)1, (int)1197043983);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1182202028);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)1, (int)-43661461);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)1, (int)998439937);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)1, (int)-445233199);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)1, (int)1787252675);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)1, (int)-615500284);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)1, (int)-33638186);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)1, (int)-2103026780);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1038218488);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1174427787);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)1, (int)1868128983);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)1, (int)1325603311);
        double[] rg0_warnHi = TestHelper.generateDoubleArray((int)1, (int)-501480951);
        double[] rg0_warnLo = TestHelper.generateDoubleArray((int)1, (int)1823838736);
        double[] rg0_limitHi = TestHelper.generateDoubleArray((int)1, (int)-260318576);
        double[] rg0_limitLo = TestHelper.generateDoubleArray((int)1, (int)-368129150);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1093253708);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1130403943);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)1, (int)-22353703);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)1, (int)1073757365);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1969283497);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)1, (int)2129654792);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1138184120);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)1, (int)-245480496);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)1, (int)703339567);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)1, (int)-597072756);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)1, (int)1475822054);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)1, (int)-2141009491);
        double[] sclk0_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1351344834);
        double[] sclk0_warnLo = TestHelper.generateDoubleArray((int)1, (int)1523727059);
        double[] sclk0_limitHi = TestHelper.generateDoubleArray((int)1, (int)1642285350);
        double[] sclk0_limitLo = TestHelper.generateDoubleArray((int)1, (int)-856475492);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)1, (int)1254579297);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)1, (int)1336914056);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)1, (int)1324942098);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1938393722);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)1, (int)1903222177);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)1, (int)541347613);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)1, (int)1442116807);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)1, (int)883869524);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1412314167);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)1, (int)762953673);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)1, (int)778376483);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1304407919);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)1, (int)2027723575);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)1, (int)-548857900);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)1, (int)-414818884);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1829568691);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)1, (int)1742669303);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)1, (int)-760929006);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)1, (int)-164235501);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)1, (int)-2092361915);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)1, (int)1659319565);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)1, (int)1528725164);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)1, (int)1041003529);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)1, (int)-51267008);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)1, (int)1346480913);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)1, (int)-21930459);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)1, (int)1043124369);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)1, (int)1244730043);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1554856959);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)1, (int)984188060);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)1, (int)-96983130);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)1, (int)-137493304);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsConfigurationEvent(version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrpi_warnHi, htrpi_warnLo, htrpi_limitHi, htrpi_limitLo, htrpv_warnHi, htrpv_warnLo, htrpv_limitHi, htrpv_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclk0_warnHi, pclk0_warnLo, pclk0_limitHi, pclk0_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rg0_warnHi, rg0_warnLo, rg0_limitHi, rg0_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, sclk0_warnHi, sclk0_warnLo, sclk0_limitHi, sclk0_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsConfigurationEvent));
        Focal_plane_Reb_LimitsConfigurationEvent item_ = (Focal_plane_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnHi, (double[])item_.getHtrpi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnLo, (double[])item_.getHtrpi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitHi, (double[])item_.getHtrpi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitLo, (double[])item_.getHtrpi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnHi, (double[])item_.getHtrpv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnLo, (double[])item_.getHtrpv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitHi, (double[])item_.getHtrpv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitLo, (double[])item_.getHtrpv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnHi, (double[])item_.getPclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnLo, (double[])item_.getPclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitHi, (double[])item_.getPclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitLo, (double[])item_.getPclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnHi, (double[])item_.getRg0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnLo, (double[])item_.getRg0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitHi, (double[])item_.getRg0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitLo, (double[])item_.getRg0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnHi, (double[])item_.getSclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnLo, (double[])item_.getSclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitHi, (double[])item_.getSclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitLo, (double[])item_.getSclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsConfigurationEvent() throws Exception {
        String version = "";
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)1, (int)747155534);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)1, (int)-1083026305);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)1, (int)-38827726);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)1, (int)810123592);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)1, (int)-576690593);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)1, (int)2033382145);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)1, (int)1012012773);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)1, (int)-786885497);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)1, (int)601363673);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)1, (int)998339445);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)1, (int)-52445556);
        boolean[] disableRTDHardwareCheck = new boolean[]{false};
        String location = "z";
        long[] serialNum = TestHelper.generateLongArray((int)1, (int)1631313019);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsConfigurationEvent(version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsConfigurationEvent));
        Focal_plane_Reb_RaftsConfigurationEvent item_ = (Focal_plane_Reb_RaftsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsConfigurationEvent() throws Exception {
        String version = "n";
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)1, (int)1371921981);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)1, (int)-1157790512);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)1, (int)1775477823);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)1, (int)-1430247905);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)1, (int)-475308570);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)1, (int)-1839067692);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)1, (int)-85656603);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)1, (int)-265717410);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)1, (int)-661104555);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)1, (int)1660116134);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)1, (int)754817146);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)1, (int)552849637);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)1, (int)1370678541);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)1, (int)1093916698);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)1, (int)-485240562);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)1, (int)-899342202);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)1, (int)2038618736);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)1, (int)1700537822);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)1, (int)1709298975);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)1, (int)1154460180);
        String location = "t";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsConfigurationEvent(version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsConfigurationEvent));
        Focal_plane_Reb_RaftsLimitsConfigurationEvent item_ = (Focal_plane_Reb_RaftsLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerConfigurationEvent() throws Exception {
        String version = "";
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)1, (int)398815596);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)1, (int)-1544125195);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)1, (int)-707108887);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)1, (int)-2077841788);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)1, (int)-2042598215);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)1, (int)-15748236);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)1, (int)-631695468);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)1, (int)-1486300823);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)1, (int)-1360595726);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)1, (int)1692230270);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)1, (int)1994848862);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)1, (int)-1431277483);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)1, (int)-922207577);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)1, (int)241126537);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)1, (int)-706872300);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)1, (int)962916754);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)1, (int)241484541);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)1, (int)1420950107);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)1, (int)1434039671);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)1, (int)856015890);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)1, (int)9646327);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)1, (int)1283165443);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)1, (int)931830043);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)1, (int)-164852610);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)1, (int)-1626218762);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)1, (int)-1727614195);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)1, (int)-533917039);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)1, (int)-2018523250);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)1, (int)1159335042);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)1, (int)-1023722256);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)1, (int)179368904);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)1, (int)-1784400485);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)1, (int)-1135500214);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)1, (int)-374930229);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)1, (int)2009060528);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)1, (int)2060512113);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)1, (int)1472519785);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)1, (int)364977488);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)1, (int)1737967903);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)1, (int)-65856406);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)1, (int)-513719574);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)1, (int)-1531151360);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)1, (int)-1860824840);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)1, (int)-345247305);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)1, (int)-809512818);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)1, (int)-2090954088);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)1, (int)1890166409);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)1, (int)759431936);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)1, (int)-1566290996);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)1, (int)1084328907);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)1, (int)-1558458571);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)1, (int)-1592441808);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)1, (int)-1233913320);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)1, (int)1580277552);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)1, (int)1310069330);
        String location = "";
        double[] maxDelta = TestHelper.generateDoubleArray((int)1, (int)709250408);
        double[] maxStep = TestHelper.generateDoubleArray((int)1, (int)-716427139);
        double[] minTol = TestHelper.generateDoubleArray((int)1, (int)1160460884);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)1, (int)-1022846210);
        double[] odiAmin = TestHelper.generateDoubleArray((int)1, (int)760628211);
        double[] odiQmax = TestHelper.generateDoubleArray((int)1, (int)751087093);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerConfigurationEvent(version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerConfigurationEvent));
        Focal_plane_Reb_RaftsPowerConfigurationEvent item_ = (Focal_plane_Reb_RaftsPowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersConfigurationEvent() throws Exception {
        String version = "o";
        String location = "h";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)349724904);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)886895385);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-738304691);
        long[] periodictasks_monitor_publish_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)658812088);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1704858203);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)347353465);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1037401273);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)1930057449);
        long[] periodictasks_monitor_update_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)876905894);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)1884345550);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)158842907);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersConfigurationEvent(version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_crVolt_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_crVolt_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersConfigurationEvent));
        Focal_plane_Reb_timersConfigurationEvent item_ = (Focal_plane_Reb_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQConfigurationEvent() throws Exception {
        String version = "p";
        int badPixelAlarmLimit = 660;
        String daqFolder = "";
        String daqPartition = "";
        boolean emulatedDAQ = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQConfigurationEvent(version, badPixelAlarmLimit, daqFolder, daqPartition, emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQConfigurationEvent));
        Focal_plane_SequencerConfig_DAQConfigurationEvent item_ = (Focal_plane_SequencerConfig_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)badPixelAlarmLimit, (long)item_.getBadPixelAlarmLimit());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerConfigurationEvent() throws Exception {
        String version = "";
        String clearCountParameter = "u";
        String clearMain = "r";
        String idleFlushMain = "";
        long idleFlushTimeout = 604L;
        String integrateMain = "d";
        String metaDataRegisters = "";
        int overCols = 857;
        int overRows = 798;
        int postCols = 618;
        int postRows = 515;
        int preCols = 908;
        int preRows = 396;
        String pseudoReadMain = "";
        int readCols = 111;
        int readCols2 = 753;
        String readMain = "m";
        int readRows = 320;
        String rowShiftForwardMain = "n";
        String rowShiftReverseMain = "";
        boolean scanMode = false;
        String sequencer = "";
        String sequencerChecksums = "";
        String shiftCountParameter = "r";
        boolean stepAfterIntegrate = false;
        int transparentMode = 901;
        int underCols = 423;
        boolean useParallelRegisters = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerConfigurationEvent(version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerConfigurationEvent));
        Focal_plane_SequencerConfig_SequencerConfigurationEvent item_ = (Focal_plane_SequencerConfig_SequencerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationConfigurationEvent() throws Exception {
        String version = "q";
        String webHooks = "f";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationConfigurationEvent(version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationConfigurationEvent));
        Focal_plane_WebHooksConfig_VisualizationConfigurationEvent item_ = (Focal_plane_WebHooksConfig_VisualizationConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 420;
        int schedulers_default_nThreads = 167;
        int schedulers_monitor_update_publish_scheduler_nTasks = 693;
        int schedulers_monitor_update_publish_scheduler_nThreads = 744;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_GeneralConfigurationEvent));
        Daq_monitor_PeriodicTasks_GeneralConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "o";
        long agentmonitorservice_taskPeriodMillis = 651L;
        long heartbeat_taskPeriodMillis = 647L;
        long monitor_check_taskPeriodMillis = 110L;
        long monitor_publish_taskPeriodMillis = 876L;
        long monitor_update_taskPeriodMillis = 241L;
        long publishstats_taskPeriodMillis = 347L;
        long purgedaq_taskPeriodMillis = 456L;
        long runtimeinfo_taskPeriodMillis = 755L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersConfigurationEvent));
        Daq_monitor_PeriodicTasks_timersConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsConfigurationEvent() throws Exception {
        String version = "z";
        int minDiffAlertWarning = 558;
        int minDiffLogWarning = 404;
        String sumDriverChecks = "";
        String sumDriverStats = "";
        String sumFirmwareChecks = "d";
        String sumFirmwareStats = "m";
        String sumRdsChecks = "b";
        String sumRdsStats = "l";
        String sumRmsChecks = "";
        String sumRmsStats = "t";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsConfigurationEvent(version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsConfigurationEvent));
        Daq_monitor_Stats_StatisticsConfigurationEvent item_ = (Daq_monitor_Stats_StatisticsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreConfigurationEvent() throws Exception {
        String version = "t";
        int alarmPurgeFailures = 23;
        String daqPartition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreConfigurationEvent(version, alarmPurgeFailures, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreConfigurationEvent));
        Daq_monitor_StoreConfigurationEvent item_ = (Daq_monitor_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)alarmPurgeFailures, (long)item_.getAlarmPurgeFailures());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_DevicesConfigurationEvent() throws Exception {
        String version = "a";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_DevicesConfigurationEvent));
        Daq_monitor_Store_DevicesConfigurationEvent item_ = (Daq_monitor_Store_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double capacity_warnHi = 0.026497721672058105;
        double capacity_warnLo = 0.7373479604721069;
        double capacity_limitHi = 0.4780054f;
        double capacity_limitLo = 0.8429917097091675;
        double freefraction_warnHi = 0.2622036933898926;
        double freefraction_warnLo = 0.6932491064071655;
        double freefraction_limitHi = 0.43241333961486816;
        double freefraction_limitLo = 0.015633821487426758;
        double freespace_warnHi = 0.6682465672492981;
        double freespace_warnLo = 0.9804776906967163;
        double freespace_limitHi = 0.7677831649780273;
        double freespace_limitLo = 0.15662521123886108;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsConfigurationEvent(version, capacity_warnHi, capacity_warnLo, capacity_limitHi, capacity_limitLo, freefraction_warnHi, freefraction_warnLo, freefraction_limitHi, freefraction_limitLo, freespace_warnHi, freespace_warnLo, freespace_limitHi, freespace_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsConfigurationEvent));
        Daq_monitor_Store_LimitsConfigurationEvent item_ = (Daq_monitor_Store_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)capacity_warnHi, (double)item_.getCapacity_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_warnLo, (double)item_.getCapacity_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitHi, (double)item_.getCapacity_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitLo, (double)item_.getCapacity_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnHi, (double)item_.getFreefraction_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitHi, (double)item_.getFreefraction_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnHi, (double)item_.getFreespace_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnLo, (double)item_.getFreespace_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitHi, (double)item_.getFreespace_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitLo, (double)item_.getFreespace_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreConfigurationEvent() throws Exception {
        String version = "d";
        String daqFolder = "";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.09786117076873779;
        double purgeThreshold = 0.09202694892883301;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreConfigurationEvent(version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreConfigurationEvent));
        Daq_monitor_Store_StoreConfigurationEvent item_ = (Daq_monitor_Store_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Analog_I_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.20048797130584717;
        double warnLo = 0.9146711230278015;
        double limitHi = 0.6109184622764587;
        double limitLo = 0.22058796882629395;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Analog_I_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Analog_I_LimitsConfigurationEvent));
        Ats_power_Analog_I_LimitsConfigurationEvent item_ = (Ats_power_Analog_I_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Analog_V_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.6479204297065735;
        double warnLo = 0.6370763778686523;
        double limitHi = 0.7762812376022339;
        double limitLo = 0.7888868451118469;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Analog_V_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Analog_V_LimitsConfigurationEvent));
        Ats_power_Analog_V_LimitsConfigurationEvent item_ = (Ats_power_Analog_V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Aux_I_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 2.7757883071899414E-4;
        double warnLo = 0.752791702747345;
        double limitHi = 0.6035393476486206;
        double limitLo = 0.5431790947914124;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Aux_I_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Aux_I_LimitsConfigurationEvent));
        Ats_power_Aux_I_LimitsConfigurationEvent item_ = (Ats_power_Aux_I_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Aux_V_LimitsConfigurationEvent() throws Exception {
        String version = "o";
        double warnHi = 0.3229595422744751;
        double warnLo = 0.8843878507614136;
        double limitHi = 0.5941145420074463;
        double limitLo = 0.5113627910614014;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Aux_V_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Aux_V_LimitsConfigurationEvent));
        Ats_power_Aux_V_LimitsConfigurationEvent item_ = (Ats_power_Aux_V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkHigh_I_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.0349254f;
        double warnLo = 0.07047587633132935;
        double limitHi = 0.744737982749939;
        double limitLo = 0.734065055847168;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkHigh_I_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkHigh_I_LimitsConfigurationEvent));
        Ats_power_ClkHigh_I_LimitsConfigurationEvent item_ = (Ats_power_ClkHigh_I_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkHigh_V_LimitsConfigurationEvent() throws Exception {
        String version = "f";
        double warnHi = 0.08176732063293457;
        double warnLo = 0.8670662641525269;
        double limitHi = 0.837917685508728;
        double limitLo = 0.22544550895690918;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkHigh_V_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkHigh_V_LimitsConfigurationEvent));
        Ats_power_ClkHigh_V_LimitsConfigurationEvent item_ = (Ats_power_ClkHigh_V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkLow_I_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.5191545486450195;
        double warnLo = 0.7961177229881287;
        double limitHi = 0.6106455326080322;
        double limitLo = 0.3151012659072876;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkLow_I_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkLow_I_LimitsConfigurationEvent));
        Ats_power_ClkLow_I_LimitsConfigurationEvent item_ = (Ats_power_ClkLow_I_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkLow_V_LimitsConfigurationEvent() throws Exception {
        String version = "k";
        double warnHi = 0.18881899118423462;
        double warnLo = 0.8483423590660095;
        double limitHi = 0.11595678329467773;
        double limitLo = 0.571389f;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkLow_V_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkLow_V_LimitsConfigurationEvent));
        Ats_power_ClkLow_V_LimitsConfigurationEvent item_ = (Ats_power_ClkLow_V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_DPHI_I_LimitsConfigurationEvent() throws Exception {
        String version = "d";
        double warnHi = 0.10363179445266724;
        double warnLo = 0.3349548f;
        double limitHi = 0.5211735963821411;
        double limitLo = 0.9351938366889954;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_DPHI_I_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_DPHI_I_LimitsConfigurationEvent));
        Ats_power_DPHI_I_LimitsConfigurationEvent item_ = (Ats_power_DPHI_I_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_DPHI_V_LimitsConfigurationEvent() throws Exception {
        String version = "r";
        double warnHi = 0.6257666945457458;
        double warnLo = 0.17463302612304688;
        double limitHi = 0.6843522191047668;
        double limitLo = 0.3546783924102783;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_DPHI_V_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_DPHI_V_LimitsConfigurationEvent));
        Ats_power_DPHI_V_LimitsConfigurationEvent item_ = (Ats_power_DPHI_V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Digital_I_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.10239458084106445;
        double warnLo = 0.711392879486084;
        double limitHi = 0.16704648733139038;
        double limitLo = 0.2358495593070984;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Digital_I_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Digital_I_LimitsConfigurationEvent));
        Ats_power_Digital_I_LimitsConfigurationEvent item_ = (Ats_power_Digital_I_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Digital_V_LimitsConfigurationEvent() throws Exception {
        String version = "v";
        double warnHi = 0.7512941360473633;
        double warnLo = 0.6937392950057983;
        double limitHi = 0.8654171228408813;
        double limitLo = 0.4845951795578003;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Digital_V_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Digital_V_LimitsConfigurationEvent));
        Ats_power_Digital_V_LimitsConfigurationEvent item_ = (Ats_power_Digital_V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Fan_I_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.08863133192062378;
        double warnLo = 0.1820812225341797;
        double limitHi = 0.05427068471908569;
        double limitLo = 0.5214723944664001;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Fan_I_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Fan_I_LimitsConfigurationEvent));
        Ats_power_Fan_I_LimitsConfigurationEvent item_ = (Ats_power_Fan_I_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Fan_V_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.6452009081840515;
        double warnLo = 0.3985958695411682;
        double limitHi = 0.9466773271560669;
        double limitLo = 0.8995060920715332;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Fan_V_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Fan_V_LimitsConfigurationEvent));
        Ats_power_Fan_V_LimitsConfigurationEvent item_ = (Ats_power_Fan_V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_HVBias_I_LimitsConfigurationEvent() throws Exception {
        String version = "l";
        double warnHi = 0.2522529363632202;
        double warnLo = 0.7295560836791992;
        double limitHi = 0.6490641236305237;
        double limitLo = 0.7439114451408386;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_HVBias_I_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_HVBias_I_LimitsConfigurationEvent));
        Ats_power_HVBias_I_LimitsConfigurationEvent item_ = (Ats_power_HVBias_I_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_HVBias_V_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.8646038174629211;
        double warnLo = 0.9383781552314758;
        double limitHi = 0.8864242434501648;
        double limitLo = 0.5181974172592163;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_HVBias_V_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_HVBias_V_LimitsConfigurationEvent));
        Ats_power_HVBias_V_LimitsConfigurationEvent item_ = (Ats_power_HVBias_V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Hameg1_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg1_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg1_DevicesConfigurationEvent));
        Ats_power_Hameg1_DevicesConfigurationEvent item_ = (Ats_power_Hameg1_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveAts_power_Hameg1_PowerConfigurationEvent() throws Exception {
        String version = "";
        String connType = "e";
        double dphi_current = 0.710189f;
        double dphi_offDelay = 0.3864247798919678;
        double dphi_onDelay = 0.2776535749435425;
        double dphi_voltage = 0.5311670303344727;
        String devcId = "q";
        int devcParm = 924;
        double digital_current = 0.4298403859138489;
        double digital_offDelay = 0.4437502f;
        double digital_onDelay = 0.4124288558959961;
        double digital_voltage = 0.16232693195343018;
        double od_current = 0.6334140300750732;
        double od_offDelay = 0.6464796662330627;
        double od_onDelay = 0.5712229609489441;
        double od_voltage = 0.8883883357048035;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg1_PowerConfigurationEvent(version, connType, dphi_current, dphi_offDelay, dphi_onDelay, dphi_voltage, devcId, devcParm, digital_current, digital_offDelay, digital_onDelay, digital_voltage, od_current, od_offDelay, od_onDelay, od_voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg1_PowerConfigurationEvent));
        Ats_power_Hameg1_PowerConfigurationEvent item_ = (Ats_power_Hameg1_PowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((double)dphi_current, (double)item_.getDphi_current(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_offDelay, (double)item_.getDphi_offDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_onDelay, (double)item_.getDphi_onDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_voltage, (double)item_.getDphi_voltage(), (double)1.0E-6f);
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
        Assert.assertEquals((double)digital_current, (double)item_.getDigital_current(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_offDelay, (double)item_.getDigital_offDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_onDelay, (double)item_.getDigital_onDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_voltage, (double)item_.getDigital_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)od_current, (double)item_.getOd_current(), (double)1.0E-6f);
        Assert.assertEquals((double)od_offDelay, (double)item_.getOd_offDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)od_onDelay, (double)item_.getOd_onDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)od_voltage, (double)item_.getOd_voltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Hameg2_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg2_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg2_DevicesConfigurationEvent));
        Ats_power_Hameg2_DevicesConfigurationEvent item_ = (Ats_power_Hameg2_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveAts_power_Hameg2_PowerConfigurationEvent() throws Exception {
        String version = "";
        double analog_current = 0.5045515298843384;
        double analog_offDelay = 0.002496778964996338;
        double analog_onDelay = 0.3206069f;
        double analog_voltage = 0.5314055681228638;
        double clockhigh_current = 0.7548640966415405;
        double clockhigh_offDelay = 0.3945449f;
        double clockhigh_onDelay = 0.15745294094085693;
        double clockhigh_voltage = 0.443982f;
        double clocklow_current = 0.05309480428695679;
        double clocklow_offDelay = 0.5899285674095154;
        double clocklow_onDelay = 0.3633301258087158;
        double clocklow_voltage = 0.3717476f;
        String connType = "";
        String devcId = "f";
        int devcParm = 647;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg2_PowerConfigurationEvent(version, analog_current, analog_offDelay, analog_onDelay, analog_voltage, clockhigh_current, clockhigh_offDelay, clockhigh_onDelay, clockhigh_voltage, clocklow_current, clocklow_offDelay, clocklow_onDelay, clocklow_voltage, connType, devcId, devcParm));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg2_PowerConfigurationEvent));
        Ats_power_Hameg2_PowerConfigurationEvent item_ = (Ats_power_Hameg2_PowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)analog_current, (double)item_.getAnalog_current(), (double)1.0E-6f);
        Assert.assertEquals((double)analog_offDelay, (double)item_.getAnalog_offDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)analog_onDelay, (double)item_.getAnalog_onDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)analog_voltage, (double)item_.getAnalog_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)clockhigh_current, (double)item_.getClockhigh_current(), (double)1.0E-6f);
        Assert.assertEquals((double)clockhigh_offDelay, (double)item_.getClockhigh_offDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)clockhigh_onDelay, (double)item_.getClockhigh_onDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)clockhigh_voltage, (double)item_.getClockhigh_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)clocklow_current, (double)item_.getClocklow_current(), (double)1.0E-6f);
        Assert.assertEquals((double)clocklow_offDelay, (double)item_.getClocklow_offDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)clocklow_onDelay, (double)item_.getClocklow_onDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)clocklow_voltage, (double)item_.getClocklow_voltage(), (double)1.0E-6f);
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
    }

    @Test
    public void sendReceiveAts_power_Hameg3_DevicesConfigurationEvent() throws Exception {
        String version = "b";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg3_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg3_DevicesConfigurationEvent));
        Ats_power_Hameg3_DevicesConfigurationEvent item_ = (Ats_power_Hameg3_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveAts_power_Hameg3_PowerConfigurationEvent() throws Exception {
        String version = "w";
        double aux_current = 0.6713044047355652;
        double aux_offDelay = 0.7150382399559021;
        double aux_onDelay = 0.9880751371383667;
        double aux_voltage = 0.0881474f;
        String connType = "j";
        String devcId = "";
        int devcParm = 444;
        double fan_current = 0.06057637929916382;
        double fan_offDelay = 0.2795097231864929;
        double fan_onDelay = 0.6227433681488037;
        double fan_voltage = 0.5955899357795715;
        double otm_current = 0.07762682437896729;
        double otm_offDelay = 0.22366827726364136;
        double otm_onDelay = 0.8872032761573792;
        double otm_voltage = 0.3791808f;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg3_PowerConfigurationEvent(version, aux_current, aux_offDelay, aux_onDelay, aux_voltage, connType, devcId, devcParm, fan_current, fan_offDelay, fan_onDelay, fan_voltage, otm_current, otm_offDelay, otm_onDelay, otm_voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg3_PowerConfigurationEvent));
        Ats_power_Hameg3_PowerConfigurationEvent item_ = (Ats_power_Hameg3_PowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aux_current, (double)item_.getAux_current(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_offDelay, (double)item_.getAux_offDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_onDelay, (double)item_.getAux_onDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_voltage, (double)item_.getAux_voltage(), (double)1.0E-6f);
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
        Assert.assertEquals((double)fan_current, (double)item_.getFan_current(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_offDelay, (double)item_.getFan_offDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_onDelay, (double)item_.getFan_onDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_voltage, (double)item_.getFan_voltage(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_current, (double)item_.getOtm_current(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_offDelay, (double)item_.getOtm_offDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_onDelay, (double)item_.getOtm_onDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_voltage, (double)item_.getOtm_voltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Keithley_DevicesConfigurationEvent() throws Exception {
        String version = "a";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Keithley_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Keithley_DevicesConfigurationEvent));
        Ats_power_Keithley_DevicesConfigurationEvent item_ = (Ats_power_Keithley_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveAts_power_Keithley_PowerConfigurationEvent() throws Exception {
        String version = "x";
        String connType = "b";
        String devcId = "i";
        int devcParm = 202;
        double hvbias_current = 0.0362359881401062;
        double hvbias_offDelay = 0.2166774868965149;
        double hvbias_onDelay = 0.5074688792228699;
        double hvbias_voltage = 0.2082958221435547;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Keithley_PowerConfigurationEvent(version, connType, devcId, devcParm, hvbias_current, hvbias_offDelay, hvbias_onDelay, hvbias_voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Keithley_PowerConfigurationEvent));
        Ats_power_Keithley_PowerConfigurationEvent item_ = (Ats_power_Keithley_PowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
        Assert.assertEquals((double)hvbias_current, (double)item_.getHvbias_current(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_offDelay, (double)item_.getHvbias_offDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_onDelay, (double)item_.getHvbias_onDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_voltage, (double)item_.getHvbias_voltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OD_I_LimitsConfigurationEvent() throws Exception {
        String version = "v";
        double warnHi = 0.6300828456878662;
        double warnLo = 0.84812f;
        double limitHi = 0.3188076615333557;
        double limitLo = 0.4344951f;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OD_I_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OD_I_LimitsConfigurationEvent));
        Ats_power_OD_I_LimitsConfigurationEvent item_ = (Ats_power_OD_I_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OD_V_LimitsConfigurationEvent() throws Exception {
        String version = "q";
        double warnHi = 0.5752735137939453;
        double warnLo = 0.2993737459182739;
        double limitHi = 0.9198556542396545;
        double limitLo = 0.8859411478042603;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OD_V_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OD_V_LimitsConfigurationEvent));
        Ats_power_OD_V_LimitsConfigurationEvent item_ = (Ats_power_OD_V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OTM_I_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.2468610405921936;
        double warnLo = 0.7000638246536255;
        double limitHi = 0.445568323135376;
        double limitLo = 0.18660366535186768;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OTM_I_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OTM_I_LimitsConfigurationEvent));
        Ats_power_OTM_I_LimitsConfigurationEvent item_ = (Ats_power_OTM_I_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OTM_V_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.2734687328338623;
        double warnLo = 0.7526744604110718;
        double limitHi = 0.791869044303894;
        double limitLo = 0.3327948f;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OTM_V_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OTM_V_LimitsConfigurationEvent));
        Ats_power_OTM_V_LimitsConfigurationEvent item_ = (Ats_power_OTM_V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 186;
        int schedulers_default_nThreads = 947;
        int schedulers_monitor_update_publish_scheduler_nTasks = 281;
        int schedulers_monitor_update_publish_scheduler_nThreads = 691;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Ats_power_PeriodicTasks_GeneralConfigurationEvent));
        Ats_power_PeriodicTasks_GeneralConfigurationEvent item_ = (Ats_power_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveAts_power_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "o";
        long agentmonitorservice_taskPeriodMillis = 881L;
        long heartbeat_taskPeriodMillis = 910L;
        long monitor_check_taskPeriodMillis = 770L;
        long monitor_publish_taskPeriodMillis = 293L;
        long monitor_update_taskPeriodMillis = 275L;
        long power_state_taskPeriodMillis = 187L;
        long runtimeinfo_taskPeriodMillis = 202L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, power_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_PeriodicTasks_timersConfigurationEvent));
        Ats_power_PeriodicTasks_timersConfigurationEvent item_ = (Ats_power_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)power_state_taskPeriodMillis, (long)item_.getPower_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_CryoCon_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String host = "q";
        SALEvent item = this.testSendReceive((SALEvent)new Ats_CryoCon_DeviceConfigurationEvent(version, host));
        Assert.assertTrue((boolean)(item instanceof Ats_CryoCon_DeviceConfigurationEvent));
        Ats_CryoCon_DeviceConfigurationEvent item_ = (Ats_CryoCon_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)host, (Object)item_.getHost());
    }

    @Test
    public void sendReceiveAts_CryoCon_DevicesConfigurationEvent() throws Exception {
        String version = "w";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_CryoCon_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Ats_CryoCon_DevicesConfigurationEvent));
        Ats_CryoCon_DevicesConfigurationEvent item_ = (Ats_CryoCon_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveAts_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "o";
        int schedulers_default_nTasks = 943;
        int schedulers_default_nThreads = 669;
        int schedulers_monitor_update_publish_scheduler_nTasks = 302;
        int schedulers_monitor_update_publish_scheduler_nThreads = 560;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Ats_PeriodicTasks_GeneralConfigurationEvent));
        Ats_PeriodicTasks_GeneralConfigurationEvent item_ = (Ats_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveAts_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "z";
        long agentmonitorservice_taskPeriodMillis = 705L;
        long basic_state_taskPeriodMillis = 495L;
        long heartbeat_taskPeriodMillis = 264L;
        long monitor_check_taskPeriodMillis = 58L;
        long monitor_publish_taskPeriodMillis = 201L;
        long monitor_update_taskPeriodMillis = 271L;
        long runtimeinfo_taskPeriodMillis = 604L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, basic_state_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_PeriodicTasks_timersConfigurationEvent));
        Ats_PeriodicTasks_timersConfigurationEvent item_ = (Ats_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)basic_state_taskPeriodMillis, (long)item_.getBasic_state_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_Pfeiffer_DeviceConfigurationEvent() throws Exception {
        String version = "n";
        String devcName = "";
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Pfeiffer_DeviceConfigurationEvent(version, devcName));
        Assert.assertTrue((boolean)(item instanceof Ats_Pfeiffer_DeviceConfigurationEvent));
        Ats_Pfeiffer_DeviceConfigurationEvent item_ = (Ats_Pfeiffer_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)devcName, (Object)item_.getDevcName());
    }

    @Test
    public void sendReceiveAts_Pfeiffer_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Pfeiffer_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Ats_Pfeiffer_DevicesConfigurationEvent));
        Ats_Pfeiffer_DevicesConfigurationEvent item_ = (Ats_Pfeiffer_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveAts_TempCCDSetPoint_LimitsConfigurationEvent() throws Exception {
        String version = "c";
        double warnHi = 0.2438182234764099;
        double warnLo = 0.0923229455947876;
        double limitHi = 0.8818138241767883;
        double limitLo = 0.5860308408737183;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempCCDSetPoint_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempCCDSetPoint_LimitsConfigurationEvent));
        Ats_TempCCDSetPoint_LimitsConfigurationEvent item_ = (Ats_TempCCDSetPoint_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_TempCCD_LimitsConfigurationEvent() throws Exception {
        String version = "b";
        double warnHi = 0.06423187255859375;
        double warnLo = 0.3067221f;
        double limitHi = 0.7203307151794434;
        double limitLo = 0.4826417565345764;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempCCD_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempCCD_LimitsConfigurationEvent));
        Ats_TempCCD_LimitsConfigurationEvent item_ = (Ats_TempCCD_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_TempColdPlate_LimitsConfigurationEvent() throws Exception {
        String version = "w";
        double warnHi = 0.9668222069740295;
        double warnLo = 0.663765013217926;
        double limitHi = 0.033656537532806396;
        double limitLo = 0.2932351231575012;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempColdPlate_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempColdPlate_LimitsConfigurationEvent));
        Ats_TempColdPlate_LimitsConfigurationEvent item_ = (Ats_TempColdPlate_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_TempCryoHead_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.6512604355812073;
        double warnLo = 0.03273433446884155;
        double limitHi = 0.23275268077850342;
        double limitLo = 0.8946744203567505;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempCryoHead_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempCryoHead_LimitsConfigurationEvent));
        Ats_TempCryoHead_LimitsConfigurationEvent item_ = (Ats_TempCryoHead_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_Vacuum_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double warnHi = 0.5685842633247375;
        double warnLo = 0.4770635962486267;
        double limitHi = 0.5543696880340576;
        double limitLo = 0.7836690545082092;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Vacuum_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_Vacuum_LimitsConfigurationEvent));
        Ats_Vacuum_LimitsConfigurationEvent item_ = (Ats_Vacuum_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_Device_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_Device_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_Device_DevicesConfigurationEvent));
        Bonn_shutter_Device_DevicesConfigurationEvent item_ = (Bonn_shutter_Device_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveBonn_shutter_Device_GeneralConfigurationEvent() throws Exception {
        String version = "o";
        String devcId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_Device_GeneralConfigurationEvent(version, devcId));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_Device_GeneralConfigurationEvent));
        Bonn_shutter_Device_GeneralConfigurationEvent item_ = (Bonn_shutter_Device_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveBonn_shutter_Device_LimitsConfigurationEvent() throws Exception {
        String version = "l";
        double bonn_V36_warnHi = 0.01894927f;
        double bonn_V36_warnLo = 0.3528527021408081;
        double bonn_V36_limitHi = 0.9307073354721069;
        double bonn_V36_limitLo = 0.974181592464447;
        double bonn_V5_warnHi = 0.41983598470687866;
        double bonn_V5_warnLo = 0.9204593300819397;
        double bonn_V5_limitHi = 0.844366192817688;
        double bonn_V5_limitLo = 0.6191104650497437;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_Device_LimitsConfigurationEvent(version, bonn_V36_warnHi, bonn_V36_warnLo, bonn_V36_limitHi, bonn_V36_limitLo, bonn_V5_warnHi, bonn_V5_warnLo, bonn_V5_limitHi, bonn_V5_limitLo));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_Device_LimitsConfigurationEvent));
        Bonn_shutter_Device_LimitsConfigurationEvent item_ = (Bonn_shutter_Device_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)bonn_V36_warnHi, (double)item_.getBonn_V36_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_warnLo, (double)item_.getBonn_V36_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_limitHi, (double)item_.getBonn_V36_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_limitLo, (double)item_.getBonn_V36_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_warnHi, (double)item_.getBonn_V5_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_warnLo, (double)item_.getBonn_V5_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_limitHi, (double)item_.getBonn_V5_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_limitLo, (double)item_.getBonn_V5_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_GeneralConfigurationEvent() throws Exception {
        String version = "";
        double maxExposureTime = 0.6157971620559692;
        double minExposureTime = 0.5302456617355347;
        int openCloseTimeMillis = 43;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_GeneralConfigurationEvent(version, maxExposureTime, minExposureTime, openCloseTimeMillis));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_GeneralConfigurationEvent));
        Bonn_shutter_GeneralConfigurationEvent item_ = (Bonn_shutter_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)maxExposureTime, (double)item_.getMaxExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)minExposureTime, (double)item_.getMinExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((long)openCloseTimeMillis, (long)item_.getOpenCloseTimeMillis());
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 480;
        int schedulers_default_nThreads = 678;
        int schedulers_monitor_update_publish_scheduler_nTasks = 128;
        int schedulers_monitor_update_publish_scheduler_nThreads = 596;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent));
        Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent item_ = (Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "z";
        long agentmonitorservice_taskPeriodMillis = 591L;
        long heartbeat_taskPeriodMillis = 309L;
        long monitor_check_taskPeriodMillis = 439L;
        long monitor_publish_taskPeriodMillis = 528L;
        long monitor_update_taskPeriodMillis = 726L;
        long runtimeinfo_taskPeriodMillis = 458L;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasks_timersConfigurationEvent));
        Bonn_shutter_PeriodicTasks_timersConfigurationEvent item_ = (Bonn_shutter_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_CommandsConfigurationEvent() throws Exception {
        String version = "";
        String imagehandlingconfig_commands = "v";
        String imagehandlingconfig_currentDirectory = "";
        String imagehandlingconfig_environment = "e";
        String imagehandlingconfig_logDirectory = "l";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_CommandsConfigurationEvent(version, imagehandlingconfig_commands, imagehandlingconfig_currentDirectory, imagehandlingconfig_environment, imagehandlingconfig_logDirectory));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_CommandsConfigurationEvent));
        Image_handling_ImageHandler_CommandsConfigurationEvent item_ = (Image_handling_ImageHandler_CommandsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_commands, (Object)item_.getImagehandlingconfig_commands());
        Assert.assertEquals((Object)imagehandlingconfig_currentDirectory, (Object)item_.getImagehandlingconfig_currentDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_environment, (Object)item_.getImagehandlingconfig_environment());
        Assert.assertEquals((Object)imagehandlingconfig_logDirectory, (Object)item_.getImagehandlingconfig_logDirectory());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_DAQConfigurationEvent() throws Exception {
        String version = "";
        int imagehandlingconfig_badPixelAlarmLevel = 986;
        int imagehandlingconfig_badPixelHighThreshold = 106;
        int imagehandlingconfig_badPixelLowThreshold = 435;
        int imagehandlingconfig_badPixelWarningLevel = 996;
        boolean imagehandlingconfig_checkForBadPixels = false;
        String imagehandlingconfig_daqFolder = "w";
        String imagehandlingconfig_daqPartition = "";
        int imagehandlingconfig_daqThreads = 421;
        String imagehandlingconfig_locations = "";
        boolean imagehandlingconfig_useStreaming = false;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_DAQConfigurationEvent(version, imagehandlingconfig_badPixelAlarmLevel, imagehandlingconfig_badPixelHighThreshold, imagehandlingconfig_badPixelLowThreshold, imagehandlingconfig_badPixelWarningLevel, imagehandlingconfig_checkForBadPixels, imagehandlingconfig_daqFolder, imagehandlingconfig_daqPartition, imagehandlingconfig_daqThreads, imagehandlingconfig_locations, imagehandlingconfig_useStreaming));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_DAQConfigurationEvent));
        Image_handling_ImageHandler_DAQConfigurationEvent item_ = (Image_handling_ImageHandler_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)imagehandlingconfig_badPixelAlarmLevel, (long)item_.getImagehandlingconfig_badPixelAlarmLevel());
        Assert.assertEquals((long)imagehandlingconfig_badPixelHighThreshold, (long)item_.getImagehandlingconfig_badPixelHighThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelLowThreshold, (long)item_.getImagehandlingconfig_badPixelLowThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelWarningLevel, (long)item_.getImagehandlingconfig_badPixelWarningLevel());
        Assert.assertEquals((Object)imagehandlingconfig_checkForBadPixels, (Object)item_.isImagehandlingconfig_checkForBadPixels());
        Assert.assertEquals((Object)imagehandlingconfig_daqFolder, (Object)item_.getImagehandlingconfig_daqFolder());
        Assert.assertEquals((Object)imagehandlingconfig_daqPartition, (Object)item_.getImagehandlingconfig_daqPartition());
        Assert.assertEquals((long)imagehandlingconfig_daqThreads, (long)item_.getImagehandlingconfig_daqThreads());
        Assert.assertEquals((Object)imagehandlingconfig_locations, (Object)item_.getImagehandlingconfig_locations());
        Assert.assertEquals((Object)imagehandlingconfig_useStreaming, (Object)item_.isImagehandlingconfig_useStreaming());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_FitsHandlingConfigurationEvent() throws Exception {
        String version = "p";
        boolean imagehandlingconfig_FITSAutoSave = false;
        String imagehandlingconfig_FITSDirectoryPattern = "";
        String imagehandlingconfig_FITSFilePattern = "";
        String imagehandlingconfig_FITSRootDirectory = "r";
        String imagehandlingconfig_subsystemsToClearOnNewRun = "d";
        String imagehandlingconfig_tempFileRelativeLocation = "";
        boolean imagehandlingconfig_useTempFile = false;
        String imagehandlingconfig_waitForHeaderService = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_FitsHandlingConfigurationEvent(version, imagehandlingconfig_FITSAutoSave, imagehandlingconfig_FITSDirectoryPattern, imagehandlingconfig_FITSFilePattern, imagehandlingconfig_FITSRootDirectory, imagehandlingconfig_subsystemsToClearOnNewRun, imagehandlingconfig_tempFileRelativeLocation, imagehandlingconfig_useTempFile, imagehandlingconfig_waitForHeaderService));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_FitsHandlingConfigurationEvent));
        Image_handling_ImageHandler_FitsHandlingConfigurationEvent item_ = (Image_handling_ImageHandler_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_FITSAutoSave, (Object)item_.isImagehandlingconfig_FITSAutoSave());
        Assert.assertEquals((Object)imagehandlingconfig_FITSDirectoryPattern, (Object)item_.getImagehandlingconfig_FITSDirectoryPattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSFilePattern, (Object)item_.getImagehandlingconfig_FITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSRootDirectory, (Object)item_.getImagehandlingconfig_FITSRootDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_subsystemsToClearOnNewRun, (Object)item_.getImagehandlingconfig_subsystemsToClearOnNewRun());
        Assert.assertEquals((Object)imagehandlingconfig_tempFileRelativeLocation, (Object)item_.getImagehandlingconfig_tempFileRelativeLocation());
        Assert.assertEquals((Object)imagehandlingconfig_useTempFile, (Object)item_.isImagehandlingconfig_useTempFile());
        Assert.assertEquals((Object)imagehandlingconfig_waitForHeaderService, (Object)item_.getImagehandlingconfig_waitForHeaderService());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 561;
        int schedulers_default_nThreads = 178;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_GeneralConfigurationEvent));
        Image_handling_PeriodicTasks_GeneralConfigurationEvent item_ = (Image_handling_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "g";
        long agentmonitorservice_taskPeriodMillis = 324L;
        long heartbeat_taskPeriodMillis = 185L;
        long runtimeinfo_taskPeriodMillis = 367L;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_timersConfigurationEvent));
        Image_handling_PeriodicTasks_timersConfigurationEvent item_ = (Image_handling_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveImage_handling_Reb_FitsHandlingConfigurationEvent() throws Exception {
        String version = "i";
        boolean[] enabled = new boolean[]{false};
        String location = "h";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_Reb_FitsHandlingConfigurationEvent(version, enabled, location));
        Assert.assertTrue((boolean)(item instanceof Image_handling_Reb_FitsHandlingConfigurationEvent));
        Image_handling_Reb_FitsHandlingConfigurationEvent item_ = (Image_handling_Reb_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])enabled, (boolean[])item_.getEnabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveImage_handling_Reb_GeneralConfigurationEvent() throws Exception {
        String version = "x";
        String fitsservice_headerFilesList = "";
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_Reb_GeneralConfigurationEvent(version, fitsservice_headerFilesList, location));
        Assert.assertTrue((boolean)(item instanceof Image_handling_Reb_GeneralConfigurationEvent));
        Image_handling_Reb_GeneralConfigurationEvent item_ = (Image_handling_Reb_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)fitsservice_headerFilesList, (Object)item_.getFitsservice_headerFilesList());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveShutterBladeMotionProfileEvent() throws Exception {
        ShutterBladeMotionProfileEvent.Blade blade = ShutterBladeMotionProfileEvent.Blade.PLUS_X;
        ShutterBladeMotionProfileEvent.Direction direction = ShutterBladeMotionProfileEvent.Direction.OPEN;
        double timestampStart = 0.300825834274292;
        double startPosition = 0.15915173292160034;
        double targetDuration = 0.4622097f;
        double targetPosition = 0.021161377429962158;
        double endPosition = 0.5130382180213928;
        double actualDuration = 0.7473477721214294;
        int hallSensorCount = 989;
        double[] timestampHallSensor = TestHelper.generateDoubleArray((int)240, (int)-2049513134);
        int[] hallSensorID = TestHelper.generateIntArray((int)240, (int)160541376);
        double[] hallSensorPosition = TestHelper.generateDoubleArray((int)240, (int)-398152021);
        boolean[] hallSensorTransition = new boolean[]{true, true, true, false, false, false, true, false, false, false, false, true, false, true, true, true, false, false, true, false, false, true, false, false, false, true, false, false, false, true, true, true, false, true, true, false, false, false, false, false, false, false, true, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, false, false, true, false, true, false, false, true, true, false, false, true, true, false, true, true, true, false, true, false, false, true, true, false, true, true, false, false, false, false, false, false, true, true, true, true, false, true, false, false, false, false, true, false, true, false, true, true, false, false, true, false, true, false, false, true, true, true, true, true, true, false, false, true, true, true, true, true, true, true, true, false, true, false, true, true, false, false, false, true, true, false, true, false, false, false, false, true, false, false, false, true, false, false, false, true, true, true, false, true, false, true, false, false, true, true, true, false, false, false, true, false, false, true, true, false, false, false, false, false, true, false, true, true, false, false, true, true, true, false, true, false, true, false, true, false, false, true, true, true, false, true, true, false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, true, false, true, false, false, true, false, true, true, true, false, true, true, true, false};
        int encoderCount = 546;
        double[] timestampEncoder = TestHelper.generateDoubleArray((int)240, (int)2052905965);
        double[] encoderPosition = TestHelper.generateDoubleArray((int)240, (int)653908139);
        SALEvent item = this.testSendReceive((SALEvent)new ShutterBladeMotionProfileEvent(blade, direction, timestampStart, startPosition, targetDuration, targetPosition, endPosition, actualDuration, hallSensorCount, timestampHallSensor, hallSensorID, hallSensorPosition, hallSensorTransition, encoderCount, timestampEncoder, encoderPosition));
        Assert.assertTrue((boolean)(item instanceof ShutterBladeMotionProfileEvent));
        ShutterBladeMotionProfileEvent item_ = (ShutterBladeMotionProfileEvent)item;
        Assert.assertEquals((Object)blade, (Object)item_.getBlade());
        Assert.assertEquals((Object)direction, (Object)item_.getDirection());
        Assert.assertEquals((double)timestampStart, (double)item_.getTimestampStart(), (double)1.0E-6f);
        Assert.assertEquals((double)startPosition, (double)item_.getStartPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)targetDuration, (double)item_.getTargetDuration(), (double)1.0E-6f);
        Assert.assertEquals((double)targetPosition, (double)item_.getTargetPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)endPosition, (double)item_.getEndPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)actualDuration, (double)item_.getActualDuration(), (double)1.0E-6f);
        Assert.assertEquals((long)hallSensorCount, (long)item_.getHallSensorCount());
        Assert.assertArrayEquals((double[])timestampHallSensor, (double[])item_.getTimestampHallSensor(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])hallSensorID, (int[])item_.getHallSensorID());
        Assert.assertArrayEquals((double[])hallSensorPosition, (double[])item_.getHallSensorPosition(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])hallSensorTransition, (boolean[])item_.getHallSensorTransition());
        Assert.assertEquals((long)encoderCount, (long)item_.getEncoderCount());
        Assert.assertArrayEquals((double[])timestampEncoder, (double[])item_.getTimestampEncoder(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])encoderPosition, (double[])item_.getEncoderPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageStoredEvent() throws Exception {
        String imageName = "oogvaqaqwbdxp";
        double timestampImageStored = 0.5026865005493164;
        SALEvent item = this.testSendReceive((SALEvent)new ImageStoredEvent(imageName, timestampImageStored));
        Assert.assertTrue((boolean)(item instanceof ImageStoredEvent));
        ImageStoredEvent item_ = (ImageStoredEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampImageStored, (double)item_.getTimestampImageStored(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFitsFilesWrittenEvent() throws Exception {
        String imageName = "igtoptrbizuvelqbeqaztjdw";
        double timestampFilesWritten = 0.11279827356338501;
        String rootFileName = "s";
        String relativeFileNames = "";
        String fileNode = "g";
        SALEvent item = this.testSendReceive((SALEvent)new FitsFilesWrittenEvent(imageName, timestampFilesWritten, rootFileName, relativeFileNames, fileNode));
        Assert.assertTrue((boolean)(item instanceof FitsFilesWrittenEvent));
        FitsFilesWrittenEvent item_ = (FitsFilesWrittenEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampFilesWritten, (double)item_.getTimestampFilesWritten(), (double)1.0E-6f);
        Assert.assertEquals((Object)rootFileName, (Object)item_.getRootFileName());
        Assert.assertEquals((Object)relativeFileNames, (Object)item_.getRelativeFileNames());
        Assert.assertEquals((Object)fileNode, (Object)item_.getFileNode());
    }

    @Test
    public void sendReceiveFileCommandExecutionEvent() throws Exception {
        String imageName = "rcfzmbojfboddazlbejnzmrgoqs";
        double timestampCommandComplete = 0.5729556679725647;
        String command = "p";
        int rc = 727;
        SALEvent item = this.testSendReceive((SALEvent)new FileCommandExecutionEvent(imageName, timestampCommandComplete, command, rc));
        Assert.assertTrue((boolean)(item instanceof FileCommandExecutionEvent));
        FileCommandExecutionEvent item_ = (FileCommandExecutionEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampCommandComplete, (double)item_.getTimestampCommandComplete(), (double)1.0E-6f);
        Assert.assertEquals((Object)command, (Object)item_.getCommand());
        Assert.assertEquals((long)rc, (long)item_.getRc());
    }

    @Test
    public void sendReceiveImageVisualizationEvent() throws Exception {
        String imageName = "tnqtmoqgwhdf";
        double timestampVisualizationAvailable = 0.48851585388183594;
        String url = "";
        String thumbnail = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageVisualizationEvent(imageName, timestampVisualizationAvailable, url, thumbnail));
        Assert.assertTrue((boolean)(item instanceof ImageVisualizationEvent));
        ImageVisualizationEvent item_ = (ImageVisualizationEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampVisualizationAvailable, (double)item_.getTimestampVisualizationAvailable(), (double)1.0E-6f);
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)thumbnail, (Object)item_.getThumbnail());
    }

    @Test
    public void sendReceiveSummaryStatusEvent() throws Exception {
        double timestampStatusChanged = 0.8507076501846313;
        String subsystems = "";
        String subsystemState = "u";
        String subsystemColor = "n";
        String additionalInfo = "";
        String drillDownLinks = "r";
        SALEvent item = this.testSendReceive((SALEvent)new SummaryStatusEvent(timestampStatusChanged, subsystems, subsystemState, subsystemColor, additionalInfo, drillDownLinks));
        Assert.assertTrue((boolean)(item instanceof SummaryStatusEvent));
        SummaryStatusEvent item_ = (SummaryStatusEvent)item;
        Assert.assertEquals((double)timestampStatusChanged, (double)item_.getTimestampStatusChanged(), (double)1.0E-6f);
        Assert.assertEquals((Object)subsystems, (Object)item_.getSubsystems());
        Assert.assertEquals((Object)subsystemState, (Object)item_.getSubsystemState());
        Assert.assertEquals((Object)subsystemColor, (Object)item_.getSubsystemColor());
        Assert.assertEquals((Object)additionalInfo, (Object)item_.getAdditionalInfo());
        Assert.assertEquals((Object)drillDownLinks, (Object)item_.getDrillDownLinks());
    }

    @Test
    public void sendReceiveAlertRaisedEvent() throws Exception {
        double timestampAlertStatusChanged = 0.17069f;
        String alertId = "p";
        String description = "";
        AlertRaisedEvent.CurrentSeverity currentSeverity = AlertRaisedEvent.CurrentSeverity.ALARM;
        int highestSeverity = 620;
        boolean isCleared = false;
        String cause = "b";
        String origin = "";
        String additionalInfo = "";
        SALEvent item = this.testSendReceive((SALEvent)new AlertRaisedEvent(timestampAlertStatusChanged, alertId, description, currentSeverity, highestSeverity, isCleared, cause, origin, additionalInfo));
        Assert.assertTrue((boolean)(item instanceof AlertRaisedEvent));
        AlertRaisedEvent item_ = (AlertRaisedEvent)item;
        Assert.assertEquals((double)timestampAlertStatusChanged, (double)item_.getTimestampAlertStatusChanged(), (double)1.0E-6f);
        Assert.assertEquals((Object)alertId, (Object)item_.getAlertId());
        Assert.assertEquals((Object)description, (Object)item_.getDescription());
        Assert.assertEquals((Object)currentSeverity, (Object)item_.getCurrentSeverity());
        Assert.assertEquals((long)highestSeverity, (long)item_.getHighestSeverity());
        Assert.assertEquals((Object)isCleared, (Object)item_.isIsCleared());
        Assert.assertEquals((Object)cause, (Object)item_.getCause());
        Assert.assertEquals((Object)origin, (Object)item_.getOrigin());
        Assert.assertEquals((Object)additionalInfo, (Object)item_.getAdditionalInfo());
    }

    @Test
    public void sendReceiveConfigurationAppliedEvent() throws Exception {
        String configurations = "u";
        String version = "";
        String url = "";
        String schemaVersion = "";
        String otherInfo = "i";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationAppliedEvent(configurations, version, url, schemaVersion, otherInfo));
        Assert.assertTrue((boolean)(item instanceof ConfigurationAppliedEvent));
        ConfigurationAppliedEvent item_ = (ConfigurationAppliedEvent)item;
        Assert.assertEquals((Object)configurations, (Object)item_.getConfigurations());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
        Assert.assertEquals((Object)otherInfo, (Object)item_.getOtherInfo());
    }

    @Test
    public void sendReceiveConfigurationsAvailableEvent() throws Exception {
        String overrides = "";
        String version = "";
        String url = "q";
        String schemaVersion = "";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationsAvailableEvent(overrides, version, url, schemaVersion));
        Assert.assertTrue((boolean)(item instanceof ConfigurationsAvailableEvent));
        ConfigurationsAvailableEvent item_ = (ConfigurationsAvailableEvent)item;
        Assert.assertEquals((Object)overrides, (Object)item_.getOverrides());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int errorCode = 237;
        String errorReport = "w";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int level = 684;
        String subsystem = "";
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(level, subsystem));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)subsystem, (Object)item_.getSubsystem());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        String name = "a";
        int level = 378;
        String message = "";
        String traceback = "";
        String filePath = "";
        String functionName = "";
        int lineNumber = 657;
        int process = 93;
        double timestamp = 0.02484762668609619;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(name, level, message, traceback, filePath, functionName, lineNumber, process, timestamp));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
        Assert.assertEquals((double)timestamp, (double)item_.getTimestamp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int mode = 435;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        String salVersion = "lfacxhnmwrnxivxmzbatnddascitozxtcfkvyqfaajdyphkrogiabrydtauvlrcbinovajubbdnysrmhrewmxjjnfoobpzsyvmzwrgadvcldlwmkltbvrhgvouipdzgrdpesevgjslvnvaabfgnhxtvojhrbbbatioozejufjdcygrtsrcekkmppbabqpewcaumtxwn";
        String xmlVersion = "hxdxousukjpdoiuj";
        String openSpliceVersion = "ivovaqkmutsjsdwutkucxnkmcaokqncaqvhcnrspiofdrptratbkajdbywwqebdasnjlscwtzrsustgxfzgxavknpsuwcsxplckkhnlmimbwcdzkopkhrdbeqjbjivltqcbvksqdwsrdkragxankbzfmqwccmlofjzmiztzpbnfpgmqupgyxtuvgsklntesqjwhetavdyxrdiukvymcttf";
        String cscVersion = "healssscajwuwnukbf";
        String subsystemVersions = "";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        String authorizedUsers = "m";
        String nonAuthorizedCSCs = "";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }

    @Test
    public void sendReceiveLargeFileObjectAvailableEvent() throws Exception {
        String url = "toauuxmjjgnwqphxdpctesikdvbkudtgpjdpmotwmouafgbkkjjgxccdyvuoherhkxhnkkckkfqeyvmoyupmrcntbzfyselziwzdafualjcejeewreankfolkflbpvhvpykfuqlptqxhqwocmidhftfrbbvuqffcgfrzdbygnrqkkvbbieyykwpejjul";
        String generator = "yzoqlplwaljyjzrnavkzkpecckdjdgwsspqdhxsrhhzcjfsgzljzdbejtqhztxvrgspliwuqzuglcmmagvqpkcorirrijxkadmahkdaswumkakrxjiycrfcdkzzvzeydlaqcyvbkexxkzwvxeobydhcql";
        float version = 0.78291196f;
        int byteSize = 574;
        String checkSum = "pbvsgxkhyzcyctfskkygismzzzgwqqnubltxijrcbkwyyktoniqxoiiejiqhkhlzxzryrppjgktyuidsadlrqycmwzfugrhrwlveqejngcsnjnephetgmsiibgdriudkkgalhgs";
        String mimeType = "psvezzhsjwhuwstkppshewoapenvgtmubdmhuyapritluircfwgqcvlfkmkxcpmsylccjokqqhxmncebblhkdblsqslavgmlnjxhoehsowscimqglhewdwngqrbehdscepwhxmvkmfzxbywzkvvdwpdne";
        String id = "mnnnsixrkvjbnlpnezxwubjqcttkadygrjzmarfgbbmfwpjagbpgydzuxqeadhsupppvdtuqnhujcmhhhsohdszawjbsjgdrjuebfzwbdmatcfqfcmcjgbxmyihihxpsmyievkzlpv";
        SALEvent item = this.testSendReceive((SALEvent)new LargeFileObjectAvailableEvent(url, generator, version, byteSize, checkSum, mimeType, id));
        Assert.assertTrue((boolean)(item instanceof LargeFileObjectAvailableEvent));
        LargeFileObjectAvailableEvent item_ = (LargeFileObjectAvailableEvent)item;
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)generator, (Object)item_.getGenerator());
        Assert.assertEquals((float)version, (float)item_.getVersion(), (float)1.0E-6f);
        Assert.assertEquals((long)byteSize, (long)item_.getByteSize());
        Assert.assertEquals((Object)checkSum, (Object)item_.getCheckSum());
        Assert.assertEquals((Object)mimeType, (Object)item_.getMimeType());
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }
}

