package org.lsst.sal.atcamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class VacuumTelemetry extends CameraTelemetry {
  private final double tempCCD;

  private final double tempCCDSetPoint;

  private final double tempColdPlate;

  private final double tempCryoHead;

  private final double vacuum;

  public VacuumTelemetry(double tempCCD, double tempCCDSetPoint, double tempColdPlate,
      double tempCryoHead, double vacuum) {
    this.tempCCD = tempCCD;
    this.tempCCDSetPoint = tempCCDSetPoint;
    this.tempColdPlate = tempColdPlate;
    this.tempCryoHead = tempCryoHead;
    this.vacuum = vacuum;
  }

  public double getTempCCD() {
    return tempCCD;
  }

  public double getTempCCDSetPoint() {
    return tempCCDSetPoint;
  }

  public double getTempColdPlate() {
    return tempColdPlate;
  }

  public double getTempCryoHead() {
    return tempCryoHead;
  }

  public double getVacuum() {
    return vacuum;
  }

  @Override
  public String toString() {
    return "VacuumTelemetry{" + "tempCCD=" + tempCCD +", tempCCDSetPoint=" + tempCCDSetPoint +
        ", tempColdPlate=" + tempColdPlate +", tempCryoHead=" + tempCryoHead +", vacuum=" + vacuum +
        "}";
  }
}
