package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Ats_power_Hameg3_PowerConfigurationEvent extends CameraEvent {
  private final String version;

  private final double aux_current;

  private final double aux_offDelay;

  private final double aux_onDelay;

  private final double aux_voltage;

  private final String connType;

  private final String devcId;

  private final int devcParm;

  private final double fan_current;

  private final double fan_offDelay;

  private final double fan_onDelay;

  private final double fan_voltage;

  private final double otm_current;

  private final double otm_offDelay;

  private final double otm_onDelay;

  private final double otm_voltage;

  public Ats_power_Hameg3_PowerConfigurationEvent(String version, double aux_current,
      double aux_offDelay, double aux_onDelay, double aux_voltage, String connType, String devcId,
      int devcParm, double fan_current, double fan_offDelay, double fan_onDelay, double fan_voltage,
      double otm_current, double otm_offDelay, double otm_onDelay, double otm_voltage) {
    this.version = version;
    this.aux_current = aux_current;
    this.aux_offDelay = aux_offDelay;
    this.aux_onDelay = aux_onDelay;
    this.aux_voltage = aux_voltage;
    this.connType = connType;
    this.devcId = devcId;
    this.devcParm = devcParm;
    this.fan_current = fan_current;
    this.fan_offDelay = fan_offDelay;
    this.fan_onDelay = fan_onDelay;
    this.fan_voltage = fan_voltage;
    this.otm_current = otm_current;
    this.otm_offDelay = otm_offDelay;
    this.otm_onDelay = otm_onDelay;
    this.otm_voltage = otm_voltage;
  }

  public String getVersion() {
    return version;
  }

  public double getAux_current() {
    return aux_current;
  }

  public double getAux_offDelay() {
    return aux_offDelay;
  }

  public double getAux_onDelay() {
    return aux_onDelay;
  }

  public double getAux_voltage() {
    return aux_voltage;
  }

  public String getConnType() {
    return connType;
  }

  public String getDevcId() {
    return devcId;
  }

  public int getDevcParm() {
    return devcParm;
  }

  public double getFan_current() {
    return fan_current;
  }

  public double getFan_offDelay() {
    return fan_offDelay;
  }

  public double getFan_onDelay() {
    return fan_onDelay;
  }

  public double getFan_voltage() {
    return fan_voltage;
  }

  public double getOtm_current() {
    return otm_current;
  }

  public double getOtm_offDelay() {
    return otm_offDelay;
  }

  public double getOtm_onDelay() {
    return otm_onDelay;
  }

  public double getOtm_voltage() {
    return otm_voltage;
  }

  @Override
  public String toString() {
    return "Ats_power_Hameg3_PowerConfigurationEvent{" + "version=" + version +
        ", aux_current=" + aux_current +", aux_offDelay=" + aux_offDelay +
        ", aux_onDelay=" + aux_onDelay +", aux_voltage=" + aux_voltage +", connType=" + connType +
        ", devcId=" + devcId +", devcParm=" + devcParm +", fan_current=" + fan_current +
        ", fan_offDelay=" + fan_offDelay +", fan_onDelay=" + fan_onDelay +
        ", fan_voltage=" + fan_voltage +", otm_current=" + otm_current +
        ", otm_offDelay=" + otm_offDelay +", otm_onDelay=" + otm_onDelay +
        ", otm_voltage=" + otm_voltage +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double aux_current;

    private double aux_offDelay;

    private double aux_onDelay;

    private double aux_voltage;

    private String connType;

    private String devcId;

    private int devcParm;

    private double fan_current;

    private double fan_offDelay;

    private double fan_onDelay;

    private double fan_voltage;

    private double otm_current;

    private double otm_offDelay;

    private double otm_onDelay;

    private double otm_voltage;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder aux_current(double aux_current) {
      this.aux_current = aux_current;
      return this;
    }

    public Builder aux_offDelay(double aux_offDelay) {
      this.aux_offDelay = aux_offDelay;
      return this;
    }

    public Builder aux_onDelay(double aux_onDelay) {
      this.aux_onDelay = aux_onDelay;
      return this;
    }

    public Builder aux_voltage(double aux_voltage) {
      this.aux_voltage = aux_voltage;
      return this;
    }

    public Builder connType(String connType) {
      this.connType = connType;
      return this;
    }

    public Builder devcId(String devcId) {
      this.devcId = devcId;
      return this;
    }

    public Builder devcParm(int devcParm) {
      this.devcParm = devcParm;
      return this;
    }

    public Builder fan_current(double fan_current) {
      this.fan_current = fan_current;
      return this;
    }

    public Builder fan_offDelay(double fan_offDelay) {
      this.fan_offDelay = fan_offDelay;
      return this;
    }

    public Builder fan_onDelay(double fan_onDelay) {
      this.fan_onDelay = fan_onDelay;
      return this;
    }

    public Builder fan_voltage(double fan_voltage) {
      this.fan_voltage = fan_voltage;
      return this;
    }

    public Builder otm_current(double otm_current) {
      this.otm_current = otm_current;
      return this;
    }

    public Builder otm_offDelay(double otm_offDelay) {
      this.otm_offDelay = otm_offDelay;
      return this;
    }

    public Builder otm_onDelay(double otm_onDelay) {
      this.otm_onDelay = otm_onDelay;
      return this;
    }

    public Builder otm_voltage(double otm_voltage) {
      this.otm_voltage = otm_voltage;
      return this;
    }

    public Ats_power_Hameg3_PowerConfigurationEvent build() {
      return new Ats_power_Hameg3_PowerConfigurationEvent(version, aux_current, aux_offDelay, aux_onDelay, aux_voltage, connType, devcId, devcParm, fan_current, fan_offDelay, fan_onDelay, fan_voltage, otm_current, otm_offDelay, otm_onDelay, otm_voltage);
    }
  }
}
