/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.telemetry.Bonn_shutter_DeviceTelemetry;
import org.lsst.sal.atcamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.atcamera.telemetry.PowerTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)1, (int)426258294);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)1, (int)826207281);
        double[] oDV = TestHelper.generateDoubleArray((int)1, (int)1628375475);
        double[] oGV = TestHelper.generateDoubleArray((int)1, (int)-1388855356);
        double[] rDV = TestHelper.generateDoubleArray((int)1, (int)1960825723);
        double[] temp = TestHelper.generateDoubleArray((int)1, (int)-1819519695);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)1, (int)-831808054);
        double[] anaV = TestHelper.generateDoubleArray((int)1, (int)881448619);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)1, (int)179097341);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)1, (int)-2121400050);
        double[] clkHI = TestHelper.generateDoubleArray((int)1, (int)1818474748);
        double[] clkHV = TestHelper.generateDoubleArray((int)1, (int)116575277);
        double[] clkLV = TestHelper.generateDoubleArray((int)1, (int)867775309);
        double[] digI = TestHelper.generateDoubleArray((int)1, (int)1896192551);
        double[] digV = TestHelper.generateDoubleArray((int)1, (int)-671050089);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)1, (int)-530657246);
        double[] htrPI = TestHelper.generateDoubleArray((int)1, (int)1728507862);
        double[] htrPV = TestHelper.generateDoubleArray((int)1, (int)1816315155);
        double[] htrV = TestHelper.generateDoubleArray((int)1, (int)-145023279);
        double[] htrW = TestHelper.generateDoubleArray((int)1, (int)512993155);
        String location = "i";
        double[] oDI = TestHelper.generateDoubleArray((int)1, (int)1676068823);
        double[] oDV = TestHelper.generateDoubleArray((int)1, (int)532314596);
        double[] pClk0 = TestHelper.generateDoubleArray((int)1, (int)-852385506);
        double[] pClkL = TestHelper.generateDoubleArray((int)1, (int)161948990);
        double[] pClkU = TestHelper.generateDoubleArray((int)1, (int)1046541350);
        double[] power = TestHelper.generateDoubleArray((int)1, (int)1534751554);
        double[] rG0 = TestHelper.generateDoubleArray((int)1, (int)-1556803224);
        double[] rGL = TestHelper.generateDoubleArray((int)1, (int)-23114266);
        double[] rGU = TestHelper.generateDoubleArray((int)1, (int)1478976026);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)1, (int)-646627841);
        double[] sClk0 = TestHelper.generateDoubleArray((int)1, (int)-1133292245);
        double[] sClkL = TestHelper.generateDoubleArray((int)1, (int)2081367091);
        double[] sClkU = TestHelper.generateDoubleArray((int)1, (int)-20086588);
        double[] temp1 = TestHelper.generateDoubleArray((int)1, (int)360880425);
        double[] temp2 = TestHelper.generateDoubleArray((int)1, (int)1551576320);
        double[] temp3 = TestHelper.generateDoubleArray((int)1, (int)-1670111726);
        double[] temp4 = TestHelper.generateDoubleArray((int)1, (int)200392192);
        double[] temp5 = TestHelper.generateDoubleArray((int)1, (int)-1273458942);
        double[] temp6 = TestHelper.generateDoubleArray((int)1, (int)-1312180599);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicu_Temp0, clkHI, clkHV, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClkL, pClkU, power, rG0, rGL, rGU, rTDTemp, sClk0, sClkL, sClkU, temp1, temp2, temp3, temp4, temp5, temp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.4423891305923462;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.8195973038673401;
        double freeFraction = 0.8911446928977966;
        double freeSpace = 0.9449220299720764;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePowerTelemetry() throws Exception {
        double analog_I = 0.3727429509162903;
        double analog_V = 0.3365599f;
        double aux_I = 0.2162773609161377;
        double aux_V = 0.08686792850494385;
        double clkhigh_I = 0.5236115455627441;
        double clkhigh_V = 0.11660957336425781;
        double clklow_I = 0.6386212110519409;
        double clklow_V = 0.5465096235275269;
        double dphi_I = 0.8977733850479126;
        double dphi_V = 0.7412078380584717;
        double digital_I = 0.33134692907333374;
        double digital_V = 0.14201372861862183;
        double fan_I = 0.4168702960014343;
        double fan_V = 0.9587225317955017;
        double hvbias_I = 0.8275997042655945;
        double hvbias_V = 0.7852810621261597;
        double od_I = 0.6418435573577881;
        double od_V = 0.3457095f;
        double otm_I = 0.5672187209129333;
        double otm_V = 0.45319098234176636;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PowerTelemetry(analog_I, analog_V, aux_I, aux_V, clkhigh_I, clkhigh_V, clklow_I, clklow_V, dphi_I, dphi_V, digital_I, digital_V, fan_I, fan_V, hvbias_I, hvbias_V, od_I, od_V, otm_I, otm_V));
        Assert.assertTrue((boolean)(item instanceof PowerTelemetry));
        PowerTelemetry item_ = (PowerTelemetry)item;
        Assert.assertEquals((double)analog_I, (double)item_.getAnalog_I(), (double)1.0E-6f);
        Assert.assertEquals((double)analog_V, (double)item_.getAnalog_V(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_I, (double)item_.getAux_I(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_V, (double)item_.getAux_V(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhigh_I, (double)item_.getClkhigh_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhigh_V, (double)item_.getClkhigh_V(), (double)1.0E-6f);
        Assert.assertEquals((double)clklow_I, (double)item_.getClklow_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clklow_V, (double)item_.getClklow_V(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_I, (double)item_.getDphi_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_V, (double)item_.getDphi_V(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_I, (double)item_.getDigital_I(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_V, (double)item_.getDigital_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_I, (double)item_.getFan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_V, (double)item_.getFan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_I, (double)item_.getHvbias_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_V, (double)item_.getHvbias_V(), (double)1.0E-6f);
        Assert.assertEquals((double)od_I, (double)item_.getOd_I(), (double)1.0E-6f);
        Assert.assertEquals((double)od_V, (double)item_.getOd_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_I, (double)item_.getOtm_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_V, (double)item_.getOtm_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumTelemetry() throws Exception {
        double tempCCD = 0.09826427698135376;
        double tempCCDSetPoint = 0.37387335300445557;
        double tempColdPlate = 0.3292325735092163;
        double tempCryoHead = 0.2597543001174927;
        double vacuum = 0.7892430424690247;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumTelemetry(tempCCD, tempCCDSetPoint, tempColdPlate, tempCryoHead, vacuum));
        Assert.assertTrue((boolean)(item instanceof VacuumTelemetry));
        VacuumTelemetry item_ = (VacuumTelemetry)item;
        Assert.assertEquals((double)tempCCD, (double)item_.getTempCCD(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCCDSetPoint, (double)item_.getTempCCDSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempColdPlate, (double)item_.getTempColdPlate(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCryoHead, (double)item_.getTempCryoHead(), (double)1.0E-6f);
        Assert.assertEquals((double)vacuum, (double)item_.getVacuum(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_DeviceTelemetry() throws Exception {
        double bonn_V36 = 0.11749368906021118;
        double bonn_V5 = 0.9075458645820618;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Bonn_shutter_DeviceTelemetry(bonn_V36, bonn_V5));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_DeviceTelemetry));
        Bonn_shutter_DeviceTelemetry item_ = (Bonn_shutter_DeviceTelemetry)item;
        Assert.assertEquals((double)bonn_V36, (double)item_.getBonn_V36(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5, (double)item_.getBonn_V5(), (double)1.0E-6f);
    }
}

