package org.lsst.sal.atcamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class PowerTelemetry extends CameraTelemetry {
  private final double analog_I;

  private final double analog_V;

  private final double aux_I;

  private final double aux_V;

  private final double clkhigh_I;

  private final double clkhigh_V;

  private final double clklow_I;

  private final double clklow_V;

  private final double dphi_I;

  private final double dphi_V;

  private final double digital_I;

  private final double digital_V;

  private final double fan_I;

  private final double fan_V;

  private final double hvbias_I;

  private final double hvbias_V;

  private final double od_I;

  private final double od_V;

  private final double otm_I;

  private final double otm_V;

  public PowerTelemetry(double analog_I, double analog_V, double aux_I, double aux_V,
      double clkhigh_I, double clkhigh_V, double clklow_I, double clklow_V, double dphi_I,
      double dphi_V, double digital_I, double digital_V, double fan_I, double fan_V,
      double hvbias_I, double hvbias_V, double od_I, double od_V, double otm_I, double otm_V) {
    this.analog_I = analog_I;
    this.analog_V = analog_V;
    this.aux_I = aux_I;
    this.aux_V = aux_V;
    this.clkhigh_I = clkhigh_I;
    this.clkhigh_V = clkhigh_V;
    this.clklow_I = clklow_I;
    this.clklow_V = clklow_V;
    this.dphi_I = dphi_I;
    this.dphi_V = dphi_V;
    this.digital_I = digital_I;
    this.digital_V = digital_V;
    this.fan_I = fan_I;
    this.fan_V = fan_V;
    this.hvbias_I = hvbias_I;
    this.hvbias_V = hvbias_V;
    this.od_I = od_I;
    this.od_V = od_V;
    this.otm_I = otm_I;
    this.otm_V = otm_V;
  }

  public double getAnalog_I() {
    return analog_I;
  }

  public double getAnalog_V() {
    return analog_V;
  }

  public double getAux_I() {
    return aux_I;
  }

  public double getAux_V() {
    return aux_V;
  }

  public double getClkhigh_I() {
    return clkhigh_I;
  }

  public double getClkhigh_V() {
    return clkhigh_V;
  }

  public double getClklow_I() {
    return clklow_I;
  }

  public double getClklow_V() {
    return clklow_V;
  }

  public double getDphi_I() {
    return dphi_I;
  }

  public double getDphi_V() {
    return dphi_V;
  }

  public double getDigital_I() {
    return digital_I;
  }

  public double getDigital_V() {
    return digital_V;
  }

  public double getFan_I() {
    return fan_I;
  }

  public double getFan_V() {
    return fan_V;
  }

  public double getHvbias_I() {
    return hvbias_I;
  }

  public double getHvbias_V() {
    return hvbias_V;
  }

  public double getOd_I() {
    return od_I;
  }

  public double getOd_V() {
    return od_V;
  }

  public double getOtm_I() {
    return otm_I;
  }

  public double getOtm_V() {
    return otm_V;
  }

  @Override
  public String toString() {
    return "PowerTelemetry{" + "analog_I=" + analog_I +", analog_V=" + analog_V +
        ", aux_I=" + aux_I +", aux_V=" + aux_V +", clkhigh_I=" + clkhigh_I +
        ", clkhigh_V=" + clkhigh_V +", clklow_I=" + clklow_I +", clklow_V=" + clklow_V +
        ", dphi_I=" + dphi_I +", dphi_V=" + dphi_V +", digital_I=" + digital_I +
        ", digital_V=" + digital_V +", fan_I=" + fan_I +", fan_V=" + fan_V +
        ", hvbias_I=" + hvbias_I +", hvbias_V=" + hvbias_V +", od_I=" + od_I +", od_V=" + od_V +
        ", otm_I=" + otm_I +", otm_V=" + otm_V +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double analog_I;

    private double analog_V;

    private double aux_I;

    private double aux_V;

    private double clkhigh_I;

    private double clkhigh_V;

    private double clklow_I;

    private double clklow_V;

    private double dphi_I;

    private double dphi_V;

    private double digital_I;

    private double digital_V;

    private double fan_I;

    private double fan_V;

    private double hvbias_I;

    private double hvbias_V;

    private double od_I;

    private double od_V;

    private double otm_I;

    private double otm_V;

    private Builder() {
    }

    public Builder analog_I(double analog_I) {
      this.analog_I = analog_I;
      return this;
    }

    public Builder analog_V(double analog_V) {
      this.analog_V = analog_V;
      return this;
    }

    public Builder aux_I(double aux_I) {
      this.aux_I = aux_I;
      return this;
    }

    public Builder aux_V(double aux_V) {
      this.aux_V = aux_V;
      return this;
    }

    public Builder clkhigh_I(double clkhigh_I) {
      this.clkhigh_I = clkhigh_I;
      return this;
    }

    public Builder clkhigh_V(double clkhigh_V) {
      this.clkhigh_V = clkhigh_V;
      return this;
    }

    public Builder clklow_I(double clklow_I) {
      this.clklow_I = clklow_I;
      return this;
    }

    public Builder clklow_V(double clklow_V) {
      this.clklow_V = clklow_V;
      return this;
    }

    public Builder dphi_I(double dphi_I) {
      this.dphi_I = dphi_I;
      return this;
    }

    public Builder dphi_V(double dphi_V) {
      this.dphi_V = dphi_V;
      return this;
    }

    public Builder digital_I(double digital_I) {
      this.digital_I = digital_I;
      return this;
    }

    public Builder digital_V(double digital_V) {
      this.digital_V = digital_V;
      return this;
    }

    public Builder fan_I(double fan_I) {
      this.fan_I = fan_I;
      return this;
    }

    public Builder fan_V(double fan_V) {
      this.fan_V = fan_V;
      return this;
    }

    public Builder hvbias_I(double hvbias_I) {
      this.hvbias_I = hvbias_I;
      return this;
    }

    public Builder hvbias_V(double hvbias_V) {
      this.hvbias_V = hvbias_V;
      return this;
    }

    public Builder od_I(double od_I) {
      this.od_I = od_I;
      return this;
    }

    public Builder od_V(double od_V) {
      this.od_V = od_V;
      return this;
    }

    public Builder otm_I(double otm_I) {
      this.otm_I = otm_I;
      return this;
    }

    public Builder otm_V(double otm_V) {
      this.otm_V = otm_V;
      return this;
    }

    public PowerTelemetry build() {
      return new PowerTelemetry(analog_I, analog_V, aux_I, aux_V, clkhigh_I, clkhigh_V, clklow_I, clklow_V, dphi_I, dphi_V, digital_I, digital_V, fan_I, fan_V, hvbias_I, hvbias_V, od_I, od_V, otm_I, otm_V);
    }
  }
}
