package org.lsst.sal.atcamera.event;

import java.util.Arrays;
import org.lsst.sal.camera.CameraEvent;

public class Focal_plane_Reb_RaftsLimitsConfigurationEvent extends CameraEvent {
  private final String version;

  private final double[] bias0_gdMax;

  private final double[] bias0_gdMin;

  private final double[] bias0_odMax;

  private final double[] bias0_odMin;

  private final double[] bias0_ogMax;

  private final double[] bias0_ogMin;

  private final double[] bias0_rdMax;

  private final double[] bias0_rdMin;

  private final double[] dac_pclkHighMax;

  private final double[] dac_pclkHighMin;

  private final double[] dac_pclkLowMax;

  private final double[] dac_pclkLowMin;

  private final double[] dac_rgHighMax;

  private final double[] dac_rgHighMin;

  private final double[] dac_rgLowMax;

  private final double[] dac_rgLowMin;

  private final double[] dac_sclkHighMax;

  private final double[] dac_sclkHighMin;

  private final double[] dac_sclkLowMax;

  private final double[] dac_sclkLowMin;

  private final String location;

  public Focal_plane_Reb_RaftsLimitsConfigurationEvent(int priority, String version,
      double[] bias0_gdMax, double[] bias0_gdMin, double[] bias0_odMax, double[] bias0_odMin,
      double[] bias0_ogMax, double[] bias0_ogMin, double[] bias0_rdMax, double[] bias0_rdMin,
      double[] dac_pclkHighMax, double[] dac_pclkHighMin, double[] dac_pclkLowMax,
      double[] dac_pclkLowMin, double[] dac_rgHighMax, double[] dac_rgHighMin,
      double[] dac_rgLowMax, double[] dac_rgLowMin, double[] dac_sclkHighMax,
      double[] dac_sclkHighMin, double[] dac_sclkLowMax, double[] dac_sclkLowMin, String location) {
    super (priority);
    this.version = version;
    this.bias0_gdMax = bias0_gdMax;
    this.bias0_gdMin = bias0_gdMin;
    this.bias0_odMax = bias0_odMax;
    this.bias0_odMin = bias0_odMin;
    this.bias0_ogMax = bias0_ogMax;
    this.bias0_ogMin = bias0_ogMin;
    this.bias0_rdMax = bias0_rdMax;
    this.bias0_rdMin = bias0_rdMin;
    this.dac_pclkHighMax = dac_pclkHighMax;
    this.dac_pclkHighMin = dac_pclkHighMin;
    this.dac_pclkLowMax = dac_pclkLowMax;
    this.dac_pclkLowMin = dac_pclkLowMin;
    this.dac_rgHighMax = dac_rgHighMax;
    this.dac_rgHighMin = dac_rgHighMin;
    this.dac_rgLowMax = dac_rgLowMax;
    this.dac_rgLowMin = dac_rgLowMin;
    this.dac_sclkHighMax = dac_sclkHighMax;
    this.dac_sclkHighMin = dac_sclkHighMin;
    this.dac_sclkLowMax = dac_sclkLowMax;
    this.dac_sclkLowMin = dac_sclkLowMin;
    this.location = location;
  }

  public String getVersion() {
    return version;
  }

  public double[] getBias0_gdMax() {
    return bias0_gdMax;
  }

  public double[] getBias0_gdMin() {
    return bias0_gdMin;
  }

  public double[] getBias0_odMax() {
    return bias0_odMax;
  }

  public double[] getBias0_odMin() {
    return bias0_odMin;
  }

  public double[] getBias0_ogMax() {
    return bias0_ogMax;
  }

  public double[] getBias0_ogMin() {
    return bias0_ogMin;
  }

  public double[] getBias0_rdMax() {
    return bias0_rdMax;
  }

  public double[] getBias0_rdMin() {
    return bias0_rdMin;
  }

  public double[] getDac_pclkHighMax() {
    return dac_pclkHighMax;
  }

  public double[] getDac_pclkHighMin() {
    return dac_pclkHighMin;
  }

  public double[] getDac_pclkLowMax() {
    return dac_pclkLowMax;
  }

  public double[] getDac_pclkLowMin() {
    return dac_pclkLowMin;
  }

  public double[] getDac_rgHighMax() {
    return dac_rgHighMax;
  }

  public double[] getDac_rgHighMin() {
    return dac_rgHighMin;
  }

  public double[] getDac_rgLowMax() {
    return dac_rgLowMax;
  }

  public double[] getDac_rgLowMin() {
    return dac_rgLowMin;
  }

  public double[] getDac_sclkHighMax() {
    return dac_sclkHighMax;
  }

  public double[] getDac_sclkHighMin() {
    return dac_sclkHighMin;
  }

  public double[] getDac_sclkLowMax() {
    return dac_sclkLowMax;
  }

  public double[] getDac_sclkLowMin() {
    return dac_sclkLowMin;
  }

  public String getLocation() {
    return location;
  }

  @Override
  public String toString() {
    return "Focal_plane_Reb_RaftsLimitsConfigurationEvent{" + "version=" + version +
        ", bias0_gdMax=" + Arrays.toString(bias0_gdMax) +
        ", bias0_gdMin=" + Arrays.toString(bias0_gdMin) +
        ", bias0_odMax=" + Arrays.toString(bias0_odMax) +
        ", bias0_odMin=" + Arrays.toString(bias0_odMin) +
        ", bias0_ogMax=" + Arrays.toString(bias0_ogMax) +
        ", bias0_ogMin=" + Arrays.toString(bias0_ogMin) +
        ", bias0_rdMax=" + Arrays.toString(bias0_rdMax) +
        ", bias0_rdMin=" + Arrays.toString(bias0_rdMin) +
        ", dac_pclkHighMax=" + Arrays.toString(dac_pclkHighMax) +
        ", dac_pclkHighMin=" + Arrays.toString(dac_pclkHighMin) +
        ", dac_pclkLowMax=" + Arrays.toString(dac_pclkLowMax) +
        ", dac_pclkLowMin=" + Arrays.toString(dac_pclkLowMin) +
        ", dac_rgHighMax=" + Arrays.toString(dac_rgHighMax) +
        ", dac_rgHighMin=" + Arrays.toString(dac_rgHighMin) +
        ", dac_rgLowMax=" + Arrays.toString(dac_rgLowMax) +
        ", dac_rgLowMin=" + Arrays.toString(dac_rgLowMin) +
        ", dac_sclkHighMax=" + Arrays.toString(dac_sclkHighMax) +
        ", dac_sclkHighMin=" + Arrays.toString(dac_sclkHighMin) +
        ", dac_sclkLowMax=" + Arrays.toString(dac_sclkLowMax) +
        ", dac_sclkLowMin=" + Arrays.toString(dac_sclkLowMin) +", location=" + location +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String version;

    private double[] bias0_gdMax;

    private double[] bias0_gdMin;

    private double[] bias0_odMax;

    private double[] bias0_odMin;

    private double[] bias0_ogMax;

    private double[] bias0_ogMin;

    private double[] bias0_rdMax;

    private double[] bias0_rdMin;

    private double[] dac_pclkHighMax;

    private double[] dac_pclkHighMin;

    private double[] dac_pclkLowMax;

    private double[] dac_pclkLowMin;

    private double[] dac_rgHighMax;

    private double[] dac_rgHighMin;

    private double[] dac_rgLowMax;

    private double[] dac_rgLowMin;

    private double[] dac_sclkHighMax;

    private double[] dac_sclkHighMin;

    private double[] dac_sclkLowMax;

    private double[] dac_sclkLowMin;

    private String location;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder bias0_gdMax(double[] bias0_gdMax) {
      this.bias0_gdMax = bias0_gdMax;
      return this;
    }

    public Builder bias0_gdMin(double[] bias0_gdMin) {
      this.bias0_gdMin = bias0_gdMin;
      return this;
    }

    public Builder bias0_odMax(double[] bias0_odMax) {
      this.bias0_odMax = bias0_odMax;
      return this;
    }

    public Builder bias0_odMin(double[] bias0_odMin) {
      this.bias0_odMin = bias0_odMin;
      return this;
    }

    public Builder bias0_ogMax(double[] bias0_ogMax) {
      this.bias0_ogMax = bias0_ogMax;
      return this;
    }

    public Builder bias0_ogMin(double[] bias0_ogMin) {
      this.bias0_ogMin = bias0_ogMin;
      return this;
    }

    public Builder bias0_rdMax(double[] bias0_rdMax) {
      this.bias0_rdMax = bias0_rdMax;
      return this;
    }

    public Builder bias0_rdMin(double[] bias0_rdMin) {
      this.bias0_rdMin = bias0_rdMin;
      return this;
    }

    public Builder dac_pclkHighMax(double[] dac_pclkHighMax) {
      this.dac_pclkHighMax = dac_pclkHighMax;
      return this;
    }

    public Builder dac_pclkHighMin(double[] dac_pclkHighMin) {
      this.dac_pclkHighMin = dac_pclkHighMin;
      return this;
    }

    public Builder dac_pclkLowMax(double[] dac_pclkLowMax) {
      this.dac_pclkLowMax = dac_pclkLowMax;
      return this;
    }

    public Builder dac_pclkLowMin(double[] dac_pclkLowMin) {
      this.dac_pclkLowMin = dac_pclkLowMin;
      return this;
    }

    public Builder dac_rgHighMax(double[] dac_rgHighMax) {
      this.dac_rgHighMax = dac_rgHighMax;
      return this;
    }

    public Builder dac_rgHighMin(double[] dac_rgHighMin) {
      this.dac_rgHighMin = dac_rgHighMin;
      return this;
    }

    public Builder dac_rgLowMax(double[] dac_rgLowMax) {
      this.dac_rgLowMax = dac_rgLowMax;
      return this;
    }

    public Builder dac_rgLowMin(double[] dac_rgLowMin) {
      this.dac_rgLowMin = dac_rgLowMin;
      return this;
    }

    public Builder dac_sclkHighMax(double[] dac_sclkHighMax) {
      this.dac_sclkHighMax = dac_sclkHighMax;
      return this;
    }

    public Builder dac_sclkHighMin(double[] dac_sclkHighMin) {
      this.dac_sclkHighMin = dac_sclkHighMin;
      return this;
    }

    public Builder dac_sclkLowMax(double[] dac_sclkLowMax) {
      this.dac_sclkLowMax = dac_sclkLowMax;
      return this;
    }

    public Builder dac_sclkLowMin(double[] dac_sclkLowMin) {
      this.dac_sclkLowMin = dac_sclkLowMin;
      return this;
    }

    public Builder location(String location) {
      this.location = location;
      return this;
    }

    public Focal_plane_Reb_RaftsLimitsConfigurationEvent build() {
      return new Focal_plane_Reb_RaftsLimitsConfigurationEvent(priority, version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location);
    }
  }
}
