/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.telemetry.Bonn_shutter_DeviceTelemetry;
import org.lsst.sal.atcamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.atcamera.telemetry.PowerTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)1, (int)141583882);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)1, (int)-274666090);
        double[] oDV = TestHelper.generateDoubleArray((int)1, (int)1090308983);
        double[] oGV = TestHelper.generateDoubleArray((int)1, (int)1267752805);
        double[] rDV = TestHelper.generateDoubleArray((int)1, (int)1270782156);
        double[] temp = TestHelper.generateDoubleArray((int)1, (int)-419112220);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)1, (int)-1939319977);
        double[] anaV = TestHelper.generateDoubleArray((int)1, (int)-724715418);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)1, (int)1073798582);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)1, (int)1996435229);
        double[] clkHI = TestHelper.generateDoubleArray((int)1, (int)1813078484);
        double[] clkHV = TestHelper.generateDoubleArray((int)1, (int)1632696800);
        double[] clkLV = TestHelper.generateDoubleArray((int)1, (int)454333359);
        double[] digI = TestHelper.generateDoubleArray((int)1, (int)-827600044);
        double[] digV = TestHelper.generateDoubleArray((int)1, (int)-1995361081);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)1, (int)1882646839);
        double[] htrPI = TestHelper.generateDoubleArray((int)1, (int)1339560005);
        double[] htrPV = TestHelper.generateDoubleArray((int)1, (int)-1553391653);
        double[] htrV = TestHelper.generateDoubleArray((int)1, (int)-865728431);
        double[] htrW = TestHelper.generateDoubleArray((int)1, (int)-1012106734);
        String location = "n";
        double[] oDI = TestHelper.generateDoubleArray((int)1, (int)1640680222);
        double[] oDV = TestHelper.generateDoubleArray((int)1, (int)-1989433522);
        double[] pClk0 = TestHelper.generateDoubleArray((int)1, (int)497738272);
        double[] pClkL = TestHelper.generateDoubleArray((int)1, (int)-586311262);
        double[] pClkU = TestHelper.generateDoubleArray((int)1, (int)-1952492818);
        double[] power = TestHelper.generateDoubleArray((int)1, (int)360212277);
        double[] rG0 = TestHelper.generateDoubleArray((int)1, (int)-1475611905);
        double[] rGL = TestHelper.generateDoubleArray((int)1, (int)-619235455);
        double[] rGU = TestHelper.generateDoubleArray((int)1, (int)1132516689);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)1, (int)-1942212881);
        double[] sClk0 = TestHelper.generateDoubleArray((int)1, (int)-649321411);
        double[] sClkL = TestHelper.generateDoubleArray((int)1, (int)1491862231);
        double[] sClkU = TestHelper.generateDoubleArray((int)1, (int)1458219185);
        double[] temp1 = TestHelper.generateDoubleArray((int)1, (int)-401491656);
        double[] temp2 = TestHelper.generateDoubleArray((int)1, (int)1022593917);
        double[] temp3 = TestHelper.generateDoubleArray((int)1, (int)302081961);
        double[] temp4 = TestHelper.generateDoubleArray((int)1, (int)-30174827);
        double[] temp5 = TestHelper.generateDoubleArray((int)1, (int)154797139);
        double[] temp6 = TestHelper.generateDoubleArray((int)1, (int)-328236423);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicu_Temp0, clkHI, clkHV, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClkL, pClkU, power, rG0, rGL, rGU, rTDTemp, sClk0, sClkL, sClkU, temp1, temp2, temp3, temp4, temp5, temp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.4671905040740967;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.7763080596923828;
        double freeFraction = 0.755107581615448;
        double freeSpace = 0.3017298f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePowerTelemetry() throws Exception {
        double analog_I = 0.8683740496635437;
        double analog_V = 0.7632885575294495;
        double aux_I = 0.2962263822555542;
        double aux_V = 0.11591315269470215;
        double clkhigh_I = 0.4327585f;
        double clkhigh_V = 0.03410977125167847;
        double clklow_I = 0.3431814908981323;
        double clklow_V = 0.3089836835861206;
        double dphi_I = 0.08747595548629761;
        double dphi_V = 0.5024642944335938;
        double digital_I = 0.5691242218017578;
        double digital_V = 0.3387439250946045;
        double fan_I = 0.2125802f;
        double fan_V = 0.6120885610580444;
        double hvbias_I = 0.6070190668106079;
        double hvbias_V = 0.726321f;
        double od_I = 0.7670446038246155;
        double od_V = 0.6325418949127197;
        double otm_I = 0.14544326066970825;
        double otm_V = 0.15658771991729736;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PowerTelemetry(analog_I, analog_V, aux_I, aux_V, clkhigh_I, clkhigh_V, clklow_I, clklow_V, dphi_I, dphi_V, digital_I, digital_V, fan_I, fan_V, hvbias_I, hvbias_V, od_I, od_V, otm_I, otm_V));
        Assert.assertTrue((boolean)(item instanceof PowerTelemetry));
        PowerTelemetry item_ = (PowerTelemetry)item;
        Assert.assertEquals((double)analog_I, (double)item_.getAnalog_I(), (double)1.0E-6f);
        Assert.assertEquals((double)analog_V, (double)item_.getAnalog_V(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_I, (double)item_.getAux_I(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_V, (double)item_.getAux_V(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhigh_I, (double)item_.getClkhigh_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhigh_V, (double)item_.getClkhigh_V(), (double)1.0E-6f);
        Assert.assertEquals((double)clklow_I, (double)item_.getClklow_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clklow_V, (double)item_.getClklow_V(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_I, (double)item_.getDphi_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_V, (double)item_.getDphi_V(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_I, (double)item_.getDigital_I(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_V, (double)item_.getDigital_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_I, (double)item_.getFan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_V, (double)item_.getFan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_I, (double)item_.getHvbias_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_V, (double)item_.getHvbias_V(), (double)1.0E-6f);
        Assert.assertEquals((double)od_I, (double)item_.getOd_I(), (double)1.0E-6f);
        Assert.assertEquals((double)od_V, (double)item_.getOd_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_I, (double)item_.getOtm_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_V, (double)item_.getOtm_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumTelemetry() throws Exception {
        double tempCCD = 0.20130383968353271;
        double tempCCDSetPoint = 0.4904070496559143;
        double tempColdPlate = 0.6301425099372864;
        double tempCryoHead = 0.5715990662574768;
        double vacuum = 0.9308252334594727;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumTelemetry(tempCCD, tempCCDSetPoint, tempColdPlate, tempCryoHead, vacuum));
        Assert.assertTrue((boolean)(item instanceof VacuumTelemetry));
        VacuumTelemetry item_ = (VacuumTelemetry)item;
        Assert.assertEquals((double)tempCCD, (double)item_.getTempCCD(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCCDSetPoint, (double)item_.getTempCCDSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempColdPlate, (double)item_.getTempColdPlate(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCryoHead, (double)item_.getTempCryoHead(), (double)1.0E-6f);
        Assert.assertEquals((double)vacuum, (double)item_.getVacuum(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_DeviceTelemetry() throws Exception {
        double bonn_V36 = 0.8303444981575012;
        double bonn_V5 = 0.08115541934967041;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Bonn_shutter_DeviceTelemetry(bonn_V36, bonn_V5));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_DeviceTelemetry));
        Bonn_shutter_DeviceTelemetry item_ = (Bonn_shutter_DeviceTelemetry)item;
        Assert.assertEquals((double)bonn_V36, (double)item_.getBonn_V36(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5, (double)item_.getBonn_V5(), (double)1.0E-6f);
    }
}

