/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.event.Ats_AgentMonitorService_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_CryoCon_DeviceSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_Heartbeat_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_Monitor_check_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_Monitor_publish_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_Monitor_update_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_RuntimeInfo_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_SchedulersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_TempCCDSetPoint_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_TempCCD_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_TempColdPlate_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_TempCryoHead_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_Vacuum_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_AgentMonitorService_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Analog_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Analog_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Analog_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Aux_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Aux_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Aux_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkHigh_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkHigh_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkLow_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkLow_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClockHigh_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClockLow_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_DPHI_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_DPHI_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_DPHI_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Digital_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Digital_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Digital_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Fan_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Fan_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Fan_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_HVBias_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_HVBias_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_HVBias_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg1_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg2_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg3_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Heartbeat_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Keithley_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Monitor_check_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Monitor_publish_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Monitor_update_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OD_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OD_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OD_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OTM_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OTM_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OTM_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Power_state_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_RuntimeInfo_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_SchedulersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FileCommandExecutionEvent;
import org.lsst.sal.atcamera.event.FitsFilesWrittenEvent;
import org.lsst.sal.atcamera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Ccd_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Raft_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Raft_RaftTempControlSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsPowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.ImageReadoutParametersEvent;
import org.lsst.sal.atcamera.event.ImageStoredEvent;
import org.lsst.sal.atcamera.event.ImageVisualizationEvent;
import org.lsst.sal.atcamera.event.ShutterBladeMotionProfileEvent;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_buildSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_StoreSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreSettingsAppliedEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageDatabaseServiceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageNameServiceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 552;
        String additionalKeys = "r";
        String additionalValues = "";
        int imagesInSequence = 832;
        String imageName = "tmdhqqrlbzrtrailuqnxcbyrumu";
        int imageIndex = 105;
        String imageSource = "ic";
        String imageController = "e";
        String imageDate = "";
        int imageNumber = 684;
        double timestampAcquisitionStart = 0.5687018036842346;
        double requestedExposureTime = 0.29564791917800903;
        double timestampEndOfReadout = 0.5370213389396667;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 812;
        double timestampTransition = 0.6371054649353027;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 213;
        double timestampTransition = 0.2607744336128235;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 775;
        double timestampTransition = 0.5835015773773193;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 175;
        double timestampTransition = 0.678645670413971;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 88;
        String additionalKeys = "";
        String additionalValues = "u";
        int imagesInSequence = 823;
        String imageName = "chxfuwvcyqbqmx";
        int imageIndex = 856;
        String imageSource = "";
        String imageController = "r";
        String imageDate = "iwvykb";
        int imageNumber = 502;
        double timestampAcquisitionStart = 0.21784543991088867;
        double exposureTime = 0.901118f;
        String imageTag = "qqvphgmozhbvogrutlnfutaeicjgpqqz";
        double timestampDateObs = 0.8087501525878906;
        double timestampDateEnd = 0.9135477542877197;
        double measuredShutterOpenTime = 0.33280056715011597;
        double darkTime = 0.607584536075592;
        String emulatedImage = "k";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 848;
        double timestampTransition = 0.6615950465202332;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 725;
        double timestampTransition = 0.5664383172988892;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 147;
        double timestampTransition = 0.08782505989074707;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 863;
        String additionalKeys = "n";
        String additionalValues = "e";
        int imagesInSequence = 207;
        String imageName = "uortnjimmdxoxtkqilzpfnvoiybb";
        int imageIndex = 940;
        String imageSource = "y";
        String imageController = "";
        String imageDate = "abfrju";
        int imageNumber = 172;
        double timestampAcquisitionStart = 0.8352605104446411;
        double exposureTime = 0.2093580961227417;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 585;
        double timestampTransition = 0.3163268566131592;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 981;
        String additionalKeys = "k";
        String additionalValues = "e";
        int imagesInSequence = 190;
        String imageName = "xqcrkmftcfudwlsjyvjxwjbm";
        int imageIndex = 458;
        String imageSource = "";
        String imageController = "o";
        String imageDate = "muieya";
        int imageNumber = 6;
        double timestampAcquisitionStart = 0.4938884377479553;
        double exposureTime = 0.38669872283935547;
        double timestampStartOfReadout = 0.7161986231803894;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveShutterMotionProfileEvent() throws Exception {
        int priority = 609;
        double measuredExposureTime = 0.908560037612915;
        SALEvent item = this.testSendReceive((SALEvent)new ShutterMotionProfileEvent(priority, measuredExposureTime));
        Assert.assertTrue((boolean)(item instanceof ShutterMotionProfileEvent));
        ShutterMotionProfileEvent item_ = (ShutterMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)measuredExposureTime, (double)item_.getMeasuredExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 329;
        String imageName = "e";
        String ccdLocation = "w";
        String raftBay = "";
        String ccdSlot = "q";
        ImageReadoutParametersEvent.CcdType ccdType = ImageReadoutParametersEvent.CcdType.ITL;
        int overRows = 386;
        int overCols = 114;
        int readRows = 381;
        int readCols = 300;
        int readCols2 = 383;
        int preCols = 237;
        int preRows = 995;
        int postCols = 963;
        int underCols = 91;
        String daqFolder = "y";
        String daqAnnotation = "l";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 750;
        String ccdLocation = "";
        String raftBay = "";
        String ccdSlot = "h";
        String rebSerialNumber = "f";
        String rebLSSTName = "z";
        String ccdLSSTName = "v";
        String raftLSSTName = "r";
        String ccdManSerNum = "";
        String ccdManufacturer = "";
        FocalPlaneSummaryInfoEvent.CcdType ccdType = FocalPlaneSummaryInfoEvent.CcdType.ITL;
        double ccdTempSetPoint = 0.4290521740913391;
        String sequencerKey = "u";
        String sequencerChecksum = "";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((double)ccdTempSetPoint, (double)item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 157;
        int version = 472;
        String location = "u";
        String manSerNum = "";
        String name = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdSettingsAppliedEvent(priority, version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdSettingsAppliedEvent));
        Focal_plane_Ccd_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Ccd_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 638;
        int version = 207;
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)1, (int)1047930356);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)1, (int)1846775960);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)1, (int)1311109679);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)1, (int)2040354731);
        String location = "l";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)1, (int)1909953860);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1417221407);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)1, (int)823326195);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)1, (int)780688061);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1397766369);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)1, (int)1535902079);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-699331790);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1933500658);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)1, (int)939325193);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)1, (int)115767502);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-106587538);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1718825415);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)1, (int)53906276);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)1, (int)920838193);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-684913463);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-385250073);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)1, (int)766406694);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1033480057);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1550570586);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)1, (int)753933065);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsSettingsAppliedEvent(priority, version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsSettingsAppliedEvent));
        Focal_plane_Ccd_LimitsSettingsAppliedEvent item_ = (Focal_plane_Ccd_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_RaftsSettingsAppliedEvent() throws Exception {
        int priority = 866;
        int version = 961;
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_RaftsSettingsAppliedEvent(priority, version, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_RaftsSettingsAppliedEvent));
        Focal_plane_Ccd_RaftsSettingsAppliedEvent item_ = (Focal_plane_Ccd_RaftsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseServiceSettingsAppliedEvent() throws Exception {
        int priority = 949;
        int version = 134;
        String dbURL = "";
        boolean enabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseServiceSettingsAppliedEvent(priority, version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseServiceSettingsAppliedEvent));
        Focal_plane_ImageDatabaseServiceSettingsAppliedEvent item_ = (Focal_plane_ImageDatabaseServiceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameServiceSettingsAppliedEvent() throws Exception {
        int priority = 462;
        int version = 868;
        String controller = "";
        String dbURL = "j";
        String offset = "j";
        String source = "j";
        String timeZoneId = "l";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameServiceSettingsAppliedEvent(priority, version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameServiceSettingsAppliedEvent));
        Focal_plane_ImageNameServiceSettingsAppliedEvent item_ = (Focal_plane_ImageNameServiceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent() throws Exception {
        int priority = 854;
        int version = 755;
        String instrument = "y";
        String telescope = "";
        String testStand = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent(priority, version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent));
        Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent item_ = (Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 705;
        int version = 431;
        int schedulers_default_nTasks = 143;
        int schedulers_default_nThreads = 600;
        int schedulers_monitor_check_scheduler_nTasks = 758;
        int schedulers_monitor_check_scheduler_nThreads = 546;
        int schedulers_monitor_update_publish_scheduler_nTasks = 423;
        int schedulers_monitor_update_publish_scheduler_nThreads = 198;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasksSettingsAppliedEvent));
        Focal_plane_PeriodicTasksSettingsAppliedEvent item_ = (Focal_plane_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 223;
        int version = 860;
        long agentmonitorservice_taskPeriodMillis = 81L;
        long heartbeat_taskPeriodMillis = 213L;
        long monitor_publish_taskPeriodMillis = 784L;
        long monitor_update_taskPeriodMillis = 369L;
        long runtimeinfo_taskPeriodMillis = 195L;
        long tempcontrol_R00_taskPeriodMillis = 727L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R00_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersSettingsAppliedEvent));
        Focal_plane_PeriodicTasks_timersSettingsAppliedEvent item_ = (Focal_plane_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R00_taskPeriodMillis, (long)item_.getTempcontrol_R00_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 514;
        int version = 708;
        String location = "";
        String name = "g";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdSettingsAppliedEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdSettingsAppliedEvent));
        Focal_plane_Raft_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Raft_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlSettingsAppliedEvent() throws Exception {
        int priority = 303;
        int version = 215;
        String location = "r";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)1, (int)708589067);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)1, (int)-1518938308);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)1, (int)-1250181728);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)1, (int)-2027831750);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)1, (int)-1139765352);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)1, (int)-383668415);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)1, (int)-1526915281);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)1, (int)949651748);
        String tempcontrol_rebs = "";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)1, (int)-1222143675);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)1, (int)981709006);
        String tempcontrol_tempChans = "s";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)1, (int)1648594268);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlSettingsAppliedEvent(priority, version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlSettingsAppliedEvent));
        Focal_plane_Raft_RaftTempControlSettingsAppliedEvent item_ = (Focal_plane_Raft_RaftTempControlSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent() throws Exception {
        int priority = 529;
        int version = 884;
        String location = "e";
        boolean[] tempcontrol_active = new boolean[]{true};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent(priority, version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent));
        Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent item_ = (Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 495;
        int version = 640;
        double warnHi = 0.22750800848007202;
        double warnLo = 0.7784445881843567;
        double limitHi = 0.5457326769828796;
        double limitLo = 0.9931433200836182;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent));
        Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent item_ = (Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 75;
        int version = 476;
        String location = "h";
        String name = "d";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdSettingsAppliedEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdSettingsAppliedEvent));
        Focal_plane_Reb_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Reb_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 447;
        int version = 2;
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)1, (int)871321290);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)1, (int)1394878018);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)1, (int)-696700444);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)1, (int)1197043983);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1182202028);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)1, (int)-43661461);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)1, (int)998439937);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)1, (int)-445233199);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)1, (int)1787252675);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)1, (int)-615500284);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)1, (int)-33638186);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)1, (int)-2103026780);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1038218488);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1174427787);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)1, (int)1868128983);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)1, (int)1325603311);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)1, (int)-501480951);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)1, (int)1823838736);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)1, (int)-260318576);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)1, (int)-368129150);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1093253708);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1130403943);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-22353703);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)1, (int)1073757365);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1969283497);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)1, (int)2129654792);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1138184120);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-245480496);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)1, (int)703339567);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)1, (int)-597072756);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)1, (int)1475822054);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)1, (int)-2141009491);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1351344834);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)1, (int)1523727059);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)1, (int)1642285350);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-856475492);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)1, (int)1254579297);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)1, (int)1336914056);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)1, (int)1324942098);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1938393722);
        double[] htrpi_warnHi = TestHelper.generateDoubleArray((int)1, (int)1903222177);
        double[] htrpi_warnLo = TestHelper.generateDoubleArray((int)1, (int)541347613);
        double[] htrpi_limitHi = TestHelper.generateDoubleArray((int)1, (int)1442116807);
        double[] htrpi_limitLo = TestHelper.generateDoubleArray((int)1, (int)883869524);
        double[] htrpv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1412314167);
        double[] htrpv_warnLo = TestHelper.generateDoubleArray((int)1, (int)762953673);
        double[] htrpv_limitHi = TestHelper.generateDoubleArray((int)1, (int)778376483);
        double[] htrpv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1304407919);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)1, (int)2027723575);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)1, (int)-548857900);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-414818884);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1829568691);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)1, (int)1742669303);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)1, (int)-760929006);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)1, (int)-164235501);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)1, (int)-2092361915);
        String location = "";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)1, (int)1528725164);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)1, (int)1041003529);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)1, (int)-51267008);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)1, (int)1346480913);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-21930459);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)1, (int)1043124369);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)1, (int)1244730043);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1554856959);
        double[] pclk0_warnHi = TestHelper.generateDoubleArray((int)1, (int)984188060);
        double[] pclk0_warnLo = TestHelper.generateDoubleArray((int)1, (int)-96983130);
        double[] pclk0_limitHi = TestHelper.generateDoubleArray((int)1, (int)-137493304);
        double[] pclk0_limitLo = TestHelper.generateDoubleArray((int)1, (int)904388178);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)1, (int)747155534);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1083026305);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)1, (int)-38827726);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)1, (int)810123592);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)1, (int)-576690593);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)1, (int)2033382145);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)1, (int)1012012773);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)1, (int)-786885497);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)1, (int)601363673);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)1, (int)998339445);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)1, (int)-52445556);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)1, (int)1402600680);
        double[] rg0_warnHi = TestHelper.generateDoubleArray((int)1, (int)-903556876);
        double[] rg0_warnLo = TestHelper.generateDoubleArray((int)1, (int)1907504506);
        double[] rg0_limitHi = TestHelper.generateDoubleArray((int)1, (int)1631313019);
        double[] rg0_limitLo = TestHelper.generateDoubleArray((int)1, (int)-592498032);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)1, (int)-3656297);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)1, (int)1371921981);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1157790512);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)1, (int)1775477823);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1430247905);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)1, (int)-475308570);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1839067692);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)1, (int)-85656603);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)1, (int)-265717410);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)1, (int)-661104555);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)1, (int)1660116134);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)1, (int)754817146);
        double[] sclk0_warnHi = TestHelper.generateDoubleArray((int)1, (int)552849637);
        double[] sclk0_warnLo = TestHelper.generateDoubleArray((int)1, (int)1370678541);
        double[] sclk0_limitHi = TestHelper.generateDoubleArray((int)1, (int)1093916698);
        double[] sclk0_limitLo = TestHelper.generateDoubleArray((int)1, (int)-485240562);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)1, (int)-899342202);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)1, (int)2038618736);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)1, (int)1700537822);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)1, (int)1709298975);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)1, (int)1154460180);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)1, (int)-665839572);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)1, (int)156571102);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)1, (int)687521322);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)1, (int)398815596);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1544125195);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)1, (int)-707108887);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)1, (int)-2077841788);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)1, (int)-2042598215);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)1, (int)-15748236);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)1, (int)-631695468);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1486300823);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1360595726);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)1, (int)1692230270);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)1, (int)1994848862);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1431277483);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)1, (int)-922207577);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)1, (int)241126537);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)1, (int)-706872300);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)1, (int)962916754);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)1, (int)241484541);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)1, (int)1420950107);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)1, (int)1434039671);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)1, (int)856015890);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)1, (int)9646327);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)1, (int)1283165443);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)1, (int)931830043);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)1, (int)-164852610);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsSettingsAppliedEvent(priority, version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrpi_warnHi, htrpi_warnLo, htrpi_limitHi, htrpi_limitLo, htrpv_warnHi, htrpv_warnLo, htrpv_limitHi, htrpv_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclk0_warnHi, pclk0_warnLo, pclk0_limitHi, pclk0_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rg0_warnHi, rg0_warnLo, rg0_limitHi, rg0_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, sclk0_warnHi, sclk0_warnLo, sclk0_limitHi, sclk0_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsSettingsAppliedEvent));
        Focal_plane_Reb_LimitsSettingsAppliedEvent item_ = (Focal_plane_Reb_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnHi, (double[])item_.getHtrpi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnLo, (double[])item_.getHtrpi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitHi, (double[])item_.getHtrpi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitLo, (double[])item_.getHtrpi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnHi, (double[])item_.getHtrpv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnLo, (double[])item_.getHtrpv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitHi, (double[])item_.getHtrpv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitLo, (double[])item_.getHtrpv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnHi, (double[])item_.getPclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnLo, (double[])item_.getPclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitHi, (double[])item_.getPclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitLo, (double[])item_.getPclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnHi, (double[])item_.getRg0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnLo, (double[])item_.getRg0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitHi, (double[])item_.getRg0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitLo, (double[])item_.getRg0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnHi, (double[])item_.getSclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnLo, (double[])item_.getSclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitHi, (double[])item_.getSclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitLo, (double[])item_.getSclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsSettingsAppliedEvent() throws Exception {
        int priority = 267;
        int version = 550;
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)1, (int)-533917039);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)1, (int)-2018523250);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)1, (int)1159335042);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)1, (int)-1023722256);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)1, (int)179368904);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)1, (int)-1784400485);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)1, (int)-1135500214);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)1, (int)-374930229);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)1, (int)2009060528);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)1, (int)2060512113);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)1, (int)1472519785);
        boolean[] disableRTDHardwareCheck = new boolean[]{false};
        String location = "";
        long[] serialNum = TestHelper.generateLongArray((int)1, (int)-65856406);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsSettingsAppliedEvent(priority, version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsSettingsAppliedEvent));
        Focal_plane_Reb_RaftsSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsSettingsAppliedEvent() throws Exception {
        int priority = 861;
        int version = 968;
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)1, (int)-1860824840);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)1, (int)-345247305);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)1, (int)-809512818);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)1, (int)-2090954088);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)1, (int)1890166409);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)1, (int)759431936);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)1, (int)-1566290996);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)1, (int)1084328907);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)1, (int)-1558458571);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)1, (int)-1592441808);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)1, (int)-1233913320);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)1, (int)1580277552);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)1, (int)1310069330);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)1, (int)275086473);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)1, (int)709250408);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)1, (int)-716427139);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)1, (int)1160460884);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)1, (int)-1022846210);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)1, (int)760628211);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)1, (int)751087093);
        String location = "o";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent(priority, version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent));
        Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerSettingsAppliedEvent() throws Exception {
        int priority = 165;
        int version = 335;
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)1, (int)349724904);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)1, (int)886895385);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)1, (int)-738304691);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)1, (int)658812088);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)1, (int)-1704858203);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)1, (int)347353465);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)1, (int)-1037401273);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)1, (int)1930057449);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)1, (int)876905894);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)1, (int)1884345550);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)1, (int)158842907);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)1, (int)-150604100);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)1, (int)1537249979);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)1, (int)257047320);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)1, (int)86583441);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)1, (int)1093178828);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)1, (int)1952120809);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)1, (int)686352956);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)1, (int)-805386862);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)1, (int)1953730364);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)1, (int)-1246105016);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)1, (int)1725833495);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)1, (int)1899385250);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)1, (int)1245567209);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)1, (int)-2003194834);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)1, (int)593159638);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)1, (int)245090990);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)1, (int)-1628951581);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)1, (int)795475597);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)1, (int)-471784060);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)1, (int)-1888822265);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)1, (int)-2067349480);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)1, (int)-196678503);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)1, (int)805222628);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)1, (int)676226222);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)1, (int)826183506);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)1, (int)-1182440019);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)1, (int)-1570020736);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)1, (int)702258641);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)1, (int)-2055253150);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)1, (int)-1154008721);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)1, (int)616569345);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)1, (int)1689953685);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)1, (int)86160285);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)1, (int)314026545);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)1, (int)-368625471);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)1, (int)-779718122);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)1, (int)76305799);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)1, (int)1115963802);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)1, (int)139090846);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)1, (int)1921675435);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)1, (int)-294796082);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)1, (int)-1094988923);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)1, (int)-1371795951);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)1, (int)-1423682194);
        String location = "";
        double[] maxDelta = TestHelper.generateDoubleArray((int)1, (int)936876840);
        double[] maxStep = TestHelper.generateDoubleArray((int)1, (int)1567134334);
        double[] minTol = TestHelper.generateDoubleArray((int)1, (int)1609883387);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)1, (int)-686363807);
        double[] odiAmin = TestHelper.generateDoubleArray((int)1, (int)-271483271);
        double[] odiQmax = TestHelper.generateDoubleArray((int)1, (int)1547328460);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerSettingsAppliedEvent(priority, version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerSettingsAppliedEvent));
        Focal_plane_Reb_RaftsPowerSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsPowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersSettingsAppliedEvent() throws Exception {
        int priority = 651;
        int version = 647;
        String location = "a";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1038240813);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1417484602);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)393278912);
        long[] periodictasks_monitor_publish_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-745861786);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1815806383);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)1787757971);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-383766180);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1460988487);
        long[] periodictasks_monitor_update_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)1748951366);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)373061603);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1317062028);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersSettingsAppliedEvent(priority, version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_crVolt_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_crVolt_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersSettingsAppliedEvent));
        Focal_plane_Reb_timersSettingsAppliedEvent item_ = (Focal_plane_Reb_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQSettingsAppliedEvent() throws Exception {
        int priority = 649;
        int version = 441;
        String daqFolder = "g";
        String daqPartition = "";
        boolean emulatedDAQ = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQSettingsAppliedEvent(priority, version, daqFolder, daqPartition, emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQSettingsAppliedEvent));
        Focal_plane_SequencerConfig_DAQSettingsAppliedEvent item_ = (Focal_plane_SequencerConfig_DAQSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerSettingsAppliedEvent() throws Exception {
        int priority = 935;
        int version = 512;
        String clearCountParameter = "t";
        String clearMain = "t";
        String idleFlushMain = "r";
        long idleFlushTimeout = 380L;
        String integrateMain = "";
        String metaDataRegisters = "s";
        int overCols = 502;
        int overRows = 756;
        int postCols = 863;
        int postRows = 913;
        int preCols = 239;
        int preRows = 171;
        String pseudoReadMain = "";
        int readCols = 446;
        int readCols2 = 658;
        String readMain = "i";
        int readRows = 138;
        String rowShiftForwardMain = "d";
        String rowShiftReverseMain = "";
        boolean scanMode = false;
        String sequencer = "";
        String sequencerChecksums = "";
        String shiftCountParameter = "";
        boolean stepAfterIntegrate = false;
        int transparentMode = 299;
        int underCols = 529;
        boolean useParallelRegisters = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent(priority, version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent));
        Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent item_ = (Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent() throws Exception {
        int priority = 412;
        int version = 610;
        String webHooks = "p";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent(priority, version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent));
        Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent item_ = (Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 653;
        int version = 264;
        int schedulers_default_nTasks = 100;
        int schedulers_default_nThreads = 943;
        int schedulers_monitor_update_publish_scheduler_nTasks = 927;
        int schedulers_monitor_update_publish_scheduler_nThreads = 283;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasksSettingsAppliedEvent));
        Daq_monitor_PeriodicTasksSettingsAppliedEvent item_ = (Daq_monitor_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 299;
        int version = 56;
        long agentmonitorservice_taskPeriodMillis = 404L;
        long heartbeat_taskPeriodMillis = 560L;
        long monitor_check_taskPeriodMillis = 283L;
        long monitor_publish_taskPeriodMillis = 288L;
        long monitor_update_taskPeriodMillis = 935L;
        long publishstats_taskPeriodMillis = 822L;
        long purgedaq_taskPeriodMillis = 888L;
        long runtimeinfo_taskPeriodMillis = 682L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent));
        Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent item_ = (Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsSettingsAppliedEvent() throws Exception {
        int priority = 757;
        int version = 270;
        int minDiffAlertWarning = 991;
        int minDiffLogWarning = 10;
        String sumDriverChecks = "g";
        String sumDriverStats = "";
        String sumFirmwareChecks = "";
        String sumFirmwareStats = "l";
        String sumRdsChecks = "g";
        String sumRdsStats = "k";
        String sumRmsChecks = "";
        String sumRmsStats = "z";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsSettingsAppliedEvent(priority, version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsSettingsAppliedEvent));
        Daq_monitor_Stats_StatisticsSettingsAppliedEvent item_ = (Daq_monitor_Stats_StatisticsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_buildSettingsAppliedEvent() throws Exception {
        int priority = 680;
        int version = 255;
        boolean enablePeriodicPublication = false;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_buildSettingsAppliedEvent(priority, version, enablePeriodicPublication));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_buildSettingsAppliedEvent));
        Daq_monitor_Stats_buildSettingsAppliedEvent item_ = (Daq_monitor_Stats_buildSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)enablePeriodicPublication, (Object)item_.isEnablePeriodicPublication());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreSettingsAppliedEvent() throws Exception {
        int priority = 635;
        int version = 28;
        String daqPartition = "k";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreSettingsAppliedEvent(priority, version, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreSettingsAppliedEvent));
        Daq_monitor_StoreSettingsAppliedEvent item_ = (Daq_monitor_StoreSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 68;
        int version = 163;
        double capacity_warnHi = 0.6257666945457458;
        double capacity_warnLo = 0.17463302612304688;
        double capacity_limitHi = 0.6843522191047668;
        double capacity_limitLo = 0.3546783924102783;
        double freefraction_warnHi = 0.46490478515625;
        double freefraction_warnLo = 0.10239458084106445;
        double freefraction_limitHi = 0.711392879486084;
        double freefraction_limitLo = 0.16704648733139038;
        double freespace_warnHi = 0.2358495593070984;
        double freespace_warnLo = 0.6809166073799133;
        double freespace_limitHi = 0.5276538729667664;
        double freespace_limitLo = 0.7512941360473633;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsSettingsAppliedEvent(priority, version, capacity_warnHi, capacity_warnLo, capacity_limitHi, capacity_limitLo, freefraction_warnHi, freefraction_warnLo, freefraction_limitHi, freefraction_limitLo, freespace_warnHi, freespace_warnLo, freespace_limitHi, freespace_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsSettingsAppliedEvent));
        Daq_monitor_Store_LimitsSettingsAppliedEvent item_ = (Daq_monitor_Store_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)capacity_warnHi, (double)item_.getCapacity_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_warnLo, (double)item_.getCapacity_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitHi, (double)item_.getCapacity_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitLo, (double)item_.getCapacity_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnHi, (double)item_.getFreefraction_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitHi, (double)item_.getFreefraction_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnHi, (double)item_.getFreespace_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnLo, (double)item_.getFreespace_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitHi, (double)item_.getFreespace_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitLo, (double)item_.getFreespace_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreSettingsAppliedEvent() throws Exception {
        int priority = 907;
        int version = 203;
        String daqFolder = "";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.08863133192062378;
        double purgeThreshold = 0.1820812225341797;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreSettingsAppliedEvent(priority, version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreSettingsAppliedEvent));
        Daq_monitor_Store_StoreSettingsAppliedEvent item_ = (Daq_monitor_Store_StoreSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_AgentMonitorService_timersSettingsAppliedEvent() throws Exception {
        int priority = 523;
        int version = 472;
        long taskPeriodMillis = 966L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_AgentMonitorService_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_AgentMonitorService_timersSettingsAppliedEvent));
        Ats_power_AgentMonitorService_timersSettingsAppliedEvent item_ = (Ats_power_AgentMonitorService_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_Analog_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 449;
        int version = 177;
        double warnHi = 0.9466773271560669;
        double warnLo = 0.8995060920715332;
        double limitHi = 0.5472736358642578;
        double limitLo = 0.7756286859512329;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Analog_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Analog_I_LimitsSettingsAppliedEvent));
        Ats_power_Analog_I_LimitsSettingsAppliedEvent item_ = (Ats_power_Analog_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Analog_PowerSettingsAppliedEvent() throws Exception {
        int priority = 75;
        int version = 796;
        double current = 0.6490641236305237;
        double offDelay = 0.7439114451408386;
        double onDelay = 0.37032806873321533;
        double voltage = 0.8646038174629211;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Analog_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Analog_PowerSettingsAppliedEvent));
        Ats_power_Analog_PowerSettingsAppliedEvent item_ = (Ats_power_Analog_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Analog_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 852;
        int version = 632;
        double warnHi = 0.5181974172592163;
        double warnLo = 0.21348637342453003;
        double limitHi = 0.2185397744178772;
        double limitLo = 0.10950464010238647;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Analog_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Analog_V_LimitsSettingsAppliedEvent));
        Ats_power_Analog_V_LimitsSettingsAppliedEvent item_ = (Ats_power_Analog_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Aux_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 317;
        int version = 118;
        double warnHi = 0.710189f;
        double warnLo = 0.3864247798919678;
        double limitHi = 0.2776535749435425;
        double limitLo = 0.5311670303344727;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Aux_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Aux_I_LimitsSettingsAppliedEvent));
        Ats_power_Aux_I_LimitsSettingsAppliedEvent item_ = (Ats_power_Aux_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Aux_PowerSettingsAppliedEvent() throws Exception {
        int priority = 16;
        int version = 850;
        double current = 0.7143215537071228;
        double offDelay = 0.4298403859138489;
        double onDelay = 0.4437502f;
        double voltage = 0.4124288558959961;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Aux_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Aux_PowerSettingsAppliedEvent));
        Ats_power_Aux_PowerSettingsAppliedEvent item_ = (Ats_power_Aux_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Aux_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 541;
        int version = 398;
        double warnHi = 0.6464796662330627;
        double warnLo = 0.5712229609489441;
        double limitHi = 0.8883883357048035;
        double limitLo = 0.010107755661010742;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Aux_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Aux_V_LimitsSettingsAppliedEvent));
        Ats_power_Aux_V_LimitsSettingsAppliedEvent item_ = (Ats_power_Aux_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkHigh_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 607;
        int version = 108;
        double warnHi = 0.5045515298843384;
        double warnLo = 0.002496778964996338;
        double limitHi = 0.3206069f;
        double limitLo = 0.5314055681228638;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkHigh_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkHigh_I_LimitsSettingsAppliedEvent));
        Ats_power_ClkHigh_I_LimitsSettingsAppliedEvent item_ = (Ats_power_ClkHigh_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkHigh_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 412;
        int version = 762;
        double warnHi = 0.15745294094085693;
        double warnLo = 0.443982f;
        double limitHi = 0.05309480428695679;
        double limitLo = 0.5899285674095154;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkHigh_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkHigh_V_LimitsSettingsAppliedEvent));
        Ats_power_ClkHigh_V_LimitsSettingsAppliedEvent item_ = (Ats_power_ClkHigh_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkLow_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 539;
        int version = 15;
        double warnHi = 0.1348469853401184;
        double warnLo = 0.9450693726539612;
        double limitHi = 0.004653573036193848;
        double limitLo = 0.6395641565322876;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkLow_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkLow_I_LimitsSettingsAppliedEvent));
        Ats_power_ClkLow_I_LimitsSettingsAppliedEvent item_ = (Ats_power_ClkLow_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkLow_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 101;
        int version = 759;
        double warnHi = 0.8036074638366699;
        double warnLo = 0.8256937861442566;
        double limitHi = 0.8046416640281677;
        double limitLo = 0.6713044047355652;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkLow_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkLow_V_LimitsSettingsAppliedEvent));
        Ats_power_ClkLow_V_LimitsSettingsAppliedEvent item_ = (Ats_power_ClkLow_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClockHigh_PowerSettingsAppliedEvent() throws Exception {
        int priority = 987;
        int version = 309;
        double current = 0.0881474f;
        double offDelay = 0.5174156427383423;
        double onDelay = 0.2915079f;
        double voltage = 0.13513261079788208;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClockHigh_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClockHigh_PowerSettingsAppliedEvent));
        Ats_power_ClockHigh_PowerSettingsAppliedEvent item_ = (Ats_power_ClockHigh_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClockLow_PowerSettingsAppliedEvent() throws Exception {
        int priority = 444;
        int version = 904;
        double current = 0.2795097231864929;
        double offDelay = 0.6227433681488037;
        double onDelay = 0.5955899357795715;
        double voltage = 0.07762682437896729;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClockLow_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClockLow_PowerSettingsAppliedEvent));
        Ats_power_ClockLow_PowerSettingsAppliedEvent item_ = (Ats_power_ClockLow_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_DPHI_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 6;
        int version = 594;
        double warnHi = 0.3791808f;
        double warnLo = 0.8549120426177979;
        double limitHi = 0.041434288024902344;
        double limitLo = 0.4745718240737915;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_DPHI_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_DPHI_I_LimitsSettingsAppliedEvent));
        Ats_power_DPHI_I_LimitsSettingsAppliedEvent item_ = (Ats_power_DPHI_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_DPHI_PowerSettingsAppliedEvent() throws Exception {
        int priority = 470;
        int version = 457;
        double current = 0.6200982928276062;
        double offDelay = 0.841245710849762;
        double onDelay = 0.7808223366737366;
        double voltage = 0.561198353767395;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_DPHI_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_DPHI_PowerSettingsAppliedEvent));
        Ats_power_DPHI_PowerSettingsAppliedEvent item_ = (Ats_power_DPHI_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_DPHI_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 202;
        int version = 222;
        double warnHi = 0.2166774868965149;
        double warnLo = 0.5074688792228699;
        double limitHi = 0.2082958221435547;
        double limitLo = 0.5552515387535095;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_DPHI_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_DPHI_V_LimitsSettingsAppliedEvent));
        Ats_power_DPHI_V_LimitsSettingsAppliedEvent item_ = (Ats_power_DPHI_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Digital_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 471;
        int version = 674;
        double warnHi = 0.84812f;
        double warnLo = 0.3188076615333557;
        double limitHi = 0.4344951f;
        double limitLo = 0.5914474725723267;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Digital_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Digital_I_LimitsSettingsAppliedEvent));
        Ats_power_Digital_I_LimitsSettingsAppliedEvent item_ = (Ats_power_Digital_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Digital_PowerSettingsAppliedEvent() throws Exception {
        int priority = 184;
        int version = 551;
        double current = 0.2993737459182739;
        double offDelay = 0.9198556542396545;
        double onDelay = 0.8859411478042603;
        double voltage = 0.284783f;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Digital_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Digital_PowerSettingsAppliedEvent));
        Ats_power_Digital_PowerSettingsAppliedEvent item_ = (Ats_power_Digital_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Digital_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 170;
        int version = 743;
        double warnHi = 0.445568323135376;
        double warnLo = 0.18660366535186768;
        double limitHi = 0.3535655736923218;
        double limitLo = 0.2734687328338623;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Digital_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Digital_V_LimitsSettingsAppliedEvent));
        Ats_power_Digital_V_LimitsSettingsAppliedEvent item_ = (Ats_power_Digital_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Fan_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 127;
        int version = 852;
        double warnHi = 0.3327948f;
        double warnLo = 0.1259095f;
        double limitHi = 0.2006917f;
        double limitLo = 0.24213123321533203;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Fan_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Fan_I_LimitsSettingsAppliedEvent));
        Ats_power_Fan_I_LimitsSettingsAppliedEvent item_ = (Ats_power_Fan_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Fan_PowerSettingsAppliedEvent() throws Exception {
        int priority = 281;
        int version = 691;
        double current = 0.6705657839775085;
        double offDelay = 0.6142090559005737;
        double onDelay = 0.8862087726593018;
        double voltage = 0.15819251537322998;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Fan_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Fan_PowerSettingsAppliedEvent));
        Ats_power_Fan_PowerSettingsAppliedEvent item_ = (Ats_power_Fan_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Fan_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 770;
        int version = 293;
        double warnHi = 0.7041372656822205;
        double warnLo = 0.5663792490959167;
        double limitHi = 0.5089836716651917;
        double limitLo = 0.4212055802345276;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Fan_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Fan_V_LimitsSettingsAppliedEvent));
        Ats_power_Fan_V_LimitsSettingsAppliedEvent item_ = (Ats_power_Fan_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_HVBias_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 849;
        int version = 20;
        double warnHi = 0.546629011631012;
        double warnLo = 0.03093355894088745;
        double limitHi = 0.8810170888900757;
        double limitLo = 0.770524263381958;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_HVBias_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_HVBias_I_LimitsSettingsAppliedEvent));
        Ats_power_HVBias_I_LimitsSettingsAppliedEvent item_ = (Ats_power_HVBias_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_HVBias_PowerSettingsAppliedEvent() throws Exception {
        int priority = 72;
        int version = 943;
        double current = 0.8093852400779724;
        double offDelay = 0.7401184439659119;
        double onDelay = 0.2639627f;
        double voltage = 0.9439328908920288;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_HVBias_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_HVBias_PowerSettingsAppliedEvent));
        Ats_power_HVBias_PowerSettingsAppliedEvent item_ = (Ats_power_HVBias_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_HVBias_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 873;
        int version = 705;
        double warnHi = 0.08638501167297363;
        double warnLo = 0.3942340612411499;
        double limitHi = 0.1649875044822693;
        double limitLo = 0.9467206597328186;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_HVBias_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_HVBias_V_LimitsSettingsAppliedEvent));
        Ats_power_HVBias_V_LimitsSettingsAppliedEvent item_ = (Ats_power_HVBias_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Hameg1_PowerSettingsAppliedEvent() throws Exception {
        int priority = 271;
        int version = 604;
        String connType = "n";
        String devcId = "";
        int devcParm = 398;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg1_PowerSettingsAppliedEvent(priority, version, connType, devcId, devcParm));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg1_PowerSettingsAppliedEvent));
        Ats_power_Hameg1_PowerSettingsAppliedEvent item_ = (Ats_power_Hameg1_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
    }

    @Test
    public void sendReceiveAts_power_Hameg2_PowerSettingsAppliedEvent() throws Exception {
        int priority = 95;
        int version = 584;
        String connType = "";
        String devcId = "";
        int devcParm = 135;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg2_PowerSettingsAppliedEvent(priority, version, connType, devcId, devcParm));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg2_PowerSettingsAppliedEvent));
        Ats_power_Hameg2_PowerSettingsAppliedEvent item_ = (Ats_power_Hameg2_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
    }

    @Test
    public void sendReceiveAts_power_Hameg3_PowerSettingsAppliedEvent() throws Exception {
        int priority = 859;
        int version = 677;
        String connType = "b";
        String devcId = "";
        int devcParm = 711;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg3_PowerSettingsAppliedEvent(priority, version, connType, devcId, devcParm));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg3_PowerSettingsAppliedEvent));
        Ats_power_Hameg3_PowerSettingsAppliedEvent item_ = (Ats_power_Hameg3_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
    }

    @Test
    public void sendReceiveAts_power_Heartbeat_timersSettingsAppliedEvent() throws Exception {
        int priority = 529;
        int version = 351;
        long taskPeriodMillis = 900L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Heartbeat_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Heartbeat_timersSettingsAppliedEvent));
        Ats_power_Heartbeat_timersSettingsAppliedEvent item_ = (Ats_power_Heartbeat_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_Keithley_PowerSettingsAppliedEvent() throws Exception {
        int priority = 496;
        int version = 0;
        String connType = "z";
        String devcId = "";
        int devcParm = 301;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Keithley_PowerSettingsAppliedEvent(priority, version, connType, devcId, devcParm));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Keithley_PowerSettingsAppliedEvent));
        Ats_power_Keithley_PowerSettingsAppliedEvent item_ = (Ats_power_Keithley_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
    }

    @Test
    public void sendReceiveAts_power_Monitor_check_timersSettingsAppliedEvent() throws Exception {
        int priority = 216;
        int version = 566;
        long taskPeriodMillis = 611L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Monitor_check_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Monitor_check_timersSettingsAppliedEvent));
        Ats_power_Monitor_check_timersSettingsAppliedEvent item_ = (Ats_power_Monitor_check_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_Monitor_publish_timersSettingsAppliedEvent() throws Exception {
        int priority = 786;
        int version = 306;
        long taskPeriodMillis = 419L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Monitor_publish_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Monitor_publish_timersSettingsAppliedEvent));
        Ats_power_Monitor_publish_timersSettingsAppliedEvent item_ = (Ats_power_Monitor_publish_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_Monitor_update_timersSettingsAppliedEvent() throws Exception {
        int priority = 330;
        int version = 891;
        long taskPeriodMillis = 523L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Monitor_update_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Monitor_update_timersSettingsAppliedEvent));
        Ats_power_Monitor_update_timersSettingsAppliedEvent item_ = (Ats_power_Monitor_update_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_OD_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 413;
        int version = 905;
        double warnHi = 0.786760687828064;
        double warnLo = 0.11390924453735352;
        double limitHi = 0.27820414304733276;
        double limitLo = 0.8154560327529907;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OD_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OD_I_LimitsSettingsAppliedEvent));
        Ats_power_OD_I_LimitsSettingsAppliedEvent item_ = (Ats_power_OD_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OD_PowerSettingsAppliedEvent() throws Exception {
        int priority = 71;
        int version = 358;
        double current = 0.3528527021408081;
        double offDelay = 0.9307073354721069;
        double onDelay = 0.974181592464447;
        double voltage = 0.41983598470687866;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OD_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OD_PowerSettingsAppliedEvent));
        Ats_power_OD_PowerSettingsAppliedEvent item_ = (Ats_power_OD_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OD_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 434;
        int version = 617;
        double warnHi = 0.6191104650497437;
        double warnLo = 0.18111753463745117;
        double limitHi = 0.6157971620559692;
        double limitLo = 0.5302456617355347;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OD_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OD_V_LimitsSettingsAppliedEvent));
        Ats_power_OD_V_LimitsSettingsAppliedEvent item_ = (Ats_power_OD_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OTM_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 43;
        int version = 968;
        double warnHi = 0.44511836767196655;
        double warnLo = 0.9004220366477966;
        double limitHi = 0.36087822914123535;
        double limitLo = 0.7641117572784424;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OTM_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OTM_I_LimitsSettingsAppliedEvent));
        Ats_power_OTM_I_LimitsSettingsAppliedEvent item_ = (Ats_power_OTM_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OTM_PowerSettingsAppliedEvent() throws Exception {
        int priority = 121;
        int version = 535;
        double current = 0.39221322536468506;
        double offDelay = 0.8009426593780518;
        double onDelay = 0.9310056567192078;
        double voltage = 0.6005901098251343;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OTM_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OTM_PowerSettingsAppliedEvent));
        Ats_power_OTM_PowerSettingsAppliedEvent item_ = (Ats_power_OTM_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OTM_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 726;
        int version = 458;
        double warnHi = 0.40960294008255005;
        double warnLo = 0.7907758355140686;
        double limitHi = 0.450225293636322;
        double limitLo = 0.19921225309371948;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OTM_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OTM_V_LimitsSettingsAppliedEvent));
        Ats_power_OTM_V_LimitsSettingsAppliedEvent item_ = (Ats_power_OTM_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Power_state_timersSettingsAppliedEvent() throws Exception {
        int priority = 300;
        int version = 316;
        long taskPeriodMillis = 732L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Power_state_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Power_state_timersSettingsAppliedEvent));
        Ats_power_Power_state_timersSettingsAppliedEvent item_ = (Ats_power_Power_state_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_RuntimeInfo_timersSettingsAppliedEvent() throws Exception {
        int priority = 229;
        int version = 760;
        long taskPeriodMillis = 986L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_RuntimeInfo_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_RuntimeInfo_timersSettingsAppliedEvent));
        Ats_power_RuntimeInfo_timersSettingsAppliedEvent item_ = (Ats_power_RuntimeInfo_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_SchedulersSettingsAppliedEvent() throws Exception {
        int priority = 106;
        int version = 435;
        int default_nTasks = 996;
        int default_nThreads = 254;
        int monitor_update_publish_scheduler_nTasks = 336;
        int monitor_update_publish_scheduler_nThreads = 114;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_SchedulersSettingsAppliedEvent(priority, version, default_nTasks, default_nThreads, monitor_update_publish_scheduler_nTasks, monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Ats_power_SchedulersSettingsAppliedEvent));
        Ats_power_SchedulersSettingsAppliedEvent item_ = (Ats_power_SchedulersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)default_nTasks, (long)item_.getDefault_nTasks());
        Assert.assertEquals((long)default_nThreads, (long)item_.getDefault_nThreads());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nTasks, (long)item_.getMonitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nThreads, (long)item_.getMonitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveAts_AgentMonitorService_timersSettingsAppliedEvent() throws Exception {
        int priority = 390;
        int version = 421;
        long taskPeriodMillis = 563L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_AgentMonitorService_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_AgentMonitorService_timersSettingsAppliedEvent));
        Ats_AgentMonitorService_timersSettingsAppliedEvent item_ = (Ats_AgentMonitorService_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_CryoCon_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 463;
        int version = 219;
        String host = "";
        SALEvent item = this.testSendReceive((SALEvent)new Ats_CryoCon_DeviceSettingsAppliedEvent(priority, version, host));
        Assert.assertTrue((boolean)(item instanceof Ats_CryoCon_DeviceSettingsAppliedEvent));
        Ats_CryoCon_DeviceSettingsAppliedEvent item_ = (Ats_CryoCon_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)host, (Object)item_.getHost());
    }

    @Test
    public void sendReceiveAts_Heartbeat_timersSettingsAppliedEvent() throws Exception {
        int priority = 248;
        int version = 786;
        long taskPeriodMillis = 492L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Heartbeat_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_Heartbeat_timersSettingsAppliedEvent));
        Ats_Heartbeat_timersSettingsAppliedEvent item_ = (Ats_Heartbeat_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_Monitor_check_timersSettingsAppliedEvent() throws Exception {
        int priority = 926;
        int version = 899;
        long taskPeriodMillis = 529L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Monitor_check_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_Monitor_check_timersSettingsAppliedEvent));
        Ats_Monitor_check_timersSettingsAppliedEvent item_ = (Ats_Monitor_check_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_Monitor_publish_timersSettingsAppliedEvent() throws Exception {
        int priority = 977;
        int version = 371;
        long taskPeriodMillis = 824L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Monitor_publish_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_Monitor_publish_timersSettingsAppliedEvent));
        Ats_Monitor_publish_timersSettingsAppliedEvent item_ = (Ats_Monitor_publish_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_Monitor_update_timersSettingsAppliedEvent() throws Exception {
        int priority = 912;
        int version = 184;
        long taskPeriodMillis = 561L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Monitor_update_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_Monitor_update_timersSettingsAppliedEvent));
        Ats_Monitor_update_timersSettingsAppliedEvent item_ = (Ats_Monitor_update_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_RuntimeInfo_timersSettingsAppliedEvent() throws Exception {
        int priority = 178;
        int version = 630;
        long taskPeriodMillis = 614L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_RuntimeInfo_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_RuntimeInfo_timersSettingsAppliedEvent));
        Ats_RuntimeInfo_timersSettingsAppliedEvent item_ = (Ats_RuntimeInfo_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_SchedulersSettingsAppliedEvent() throws Exception {
        int priority = 324;
        int version = 185;
        int default_nTasks = 367;
        int default_nThreads = 262;
        int monitor_update_publish_scheduler_nTasks = 138;
        int monitor_update_publish_scheduler_nThreads = 166;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_SchedulersSettingsAppliedEvent(priority, version, default_nTasks, default_nThreads, monitor_update_publish_scheduler_nTasks, monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Ats_SchedulersSettingsAppliedEvent));
        Ats_SchedulersSettingsAppliedEvent item_ = (Ats_SchedulersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)default_nTasks, (long)item_.getDefault_nTasks());
        Assert.assertEquals((long)default_nThreads, (long)item_.getDefault_nThreads());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nTasks, (long)item_.getMonitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nThreads, (long)item_.getMonitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveAts_TempCCDSetPoint_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 418;
        int version = 759;
        double warnHi = 0.5617164969444275;
        double warnLo = 0.5828642249107361;
        double limitHi = 0.05298245f;
        double limitLo = 0.17073094844818115;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempCCDSetPoint_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempCCDSetPoint_LimitsSettingsAppliedEvent));
        Ats_TempCCDSetPoint_LimitsSettingsAppliedEvent item_ = (Ats_TempCCDSetPoint_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_TempCCD_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 193;
        int version = 853;
        double warnHi = 0.300825834274292;
        double warnLo = 0.15915173292160034;
        double limitHi = 0.4622097f;
        double limitLo = 0.021161377429962158;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempCCD_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempCCD_LimitsSettingsAppliedEvent));
        Ats_TempCCD_LimitsSettingsAppliedEvent item_ = (Ats_TempCCD_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_TempColdPlate_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 285;
        int version = 149;
        double warnHi = 0.6755883693695068;
        double warnLo = 0.5228105187416077;
        double limitHi = 0.037378907203674316;
        double limitLo = 0.9072979688644409;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempColdPlate_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempColdPlate_LimitsSettingsAppliedEvent));
        Ats_TempColdPlate_LimitsSettingsAppliedEvent item_ = (Ats_TempColdPlate_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_TempCryoHead_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 713;
        int version = 453;
        double warnHi = 0.7588313817977905;
        double warnLo = 0.4588811993598938;
        double limitHi = 0.3201286196708679;
        double limitLo = 0.3820696473121643;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempCryoHead_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempCryoHead_LimitsSettingsAppliedEvent));
        Ats_TempCryoHead_LimitsSettingsAppliedEvent item_ = (Ats_TempCryoHead_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_Vacuum_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 640;
        int version = 571;
        double warnHi = 0.02814584970474243;
        double warnLo = 0.382207453250885;
        double limitHi = 0.12228578329086304;
        double limitLo = 0.973324716091156;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Vacuum_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_Vacuum_LimitsSettingsAppliedEvent));
        Ats_Vacuum_LimitsSettingsAppliedEvent item_ = (Ats_Vacuum_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 373;
        int version = 143;
        int schedulers_default_nTasks = 22;
        int schedulers_default_nThreads = 533;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasksSettingsAppliedEvent));
        Bonn_shutter_PeriodicTasksSettingsAppliedEvent item_ = (Bonn_shutter_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 39;
        int version = 690;
        long agentmonitorservice_taskPeriodMillis = 798L;
        long heartbeat_taskPeriodMillis = 312L;
        long runtimeinfo_taskPeriodMillis = 332L;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent));
        Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent item_ = (Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveShutterBladeMotionProfileEvent() throws Exception {
        int priority = 581;
        ShutterBladeMotionProfileEvent.Blade blade = ShutterBladeMotionProfileEvent.Blade.PLUS_X;
        ShutterBladeMotionProfileEvent.Direction direction = ShutterBladeMotionProfileEvent.Direction.OPEN;
        double timestampStart = 0.4308992028236389;
        double startPosition = 0.5011999607086182;
        double targetDuration = 4.4840574264526367E-4;
        double targetPosition = 0.07299137115478516;
        double endPosition = 0.14174103736877441;
        double actualDuration = 0.8059961199760437;
        int hallSensorCount = 391;
        double[] timestampHallSensor = TestHelper.generateDoubleArray((int)240, (int)-1305877954);
        int[] hallSensorID = TestHelper.generateIntArray((int)240, (int)1200485353);
        double[] hallSensorPosition = TestHelper.generateDoubleArray((int)240, (int)-686678415);
        boolean[] hallSensorTransition = new boolean[]{true, false, false, false, false, false, false, false, true, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, false, false, true, false, true, false, false, true, true, false, false, true, true, false, true, true, true, false, true, false, false, true, true, false, true, true, false, false, false, false, false, false, true, true, true, true, false, true, false, false, false, false, true, false, true, false, true, true, false, false, true, false, true, false, false, true, true, true, true, true, true, false, false, true, true, true, true, true, true, true, true, false, true, false, true, true, false, false, false, true, true, false, true, false, false, false, false, true, false, false, false, true, false, false, false, true, true, true, false, true, false, true, false, false, true, true, true, false, false, false, true, false, false, true, true, false, false, false, false, false, true, false, true, true, false, false, true, true, true, false, true, false, true, false, true, false, false, true, true, true, false, true, true, false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, true, false, true, false, false, true, false, true, true, true, false, true, true, true, false, false, false, false, false, true, false, false, false, false, false, true, true, true, false, false, false, true, true, false, true, true, true, false, false, true, false, true, true, true, false, false, false, false, false};
        int encoderCount = 177;
        double[] timestampEncoder = TestHelper.generateDoubleArray((int)240, (int)-1012057892);
        double[] encoderPosition = TestHelper.generateDoubleArray((int)240, (int)1531756804);
        SALEvent item = this.testSendReceive((SALEvent)new ShutterBladeMotionProfileEvent(priority, blade, direction, timestampStart, startPosition, targetDuration, targetPosition, endPosition, actualDuration, hallSensorCount, timestampHallSensor, hallSensorID, hallSensorPosition, hallSensorTransition, encoderCount, timestampEncoder, encoderPosition));
        Assert.assertTrue((boolean)(item instanceof ShutterBladeMotionProfileEvent));
        ShutterBladeMotionProfileEvent item_ = (ShutterBladeMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)blade, (Object)item_.getBlade());
        Assert.assertEquals((Object)direction, (Object)item_.getDirection());
        Assert.assertEquals((double)timestampStart, (double)item_.getTimestampStart(), (double)1.0E-6f);
        Assert.assertEquals((double)startPosition, (double)item_.getStartPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)targetDuration, (double)item_.getTargetDuration(), (double)1.0E-6f);
        Assert.assertEquals((double)targetPosition, (double)item_.getTargetPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)endPosition, (double)item_.getEndPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)actualDuration, (double)item_.getActualDuration(), (double)1.0E-6f);
        Assert.assertEquals((long)hallSensorCount, (long)item_.getHallSensorCount());
        Assert.assertArrayEquals((double[])timestampHallSensor, (double[])item_.getTimestampHallSensor(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])hallSensorID, (int[])item_.getHallSensorID());
        Assert.assertArrayEquals((double[])hallSensorPosition, (double[])item_.getHallSensorPosition(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])hallSensorTransition, (boolean[])item_.getHallSensorTransition());
        Assert.assertEquals((long)encoderCount, (long)item_.getEncoderCount());
        Assert.assertArrayEquals((double[])timestampEncoder, (double[])item_.getTimestampEncoder(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])encoderPosition, (double[])item_.getEncoderPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageStoredEvent() throws Exception {
        int priority = 480;
        String imageName = "tjdwyysopgkrcfzm";
        double timestampImageStored = 0.05116891860961914;
        SALEvent item = this.testSendReceive((SALEvent)new ImageStoredEvent(priority, imageName, timestampImageStored));
        Assert.assertTrue((boolean)(item instanceof ImageStoredEvent));
        ImageStoredEvent item_ = (ImageStoredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampImageStored, (double)item_.getTimestampImageStored(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFitsFilesWrittenEvent() throws Exception {
        int priority = 880;
        String imageName = "fbod";
        double timestampFilesWritten = 0.161748468875885;
        String rootFileName = "z";
        String relativeFileNames = "b";
        String fileNode = "";
        SALEvent item = this.testSendReceive((SALEvent)new FitsFilesWrittenEvent(priority, imageName, timestampFilesWritten, rootFileName, relativeFileNames, fileNode));
        Assert.assertTrue((boolean)(item instanceof FitsFilesWrittenEvent));
        FitsFilesWrittenEvent item_ = (FitsFilesWrittenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampFilesWritten, (double)item_.getTimestampFilesWritten(), (double)1.0E-6f);
        Assert.assertEquals((Object)rootFileName, (Object)item_.getRootFileName());
        Assert.assertEquals((Object)relativeFileNames, (Object)item_.getRelativeFileNames());
        Assert.assertEquals((Object)fileNode, (Object)item_.getFileNode());
    }

    @Test
    public void sendReceiveFileCommandExecutionEvent() throws Exception {
        int priority = 549;
        String imageName = "zmrgoqs";
        double timestampCommandComplete = 0.5729556679725647;
        String command = "p";
        int rc = 727;
        SALEvent item = this.testSendReceive((SALEvent)new FileCommandExecutionEvent(priority, imageName, timestampCommandComplete, command, rc));
        Assert.assertTrue((boolean)(item instanceof FileCommandExecutionEvent));
        FileCommandExecutionEvent item_ = (FileCommandExecutionEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampCommandComplete, (double)item_.getTimestampCommandComplete(), (double)1.0E-6f);
        Assert.assertEquals((Object)command, (Object)item_.getCommand());
        Assert.assertEquals((long)rc, (long)item_.getRc());
    }

    @Test
    public void sendReceiveImageVisualizationEvent() throws Exception {
        int priority = 3;
        String imageName = "nqtmoqgwhdfjgfblquwnporwzppfw";
        double timestampVisualizationAvailable = 0.3663373f;
        String url = "b";
        String thumbnail = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageVisualizationEvent(priority, imageName, timestampVisualizationAvailable, url, thumbnail));
        Assert.assertTrue((boolean)(item instanceof ImageVisualizationEvent));
        ImageVisualizationEvent item_ = (ImageVisualizationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampVisualizationAvailable, (double)item_.getTimestampVisualizationAvailable(), (double)1.0E-6f);
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)thumbnail, (Object)item_.getThumbnail());
    }

    @Test
    public void sendReceiveConfigurationAppliedEvent() throws Exception {
        int priority = 992;
        String configurations = "u";
        String version = "";
        String url = "";
        String schemaVersion = "";
        String otherInfo = "i";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationAppliedEvent(priority, configurations, version, url, schemaVersion, otherInfo));
        Assert.assertTrue((boolean)(item instanceof ConfigurationAppliedEvent));
        ConfigurationAppliedEvent item_ = (ConfigurationAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)configurations, (Object)item_.getConfigurations());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
        Assert.assertEquals((Object)otherInfo, (Object)item_.getOtherInfo());
    }

    @Test
    public void sendReceiveConfigurationsAvailableEvent() throws Exception {
        int priority = 147;
        String overrides = "";
        String version = "q";
        String url = "";
        String schemaVersion = "s";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationsAvailableEvent(priority, overrides, version, url, schemaVersion));
        Assert.assertTrue((boolean)(item instanceof ConfigurationsAvailableEvent));
        ConfigurationsAvailableEvent item_ = (ConfigurationsAvailableEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)overrides, (Object)item_.getOverrides());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 786;
        int errorCode = 330;
        String errorReport = "y";
        String traceback = "a";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 378;
        int level = 522;
        String subsystem = "";
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level, subsystem));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)subsystem, (Object)item_.getSubsystem());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 262;
        String name = "";
        int level = 657;
        String message = "w";
        String traceback = "u";
        String filePath = "f";
        String functionName = "c";
        int lineNumber = 973;
        int process = 235;
        double timestamp = 0.5877537727355957;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process, timestamp));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
        Assert.assertEquals((double)timestamp, (double)item_.getTimestamp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 100;
        int mode = 614;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 705;
        String salVersion = "xivxmzbatnddascitozxtcfkvyqfaajdyphkrogiabrydtauvlrcbinovajubbdnysrmhrewmxjjnfoobpzsyvmzwrgadvcldlwmkltbvrhgvouipdzgrdpesevgjslvnvaabfgnhxtvojhrbbbatioozejufjdcygrtsrcekkmppbabqpewcaumtxwnnhxdxousukjpdoiujcivovaqkmutsjsdwutkucxnkmcaokqncaqvhcnrspiofd";
        String xmlVersion = "ptratbkajdbywwqebdasnjlscwtzrsustgxfzgxavknpsuwcsxplckkhnlmimbwcdzkopkhrdbeqjbjivltqcbvksqdwsrdkragxankbzfmqwccmlofjzmiztzpbnfpgmqupgyxtuvgsklntesqjwhetavdyxrdiukvymcttfohealssscajwuwnukbfxsomuctoauuxmjjgnwqphxdpctesikdvbkudtg";
        String openSpliceVersion = "jdpmotwmouafgbkkjjgxccdyvuoherhkxhnkkckkfqeyvmoyupmrcntbzfyselziwzdafualjcejeewreankfolkflbpvhvpykfuqlptqxhqwocmidhftfrbbvuqffcgfr";
        String cscVersion = "dbygnrqkkvbbieyykwpejjulnyzoqlplwaljyjzrnavkzkpecckdjdgwsspqdhxsrhhzcjfsgzljzdbejtqhztxvrgspliwuqzuglcmmagvqpkcorirrijxkadmahkdaswumk";
        String subsystemVersions = "";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 592;
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 479;
        String authorizedUsers = "i";
        String nonAuthorizedCSCs = "";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }

    @Test
    public void sendReceiveLargeFileObjectAvailableEvent() throws Exception {
        int priority = 656;
        String url = "fcdkzzvzeydlaqcyvbkexxkzwvxeobydhcqlgeapbvsgxkhyzcyctfskkygismzzzgwqqnubltxijrcbkwyyktoniqxoiiejiqhkhlzxzryrppjgktyuidsadlrqycmwzfugrhrwlveqejngcsnjnephetgmsiibgdriudkkgalhgsvpsvezzhsjwhuwstkppshewoapenvgtmubdmhuyapritluircfwgqcvlfkmkxcpmsylccjo";
        String generator = "qqhxmncebblhkdblsqslavgmlnjxhoehsowscimqglhewdwngqrbehdscepwhxmvkmfzxbywzkvvdwpdneimnnnsixrkvjbnlpnezxwubjqcttkadygrjzmarfgbbmfwpjagbpgydzuxqeadhsupppvdtuqnhujcmhhhsohdszawjbsjgdrjuebfzwbdmatcfqfcmcjgbxmyihihxpsmyievkzlpvwvjtqmxjfrdjghvqyzdkbqolft";
        float version = 0.88366497f;
        int byteSize = 142;
        String checkSum = "gbyctwbyltjtpojslrvqygvliyeusxsqvhxqmallgvbdariwdizmdsvaneypwtbyenawpytbxhivepqbdefckdrfcozgfanglnohyctjrzkxdjnzdsbmrjrckapmqzuhhkmmbxwypgnofrlqqqgquqmsygenfjxopcqrhqrccyewh";
        String mimeType = "xmdehlhlmiwtdxkzrfomsurydqxqozczofzqdggsjnxvpszaitezrfzkvrdhfkeetaxqziiovpskmlwnjnoiawtuhibihxbvpovachsqojgomkvavxjzzgbttqkigmaslshbykwcsezaahoocmquqfwmvrdbfeynqgwjzutjtmiyxpissbjddr";
        String id = "akxmojjdtbbzotfrlryprfqrguaogxhsahtelupqwmsvgajfmwfnumigypsarrrkxbyzisqsbcumlkun";
        SALEvent item = this.testSendReceive((SALEvent)new LargeFileObjectAvailableEvent(priority, url, generator, version, byteSize, checkSum, mimeType, id));
        Assert.assertTrue((boolean)(item instanceof LargeFileObjectAvailableEvent));
        LargeFileObjectAvailableEvent item_ = (LargeFileObjectAvailableEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)generator, (Object)item_.getGenerator());
        Assert.assertEquals((float)version, (float)item_.getVersion(), (float)1.0E-6f);
        Assert.assertEquals((long)byteSize, (long)item_.getByteSize());
        Assert.assertEquals((Object)checkSum, (Object)item_.getCheckSum());
        Assert.assertEquals((Object)mimeType, (Object)item_.getMimeType());
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }
}

