package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Ats_power_Aux_PowerSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final double current;

  private final double offDelay;

  private final double onDelay;

  private final double voltage;

  public Ats_power_Aux_PowerSettingsAppliedEvent(int priority, int version, double current,
      double offDelay, double onDelay, double voltage) {
    super (priority);
    this.version = version;
    this.current = current;
    this.offDelay = offDelay;
    this.onDelay = onDelay;
    this.voltage = voltage;
  }

  public int getVersion() {
    return version;
  }

  public double getCurrent() {
    return current;
  }

  public double getOffDelay() {
    return offDelay;
  }

  public double getOnDelay() {
    return onDelay;
  }

  public double getVoltage() {
    return voltage;
  }

  @Override
  public String toString() {
    return "Ats_power_Aux_PowerSettingsAppliedEvent{" + "version=" + version +
        ", current=" + current +", offDelay=" + offDelay +", onDelay=" + onDelay +
        ", voltage=" + voltage +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private int version;

    private double current;

    private double offDelay;

    private double onDelay;

    private double voltage;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(int version) {
      this.version = version;
      return this;
    }

    public Builder current(double current) {
      this.current = current;
      return this;
    }

    public Builder offDelay(double offDelay) {
      this.offDelay = offDelay;
      return this;
    }

    public Builder onDelay(double onDelay) {
      this.onDelay = onDelay;
      return this;
    }

    public Builder voltage(double voltage) {
      this.voltage = voltage;
      return this;
    }

    public Ats_power_Aux_PowerSettingsAppliedEvent build() {
      return new Ats_power_Aux_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage);
    }
  }
}
