package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Ats_power_Analog_I_LimitsSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final double warnHi;

  private final double warnLo;

  private final double limitHi;

  private final double limitLo;

  public Ats_power_Analog_I_LimitsSettingsAppliedEvent(int priority, int version, double warnHi,
      double warnLo, double limitHi, double limitLo) {
    super (priority);
    this.version = version;
    this.warnHi = warnHi;
    this.warnLo = warnLo;
    this.limitHi = limitHi;
    this.limitLo = limitLo;
  }

  public int getVersion() {
    return version;
  }

  public double getWarnHi() {
    return warnHi;
  }

  public double getWarnLo() {
    return warnLo;
  }

  public double getLimitHi() {
    return limitHi;
  }

  public double getLimitLo() {
    return limitLo;
  }

  @Override
  public String toString() {
    return "Ats_power_Analog_I_LimitsSettingsAppliedEvent{" + "version=" + version +
        ", warnHi=" + warnHi +", warnLo=" + warnLo +", limitHi=" + limitHi +", limitLo=" + limitLo +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private int version;

    private double warnHi;

    private double warnLo;

    private double limitHi;

    private double limitLo;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(int version) {
      this.version = version;
      return this;
    }

    public Builder warnHi(double warnHi) {
      this.warnHi = warnHi;
      return this;
    }

    public Builder warnLo(double warnLo) {
      this.warnLo = warnLo;
      return this;
    }

    public Builder limitHi(double limitHi) {
      this.limitHi = limitHi;
      return this;
    }

    public Builder limitLo(double limitLo) {
      this.limitLo = limitLo;
      return this;
    }

    public Ats_power_Analog_I_LimitsSettingsAppliedEvent build() {
      return new Ats_power_Analog_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo);
    }
  }
}
