/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.event.Ats_AgentMonitorService_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_CryoCon_DeviceSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_Heartbeat_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_Monitor_check_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_Monitor_publish_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_Monitor_update_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_RuntimeInfo_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_SchedulersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_TempCCDSetPoint_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_TempCCD_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_TempColdPlate_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_TempCryoHead_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_Vacuum_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_AgentMonitorService_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Analog_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Analog_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Analog_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Aux_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Aux_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Aux_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkHigh_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkHigh_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkLow_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClkLow_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClockHigh_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_ClockLow_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_DPHI_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_DPHI_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_DPHI_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Digital_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Digital_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Digital_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Fan_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Fan_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Fan_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_HVBias_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_HVBias_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_HVBias_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg1_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg2_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Hameg3_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Heartbeat_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Keithley_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Monitor_check_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Monitor_publish_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Monitor_update_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OD_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OD_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OD_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OTM_I_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OTM_PowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_OTM_V_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_Power_state_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_RuntimeInfo_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Ats_power_SchedulersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FileCommandExecutionEvent;
import org.lsst.sal.atcamera.event.FitsFilesWrittenEvent;
import org.lsst.sal.atcamera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Ccd_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Raft_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Raft_RaftTempControlSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_LimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsPowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Focal_plane_Reb_timersSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.ImageReadoutParametersEvent;
import org.lsst.sal.atcamera.event.ImageStoredEvent;
import org.lsst.sal.atcamera.event.ImageVisualizationEvent;
import org.lsst.sal.atcamera.event.ShutterBladeMotionProfileEvent;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_buildSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_StoreSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreSettingsAppliedEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageDatabaseServiceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageNameServiceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 450;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 731;
        String imageName = "epvkoozs";
        int imageIndex = 147;
        String imageSource = "";
        String imageController = "g";
        String imageDate = "vehxuort";
        int imageNumber = 835;
        double timestampAcquisitionStart = 0.8096395134925842;
        double requestedExposureTime = 0.35675424337387085;
        double timestampEndOfReadout = 0.1982351f;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 338;
        double timestampTransition = 0.02030092477798462;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 651;
        double timestampTransition = 0.04284829f;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 763;
        double timestampTransition = 0.2315411f;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 292;
        double timestampTransition = 0.6703230738639832;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 688;
        String additionalKeys = "z";
        String additionalValues = "";
        int imagesInSequence = 983;
        String imageName = "voiybbydygmabfrjukpffm";
        int imageIndex = 981;
        String imageSource = "";
        String imageController = "";
        String imageDate = "";
        int imageNumber = 126;
        double timestampAcquisitionStart = 0.6100382208824158;
        double exposureTime = 0.4420720338821411;
        String imageTag = "qcrkmftcfu";
        double timestampDateObs = 0.12346959114074707;
        double timestampDateEnd = 0.7179641723632812;
        double measuredShutterOpenTime = 0.2884870767593384;
        double darkTime = 0.6366291642189026;
        String emulatedImage = "";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 666;
        double timestampTransition = 0.2761433f;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 751;
        double timestampTransition = 0.5855571627616882;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 912;
        double timestampTransition = 0.13470983505249023;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 559;
        String additionalKeys = "";
        String additionalValues = "l";
        int imagesInSequence = 257;
        String imageName = "rmuieya";
        int imageIndex = 6;
        String imageSource = "j";
        String imageController = "p";
        String imageDate = "ljekw";
        int imageNumber = 618;
        double timestampAcquisitionStart = 0.660609f;
        double exposureTime = 0.45992857217788696;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 805;
        double timestampTransition = 0.7265490889549255;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 114;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 383;
        String imageName = "drdpynlkeqghnfuzovpreprkfuy";
        int imageIndex = 157;
        String imageSource = "ju";
        String imageController = "";
        String imageDate = "yzw";
        int imageNumber = 980;
        double timestampAcquisitionStart = 0.3052665f;
        double exposureTime = 0.47505706548690796;
        double timestampStartOfReadout = 0.9432885646820068;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveShutterMotionProfileEvent() throws Exception {
        int priority = 729;
        double measuredExposureTime = 0.44469577074050903;
        SALEvent item = this.testSendReceive((SALEvent)new ShutterMotionProfileEvent(priority, measuredExposureTime));
        Assert.assertTrue((boolean)(item instanceof ShutterMotionProfileEvent));
        ShutterMotionProfileEvent item_ = (ShutterMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)measuredExposureTime, (double)item_.getMeasuredExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 944;
        String imageName = "";
        String ccdLocation = "";
        String raftBay = "l";
        String ccdSlot = "z";
        ImageReadoutParametersEvent.CcdType ccdType = ImageReadoutParametersEvent.CcdType.E2V;
        int overRows = 751;
        int overCols = 879;
        int readRows = 940;
        int readCols = 138;
        int readCols2 = 96;
        int preCols = 916;
        int preRows = 611;
        int postCols = 347;
        int underCols = 619;
        String daqFolder = "u";
        String daqAnnotation = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 961;
        String ccdLocation = "";
        String raftBay = "";
        String ccdSlot = "f";
        String rebSerialNumber = "y";
        String rebLSSTName = "e";
        String ccdLSSTName = "j";
        String raftLSSTName = "j";
        String ccdManSerNum = "j";
        String ccdManufacturer = "l";
        FocalPlaneSummaryInfoEvent.CcdType ccdType = FocalPlaneSummaryInfoEvent.CcdType.E2V;
        double ccdTempSetPoint = 0.4391133189201355;
        String sequencerKey = "y";
        String sequencerChecksum = "";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((double)ccdTempSetPoint, (double)item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 909;
        int version = 705;
        String location = "";
        String manSerNum = "";
        String name = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdSettingsAppliedEvent(priority, version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdSettingsAppliedEvent));
        Focal_plane_Ccd_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Ccd_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 758;
        int version = 546;
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-285564450);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)1, (int)-2128996900);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1411552849);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)1, (int)988845720);
        String location = "";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)1, (int)-405620869);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)1, (int)380063568);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)1, (int)-881196557);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)1, (int)1668298390);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)1, (int)1066273454);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)1, (int)558779028);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1818025879);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)1, (int)177966273);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-958412791);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)1, (int)1220371580);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1603146689);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)1, (int)1486134430);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-862472425);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)1, (int)1027608383);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)1, (int)708589067);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1518938308);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1250181728);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)1, (int)-2027831750);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1139765352);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)1, (int)-383668415);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsSettingsAppliedEvent(priority, version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsSettingsAppliedEvent));
        Focal_plane_Ccd_LimitsSettingsAppliedEvent item_ = (Focal_plane_Ccd_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_RaftsSettingsAppliedEvent() throws Exception {
        int priority = 7;
        int version = 874;
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_RaftsSettingsAppliedEvent(priority, version, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_RaftsSettingsAppliedEvent));
        Focal_plane_Ccd_RaftsSettingsAppliedEvent item_ = (Focal_plane_Ccd_RaftsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseServiceSettingsAppliedEvent() throws Exception {
        int priority = 810;
        int version = 503;
        String dbURL = "s";
        boolean enabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseServiceSettingsAppliedEvent(priority, version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseServiceSettingsAppliedEvent));
        Focal_plane_ImageDatabaseServiceSettingsAppliedEvent item_ = (Focal_plane_ImageDatabaseServiceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameServiceSettingsAppliedEvent() throws Exception {
        int priority = 529;
        int version = 884;
        String controller = "e";
        String dbURL = "l";
        String offset = "";
        String source = "";
        String timeZoneId = "x";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameServiceSettingsAppliedEvent(priority, version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameServiceSettingsAppliedEvent));
        Focal_plane_ImageNameServiceSettingsAppliedEvent item_ = (Focal_plane_ImageNameServiceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent() throws Exception {
        int priority = 52;
        int version = 75;
        String instrument = "m";
        String telescope = "n";
        String testStand = "d";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent(priority, version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent));
        Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent item_ = (Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 2;
        int version = 645;
        int schedulers_default_nTasks = 9;
        int schedulers_default_nThreads = 426;
        int schedulers_monitor_check_scheduler_nTasks = 991;
        int schedulers_monitor_check_scheduler_nThreads = 634;
        int schedulers_monitor_update_publish_scheduler_nTasks = 917;
        int schedulers_monitor_update_publish_scheduler_nThreads = 968;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasksSettingsAppliedEvent));
        Focal_plane_PeriodicTasksSettingsAppliedEvent item_ = (Focal_plane_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 48;
        int version = 337;
        long agentmonitorservice_taskPeriodMillis = 506L;
        long heartbeat_taskPeriodMillis = 555L;
        long monitor_publish_taskPeriodMillis = 258L;
        long monitor_update_taskPeriodMillis = 404L;
        long runtimeinfo_taskPeriodMillis = 754L;
        long tempcontrol_R00_taskPeriodMillis = 491L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R00_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersSettingsAppliedEvent));
        Focal_plane_PeriodicTasks_timersSettingsAppliedEvent item_ = (Focal_plane_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R00_taskPeriodMillis, (long)item_.getTempcontrol_R00_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 655;
        int version = 172;
        String location = "";
        String name = "f";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdSettingsAppliedEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdSettingsAppliedEvent));
        Focal_plane_Raft_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Raft_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlSettingsAppliedEvent() throws Exception {
        int priority = 794;
        int version = 676;
        String location = "c";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)1, (int)-1969283497);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)1, (int)2129654792);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)1, (int)-1138184120);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)1, (int)-245480496);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)1, (int)703339567);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)1, (int)-597072756);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)1, (int)1475822054);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)1, (int)-2141009491);
        String tempcontrol_rebs = "l";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)1, (int)1642285350);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)1, (int)-856475492);
        String tempcontrol_tempChans = "";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)1, (int)1336914056);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlSettingsAppliedEvent(priority, version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlSettingsAppliedEvent));
        Focal_plane_Raft_RaftTempControlSettingsAppliedEvent item_ = (Focal_plane_Raft_RaftTempControlSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent() throws Exception {
        int priority = 49;
        int version = 787;
        String location = "";
        boolean[] tempcontrol_active = new boolean[]{false};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent(priority, version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent));
        Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent item_ = (Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 403;
        int version = 762;
        double warnHi = 0.6711699366569519;
        double warnLo = 0.1776389479637146;
        double limitHi = 0.18122988939285278;
        double limitLo = 0.696293830871582;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent));
        Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent item_ = (Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 787;
        int version = 698;
        String location = "q";
        String name = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdSettingsAppliedEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdSettingsAppliedEvent));
        Focal_plane_Reb_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Reb_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 145;
        int version = 897;
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)1, (int)-2092361915);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)1, (int)1659319565);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)1, (int)1528725164);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)1, (int)1041003529);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)1, (int)-51267008);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)1, (int)1346480913);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)1, (int)-21930459);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)1, (int)1043124369);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)1, (int)1244730043);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1554856959);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)1, (int)984188060);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)1, (int)-96983130);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)1, (int)-137493304);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)1, (int)904388178);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)1, (int)747155534);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1083026305);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)1, (int)-38827726);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)1, (int)810123592);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)1, (int)-576690593);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)1, (int)2033382145);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)1, (int)1012012773);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)1, (int)-786885497);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)1, (int)601363673);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)1, (int)998339445);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-52445556);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)1, (int)1402600680);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-903556876);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)1, (int)1907504506);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)1, (int)1631313019);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)1, (int)-592498032);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)1, (int)-3656297);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)1, (int)1371921981);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1157790512);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)1, (int)1775477823);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1430247905);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-475308570);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1839067692);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)1, (int)-85656603);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)1, (int)-265717410);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)1, (int)-661104555);
        double[] htrpi_warnHi = TestHelper.generateDoubleArray((int)1, (int)1660116134);
        double[] htrpi_warnLo = TestHelper.generateDoubleArray((int)1, (int)754817146);
        double[] htrpi_limitHi = TestHelper.generateDoubleArray((int)1, (int)552849637);
        double[] htrpi_limitLo = TestHelper.generateDoubleArray((int)1, (int)1370678541);
        double[] htrpv_warnHi = TestHelper.generateDoubleArray((int)1, (int)1093916698);
        double[] htrpv_warnLo = TestHelper.generateDoubleArray((int)1, (int)-485240562);
        double[] htrpv_limitHi = TestHelper.generateDoubleArray((int)1, (int)-899342202);
        double[] htrpv_limitLo = TestHelper.generateDoubleArray((int)1, (int)2038618736);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)1, (int)1700537822);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)1, (int)1709298975);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)1, (int)1154460180);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-665839572);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)1, (int)156571102);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)1, (int)687521322);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)1, (int)398815596);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1544125195);
        String location = "a";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)1, (int)-2042598215);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)1, (int)-15748236);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)1, (int)-631695468);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1486300823);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1360595726);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)1, (int)1692230270);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)1, (int)1994848862);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1431277483);
        double[] pclk0_warnHi = TestHelper.generateDoubleArray((int)1, (int)-922207577);
        double[] pclk0_warnLo = TestHelper.generateDoubleArray((int)1, (int)241126537);
        double[] pclk0_limitHi = TestHelper.generateDoubleArray((int)1, (int)-706872300);
        double[] pclk0_limitLo = TestHelper.generateDoubleArray((int)1, (int)962916754);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)1, (int)241484541);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)1, (int)1420950107);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)1, (int)1434039671);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)1, (int)856015890);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)1, (int)9646327);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)1, (int)1283165443);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)1, (int)931830043);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)1, (int)-164852610);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1626218762);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1727614195);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)1, (int)-533917039);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)1, (int)-2018523250);
        double[] rg0_warnHi = TestHelper.generateDoubleArray((int)1, (int)1159335042);
        double[] rg0_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1023722256);
        double[] rg0_limitHi = TestHelper.generateDoubleArray((int)1, (int)179368904);
        double[] rg0_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1784400485);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1135500214);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)1, (int)-374930229);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)1, (int)2009060528);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)1, (int)2060512113);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)1, (int)1472519785);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)1, (int)364977488);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)1, (int)1737967903);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)1, (int)-65856406);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)1, (int)-513719574);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1531151360);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1860824840);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)1, (int)-345247305);
        double[] sclk0_warnHi = TestHelper.generateDoubleArray((int)1, (int)-809512818);
        double[] sclk0_warnLo = TestHelper.generateDoubleArray((int)1, (int)-2090954088);
        double[] sclk0_limitHi = TestHelper.generateDoubleArray((int)1, (int)1890166409);
        double[] sclk0_limitLo = TestHelper.generateDoubleArray((int)1, (int)759431936);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1566290996);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)1, (int)1084328907);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1558458571);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1592441808);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1233913320);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)1, (int)1580277552);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)1, (int)1310069330);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)1, (int)275086473);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)1, (int)709250408);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)1, (int)-716427139);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)1, (int)1160460884);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1022846210);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)1, (int)760628211);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)1, (int)751087093);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)1, (int)-191544278);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)1, (int)2135129025);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)1, (int)-943488965);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)1, (int)175792671);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)1, (int)349724904);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)1, (int)886895385);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)1, (int)-738304691);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)1, (int)658812088);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1704858203);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)1, (int)347353465);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1037401273);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)1, (int)1930057449);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)1, (int)876905894);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)1, (int)1884345550);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)1, (int)158842907);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)1, (int)-150604100);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)1, (int)1537249979);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)1, (int)257047320);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsSettingsAppliedEvent(priority, version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrpi_warnHi, htrpi_warnLo, htrpi_limitHi, htrpi_limitLo, htrpv_warnHi, htrpv_warnLo, htrpv_limitHi, htrpv_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclk0_warnHi, pclk0_warnLo, pclk0_limitHi, pclk0_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rg0_warnHi, rg0_warnLo, rg0_limitHi, rg0_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, sclk0_warnHi, sclk0_warnLo, sclk0_limitHi, sclk0_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsSettingsAppliedEvent));
        Focal_plane_Reb_LimitsSettingsAppliedEvent item_ = (Focal_plane_Reb_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnHi, (double[])item_.getHtrpi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnLo, (double[])item_.getHtrpi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitHi, (double[])item_.getHtrpi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitLo, (double[])item_.getHtrpi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnHi, (double[])item_.getHtrpv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnLo, (double[])item_.getHtrpv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitHi, (double[])item_.getHtrpv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitLo, (double[])item_.getHtrpv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnHi, (double[])item_.getPclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnLo, (double[])item_.getPclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitHi, (double[])item_.getPclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitLo, (double[])item_.getPclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnHi, (double[])item_.getRg0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnLo, (double[])item_.getRg0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitHi, (double[])item_.getRg0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitLo, (double[])item_.getRg0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnHi, (double[])item_.getSclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnLo, (double[])item_.getSclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitHi, (double[])item_.getSclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitLo, (double[])item_.getSclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsSettingsAppliedEvent() throws Exception {
        int priority = 720;
        int version = 414;
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)1, (int)1952120809);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)1, (int)686352956);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)1, (int)-805386862);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)1, (int)1953730364);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)1, (int)-1246105016);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)1, (int)1725833495);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)1, (int)1899385250);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)1, (int)1245567209);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)1, (int)-2003194834);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)1, (int)593159638);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)1, (int)245090990);
        boolean[] disableRTDHardwareCheck = new boolean[]{true};
        String location = "";
        long[] serialNum = TestHelper.generateLongArray((int)1, (int)-471784060);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsSettingsAppliedEvent(priority, version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsSettingsAppliedEvent));
        Focal_plane_Reb_RaftsSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsSettingsAppliedEvent() throws Exception {
        int priority = 515;
        int version = 908;
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)1, (int)-196678503);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)1, (int)805222628);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)1, (int)676226222);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)1, (int)826183506);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)1, (int)-1182440019);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)1, (int)-1570020736);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)1, (int)702258641);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)1, (int)-2055253150);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)1, (int)-1154008721);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)1, (int)616569345);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)1, (int)1689953685);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)1, (int)86160285);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)1, (int)314026545);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)1, (int)-368625471);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)1, (int)-779718122);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)1, (int)76305799);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)1, (int)1115963802);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)1, (int)139090846);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)1, (int)1921675435);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)1, (int)-294796082);
        String location = "o";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent(priority, version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent));
        Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerSettingsAppliedEvent() throws Exception {
        int priority = 551;
        int version = 876;
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)1, (int)936876840);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)1, (int)1567134334);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)1, (int)1609883387);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)1, (int)-686363807);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)1, (int)-271483271);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)1, (int)1547328460);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)1, (int)-193817994);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)1, (int)-658836001);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)1, (int)-936705076);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)1, (int)-1563161544);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)1, (int)-1038240813);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)1, (int)-1417484602);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)1, (int)393278912);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)1, (int)-745861786);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)1, (int)-1815806383);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)1, (int)1787757971);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)1, (int)-383766180);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)1, (int)-1460988487);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)1, (int)1748951366);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)1, (int)373061603);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)1, (int)-1317062028);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)1, (int)-1998835997);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)1, (int)-1410120414);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)1, (int)-226509787);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)1, (int)-95276463);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)1, (int)1409946047);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)1, (int)-473031507);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)1, (int)559913871);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)1, (int)1132795024);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)1, (int)-616240291);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)1, (int)-1628223853);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)1, (int)-2032613547);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)1, (int)-1908253110);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)1, (int)-1082073250);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)1, (int)1662026530);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)1, (int)-1824418536);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)1, (int)2007663477);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)1, (int)-1785013374);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)1, (int)565346897);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)1, (int)113807004);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)1, (int)-1128081783);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)1, (int)2053017727);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)1, (int)-674345469);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)1, (int)1126156478);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)1, (int)-1317484954);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)1, (int)1857201172);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)1, (int)67146893);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)1, (int)-1424869980);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)1, (int)-83847564);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)1, (int)-997363620);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)1, (int)672700277);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)1, (int)-1310759371);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)1, (int)2024076555);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)1, (int)480633959);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)1, (int)396149372);
        String location = "";
        double[] maxDelta = TestHelper.generateDoubleArray((int)1, (int)395252757);
        double[] maxStep = TestHelper.generateDoubleArray((int)1, (int)1207523846);
        double[] minTol = TestHelper.generateDoubleArray((int)1, (int)861089503);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)1, (int)-366484697);
        double[] odiAmin = TestHelper.generateDoubleArray((int)1, (int)-1671092238);
        double[] odiQmax = TestHelper.generateDoubleArray((int)1, (int)947418342);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerSettingsAppliedEvent(priority, version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerSettingsAppliedEvent));
        Focal_plane_Reb_RaftsPowerSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsPowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersSettingsAppliedEvent() throws Exception {
        int priority = 412;
        int version = 610;
        String location = "p";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-906723990);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)174212528);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)1192201);
        long[] periodictasks_monitor_publish_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1061751410);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1702785442);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1962030729);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1064486697);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1669481184);
        long[] periodictasks_monitor_update_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)1387100808);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-496550176);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)1, (int)-1743264730);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersSettingsAppliedEvent(priority, version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_crVolt_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_crVolt_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersSettingsAppliedEvent));
        Focal_plane_Reb_timersSettingsAppliedEvent item_ = (Focal_plane_Reb_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQSettingsAppliedEvent() throws Exception {
        int priority = 288;
        int version = 935;
        String daqFolder = "";
        String daqPartition = "";
        boolean emulatedDAQ = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQSettingsAppliedEvent(priority, version, daqFolder, daqPartition, emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQSettingsAppliedEvent));
        Focal_plane_SequencerConfig_DAQSettingsAppliedEvent item_ = (Focal_plane_SequencerConfig_DAQSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerSettingsAppliedEvent() throws Exception {
        int priority = 757;
        int version = 270;
        String clearCountParameter = "";
        String clearMain = "";
        String idleFlushMain = "g";
        long idleFlushTimeout = 663L;
        String integrateMain = "";
        String metaDataRegisters = "l";
        int overCols = 321;
        int overRows = 888;
        int postCols = 515;
        int postRows = 768;
        int preCols = 714;
        int preRows = 396;
        String pseudoReadMain = "";
        int readCols = 680;
        int readCols2 = 255;
        String readMain = "";
        int readRows = 635;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "k";
        boolean scanMode = true;
        String sequencer = "g";
        String sequencerChecksums = "";
        String shiftCountParameter = "c";
        boolean stepAfterIntegrate = false;
        int transparentMode = 692;
        int underCols = 630;
        boolean useParallelRegisters = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent(priority, version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent));
        Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent item_ = (Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent() throws Exception {
        int priority = 116;
        int version = 305;
        String webHooks = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent(priority, version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent));
        Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent item_ = (Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 907;
        int version = 203;
        int schedulers_default_nTasks = 345;
        int schedulers_default_nThreads = 934;
        int schedulers_monitor_update_publish_scheduler_nTasks = 444;
        int schedulers_monitor_update_publish_scheduler_nThreads = 484;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasksSettingsAppliedEvent));
        Daq_monitor_PeriodicTasksSettingsAppliedEvent item_ = (Daq_monitor_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 523;
        int version = 472;
        long agentmonitorservice_taskPeriodMillis = 966L;
        long heartbeat_taskPeriodMillis = 449L;
        long monitor_check_taskPeriodMillis = 177L;
        long monitor_publish_taskPeriodMillis = 97L;
        long monitor_update_taskPeriodMillis = 638L;
        long publishstats_taskPeriodMillis = 218L;
        long purgedaq_taskPeriodMillis = 945L;
        long runtimeinfo_taskPeriodMillis = 75L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent));
        Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent item_ = (Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsSettingsAppliedEvent() throws Exception {
        int priority = 796;
        int version = 601;
        int minDiffAlertWarning = 751;
        int minDiffLogWarning = 507;
        String sumDriverChecks = "m";
        String sumDriverStats = "w";
        String sumFirmwareChecks = "";
        String sumFirmwareStats = "";
        String sumRdsChecks = "";
        String sumRdsStats = "e";
        String sumRmsChecks = "p";
        String sumRmsStats = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsSettingsAppliedEvent(priority, version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsSettingsAppliedEvent));
        Daq_monitor_Stats_StatisticsSettingsAppliedEvent item_ = (Daq_monitor_Stats_StatisticsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_buildSettingsAppliedEvent() throws Exception {
        int priority = 514;
        int version = 16;
        boolean enablePeriodicPublication = false;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_buildSettingsAppliedEvent(priority, version, enablePeriodicPublication));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_buildSettingsAppliedEvent));
        Daq_monitor_Stats_buildSettingsAppliedEvent item_ = (Daq_monitor_Stats_buildSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)enablePeriodicPublication, (Object)item_.isEnablePeriodicPublication());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreSettingsAppliedEvent() throws Exception {
        int priority = 924;
        int version = 255;
        String daqPartition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreSettingsAppliedEvent(priority, version, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreSettingsAppliedEvent));
        Daq_monitor_StoreSettingsAppliedEvent item_ = (Daq_monitor_StoreSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 256;
        int version = 541;
        double capacity_warnHi = 0.6334140300750732;
        double capacity_warnLo = 0.6464796662330627;
        double capacity_limitHi = 0.5712229609489441;
        double capacity_limitLo = 0.8883883357048035;
        double freefraction_warnHi = 0.010107755661010742;
        double freefraction_warnLo = 0.4159959554672241;
        double freefraction_limitHi = 0.18105238676071167;
        double freefraction_limitLo = 0.5045515298843384;
        double freespace_warnHi = 0.002496778964996338;
        double freespace_warnLo = 0.3206069f;
        double freespace_limitHi = 0.5314055681228638;
        double freespace_limitLo = 0.7548640966415405;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsSettingsAppliedEvent(priority, version, capacity_warnHi, capacity_warnLo, capacity_limitHi, capacity_limitLo, freefraction_warnHi, freefraction_warnLo, freefraction_limitHi, freefraction_limitLo, freespace_warnHi, freespace_warnLo, freespace_limitHi, freespace_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsSettingsAppliedEvent));
        Daq_monitor_Store_LimitsSettingsAppliedEvent item_ = (Daq_monitor_Store_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)capacity_warnHi, (double)item_.getCapacity_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_warnLo, (double)item_.getCapacity_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitHi, (double)item_.getCapacity_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitLo, (double)item_.getCapacity_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnHi, (double)item_.getFreefraction_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitHi, (double)item_.getFreefraction_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnHi, (double)item_.getFreespace_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnLo, (double)item_.getFreespace_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitHi, (double)item_.getFreespace_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitLo, (double)item_.getFreespace_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreSettingsAppliedEvent() throws Exception {
        int priority = 762;
        int version = 705;
        String daqFolder = "";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.5899285674095154;
        double purgeThreshold = 0.3633301258087158;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreSettingsAppliedEvent(priority, version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreSettingsAppliedEvent));
        Daq_monitor_Store_StoreSettingsAppliedEvent item_ = (Daq_monitor_Store_StoreSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_AgentMonitorService_timersSettingsAppliedEvent() throws Exception {
        int priority = 15;
        int version = 712;
        long taskPeriodMillis = 67L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_AgentMonitorService_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_AgentMonitorService_timersSettingsAppliedEvent));
        Ats_power_AgentMonitorService_timersSettingsAppliedEvent item_ = (Ats_power_AgentMonitorService_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_Analog_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 521;
        int version = 647;
        double warnHi = 0.5910294055938721;
        double warnLo = 0.4891449213027954;
        double limitHi = 0.8036074638366699;
        double limitLo = 0.8256937861442566;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Analog_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Analog_I_LimitsSettingsAppliedEvent));
        Ats_power_Analog_I_LimitsSettingsAppliedEvent item_ = (Ats_power_Analog_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Analog_PowerSettingsAppliedEvent() throws Exception {
        int priority = 822;
        int version = 293;
        double current = 0.7150382399559021;
        double offDelay = 0.9880751371383667;
        double onDelay = 0.0881474f;
        double voltage = 0.5174156427383423;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Analog_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Analog_PowerSettingsAppliedEvent));
        Ats_power_Analog_PowerSettingsAppliedEvent item_ = (Ats_power_Analog_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Analog_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 483;
        int version = 137;
        double warnHi = 0.2364257f;
        double warnLo = 0.06057637929916382;
        double limitHi = 0.2795097231864929;
        double limitLo = 0.6227433681488037;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Analog_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Analog_V_LimitsSettingsAppliedEvent));
        Ats_power_Analog_V_LimitsSettingsAppliedEvent item_ = (Ats_power_Analog_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Aux_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 670;
        int version = 384;
        double warnHi = 0.22366827726364136;
        double warnLo = 0.8872032761573792;
        double limitHi = 0.3791808f;
        double limitLo = 0.8549120426177979;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Aux_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Aux_I_LimitsSettingsAppliedEvent));
        Ats_power_Aux_I_LimitsSettingsAppliedEvent item_ = (Ats_power_Aux_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Aux_PowerSettingsAppliedEvent() throws Exception {
        int priority = 566;
        int version = 251;
        double current = 0.8218094706535339;
        double offDelay = 0.8981080651283264;
        double onDelay = 0.6200982928276062;
        double voltage = 0.841245710849762;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Aux_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Aux_PowerSettingsAppliedEvent));
        Ats_power_Aux_PowerSettingsAppliedEvent item_ = (Ats_power_Aux_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Aux_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 269;
        int version = 358;
        double warnHi = 0.11076831817626953;
        double warnLo = 0.0362359881401062;
        double limitHi = 0.2166774868965149;
        double limitLo = 0.5074688792228699;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Aux_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Aux_V_LimitsSettingsAppliedEvent));
        Ats_power_Aux_V_LimitsSettingsAppliedEvent item_ = (Ats_power_Aux_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkHigh_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 984;
        int version = 664;
        double warnHi = 0.19328314065933228;
        double warnLo = 0.6300828456878662;
        double limitHi = 0.84812f;
        double limitLo = 0.3188076615333557;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkHigh_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkHigh_I_LimitsSettingsAppliedEvent));
        Ats_power_ClkHigh_I_LimitsSettingsAppliedEvent item_ = (Ats_power_ClkHigh_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkHigh_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 162;
        int version = 785;
        double warnHi = 0.284894f;
        double warnLo = 0.5752735137939453;
        double limitHi = 0.2993737459182739;
        double limitLo = 0.9198556542396545;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkHigh_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkHigh_V_LimitsSettingsAppliedEvent));
        Ats_power_ClkHigh_V_LimitsSettingsAppliedEvent item_ = (Ats_power_ClkHigh_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkLow_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 190;
        int version = 971;
        double warnHi = 0.2468610405921936;
        double warnLo = 0.7000638246536255;
        double limitHi = 0.445568323135376;
        double limitLo = 0.18660366535186768;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkLow_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkLow_I_LimitsSettingsAppliedEvent));
        Ats_power_ClkLow_I_LimitsSettingsAppliedEvent item_ = (Ats_power_ClkLow_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClkLow_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 291;
        int version = 638;
        double warnHi = 0.7526744604110718;
        double warnLo = 0.791869044303894;
        double limitHi = 0.3327948f;
        double limitLo = 0.1259095f;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClkLow_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClkLow_V_LimitsSettingsAppliedEvent));
        Ats_power_ClkLow_V_LimitsSettingsAppliedEvent item_ = (Ats_power_ClkLow_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClockHigh_PowerSettingsAppliedEvent() throws Exception {
        int priority = 186;
        int version = 947;
        double current = 0.33841103315353394;
        double offDelay = 0.7800118327140808;
        double onDelay = 0.6705657839775085;
        double voltage = 0.6142090559005737;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClockHigh_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClockHigh_PowerSettingsAppliedEvent));
        Ats_power_ClockHigh_PowerSettingsAppliedEvent item_ = (Ats_power_ClockHigh_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_ClockLow_PowerSettingsAppliedEvent() throws Exception {
        int priority = 881;
        int version = 910;
        double current = 0.8272294402122498;
        double offDelay = 0.3811434f;
        double onDelay = 0.7041372656822205;
        double voltage = 0.5663792490959167;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_ClockLow_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_ClockLow_PowerSettingsAppliedEvent));
        Ats_power_ClockLow_PowerSettingsAppliedEvent item_ = (Ats_power_ClockLow_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_DPHI_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 202;
        int version = 216;
        double warnHi = 0.6497701406478882;
        double warnLo = 0.3321990370750427;
        double limitHi = 0.546629011631012;
        double limitLo = 0.03093355894088745;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_DPHI_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_DPHI_I_LimitsSettingsAppliedEvent));
        Ats_power_DPHI_I_LimitsSettingsAppliedEvent item_ = (Ats_power_DPHI_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_DPHI_PowerSettingsAppliedEvent() throws Exception {
        int priority = 848;
        int version = 356;
        double current = 0.19247084856033325;
        double offDelay = 0.6888233423233032;
        double onDelay = 0.8093852400779724;
        double voltage = 0.7401184439659119;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_DPHI_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_DPHI_PowerSettingsAppliedEvent));
        Ats_power_DPHI_PowerSettingsAppliedEvent item_ = (Ats_power_DPHI_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_DPHI_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 560;
        int version = 485;
        double warnHi = 0.5324458479881287;
        double warnLo = 0.6846141219139099;
        double limitHi = 0.08638501167297363;
        double limitLo = 0.3942340612411499;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_DPHI_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_DPHI_V_LimitsSettingsAppliedEvent));
        Ats_power_DPHI_V_LimitsSettingsAppliedEvent item_ = (Ats_power_DPHI_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Digital_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 58;
        int version = 201;
        double warnHi = 0.6553415060043335;
        double warnLo = 0.6646828651428223;
        double limitHi = 0.9512182474136353;
        double limitLo = 0.9245601296424866;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Digital_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Digital_I_LimitsSettingsAppliedEvent));
        Ats_power_Digital_I_LimitsSettingsAppliedEvent item_ = (Ats_power_Digital_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Digital_PowerSettingsAppliedEvent() throws Exception {
        int priority = 498;
        int version = 398;
        double current = 0.13100403547286987;
        double offDelay = 0.5621614456176758;
        double onDelay = 0.348626971244812;
        double voltage = 0.2438182234764099;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Digital_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Digital_PowerSettingsAppliedEvent));
        Ats_power_Digital_PowerSettingsAppliedEvent item_ = (Ats_power_Digital_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Digital_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 135;
        int version = 859;
        double warnHi = 0.5860308408737183;
        double warnLo = 0.6875885128974915;
        double limitHi = 0.41382116079330444;
        double limitLo = 0.06423187255859375;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Digital_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Digital_V_LimitsSettingsAppliedEvent));
        Ats_power_Digital_V_LimitsSettingsAppliedEvent item_ = (Ats_power_Digital_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Fan_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 711;
        int version = 529;
        double warnHi = 0.4826417565345764;
        double warnLo = 0.6439829468727112;
        double limitHi = 0.497566282749176;
        double limitLo = 0.9668222069740295;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Fan_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Fan_I_LimitsSettingsAppliedEvent));
        Ats_power_Fan_I_LimitsSettingsAppliedEvent item_ = (Ats_power_Fan_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Fan_PowerSettingsAppliedEvent() throws Exception {
        int priority = 619;
        int version = 931;
        double current = 0.2932351231575012;
        double offDelay = 0.37873637676239014;
        double onDelay = 0.6512604355812073;
        double voltage = 0.03273433446884155;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Fan_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Fan_PowerSettingsAppliedEvent));
        Ats_power_Fan_PowerSettingsAppliedEvent item_ = (Ats_power_Fan_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Fan_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 611;
        int version = 786;
        double warnHi = 0.0055582523345947266;
        double warnLo = 0.5685842633247375;
        double limitHi = 0.4770635962486267;
        double limitLo = 0.5543696880340576;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Fan_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Fan_V_LimitsSettingsAppliedEvent));
        Ats_power_Fan_V_LimitsSettingsAppliedEvent item_ = (Ats_power_Fan_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_HVBias_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 523;
        int version = 413;
        double warnHi = 0.4515455961227417;
        double warnLo = 0.786760687828064;
        double limitHi = 0.11390924453735352;
        double limitLo = 0.27820414304733276;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_HVBias_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_HVBias_I_LimitsSettingsAppliedEvent));
        Ats_power_HVBias_I_LimitsSettingsAppliedEvent item_ = (Ats_power_HVBias_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_HVBias_PowerSettingsAppliedEvent() throws Exception {
        int priority = 545;
        int version = 71;
        double current = 0.01894927f;
        double offDelay = 0.3528527021408081;
        double onDelay = 0.9307073354721069;
        double voltage = 0.974181592464447;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_HVBias_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_HVBias_PowerSettingsAppliedEvent));
        Ats_power_HVBias_PowerSettingsAppliedEvent item_ = (Ats_power_HVBias_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_HVBias_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 934;
        int version = 434;
        double warnHi = 0.844366192817688;
        double warnLo = 0.6191104650497437;
        double limitHi = 0.18111753463745117;
        double limitLo = 0.6157971620559692;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_HVBias_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_HVBias_V_LimitsSettingsAppliedEvent));
        Ats_power_HVBias_V_LimitsSettingsAppliedEvent item_ = (Ats_power_HVBias_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Hameg1_PowerSettingsAppliedEvent() throws Exception {
        int priority = 971;
        int version = 43;
        String connType = "";
        String devcId = "";
        int devcParm = 678;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg1_PowerSettingsAppliedEvent(priority, version, connType, devcId, devcParm));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg1_PowerSettingsAppliedEvent));
        Ats_power_Hameg1_PowerSettingsAppliedEvent item_ = (Ats_power_Hameg1_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
    }

    @Test
    public void sendReceiveAts_power_Hameg2_PowerSettingsAppliedEvent() throws Exception {
        int priority = 128;
        int version = 596;
        String connType = "z";
        String devcId = "";
        int devcParm = 309;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg2_PowerSettingsAppliedEvent(priority, version, connType, devcId, devcParm));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg2_PowerSettingsAppliedEvent));
        Ats_power_Hameg2_PowerSettingsAppliedEvent item_ = (Ats_power_Hameg2_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
    }

    @Test
    public void sendReceiveAts_power_Hameg3_PowerSettingsAppliedEvent() throws Exception {
        int priority = 439;
        int version = 528;
        String connType = "";
        String devcId = "f";
        int devcParm = 261;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Hameg3_PowerSettingsAppliedEvent(priority, version, connType, devcId, devcParm));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Hameg3_PowerSettingsAppliedEvent));
        Ats_power_Hameg3_PowerSettingsAppliedEvent item_ = (Ats_power_Hameg3_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
    }

    @Test
    public void sendReceiveAts_power_Heartbeat_timersSettingsAppliedEvent() throws Exception {
        int priority = 517;
        int version = 78;
        long taskPeriodMillis = 300L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Heartbeat_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Heartbeat_timersSettingsAppliedEvent));
        Ats_power_Heartbeat_timersSettingsAppliedEvent item_ = (Ats_power_Heartbeat_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_Keithley_PowerSettingsAppliedEvent() throws Exception {
        int priority = 316;
        int version = 732;
        String connType = "s";
        String devcId = "o";
        int devcParm = 435;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Keithley_PowerSettingsAppliedEvent(priority, version, connType, devcId, devcParm));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Keithley_PowerSettingsAppliedEvent));
        Ats_power_Keithley_PowerSettingsAppliedEvent item_ = (Ats_power_Keithley_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)connType, (Object)item_.getConnType());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((long)devcParm, (long)item_.getDevcParm());
    }

    @Test
    public void sendReceiveAts_power_Monitor_check_timersSettingsAppliedEvent() throws Exception {
        int priority = 996;
        int version = 254;
        long taskPeriodMillis = 336L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Monitor_check_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Monitor_check_timersSettingsAppliedEvent));
        Ats_power_Monitor_check_timersSettingsAppliedEvent item_ = (Ats_power_Monitor_check_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_Monitor_publish_timersSettingsAppliedEvent() throws Exception {
        int priority = 114;
        int version = 390;
        long taskPeriodMillis = 421L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Monitor_publish_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Monitor_publish_timersSettingsAppliedEvent));
        Ats_power_Monitor_publish_timersSettingsAppliedEvent item_ = (Ats_power_Monitor_publish_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_Monitor_update_timersSettingsAppliedEvent() throws Exception {
        int priority = 563;
        int version = 463;
        long taskPeriodMillis = 219L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Monitor_update_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Monitor_update_timersSettingsAppliedEvent));
        Ats_power_Monitor_update_timersSettingsAppliedEvent item_ = (Ats_power_Monitor_update_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_OD_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 25;
        int version = 248;
        double warnHi = 0.482200026512146;
        double warnLo = 0.2835758328437805;
        double limitHi = 0.8459919691085815;
        double limitLo = 0.2846637964248657;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OD_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OD_I_LimitsSettingsAppliedEvent));
        Ats_power_OD_I_LimitsSettingsAppliedEvent item_ = (Ats_power_OD_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OD_PowerSettingsAppliedEvent() throws Exception {
        int priority = 529;
        int version = 977;
        double current = 0.29583287239074707;
        double offDelay = 0.25458717346191406;
        double onDelay = 0.2159196138381958;
        double voltage = 0.07165837287902832;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OD_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OD_PowerSettingsAppliedEvent));
        Ats_power_OD_PowerSettingsAppliedEvent item_ = (Ats_power_OD_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OD_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 561;
        int version = 178;
        double warnHi = 0.7609010338783264;
        double warnLo = 0.2154766321182251;
        double limitHi = 0.4796936511993408;
        double limitLo = 0.380581796169281;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OD_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OD_V_LimitsSettingsAppliedEvent));
        Ats_power_OD_V_LimitsSettingsAppliedEvent item_ = (Ats_power_OD_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OTM_I_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 367;
        int version = 262;
        double warnHi = 0.4119594097137451;
        double warnLo = 0.2212618f;
        double limitHi = 0.7315186858177185;
        double limitLo = 0.02538210153579712;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OTM_I_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OTM_I_LimitsSettingsAppliedEvent));
        Ats_power_OTM_I_LimitsSettingsAppliedEvent item_ = (Ats_power_OTM_I_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OTM_PowerSettingsAppliedEvent() throws Exception {
        int priority = 84;
        int version = 451;
        double current = 0.05298245f;
        double offDelay = 0.17073094844818115;
        double onDelay = 0.08198577165603638;
        double voltage = 0.10556250810623169;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OTM_PowerSettingsAppliedEvent(priority, version, current, offDelay, onDelay, voltage));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OTM_PowerSettingsAppliedEvent));
        Ats_power_OTM_PowerSettingsAppliedEvent item_ = (Ats_power_OTM_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)offDelay, (double)item_.getOffDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)onDelay, (double)item_.getOnDelay(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_OTM_V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 662;
        int version = 750;
        double warnHi = 0.4622097f;
        double warnLo = 0.021161377429962158;
        double limitHi = 0.5130382180213928;
        double limitLo = 0.7473477721214294;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_OTM_V_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_power_OTM_V_LimitsSettingsAppliedEvent));
        Ats_power_OTM_V_LimitsSettingsAppliedEvent item_ = (Ats_power_OTM_V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_power_Power_state_timersSettingsAppliedEvent() throws Exception {
        int priority = 989;
        int version = 81;
        long taskPeriodMillis = 688L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_Power_state_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_Power_state_timersSettingsAppliedEvent));
        Ats_power_Power_state_timersSettingsAppliedEvent item_ = (Ats_power_Power_state_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_RuntimeInfo_timersSettingsAppliedEvent() throws Exception {
        int priority = 637;
        int version = 713;
        long taskPeriodMillis = 453L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_RuntimeInfo_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_power_RuntimeInfo_timersSettingsAppliedEvent));
        Ats_power_RuntimeInfo_timersSettingsAppliedEvent item_ = (Ats_power_RuntimeInfo_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_power_SchedulersSettingsAppliedEvent() throws Exception {
        int priority = 79;
        int version = 908;
        int default_nTasks = 18;
        int default_nThreads = 346;
        int monitor_update_publish_scheduler_nTasks = 640;
        int monitor_update_publish_scheduler_nThreads = 571;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_power_SchedulersSettingsAppliedEvent(priority, version, default_nTasks, default_nThreads, monitor_update_publish_scheduler_nTasks, monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Ats_power_SchedulersSettingsAppliedEvent));
        Ats_power_SchedulersSettingsAppliedEvent item_ = (Ats_power_SchedulersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)default_nTasks, (long)item_.getDefault_nTasks());
        Assert.assertEquals((long)default_nThreads, (long)item_.getDefault_nThreads());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nTasks, (long)item_.getMonitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nThreads, (long)item_.getMonitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveAts_AgentMonitorService_timersSettingsAppliedEvent() throws Exception {
        int priority = 770;
        int version = 362;
        long taskPeriodMillis = 816L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_AgentMonitorService_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_AgentMonitorService_timersSettingsAppliedEvent));
        Ats_AgentMonitorService_timersSettingsAppliedEvent item_ = (Ats_AgentMonitorService_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_CryoCon_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 963;
        int version = 373;
        String host = "q";
        SALEvent item = this.testSendReceive((SALEvent)new Ats_CryoCon_DeviceSettingsAppliedEvent(priority, version, host));
        Assert.assertTrue((boolean)(item instanceof Ats_CryoCon_DeviceSettingsAppliedEvent));
        Ats_CryoCon_DeviceSettingsAppliedEvent item_ = (Ats_CryoCon_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)host, (Object)item_.getHost());
    }

    @Test
    public void sendReceiveAts_Heartbeat_timersSettingsAppliedEvent() throws Exception {
        int priority = 533;
        int version = 39;
        long taskPeriodMillis = 690L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Heartbeat_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_Heartbeat_timersSettingsAppliedEvent));
        Ats_Heartbeat_timersSettingsAppliedEvent item_ = (Ats_Heartbeat_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_Monitor_check_timersSettingsAppliedEvent() throws Exception {
        int priority = 798;
        int version = 312;
        long taskPeriodMillis = 332L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Monitor_check_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_Monitor_check_timersSettingsAppliedEvent));
        Ats_Monitor_check_timersSettingsAppliedEvent item_ = (Ats_Monitor_check_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_Monitor_publish_timersSettingsAppliedEvent() throws Exception {
        int priority = 581;
        int version = 351;
        long taskPeriodMillis = 821L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Monitor_publish_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_Monitor_publish_timersSettingsAppliedEvent));
        Ats_Monitor_publish_timersSettingsAppliedEvent item_ = (Ats_Monitor_publish_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_Monitor_update_timersSettingsAppliedEvent() throws Exception {
        int priority = 59;
        int version = 764;
        long taskPeriodMillis = 954L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Monitor_update_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_Monitor_update_timersSettingsAppliedEvent));
        Ats_Monitor_update_timersSettingsAppliedEvent item_ = (Ats_Monitor_update_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_RuntimeInfo_timersSettingsAppliedEvent() throws Exception {
        int priority = 799;
        int version = 664;
        long taskPeriodMillis = 533L;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_RuntimeInfo_timersSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Ats_RuntimeInfo_timersSettingsAppliedEvent));
        Ats_RuntimeInfo_timersSettingsAppliedEvent item_ = (Ats_RuntimeInfo_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveAts_SchedulersSettingsAppliedEvent() throws Exception {
        int priority = 391;
        int version = 671;
        int default_nTasks = 676;
        int default_nThreads = 440;
        int monitor_update_publish_scheduler_nTasks = 478;
        int monitor_update_publish_scheduler_nThreads = 3;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_SchedulersSettingsAppliedEvent(priority, version, default_nTasks, default_nThreads, monitor_update_publish_scheduler_nTasks, monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Ats_SchedulersSettingsAppliedEvent));
        Ats_SchedulersSettingsAppliedEvent item_ = (Ats_SchedulersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)default_nTasks, (long)item_.getDefault_nTasks());
        Assert.assertEquals((long)default_nThreads, (long)item_.getDefault_nThreads());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nTasks, (long)item_.getMonitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nThreads, (long)item_.getMonitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveAts_TempCCDSetPoint_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 340;
        int version = 962;
        double warnHi = 0.3754054307937622;
        double warnLo = 0.2668830156326294;
        double limitHi = 0.29815244674682617;
        double limitLo = 0.3598290681838989;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempCCDSetPoint_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempCCDSetPoint_LimitsSettingsAppliedEvent));
        Ats_TempCCDSetPoint_LimitsSettingsAppliedEvent item_ = (Ats_TempCCDSetPoint_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_TempCCD_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 333;
        int version = 427;
        double warnHi = 0.08714598417282104;
        double warnLo = 0.6992331743240356;
        double limitHi = 0.4956783652305603;
        double limitLo = 0.5278825759887695;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempCCD_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempCCD_LimitsSettingsAppliedEvent));
        Ats_TempCCD_LimitsSettingsAppliedEvent item_ = (Ats_TempCCD_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_TempColdPlate_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 553;
        int version = 355;
        double warnHi = 0.564589f;
        double warnLo = 0.9360262751579285;
        double limitHi = 0.9758511185646057;
        double limitLo = 0.6161421537399292;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempColdPlate_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempColdPlate_LimitsSettingsAppliedEvent));
        Ats_TempColdPlate_LimitsSettingsAppliedEvent item_ = (Ats_TempColdPlate_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_TempCryoHead_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 679;
        int version = 846;
        double warnHi = 0.7242476940155029;
        double warnLo = 0.674912691116333;
        double limitHi = 0.16533923149108887;
        double limitLo = 0.2855575f;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_TempCryoHead_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_TempCryoHead_LimitsSettingsAppliedEvent));
        Ats_TempCryoHead_LimitsSettingsAppliedEvent item_ = (Ats_TempCryoHead_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAts_Vacuum_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 874;
        int version = 956;
        double warnHi = 0.5070011615753174;
        double warnLo = 0.40193772315979004;
        double limitHi = 0.3482709527015686;
        double limitLo = 0.90446937084198;
        SALEvent item = this.testSendReceive((SALEvent)new Ats_Vacuum_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Ats_Vacuum_LimitsSettingsAppliedEvent));
        Ats_Vacuum_LimitsSettingsAppliedEvent item_ = (Ats_Vacuum_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 694;
        int version = 337;
        int schedulers_default_nTasks = 178;
        int schedulers_default_nThreads = 261;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasksSettingsAppliedEvent));
        Bonn_shutter_PeriodicTasksSettingsAppliedEvent item_ = (Bonn_shutter_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 133;
        int version = 237;
        long agentmonitorservice_taskPeriodMillis = 380L;
        long heartbeat_taskPeriodMillis = 289L;
        long runtimeinfo_taskPeriodMillis = 625L;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent));
        Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent item_ = (Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveShutterBladeMotionProfileEvent() throws Exception {
        int priority = 74;
        ShutterBladeMotionProfileEvent.Blade blade = ShutterBladeMotionProfileEvent.Blade.MINUS_X;
        ShutterBladeMotionProfileEvent.Direction direction = ShutterBladeMotionProfileEvent.Direction.OPEN;
        double timestampStart = 0.08200287818908691;
        double startPosition = 0.8293628096580505;
        double targetDuration = 0.8970068693161011;
        double targetPosition = 0.2322337031364441;
        double endPosition = 0.659993f;
        double actualDuration = 0.9325717687606812;
        int hallSensorCount = 813;
        double[] timestampHallSensor = TestHelper.generateDoubleArray((int)240, (int)795456169);
        int[] hallSensorID = TestHelper.generateIntArray((int)240, (int)1545754438);
        double[] hallSensorPosition = TestHelper.generateDoubleArray((int)240, (int)966658503);
        boolean[] hallSensorTransition = new boolean[]{false, false, true, true, true, true, false, true, false, false, false, false, true, false, true, false, true, true, false, false, true, false, true, false, false, true, true, true, true, true, true, false, false, true, true, true, true, true, true, true, true, false, true, false, true, true, false, false, false, true, true, false, true, false, false, false, false, true, false, false, false, true, false, false, false, true, true, true, false, true, false, true, false, false, true, true, true, false, false, false, true, false, false, true, true, false, false, false, false, false, true, false, true, true, false, false, true, true, true, false, true, false, true, false, true, false, false, true, true, true, false, true, true, false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, true, false, true, false, false, true, false, true, true, true, false, true, true, true, false, false, false, false, false, true, false, false, false, false, false, true, true, true, false, false, false, true, true, false, true, true, true, false, false, true, false, true, true, true, false, false, false, false, false, true, true, false, true, false, true, true, false, true, false, true, true, false, true, false, false, false, false, false, false, true, false, true, true, true, false, true, true, false, true, false, true, true, false, true, false, false, false, true, true, false, false, false, true, true, true, true, false, false, true, false, true, false, false};
        int encoderCount = 802;
        double[] timestampEncoder = TestHelper.generateDoubleArray((int)240, (int)-2032200855);
        double[] encoderPosition = TestHelper.generateDoubleArray((int)240, (int)1286343597);
        SALEvent item = this.testSendReceive((SALEvent)new ShutterBladeMotionProfileEvent(priority, blade, direction, timestampStart, startPosition, targetDuration, targetPosition, endPosition, actualDuration, hallSensorCount, timestampHallSensor, hallSensorID, hallSensorPosition, hallSensorTransition, encoderCount, timestampEncoder, encoderPosition));
        Assert.assertTrue((boolean)(item instanceof ShutterBladeMotionProfileEvent));
        ShutterBladeMotionProfileEvent item_ = (ShutterBladeMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)blade, (Object)item_.getBlade());
        Assert.assertEquals((Object)direction, (Object)item_.getDirection());
        Assert.assertEquals((double)timestampStart, (double)item_.getTimestampStart(), (double)1.0E-6f);
        Assert.assertEquals((double)startPosition, (double)item_.getStartPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)targetDuration, (double)item_.getTargetDuration(), (double)1.0E-6f);
        Assert.assertEquals((double)targetPosition, (double)item_.getTargetPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)endPosition, (double)item_.getEndPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)actualDuration, (double)item_.getActualDuration(), (double)1.0E-6f);
        Assert.assertEquals((long)hallSensorCount, (long)item_.getHallSensorCount());
        Assert.assertArrayEquals((double[])timestampHallSensor, (double[])item_.getTimestampHallSensor(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])hallSensorID, (int[])item_.getHallSensorID());
        Assert.assertArrayEquals((double[])hallSensorPosition, (double[])item_.getHallSensorPosition(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])hallSensorTransition, (boolean[])item_.getHallSensorTransition());
        Assert.assertEquals((long)encoderCount, (long)item_.getEncoderCount());
        Assert.assertArrayEquals((double[])timestampEncoder, (double[])item_.getTimestampEncoder(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])encoderPosition, (double[])item_.getEncoderPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageStoredEvent() throws Exception {
        int priority = 997;
        String imageName = "fjgfblquwnporwzppfwqkbngkuzdwzi";
        double timestampImageStored = 0.11182254552841187;
        SALEvent item = this.testSendReceive((SALEvent)new ImageStoredEvent(priority, imageName, timestampImageStored));
        Assert.assertTrue((boolean)(item instanceof ImageStoredEvent));
        ImageStoredEvent item_ = (ImageStoredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampImageStored, (double)item_.getTimestampImageStored(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFitsFilesWrittenEvent() throws Exception {
        int priority = 202;
        String imageName = "qjbswmaywayynowtrwnulfacxh";
        double timestampFilesWritten = 0.5877537727355957;
        String rootFileName = "";
        String relativeFileNames = "";
        String fileNode = "n";
        SALEvent item = this.testSendReceive((SALEvent)new FitsFilesWrittenEvent(priority, imageName, timestampFilesWritten, rootFileName, relativeFileNames, fileNode));
        Assert.assertTrue((boolean)(item instanceof FitsFilesWrittenEvent));
        FitsFilesWrittenEvent item_ = (FitsFilesWrittenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampFilesWritten, (double)item_.getTimestampFilesWritten(), (double)1.0E-6f);
        Assert.assertEquals((Object)rootFileName, (Object)item_.getRootFileName());
        Assert.assertEquals((Object)relativeFileNames, (Object)item_.getRelativeFileNames());
        Assert.assertEquals((Object)fileNode, (Object)item_.getFileNode());
    }

    @Test
    public void sendReceiveFileCommandExecutionEvent() throws Exception {
        int priority = 685;
        String imageName = "vxmzbatnddascitozxtcfkvyqf";
        double timestampCommandComplete = 0.45781224966049194;
        String command = "";
        int rc = 629;
        SALEvent item = this.testSendReceive((SALEvent)new FileCommandExecutionEvent(priority, imageName, timestampCommandComplete, command, rc));
        Assert.assertTrue((boolean)(item instanceof FileCommandExecutionEvent));
        FileCommandExecutionEvent item_ = (FileCommandExecutionEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampCommandComplete, (double)item_.getTimestampCommandComplete(), (double)1.0E-6f);
        Assert.assertEquals((Object)command, (Object)item_.getCommand());
        Assert.assertEquals((long)rc, (long)item_.getRc());
    }

    @Test
    public void sendReceiveImageVisualizationEvent() throws Exception {
        int priority = 769;
        String imageName = "phkrogiabrydtauvlrcbin";
        double timestampVisualizationAvailable = 0.5232800841331482;
        String url = "a";
        String thumbnail = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageVisualizationEvent(priority, imageName, timestampVisualizationAvailable, url, thumbnail));
        Assert.assertTrue((boolean)(item instanceof ImageVisualizationEvent));
        ImageVisualizationEvent item_ = (ImageVisualizationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampVisualizationAvailable, (double)item_.getTimestampVisualizationAvailable(), (double)1.0E-6f);
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)thumbnail, (Object)item_.getThumbnail());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 634;
        String recommendedSettingsVersion = "";
        String recommendedSettingsLabels = "d";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 806;
        int errorCode = 120;
        String errorReport = "m";
        String traceback = "r";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 614;
        boolean appliedSettingsMatchStartIsTrue = true;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 796;
        int level = 447;
        String subsystem = "j";
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level, subsystem));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)subsystem, (Object)item_.getSubsystem());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 799;
        String name = "o";
        int level = 2;
        String message = "p";
        String traceback = "s";
        String filePath = "v";
        String functionName = "z";
        int lineNumber = 10;
        int process = 441;
        double timestamp = 0.3154820203781128;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process, timestamp));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
        Assert.assertEquals((double)timestamp, (double)item_.getTimestamp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 56;
        String settingsVersion = "vcldlwmkltbvrhgvouipdzgrdpesevgjslvnvaabfgnhxtvojhrbbbatioozejufjdcygrtsrcekkmppbabqpewcaumtxwnnhxdxousukjpdoiujcivovaqkmutsjsdwutkucxnkmcaokqncaqvhcnrspiofdrptratbkajdbywwqebdasnjl";
        String otherSettingsEvents = "c";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 538;
        int mode = 943;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 239;
        String salVersion = "sustgxfzgxavknpsuwcsxplckkhnlmimbwcdzkopkhrdbeqjbjivltqcbvksqdwsrdkragxankbzfmqwccmlofjzmiztzpbnfpgmqupgyxtuvgsklntesqjwhetavdyxrdiukvymcttfohealssscajwuwnukbfxsom";
        String xmlVersion = "ctoauuxmjjgnwqphxdpctesikdvbkudtgpjdpmotwmouafgbkkjjgxccdyvuoherhkxhnkkckkfqeyvmoyupmrcntbzfyselziwzdafualjcejeewreankfolkflbpvhvpykfuqlptqx";
        String openSpliceVersion = "qwocmidhftfrbbvuqffcgfrzdbygnrqkkvbbieyykwpejjulnyzoqlplwaljy";
        String cscVersion = "zrnavkzkpecckdjdgwsspqdhxsrhhzcjfsgzljzdbejtqhztxvrgspliwuqzuglcmmagvqpkcorirrijxkadmahkdaswumkakrxjiycrfcdkzzvzeydlaqcyvbkexxkzwvxeobydhcqlgeapbvs";
        String subsystemVersions = "x";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 522;
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 34;
        String authorizedUsers = "c";
        String nonAuthorizedCSCs = "";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }

    @Test
    public void sendReceiveLargeFileObjectAvailableEvent() throws Exception {
        int priority = 812;
        String url = "fskkygismzz";
        String generator = "gwqqnubltxijrcbkwyyktoniqxoiiejiqhkhlzxzryrppjgktyuidsadlrqycmwzfugrhrwlveqejngcsnjnephetgmsiibgdriudkkgalhgsvpsvezzhsjwhuwstkppshewoapenvgtmubdmhuyapritluircfwgqcvlfkmkxcpmsylcc";
        float version = 0.62911445f;
        int byteSize = 794;
        String checkSum = "qqhxmncebblhkdblsqslavgmlnjxhoehsowscimqglhewdwngqrbehdscepwhxmvkmfzxbywzkvvdwpdneimnnnsixrkvjbnlpnezxwubjqcttkadygrjzmarfgbbmfwpjagbpgydzuxqeadhsupppvdtuqnhujcmhhhsohdszawjbsjgdrjuebfzwbdmatcfqfcmcjgbxmyihihxpsmyievkzlpvwvjtqmxjfrdjghvqyzdkbqolft";
        String mimeType = "mqgbyctwbyltjtpojslrvqygvliy";
        String id = "usxsqvhxqmallgvbdariwdizmdsvaneypwtbyenawpytbxhivepqbdefckdrfcozgfanglnohyctjrzkxdjnzdsbmrjrckapmqzuhhkmmbxwypgnofrlqqqgquq";
        SALEvent item = this.testSendReceive((SALEvent)new LargeFileObjectAvailableEvent(priority, url, generator, version, byteSize, checkSum, mimeType, id));
        Assert.assertTrue((boolean)(item instanceof LargeFileObjectAvailableEvent));
        LargeFileObjectAvailableEvent item_ = (LargeFileObjectAvailableEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)generator, (Object)item_.getGenerator());
        Assert.assertEquals((float)version, (float)item_.getVersion(), (float)1.0E-6f);
        Assert.assertEquals((long)byteSize, (long)item_.getByteSize());
        Assert.assertEquals((Object)checkSum, (Object)item_.getCheckSum());
        Assert.assertEquals((Object)mimeType, (Object)item_.getMimeType());
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }
}

