package org.lsst.sal.atcamera.event;

import java.util.Arrays;
import org.lsst.sal.camera.CameraEvent;

public class Focal_plane_Raft_RaftTempControlSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final String location;

  private final double[] tempcontrol_basePower;

  private final double[] tempcontrol_coefD;

  private final double[] tempcontrol_coefI;

  private final double[] tempcontrol_coefP;

  private final double[] tempcontrol_maxInput;

  private final double[] tempcontrol_maxOutput;

  private final double[] tempcontrol_minInput;

  private final double[] tempcontrol_minOutput;

  private final String tempcontrol_rebs;

  private final double[] tempcontrol_setTemp;

  private final double[] tempcontrol_smoothTime;

  private final String tempcontrol_tempChans;

  private final double[] tempcontrol_timeConst;

  public Focal_plane_Raft_RaftTempControlSettingsAppliedEvent(int priority, int version,
      String location, double[] tempcontrol_basePower, double[] tempcontrol_coefD,
      double[] tempcontrol_coefI, double[] tempcontrol_coefP, double[] tempcontrol_maxInput,
      double[] tempcontrol_maxOutput, double[] tempcontrol_minInput, double[] tempcontrol_minOutput,
      String tempcontrol_rebs, double[] tempcontrol_setTemp, double[] tempcontrol_smoothTime,
      String tempcontrol_tempChans, double[] tempcontrol_timeConst) {
    super (priority);
    this.version = version;
    this.location = location;
    this.tempcontrol_basePower = tempcontrol_basePower;
    this.tempcontrol_coefD = tempcontrol_coefD;
    this.tempcontrol_coefI = tempcontrol_coefI;
    this.tempcontrol_coefP = tempcontrol_coefP;
    this.tempcontrol_maxInput = tempcontrol_maxInput;
    this.tempcontrol_maxOutput = tempcontrol_maxOutput;
    this.tempcontrol_minInput = tempcontrol_minInput;
    this.tempcontrol_minOutput = tempcontrol_minOutput;
    this.tempcontrol_rebs = tempcontrol_rebs;
    this.tempcontrol_setTemp = tempcontrol_setTemp;
    this.tempcontrol_smoothTime = tempcontrol_smoothTime;
    this.tempcontrol_tempChans = tempcontrol_tempChans;
    this.tempcontrol_timeConst = tempcontrol_timeConst;
  }

  public int getVersion() {
    return version;
  }

  public String getLocation() {
    return location;
  }

  public double[] getTempcontrol_basePower() {
    return tempcontrol_basePower;
  }

  public double[] getTempcontrol_coefD() {
    return tempcontrol_coefD;
  }

  public double[] getTempcontrol_coefI() {
    return tempcontrol_coefI;
  }

  public double[] getTempcontrol_coefP() {
    return tempcontrol_coefP;
  }

  public double[] getTempcontrol_maxInput() {
    return tempcontrol_maxInput;
  }

  public double[] getTempcontrol_maxOutput() {
    return tempcontrol_maxOutput;
  }

  public double[] getTempcontrol_minInput() {
    return tempcontrol_minInput;
  }

  public double[] getTempcontrol_minOutput() {
    return tempcontrol_minOutput;
  }

  public String getTempcontrol_rebs() {
    return tempcontrol_rebs;
  }

  public double[] getTempcontrol_setTemp() {
    return tempcontrol_setTemp;
  }

  public double[] getTempcontrol_smoothTime() {
    return tempcontrol_smoothTime;
  }

  public String getTempcontrol_tempChans() {
    return tempcontrol_tempChans;
  }

  public double[] getTempcontrol_timeConst() {
    return tempcontrol_timeConst;
  }

  @Override
  public String toString() {
    return "Focal_plane_Raft_RaftTempControlSettingsAppliedEvent{" + "version=" + version +
        ", location=" + location +
        ", tempcontrol_basePower=" + Arrays.toString(tempcontrol_basePower) +
        ", tempcontrol_coefD=" + Arrays.toString(tempcontrol_coefD) +
        ", tempcontrol_coefI=" + Arrays.toString(tempcontrol_coefI) +
        ", tempcontrol_coefP=" + Arrays.toString(tempcontrol_coefP) +
        ", tempcontrol_maxInput=" + Arrays.toString(tempcontrol_maxInput) +
        ", tempcontrol_maxOutput=" + Arrays.toString(tempcontrol_maxOutput) +
        ", tempcontrol_minInput=" + Arrays.toString(tempcontrol_minInput) +
        ", tempcontrol_minOutput=" + Arrays.toString(tempcontrol_minOutput) +
        ", tempcontrol_rebs=" + tempcontrol_rebs +
        ", tempcontrol_setTemp=" + Arrays.toString(tempcontrol_setTemp) +
        ", tempcontrol_smoothTime=" + Arrays.toString(tempcontrol_smoothTime) +
        ", tempcontrol_tempChans=" + tempcontrol_tempChans +
        ", tempcontrol_timeConst=" + Arrays.toString(tempcontrol_timeConst) +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private int version;

    private String location;

    private double[] tempcontrol_basePower;

    private double[] tempcontrol_coefD;

    private double[] tempcontrol_coefI;

    private double[] tempcontrol_coefP;

    private double[] tempcontrol_maxInput;

    private double[] tempcontrol_maxOutput;

    private double[] tempcontrol_minInput;

    private double[] tempcontrol_minOutput;

    private String tempcontrol_rebs;

    private double[] tempcontrol_setTemp;

    private double[] tempcontrol_smoothTime;

    private String tempcontrol_tempChans;

    private double[] tempcontrol_timeConst;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(int version) {
      this.version = version;
      return this;
    }

    public Builder location(String location) {
      this.location = location;
      return this;
    }

    public Builder tempcontrol_basePower(double[] tempcontrol_basePower) {
      this.tempcontrol_basePower = tempcontrol_basePower;
      return this;
    }

    public Builder tempcontrol_coefD(double[] tempcontrol_coefD) {
      this.tempcontrol_coefD = tempcontrol_coefD;
      return this;
    }

    public Builder tempcontrol_coefI(double[] tempcontrol_coefI) {
      this.tempcontrol_coefI = tempcontrol_coefI;
      return this;
    }

    public Builder tempcontrol_coefP(double[] tempcontrol_coefP) {
      this.tempcontrol_coefP = tempcontrol_coefP;
      return this;
    }

    public Builder tempcontrol_maxInput(double[] tempcontrol_maxInput) {
      this.tempcontrol_maxInput = tempcontrol_maxInput;
      return this;
    }

    public Builder tempcontrol_maxOutput(double[] tempcontrol_maxOutput) {
      this.tempcontrol_maxOutput = tempcontrol_maxOutput;
      return this;
    }

    public Builder tempcontrol_minInput(double[] tempcontrol_minInput) {
      this.tempcontrol_minInput = tempcontrol_minInput;
      return this;
    }

    public Builder tempcontrol_minOutput(double[] tempcontrol_minOutput) {
      this.tempcontrol_minOutput = tempcontrol_minOutput;
      return this;
    }

    public Builder tempcontrol_rebs(String tempcontrol_rebs) {
      this.tempcontrol_rebs = tempcontrol_rebs;
      return this;
    }

    public Builder tempcontrol_setTemp(double[] tempcontrol_setTemp) {
      this.tempcontrol_setTemp = tempcontrol_setTemp;
      return this;
    }

    public Builder tempcontrol_smoothTime(double[] tempcontrol_smoothTime) {
      this.tempcontrol_smoothTime = tempcontrol_smoothTime;
      return this;
    }

    public Builder tempcontrol_tempChans(String tempcontrol_tempChans) {
      this.tempcontrol_tempChans = tempcontrol_tempChans;
      return this;
    }

    public Builder tempcontrol_timeConst(double[] tempcontrol_timeConst) {
      this.tempcontrol_timeConst = tempcontrol_timeConst;
      return this;
    }

    public Focal_plane_Raft_RaftTempControlSettingsAppliedEvent build() {
      return new Focal_plane_Raft_RaftTempControlSettingsAppliedEvent(priority, version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst);
    }
  }
}
