package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Ats_power_SchedulersSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final int default_nTasks;

  private final int default_nThreads;

  private final int monitor_update_publish_scheduler_nTasks;

  private final int monitor_update_publish_scheduler_nThreads;

  public Ats_power_SchedulersSettingsAppliedEvent(int priority, int version, int default_nTasks,
      int default_nThreads, int monitor_update_publish_scheduler_nTasks,
      int monitor_update_publish_scheduler_nThreads) {
    super (priority);
    this.version = version;
    this.default_nTasks = default_nTasks;
    this.default_nThreads = default_nThreads;
    this.monitor_update_publish_scheduler_nTasks = monitor_update_publish_scheduler_nTasks;
    this.monitor_update_publish_scheduler_nThreads = monitor_update_publish_scheduler_nThreads;
  }

  public int getVersion() {
    return version;
  }

  public int getDefault_nTasks() {
    return default_nTasks;
  }

  public int getDefault_nThreads() {
    return default_nThreads;
  }

  public int getMonitor_update_publish_scheduler_nTasks() {
    return monitor_update_publish_scheduler_nTasks;
  }

  public int getMonitor_update_publish_scheduler_nThreads() {
    return monitor_update_publish_scheduler_nThreads;
  }

  @Override
  public String toString() {
    return "Ats_power_SchedulersSettingsAppliedEvent{" + "version=" + version +
        ", default_nTasks=" + default_nTasks +", default_nThreads=" + default_nThreads +
        ", monitor_update_publish_scheduler_nTasks=" + monitor_update_publish_scheduler_nTasks +
        ", monitor_update_publish_scheduler_nThreads=" + monitor_update_publish_scheduler_nThreads +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private int version;

    private int default_nTasks;

    private int default_nThreads;

    private int monitor_update_publish_scheduler_nTasks;

    private int monitor_update_publish_scheduler_nThreads;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(int version) {
      this.version = version;
      return this;
    }

    public Builder default_nTasks(int default_nTasks) {
      this.default_nTasks = default_nTasks;
      return this;
    }

    public Builder default_nThreads(int default_nThreads) {
      this.default_nThreads = default_nThreads;
      return this;
    }

    public Builder monitor_update_publish_scheduler_nTasks(
        int monitor_update_publish_scheduler_nTasks) {
      this.monitor_update_publish_scheduler_nTasks = monitor_update_publish_scheduler_nTasks;
      return this;
    }

    public Builder monitor_update_publish_scheduler_nThreads(
        int monitor_update_publish_scheduler_nThreads) {
      this.monitor_update_publish_scheduler_nThreads = monitor_update_publish_scheduler_nThreads;
      return this;
    }

    public Ats_power_SchedulersSettingsAppliedEvent build() {
      return new Ats_power_SchedulersSettingsAppliedEvent(priority, version, default_nTasks, default_nThreads, monitor_update_publish_scheduler_nTasks, monitor_update_publish_scheduler_nThreads);
    }
  }
}
