/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.atcamera.telemetry.PowerTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)1, (int)1692456816);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)1, (int)2067639701);
        double[] oDV = TestHelper.generateDoubleArray((int)1, (int)130033760);
        double[] oGV = TestHelper.generateDoubleArray((int)1, (int)2023112320);
        double[] rDV = TestHelper.generateDoubleArray((int)1, (int)-1031948134);
        double[] temp = TestHelper.generateDoubleArray((int)1, (int)1460871007);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)1, (int)-893253377);
        double[] anaV = TestHelper.generateDoubleArray((int)1, (int)1871958810);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)1, (int)-644472991);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)1, (int)-2092563425);
        double[] clkHI = TestHelper.generateDoubleArray((int)1, (int)-1944800355);
        double[] clkHV = TestHelper.generateDoubleArray((int)1, (int)-1997910944);
        double[] clkLV = TestHelper.generateDoubleArray((int)1, (int)-1043693262);
        double[] digI = TestHelper.generateDoubleArray((int)1, (int)1245067630);
        double[] digV = TestHelper.generateDoubleArray((int)1, (int)-258759295);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)1, (int)-1628639025);
        double[] htrPI = TestHelper.generateDoubleArray((int)1, (int)-853434444);
        double[] htrPV = TestHelper.generateDoubleArray((int)1, (int)1182931208);
        double[] htrV = TestHelper.generateDoubleArray((int)1, (int)-2015599975);
        double[] htrW = TestHelper.generateDoubleArray((int)1, (int)-1031698967);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)1, (int)1672227611);
        double[] oDV = TestHelper.generateDoubleArray((int)1, (int)1068790890);
        double[] pClk0 = TestHelper.generateDoubleArray((int)1, (int)-1584589293);
        double[] pClkL = TestHelper.generateDoubleArray((int)1, (int)-974540084);
        double[] pClkU = TestHelper.generateDoubleArray((int)1, (int)-1510786878);
        double[] power = TestHelper.generateDoubleArray((int)1, (int)626779201);
        double[] rG0 = TestHelper.generateDoubleArray((int)1, (int)-1328762689);
        double[] rGL = TestHelper.generateDoubleArray((int)1, (int)1739530126);
        double[] rGU = TestHelper.generateDoubleArray((int)1, (int)691700427);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)1, (int)72393902);
        double[] sClk0 = TestHelper.generateDoubleArray((int)1, (int)616007885);
        double[] sClkL = TestHelper.generateDoubleArray((int)1, (int)1478437185);
        double[] sClkU = TestHelper.generateDoubleArray((int)1, (int)-1065869120);
        double[] temp1 = TestHelper.generateDoubleArray((int)1, (int)-2124767694);
        double[] temp2 = TestHelper.generateDoubleArray((int)1, (int)385488174);
        double[] temp3 = TestHelper.generateDoubleArray((int)1, (int)-545210850);
        double[] temp4 = TestHelper.generateDoubleArray((int)1, (int)-1308898267);
        double[] temp5 = TestHelper.generateDoubleArray((int)1, (int)973034295);
        double[] temp6 = TestHelper.generateDoubleArray((int)1, (int)-1930422326);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicu_Temp0, clkHI, clkHV, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClkL, pClkU, power, rG0, rGL, rGU, rTDTemp, sClk0, sClkL, sClkU, temp1, temp2, temp3, temp4, temp5, temp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.014067888259887695;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.03614205f;
        double freeFraction = 0.37096112966537476;
        double freeSpace = 0.3495739698410034;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePowerTelemetry() throws Exception {
        double analog_I = 0.7331953048706055;
        double analog_V = 0.44190144538879395;
        double aux_I = 0.8249333500862122;
        double aux_V = 0.3438388705253601;
        double clkhigh_I = 0.6647447347640991;
        double clkhigh_V = 0.09924596548080444;
        double clklow_I = 0.388649046421051;
        double clklow_V = 0.192366361618042;
        double dphi_I = 0.3791356682777405;
        double dphi_V = 0.6766318678855896;
        double digital_I = 0.4565402865409851;
        double digital_V = 0.5763600468635559;
        double fan_I = 0.8063295483589172;
        double fan_V = 0.20522820949554443;
        double hvbias_I = 0.04169929027557373;
        double hvbias_V = 0.5060730576515198;
        double od_I = 0.4233966f;
        double od_V = 0.02714228630065918;
        double otm_I = 0.20204466581344604;
        double otm_V = 0.4414917230606079;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PowerTelemetry(analog_I, analog_V, aux_I, aux_V, clkhigh_I, clkhigh_V, clklow_I, clklow_V, dphi_I, dphi_V, digital_I, digital_V, fan_I, fan_V, hvbias_I, hvbias_V, od_I, od_V, otm_I, otm_V));
        Assert.assertTrue((boolean)(item instanceof PowerTelemetry));
        PowerTelemetry item_ = (PowerTelemetry)item;
        Assert.assertEquals((double)analog_I, (double)item_.getAnalog_I(), (double)1.0E-6f);
        Assert.assertEquals((double)analog_V, (double)item_.getAnalog_V(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_I, (double)item_.getAux_I(), (double)1.0E-6f);
        Assert.assertEquals((double)aux_V, (double)item_.getAux_V(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhigh_I, (double)item_.getClkhigh_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhigh_V, (double)item_.getClkhigh_V(), (double)1.0E-6f);
        Assert.assertEquals((double)clklow_I, (double)item_.getClklow_I(), (double)1.0E-6f);
        Assert.assertEquals((double)clklow_V, (double)item_.getClklow_V(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_I, (double)item_.getDphi_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dphi_V, (double)item_.getDphi_V(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_I, (double)item_.getDigital_I(), (double)1.0E-6f);
        Assert.assertEquals((double)digital_V, (double)item_.getDigital_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_I, (double)item_.getFan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fan_V, (double)item_.getFan_V(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_I, (double)item_.getHvbias_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hvbias_V, (double)item_.getHvbias_V(), (double)1.0E-6f);
        Assert.assertEquals((double)od_I, (double)item_.getOd_I(), (double)1.0E-6f);
        Assert.assertEquals((double)od_V, (double)item_.getOd_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_I, (double)item_.getOtm_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_V, (double)item_.getOtm_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumTelemetry() throws Exception {
        double tempCCD = 0.8437589406967163;
        double tempCCDSetPoint = 0.8764467239379883;
        double tempColdPlate = 0.4024495482444763;
        double tempCryoHead = 0.42289382219314575;
        double vacuum = 0.9662340879440308;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumTelemetry(tempCCD, tempCCDSetPoint, tempColdPlate, tempCryoHead, vacuum));
        Assert.assertTrue((boolean)(item instanceof VacuumTelemetry));
        VacuumTelemetry item_ = (VacuumTelemetry)item;
        Assert.assertEquals((double)tempCCD, (double)item_.getTempCCD(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCCDSetPoint, (double)item_.getTempCCDSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((double)tempColdPlate, (double)item_.getTempColdPlate(), (double)1.0E-6f);
        Assert.assertEquals((double)tempCryoHead, (double)item_.getTempCryoHead(), (double)1.0E-6f);
        Assert.assertEquals((double)vacuum, (double)item_.getVacuum(), (double)1.0E-6f);
    }
}

