package org.lsst.sal.atcamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class VacuumTelemetry extends CameraTelemetry {
  private final float tempCCD;

  private final float tempColdPlate;

  private final float tempCryoHead;

  private final float vacuum;

  private final float tempCCDSetPoint;

  public VacuumTelemetry(float tempCCD, float tempColdPlate, float tempCryoHead, float vacuum,
      float tempCCDSetPoint) {
    this.tempCCD = tempCCD;
    this.tempColdPlate = tempColdPlate;
    this.tempCryoHead = tempCryoHead;
    this.vacuum = vacuum;
    this.tempCCDSetPoint = tempCCDSetPoint;
  }

  public float getTempCCD() {
    return tempCCD;
  }

  public float getTempColdPlate() {
    return tempColdPlate;
  }

  public float getTempCryoHead() {
    return tempCryoHead;
  }

  public float getVacuum() {
    return vacuum;
  }

  public float getTempCCDSetPoint() {
    return tempCCDSetPoint;
  }

  @Override
  public String toString() {
    return "VacuumTelemetry{" + "tempCCD=" + tempCCD +", tempColdPlate=" + tempColdPlate +
        ", tempCryoHead=" + tempCryoHead +", vacuum=" + vacuum +
        ", tempCCDSetPoint=" + tempCCDSetPoint +"}";
  }
}
