package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class ImageStoredEvent extends CameraEvent {
  private final String imageName;

  private final double timestampImageStored;

  public ImageStoredEvent(int priority, String imageName, double timestampImageStored) {
    super (priority);
    this.imageName = imageName;
    this.timestampImageStored = timestampImageStored;
  }

  public String getImageName() {
    return imageName;
  }

  public double getTimestampImageStored() {
    return timestampImageStored;
  }

  @Override
  public String toString() {
    return "ImageStoredEvent{" + "imageName=" + imageName +
        ", timestampImageStored=" + timestampImageStored +"}";
  }
}
