package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class FitsFilesWrittenEvent extends CameraEvent {
  private final String imageName;

  private final double timestampFilesWritten;

  private final String rootFileName;

  private final String relativeFileNames;

  private final String fileNode;

  public FitsFilesWrittenEvent(int priority, String imageName, double timestampFilesWritten,
      String rootFileName, String relativeFileNames, String fileNode) {
    super (priority);
    this.imageName = imageName;
    this.timestampFilesWritten = timestampFilesWritten;
    this.rootFileName = rootFileName;
    this.relativeFileNames = relativeFileNames;
    this.fileNode = fileNode;
  }

  public String getImageName() {
    return imageName;
  }

  public double getTimestampFilesWritten() {
    return timestampFilesWritten;
  }

  public String getRootFileName() {
    return rootFileName;
  }

  public String getRelativeFileNames() {
    return relativeFileNames;
  }

  public String getFileNode() {
    return fileNode;
  }

  @Override
  public String toString() {
    return "FitsFilesWrittenEvent{" + "imageName=" + imageName +
        ", timestampFilesWritten=" + timestampFilesWritten +", rootFileName=" + rootFileName +
        ", relativeFileNames=" + relativeFileNames +", fileNode=" + fileNode +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String imageName;

    private double timestampFilesWritten;

    private String rootFileName;

    private String relativeFileNames;

    private String fileNode;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder imageName(String imageName) {
      this.imageName = imageName;
      return this;
    }

    public Builder timestampFilesWritten(double timestampFilesWritten) {
      this.timestampFilesWritten = timestampFilesWritten;
      return this;
    }

    public Builder rootFileName(String rootFileName) {
      this.rootFileName = rootFileName;
      return this;
    }

    public Builder relativeFileNames(String relativeFileNames) {
      this.relativeFileNames = relativeFileNames;
      return this;
    }

    public Builder fileNode(String fileNode) {
      this.fileNode = fileNode;
      return this;
    }

    public FitsFilesWrittenEvent build() {
      return new FitsFilesWrittenEvent(priority, imageName, timestampFilesWritten, rootFileName, relativeFileNames, fileNode);
    }
  }
}
