package org.lsst.sal.atcamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class WrebTelemetry extends CameraTelemetry {
  private final float temp1;

  private final float temp2;

  private final float temp3;

  private final float temp4;

  private final float temp5;

  private final float temp6;

  private final float atemp0U;

  private final float atemp0L;

  private final float ccdTemp0;

  private final float digV;

  private final float digI;

  private final float anaV;

  private final float anaI;

  private final float clkHV;

  private final float clkHI;

  private final float clkLV;

  private final float odV;

  private final float odI;

  private final float power;

  private final float pClkU;

  private final float pClkL;

  private final float sClkU;

  private final float sClkL;

  private final float rgU;

  private final float rgL;

  private final float pClk0;

  private final float sClk0;

  private final float rg0;

  private final float od0V;

  private final float og0V;

  private final float rd0V;

  private final float gd0V;

  private final float od0I;

  private final float hvbiasSwitch;

  public WrebTelemetry(float temp1, float temp2, float temp3, float temp4, float temp5, float temp6,
      float atemp0U, float atemp0L, float ccdTemp0, float digV, float digI, float anaV, float anaI,
      float clkHV, float clkHI, float clkLV, float odV, float odI, float power, float pClkU,
      float pClkL, float sClkU, float sClkL, float rgU, float rgL, float pClk0, float sClk0,
      float rg0, float od0V, float og0V, float rd0V, float gd0V, float od0I, float hvbiasSwitch) {
    this.temp1 = temp1;
    this.temp2 = temp2;
    this.temp3 = temp3;
    this.temp4 = temp4;
    this.temp5 = temp5;
    this.temp6 = temp6;
    this.atemp0U = atemp0U;
    this.atemp0L = atemp0L;
    this.ccdTemp0 = ccdTemp0;
    this.digV = digV;
    this.digI = digI;
    this.anaV = anaV;
    this.anaI = anaI;
    this.clkHV = clkHV;
    this.clkHI = clkHI;
    this.clkLV = clkLV;
    this.odV = odV;
    this.odI = odI;
    this.power = power;
    this.pClkU = pClkU;
    this.pClkL = pClkL;
    this.sClkU = sClkU;
    this.sClkL = sClkL;
    this.rgU = rgU;
    this.rgL = rgL;
    this.pClk0 = pClk0;
    this.sClk0 = sClk0;
    this.rg0 = rg0;
    this.od0V = od0V;
    this.og0V = og0V;
    this.rd0V = rd0V;
    this.gd0V = gd0V;
    this.od0I = od0I;
    this.hvbiasSwitch = hvbiasSwitch;
  }

  public float getTemp1() {
    return temp1;
  }

  public float getTemp2() {
    return temp2;
  }

  public float getTemp3() {
    return temp3;
  }

  public float getTemp4() {
    return temp4;
  }

  public float getTemp5() {
    return temp5;
  }

  public float getTemp6() {
    return temp6;
  }

  public float getAtemp0U() {
    return atemp0U;
  }

  public float getAtemp0L() {
    return atemp0L;
  }

  public float getCcdTemp0() {
    return ccdTemp0;
  }

  public float getDigV() {
    return digV;
  }

  public float getDigI() {
    return digI;
  }

  public float getAnaV() {
    return anaV;
  }

  public float getAnaI() {
    return anaI;
  }

  public float getClkHV() {
    return clkHV;
  }

  public float getClkHI() {
    return clkHI;
  }

  public float getClkLV() {
    return clkLV;
  }

  public float getOdV() {
    return odV;
  }

  public float getOdI() {
    return odI;
  }

  public float getPower() {
    return power;
  }

  public float getPClkU() {
    return pClkU;
  }

  public float getPClkL() {
    return pClkL;
  }

  public float getSClkU() {
    return sClkU;
  }

  public float getSClkL() {
    return sClkL;
  }

  public float getRgU() {
    return rgU;
  }

  public float getRgL() {
    return rgL;
  }

  public float getPClk0() {
    return pClk0;
  }

  public float getSClk0() {
    return sClk0;
  }

  public float getRg0() {
    return rg0;
  }

  public float getOd0V() {
    return od0V;
  }

  public float getOg0V() {
    return og0V;
  }

  public float getRd0V() {
    return rd0V;
  }

  public float getGd0V() {
    return gd0V;
  }

  public float getOd0I() {
    return od0I;
  }

  public float getHvbiasSwitch() {
    return hvbiasSwitch;
  }

  @Override
  public String toString() {
    return "WrebTelemetry{" + "temp1=" + temp1 +", temp2=" + temp2 +", temp3=" + temp3 +
        ", temp4=" + temp4 +", temp5=" + temp5 +", temp6=" + temp6 +", atemp0U=" + atemp0U +
        ", atemp0L=" + atemp0L +", ccdTemp0=" + ccdTemp0 +", digV=" + digV +", digI=" + digI +
        ", anaV=" + anaV +", anaI=" + anaI +", clkHV=" + clkHV +", clkHI=" + clkHI +
        ", clkLV=" + clkLV +", odV=" + odV +", odI=" + odI +", power=" + power +", pClkU=" + pClkU +
        ", pClkL=" + pClkL +", sClkU=" + sClkU +", sClkL=" + sClkL +", rgU=" + rgU +", rgL=" + rgL +
        ", pClk0=" + pClk0 +", sClk0=" + sClk0 +", rg0=" + rg0 +", od0V=" + od0V +", og0V=" + og0V +
        ", rd0V=" + rd0V +", gd0V=" + gd0V +", od0I=" + od0I +", hvbiasSwitch=" + hvbiasSwitch +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private float temp1;

    private float temp2;

    private float temp3;

    private float temp4;

    private float temp5;

    private float temp6;

    private float atemp0U;

    private float atemp0L;

    private float ccdTemp0;

    private float digV;

    private float digI;

    private float anaV;

    private float anaI;

    private float clkHV;

    private float clkHI;

    private float clkLV;

    private float odV;

    private float odI;

    private float power;

    private float pClkU;

    private float pClkL;

    private float sClkU;

    private float sClkL;

    private float rgU;

    private float rgL;

    private float pClk0;

    private float sClk0;

    private float rg0;

    private float od0V;

    private float og0V;

    private float rd0V;

    private float gd0V;

    private float od0I;

    private float hvbiasSwitch;

    private Builder() {
    }

    public Builder temp1(float temp1) {
      this.temp1 = temp1;
      return this;
    }

    public Builder temp2(float temp2) {
      this.temp2 = temp2;
      return this;
    }

    public Builder temp3(float temp3) {
      this.temp3 = temp3;
      return this;
    }

    public Builder temp4(float temp4) {
      this.temp4 = temp4;
      return this;
    }

    public Builder temp5(float temp5) {
      this.temp5 = temp5;
      return this;
    }

    public Builder temp6(float temp6) {
      this.temp6 = temp6;
      return this;
    }

    public Builder atemp0U(float atemp0U) {
      this.atemp0U = atemp0U;
      return this;
    }

    public Builder atemp0L(float atemp0L) {
      this.atemp0L = atemp0L;
      return this;
    }

    public Builder ccdTemp0(float ccdTemp0) {
      this.ccdTemp0 = ccdTemp0;
      return this;
    }

    public Builder digV(float digV) {
      this.digV = digV;
      return this;
    }

    public Builder digI(float digI) {
      this.digI = digI;
      return this;
    }

    public Builder anaV(float anaV) {
      this.anaV = anaV;
      return this;
    }

    public Builder anaI(float anaI) {
      this.anaI = anaI;
      return this;
    }

    public Builder clkHV(float clkHV) {
      this.clkHV = clkHV;
      return this;
    }

    public Builder clkHI(float clkHI) {
      this.clkHI = clkHI;
      return this;
    }

    public Builder clkLV(float clkLV) {
      this.clkLV = clkLV;
      return this;
    }

    public Builder odV(float odV) {
      this.odV = odV;
      return this;
    }

    public Builder odI(float odI) {
      this.odI = odI;
      return this;
    }

    public Builder power(float power) {
      this.power = power;
      return this;
    }

    public Builder pClkU(float pClkU) {
      this.pClkU = pClkU;
      return this;
    }

    public Builder pClkL(float pClkL) {
      this.pClkL = pClkL;
      return this;
    }

    public Builder sClkU(float sClkU) {
      this.sClkU = sClkU;
      return this;
    }

    public Builder sClkL(float sClkL) {
      this.sClkL = sClkL;
      return this;
    }

    public Builder rgU(float rgU) {
      this.rgU = rgU;
      return this;
    }

    public Builder rgL(float rgL) {
      this.rgL = rgL;
      return this;
    }

    public Builder pClk0(float pClk0) {
      this.pClk0 = pClk0;
      return this;
    }

    public Builder sClk0(float sClk0) {
      this.sClk0 = sClk0;
      return this;
    }

    public Builder rg0(float rg0) {
      this.rg0 = rg0;
      return this;
    }

    public Builder od0V(float od0V) {
      this.od0V = od0V;
      return this;
    }

    public Builder og0V(float og0V) {
      this.og0V = og0V;
      return this;
    }

    public Builder rd0V(float rd0V) {
      this.rd0V = rd0V;
      return this;
    }

    public Builder gd0V(float gd0V) {
      this.gd0V = gd0V;
      return this;
    }

    public Builder od0I(float od0I) {
      this.od0I = od0I;
      return this;
    }

    public Builder hvbiasSwitch(float hvbiasSwitch) {
      this.hvbiasSwitch = hvbiasSwitch;
      return this;
    }

    public WrebTelemetry build() {
      return new WrebTelemetry(temp1, temp2, temp3, temp4, temp5, temp6, atemp0U, atemp0L, ccdTemp0, digV, digI, anaV, anaI, clkHV, clkHI, clkLV, odV, odI, power, pClkU, pClkL, sClkU, sClkL, rgU, rgL, pClk0, sClk0, rg0, od0V, og0V, rd0V, gd0V, od0I, hvbiasSwitch);
    }
  }
}
