package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Daq_monitor_StatsSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final boolean enablePeriodicPublication;

  private final int minDiffAlertWarning;

  private final int minDiffLogWarning;

  private final String sumDriverChecks;

  private final String sumDriverStats;

  private final String sumFirmwareChecks;

  private final String sumFirmwareStats;

  private final String sumRdsChecks;

  private final String sumRdsStats;

  private final String sumRmsChecks;

  private final String sumRmsStats;

  public Daq_monitor_StatsSettingsAppliedEvent(int priority, int version,
      boolean enablePeriodicPublication, int minDiffAlertWarning, int minDiffLogWarning,
      String sumDriverChecks, String sumDriverStats, String sumFirmwareChecks,
      String sumFirmwareStats, String sumRdsChecks, String sumRdsStats, String sumRmsChecks,
      String sumRmsStats) {
    super (priority);
    this.version = version;
    this.enablePeriodicPublication = enablePeriodicPublication;
    this.minDiffAlertWarning = minDiffAlertWarning;
    this.minDiffLogWarning = minDiffLogWarning;
    this.sumDriverChecks = sumDriverChecks;
    this.sumDriverStats = sumDriverStats;
    this.sumFirmwareChecks = sumFirmwareChecks;
    this.sumFirmwareStats = sumFirmwareStats;
    this.sumRdsChecks = sumRdsChecks;
    this.sumRdsStats = sumRdsStats;
    this.sumRmsChecks = sumRmsChecks;
    this.sumRmsStats = sumRmsStats;
  }

  public int getVersion() {
    return version;
  }

  public boolean isEnablePeriodicPublication() {
    return enablePeriodicPublication;
  }

  public int getMinDiffAlertWarning() {
    return minDiffAlertWarning;
  }

  public int getMinDiffLogWarning() {
    return minDiffLogWarning;
  }

  public String getSumDriverChecks() {
    return sumDriverChecks;
  }

  public String getSumDriverStats() {
    return sumDriverStats;
  }

  public String getSumFirmwareChecks() {
    return sumFirmwareChecks;
  }

  public String getSumFirmwareStats() {
    return sumFirmwareStats;
  }

  public String getSumRdsChecks() {
    return sumRdsChecks;
  }

  public String getSumRdsStats() {
    return sumRdsStats;
  }

  public String getSumRmsChecks() {
    return sumRmsChecks;
  }

  public String getSumRmsStats() {
    return sumRmsStats;
  }

  @Override
  public String toString() {
    return "Daq_monitor_StatsSettingsAppliedEvent{" + "version=" + version +
        ", enablePeriodicPublication=" + enablePeriodicPublication +
        ", minDiffAlertWarning=" + minDiffAlertWarning +", minDiffLogWarning=" + minDiffLogWarning +
        ", sumDriverChecks=" + sumDriverChecks +", sumDriverStats=" + sumDriverStats +
        ", sumFirmwareChecks=" + sumFirmwareChecks +", sumFirmwareStats=" + sumFirmwareStats +
        ", sumRdsChecks=" + sumRdsChecks +", sumRdsStats=" + sumRdsStats +
        ", sumRmsChecks=" + sumRmsChecks +", sumRmsStats=" + sumRmsStats +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private int version;

    private boolean enablePeriodicPublication;

    private int minDiffAlertWarning;

    private int minDiffLogWarning;

    private String sumDriverChecks;

    private String sumDriverStats;

    private String sumFirmwareChecks;

    private String sumFirmwareStats;

    private String sumRdsChecks;

    private String sumRdsStats;

    private String sumRmsChecks;

    private String sumRmsStats;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(int version) {
      this.version = version;
      return this;
    }

    public Builder enablePeriodicPublication(boolean enablePeriodicPublication) {
      this.enablePeriodicPublication = enablePeriodicPublication;
      return this;
    }

    public Builder minDiffAlertWarning(int minDiffAlertWarning) {
      this.minDiffAlertWarning = minDiffAlertWarning;
      return this;
    }

    public Builder minDiffLogWarning(int minDiffLogWarning) {
      this.minDiffLogWarning = minDiffLogWarning;
      return this;
    }

    public Builder sumDriverChecks(String sumDriverChecks) {
      this.sumDriverChecks = sumDriverChecks;
      return this;
    }

    public Builder sumDriverStats(String sumDriverStats) {
      this.sumDriverStats = sumDriverStats;
      return this;
    }

    public Builder sumFirmwareChecks(String sumFirmwareChecks) {
      this.sumFirmwareChecks = sumFirmwareChecks;
      return this;
    }

    public Builder sumFirmwareStats(String sumFirmwareStats) {
      this.sumFirmwareStats = sumFirmwareStats;
      return this;
    }

    public Builder sumRdsChecks(String sumRdsChecks) {
      this.sumRdsChecks = sumRdsChecks;
      return this;
    }

    public Builder sumRdsStats(String sumRdsStats) {
      this.sumRdsStats = sumRdsStats;
      return this;
    }

    public Builder sumRmsChecks(String sumRmsChecks) {
      this.sumRmsChecks = sumRmsChecks;
      return this;
    }

    public Builder sumRmsStats(String sumRmsStats) {
      this.sumRmsStats = sumRmsStats;
      return this;
    }

    public Daq_monitor_StatsSettingsAppliedEvent build() {
      return new Daq_monitor_StatsSettingsAppliedEvent(priority, version, enablePeriodicPublication, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats);
    }
  }
}
