/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.event.Daq_monitorSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Daq_monitor_StatsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Daq_monitor_StoreSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FileCommandExecutionEvent;
import org.lsst.sal.atcamera.event.FitsFilesWrittenEvent;
import org.lsst.sal.atcamera.event.FocalPlaneDAQSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneHardwareIdSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneRaftTempControlSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneRaftTempControlStatusSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneRebRaftsPowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneRebRaftsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneSequencerConfigSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.atcamera.event.ImageReadoutParametersEvent;
import org.lsst.sal.atcamera.event.ImageStoredEvent;
import org.lsst.sal.atcamera.event.ImageVisualizationEvent;
import org.lsst.sal.atcamera.event.ShutterBladeMotionProfileEvent;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 600;
        String additionalKeys = "s";
        String additionalValues = "w";
        int imagesInSequence = 223;
        String imageName = "dpuhjtouisgxhtrvwqnmenqiyjgsyf";
        int imageIndex = 884;
        String imageSource = "";
        String imageController = "e";
        String imageDate = "os";
        int imageNumber = 74;
        double timestampAcquisitionStart = 0.5457326769828796;
        double requestedExposureTime = 0.9931433200836182;
        double timestampEndOfReadout = 0.6937207579612732;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 476;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 462;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 895;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 75;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 701;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 645;
        String imageName = "mpolaatatguejj";
        int imageIndex = 172;
        String imageSource = "mf";
        String imageController = "o";
        String imageDate = "clwuexo";
        int imageNumber = 27;
        double timestampAcquisitionStart = 0.5015073418617249;
        double exposureTime = 0.6853654980659485;
        String imageTag = "pkystpmanwcangdisqfvxuqw";
        double timestampDateObs = 0.24237751960754395;
        double timestampDateEnd = 0.9880634546279907;
        double measuredShutterOpenTime = 0.313502f;
        double darkTime = 0.9948939085006714;
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 184;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 21;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 168;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 30;
        String additionalKeys = "y";
        String additionalValues = "";
        int imagesInSequence = 767;
        String imageName = "xwfucnamoaezfanauhn";
        int imageIndex = 363;
        String imageSource = "ot";
        String imageController = "h";
        String imageDate = "usprpmld";
        int imageNumber = 90;
        double timestampAcquisitionStart = 0.8449721336364746;
        double exposureTime = 0.0364545f;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 661;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 798;
        String additionalKeys = "c";
        String additionalValues = "a";
        int imagesInSequence = 530;
        String imageName = "unvdyvuwxmpzbhnnlfao";
        int imageIndex = 23;
        String imageSource = "";
        String imageController = "a";
        String imageDate = "jfkyewrp";
        int imageNumber = 861;
        double timestampAcquisitionStart = 0.6435010433197021;
        double exposureTime = 0.5667428970336914;
        double timestampStartOfReadout = 0.9196158051490784;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveShutterMotionProfileEvent() throws Exception {
        int priority = 239;
        double measuredExposureTime = 0.5131617784500122;
        SALEvent item = this.testSendReceive((SALEvent)new ShutterMotionProfileEvent(priority, measuredExposureTime));
        Assert.assertTrue((boolean)(item instanceof ShutterMotionProfileEvent));
        ShutterMotionProfileEvent item_ = (ShutterMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)measuredExposureTime, (double)item_.getMeasuredExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 204;
        String imageName = "";
        String ccdLocation = "z";
        String raftBay = "a";
        String ccdSlot = "y";
        ImageReadoutParametersEvent.CcdType ccdType = ImageReadoutParametersEvent.CcdType.E2V;
        int overRows = 236;
        int overCols = 204;
        int readRows = 78;
        int readCols = 442;
        int readCols2 = 543;
        int preCols = 105;
        int preRows = 546;
        int postCols = 509;
        int underCols = 512;
        String daqFolder = "h";
        String daqAnnotation = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 692;
        String ccdLocation = "g";
        String raftBay = "i";
        String ccdSlot = "k";
        String rebSerialNumber = "";
        String rebLSSTName = "";
        String ccdLSSTName = "";
        String raftLSSTName = "p";
        String ccdManSerNum = "";
        String ccdManufacturer = "";
        FocalPlaneSummaryInfoEvent.CcdType ccdType = FocalPlaneSummaryInfoEvent.CcdType.E2V;
        double ccdTempSetPoint = 0.4545134902000427;
        String sequencerKey = "";
        String sequencerChecksum = "u";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((double)ccdTempSetPoint, (double)item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveFocalPlaneHardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 140;
        int version = 747;
        String rebLocation = "";
        String rebLSSTName = "";
        String ccdLocation = "d";
        String ccdLSSTName = "";
        String ccdManSerNum = "q";
        String raftLocation = "v";
        String raftLSSTName = "a";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneHardwareIdSettingsAppliedEvent(priority, version, rebLocation, rebLSSTName, ccdLocation, ccdLSSTName, ccdManSerNum, raftLocation, raftLSSTName));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneHardwareIdSettingsAppliedEvent));
        FocalPlaneHardwareIdSettingsAppliedEvent item_ = (FocalPlaneHardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)rebLocation, (Object)item_.getRebLocation());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
    }

    @Test
    public void sendReceiveFocalPlaneRaftTempControlStatusSettingsAppliedEvent() throws Exception {
        int priority = 314;
        int version = 111;
        String raftLocation = "";
        boolean raft_TempControl_active = true;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRaftTempControlStatusSettingsAppliedEvent(priority, version, raftLocation, raft_TempControl_active));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRaftTempControlStatusSettingsAppliedEvent));
        FocalPlaneRaftTempControlStatusSettingsAppliedEvent item_ = (FocalPlaneRaftTempControlStatusSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((Object)raft_TempControl_active, (Object)item_.isRaft_TempControl_active());
    }

    @Test
    public void sendReceiveFocalPlaneRaftTempControlSettingsAppliedEvent() throws Exception {
        int priority = 280;
        int version = 320;
        String raftLocation = "n";
        double raft_TempControl_awGain = 0.14355623722076416;
        double raft_TempControl_basePower = 0.39347296953201294;
        double raft_TempControl_gain = 0.020060718059539795;
        double raft_TempControl_maxInput = 0.07311499118804932;
        double raft_TempControl_maxOutput = 0.9141726493835449;
        double raft_TempControl_minInput = 0.8184577226638794;
        double raft_TempControl_minOutput = 0.017766296863555908;
        String raft_TempControl_rebs = "";
        double raft_TempControl_setTemp = 0.03238457441329956;
        double raft_TempControl_smoothTime = 0.4474249f;
        String raft_TempControl_tempChans = "q";
        double raft_TempControl_timeConst = 0.6806038618087769;
        double raft_TempControl_tolerance = 0.6685231328010559;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRaftTempControlSettingsAppliedEvent(priority, version, raftLocation, raft_TempControl_awGain, raft_TempControl_basePower, raft_TempControl_gain, raft_TempControl_maxInput, raft_TempControl_maxOutput, raft_TempControl_minInput, raft_TempControl_minOutput, raft_TempControl_rebs, raft_TempControl_setTemp, raft_TempControl_smoothTime, raft_TempControl_tempChans, raft_TempControl_timeConst, raft_TempControl_tolerance));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRaftTempControlSettingsAppliedEvent));
        FocalPlaneRaftTempControlSettingsAppliedEvent item_ = (FocalPlaneRaftTempControlSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((double)raft_TempControl_awGain, (double)item_.getRaft_TempControl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_basePower, (double)item_.getRaft_TempControl_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_gain, (double)item_.getRaft_TempControl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_maxInput, (double)item_.getRaft_TempControl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_maxOutput, (double)item_.getRaft_TempControl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_minInput, (double)item_.getRaft_TempControl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_minOutput, (double)item_.getRaft_TempControl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)raft_TempControl_rebs, (Object)item_.getRaft_TempControl_rebs());
        Assert.assertEquals((double)raft_TempControl_setTemp, (double)item_.getRaft_TempControl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_smoothTime, (double)item_.getRaft_TempControl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)raft_TempControl_tempChans, (Object)item_.getRaft_TempControl_tempChans());
        Assert.assertEquals((double)raft_TempControl_timeConst, (double)item_.getRaft_TempControl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_tolerance, (double)item_.getRaft_TempControl_tolerance(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocalPlaneDAQSettingsAppliedEvent() throws Exception {
        int priority = 876;
        int version = 420;
        String daqFolder = "";
        String daqPartition = "";
        boolean emulatedDAQ = true;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneDAQSettingsAppliedEvent(priority, version, daqFolder, daqPartition, emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneDAQSettingsAppliedEvent));
        FocalPlaneDAQSettingsAppliedEvent item_ = (FocalPlaneDAQSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
    }

    @Test
    public void sendReceiveFocalPlaneSequencerConfigSettingsAppliedEvent() throws Exception {
        int priority = 12;
        String clearCountParameter = "";
        String clearMain = "v";
        String idleFlushMain = "a";
        String integrateMain = "r";
        String metaDataRegisters = "";
        int overCols = 755;
        int overRows = 456;
        int postCols = 985;
        int postRows = 558;
        int preCols = 404;
        int preRows = 683;
        String pseudoReadMain = "";
        int readCols = 634;
        int readCols2 = 649;
        String readMain = "m";
        int readRows = 416;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "l";
        boolean scanMode = false;
        String sequencer = "t";
        String sequencerChecksums = "t";
        String shiftCountParameter = "r";
        int transparentMode = 380;
        int underCols = 738;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSequencerConfigSettingsAppliedEvent(priority, clearCountParameter, clearMain, idleFlushMain, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, transparentMode, underCols));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSequencerConfigSettingsAppliedEvent));
        FocalPlaneSequencerConfigSettingsAppliedEvent item_ = (FocalPlaneSequencerConfigSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
    }

    @Test
    public void sendReceiveFocalPlaneRebRaftsSettingsAppliedEvent() throws Exception {
        int priority = 961;
        int version = 448;
        double bias0_csGateP = 0.026497721672058105;
        double bias0_gdP = 0.7373479604721069;
        double bias0_odP = 0.4780054f;
        double bias0_ogP = 0.8429917097091675;
        double bias0_rdP = 0.2622036933898926;
        double bias1_csGateP = 0.6932491064071655;
        double bias1_gdP = 0.43241333961486816;
        double bias1_odP = 0.015633821487426758;
        double bias1_ogP = 0.6682465672492981;
        double bias1_rdP = 0.9804776906967163;
        double bias2_csGateP = 0.7677831649780273;
        double bias2_gdP = 0.15662521123886108;
        double bias2_odP = 0.6948150396347046;
        double bias2_ogP = 0.47126704454421997;
        double bias2_rdP = 0.11190629005432129;
        double dac_pclkHighP = 0.09223568439483643;
        double dac_pclkLowP = 0.09786117076873779;
        double dac_rgHighP = 0.09202694892883301;
        double dac_rgLowP = 0.2811485528945923;
        double dac_sclkHighP = 0.20048797130584717;
        double dac_sclkLowP = 0.9146711230278015;
        boolean disableRTDHardwareCheck = true;
        String location = "";
        int serialNum = 412;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRebRaftsSettingsAppliedEvent(priority, version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRebRaftsSettingsAppliedEvent));
        FocalPlaneRebRaftsSettingsAppliedEvent item_ = (FocalPlaneRebRaftsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)bias0_csGateP, (double)item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_gdP, (double)item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_odP, (double)item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogP, (double)item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdP, (double)item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_csGateP, (double)item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdP, (double)item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_odP, (double)item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogP, (double)item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdP, (double)item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_csGateP, (double)item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdP, (double)item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_odP, (double)item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogP, (double)item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdP, (double)item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighP, (double)item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowP, (double)item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighP, (double)item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowP, (double)item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighP, (double)item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowP, (double)item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertEquals((Object)disableRTDHardwareCheck, (Object)item_.isDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((long)serialNum, (long)item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocalPlaneRebRaftsPowerSettingsAppliedEvent() throws Exception {
        int priority = 610;
        int version = 181;
        double bias0_gdCal = 0.7762812376022339;
        double bias0_gdTestVolts = 0.7888868451118469;
        double bias0_gdTol = 0.0405619740486145;
        double bias0_gdValueErr = 2.7757883071899414E-4;
        double bias0_gdZeroErr = 0.752791702747345;
        double bias0_odCal = 0.6035393476486206;
        double bias0_odIMax = 0.5431790947914124;
        double bias0_odTol = 0.7521548271179199;
        double bias0_odZeroErr = 0.611293613910675;
        double bias0_ogCal = 0.3229595422744751;
        double bias0_ogTestVolts = 0.8843878507614136;
        double bias0_ogTol = 0.5941145420074463;
        double bias0_ogValueErr = 0.5113627910614014;
        double bias0_ogZeroErr = 0.3691990375518799;
        double bias0_rdCal = 0.0349254f;
        double bias0_rdTestVolts = 0.07047587633132935;
        double bias0_rdTol = 0.744737982749939;
        double bias0_rdValueErr = 0.734065055847168;
        double bias0_rdZeroErr = 0.741792f;
        double bias1_gdCal = 0.23617452383041382;
        double bias1_gdTestVolts = 0.08176732063293457;
        double bias1_gdTol = 0.8670662641525269;
        double bias1_gdValueErr = 0.837917685508728;
        double bias1_gdZeroErr = 0.22544550895690918;
        double bias1_odCal = 0.10895282030105591;
        double bias1_odIMax = 0.5191545486450195;
        double bias1_odTol = 0.7961177229881287;
        double bias1_odZeroErr = 0.6106455326080322;
        double bias1_ogCal = 0.3151012659072876;
        double bias1_ogTestVolts = 0.6496312618255615;
        double bias1_ogTol = 0.7875327467918396;
        double bias1_ogValueErr = 0.18881899118423462;
        double bias1_ogZeroErr = 0.8483423590660095;
        double bias1_rdCal = 0.11595678329467773;
        double bias1_rdTestVolts = 0.571389f;
        double bias1_rdTol = 0.7984322309494019;
        double bias1_rdValueErr = 0.4590691328048706;
        double bias1_rdZeroErr = 0.10363179445266724;
        double bias2_gdCal = 0.3349548f;
        double bias2_gdTestVolts = 0.5211735963821411;
        double bias2_gdTol = 0.9351938366889954;
        double bias2_gdValueErr = 0.6011621952056885;
        double bias2_gdZeroErr = 0.5233348608016968;
        double bias2_odCal = 0.6257666945457458;
        double bias2_odIMax = 0.17463302612304688;
        double bias2_odTol = 0.6843522191047668;
        double bias2_odZeroErr = 0.3546783924102783;
        double bias2_ogCal = 0.46490478515625;
        double bias2_ogTestVolts = 0.10239458084106445;
        double bias2_ogTol = 0.711392879486084;
        double bias2_ogValueErr = 0.16704648733139038;
        double bias2_ogZeroErr = 0.2358495593070984;
        double bias2_rdCal = 0.6809166073799133;
        double bias2_rdTestVolts = 0.5276538729667664;
        double bias2_rdTol = 0.7512941360473633;
        double bias2_rdValueErr = 0.6937392950057983;
        double bias2_rdZeroErr = 0.8654171228408813;
        double clkhiAmin = 0.4845951795578003;
        double clkhiQmax = 0.1056789755821228;
        double clkliAmin = 0.08863133192062378;
        double clkliQmax = 0.1820812225341797;
        double dac_clkhIMax = 0.05427068471908569;
        double dac_clklIMax = 0.5214723944664001;
        double dac_pclkHighCal = 0.4478017f;
        double dac_pclkHighTestV = 0.6452009081840515;
        double dac_pclkHighTol = 0.3985958695411682;
        double dac_pclkHighValueErr = 0.9466773271560669;
        double dac_pclkHighZeroErr = 0.8995060920715332;
        double dac_pclkLowCal = 0.5472736358642578;
        double dac_pclkLowTestV = 0.7756286859512329;
        double dac_pclkLowTol = 0.2522529363632202;
        double dac_pclkLowValueErr = 0.7295560836791992;
        double dac_pclkLowZeroErr = 0.6490641236305237;
        double dac_rgHighCal = 0.7439114451408386;
        double dac_rgHighTestV = 0.37032806873321533;
        double dac_rgHighTol = 0.8646038174629211;
        double dac_rgHighValueErr = 0.9383781552314758;
        double dac_rgHighZeroErr = 0.8864242434501648;
        double dac_rgLowCal = 0.5181974172592163;
        double dac_rgLowTestV = 0.21348637342453003;
        double dac_rgLowTol = 0.2185397744178772;
        double dac_rgLowValueErr = 0.10950464010238647;
        double dac_rgLowZeroErr = 0.5500080585479736;
        double dac_sclkHighCal = 0.8885334730148315;
        double dac_sclkHighTestV = 0.710189f;
        double dac_sclkHighTol = 0.3864247798919678;
        double dac_sclkHighValueErr = 0.2776535749435425;
        double dac_sclkHighZeroErr = 0.5311670303344727;
        double dac_sclkLowCal = 0.8110361695289612;
        double dac_sclkLowTestV = 0.283031165599823;
        double dac_sclkLowTol = 0.7143215537071228;
        double dac_sclkLowValueErr = 0.4298403859138489;
        double dac_sclkLowZeroErr = 0.4437502f;
        String location = "";
        double maxDelta = 0.16232693195343018;
        double maxStep = 0.6334140300750732;
        double minTol = 0.6464796662330627;
        int nPowerOnPub = 81;
        double odiAmin = 0.8883883357048035;
        double odiQmax = 0.010107755661010742;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRebRaftsPowerSettingsAppliedEvent(priority, version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRebRaftsPowerSettingsAppliedEvent));
        FocalPlaneRebRaftsPowerSettingsAppliedEvent item_ = (FocalPlaneRebRaftsPowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)bias0_gdCal, (double)item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_gdTestVolts, (double)item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_gdTol, (double)item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_gdValueErr, (double)item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_gdZeroErr, (double)item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_odCal, (double)item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_odIMax, (double)item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_odTol, (double)item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_odZeroErr, (double)item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogCal, (double)item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogTestVolts, (double)item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogTol, (double)item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogValueErr, (double)item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogZeroErr, (double)item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdCal, (double)item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdTestVolts, (double)item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdTol, (double)item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdValueErr, (double)item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdZeroErr, (double)item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdCal, (double)item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdTestVolts, (double)item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdTol, (double)item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdValueErr, (double)item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdZeroErr, (double)item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_odCal, (double)item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_odIMax, (double)item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_odTol, (double)item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_odZeroErr, (double)item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogCal, (double)item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogTestVolts, (double)item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogTol, (double)item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogValueErr, (double)item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogZeroErr, (double)item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdCal, (double)item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdTestVolts, (double)item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdTol, (double)item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdValueErr, (double)item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdZeroErr, (double)item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdCal, (double)item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdTestVolts, (double)item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdTol, (double)item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdValueErr, (double)item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdZeroErr, (double)item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_odCal, (double)item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_odIMax, (double)item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_odTol, (double)item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_odZeroErr, (double)item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogCal, (double)item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogTestVolts, (double)item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogTol, (double)item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogValueErr, (double)item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogZeroErr, (double)item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdCal, (double)item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdTestVolts, (double)item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdTol, (double)item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdValueErr, (double)item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdZeroErr, (double)item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhiAmin, (double)item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhiQmax, (double)item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertEquals((double)clkliAmin, (double)item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertEquals((double)clkliQmax, (double)item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_clkhIMax, (double)item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_clklIMax, (double)item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighCal, (double)item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighTestV, (double)item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighTol, (double)item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighValueErr, (double)item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighZeroErr, (double)item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowCal, (double)item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowTestV, (double)item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowTol, (double)item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowValueErr, (double)item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowZeroErr, (double)item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighCal, (double)item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighTestV, (double)item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighTol, (double)item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighValueErr, (double)item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighZeroErr, (double)item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowCal, (double)item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowTestV, (double)item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowTol, (double)item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowValueErr, (double)item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowZeroErr, (double)item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighCal, (double)item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighTestV, (double)item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighTol, (double)item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighValueErr, (double)item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighZeroErr, (double)item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowCal, (double)item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowTestV, (double)item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowTol, (double)item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowValueErr, (double)item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowZeroErr, (double)item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((double)maxDelta, (double)item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertEquals((double)maxStep, (double)item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertEquals((double)minTol, (double)item_.getMinTol(), (double)1.0E-6f);
        Assert.assertEquals((long)nPowerOnPub, (long)item_.getNPowerOnPub());
        Assert.assertEquals((double)odiAmin, (double)item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertEquals((double)odiQmax, (double)item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitorSettingsAppliedEvent() throws Exception {
        int priority = 607;
        int version = 108;
        String daqPartition = "d";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitorSettingsAppliedEvent(priority, version, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitorSettingsAppliedEvent));
        Daq_monitorSettingsAppliedEvent item_ = (Daq_monitorSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_StatsSettingsAppliedEvent() throws Exception {
        int priority = 73;
        int version = 879;
        boolean enablePeriodicPublication = true;
        int minDiffAlertWarning = 762;
        int minDiffLogWarning = 705;
        String sumDriverChecks = "";
        String sumDriverStats = "";
        String sumFirmwareChecks = "v";
        String sumFirmwareStats = "";
        String sumRdsChecks = "";
        String sumRdsStats = "f";
        String sumRmsChecks = "n";
        String sumRmsStats = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StatsSettingsAppliedEvent(priority, version, enablePeriodicPublication, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StatsSettingsAppliedEvent));
        Daq_monitor_StatsSettingsAppliedEvent item_ = (Daq_monitor_StatsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)enablePeriodicPublication, (Object)item_.isEnablePeriodicPublication());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreSettingsAppliedEvent() throws Exception {
        int priority = 984;
        int version = 923;
        String daqFolder = "b";
        boolean enableAutoPurge = true;
        double purgeTarget = 0.9880751371383667;
        double purgeThreshold = 0.0881474f;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreSettingsAppliedEvent(priority, version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreSettingsAppliedEvent));
        Daq_monitor_StoreSettingsAppliedEvent item_ = (Daq_monitor_StoreSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveShutterBladeMotionProfileEvent() throws Exception {
        int priority = 677;
        ShutterBladeMotionProfileEvent.Blade blade = ShutterBladeMotionProfileEvent.Blade.PLUS_X;
        ShutterBladeMotionProfileEvent.Direction direction = ShutterBladeMotionProfileEvent.Direction.OPEN;
        double timestampStart = 0.2364257f;
        double startPosition = 0.06057637929916382;
        double targetDuration = 0.2795097231864929;
        double targetPosition = 0.6227433681488037;
        double endPosition = 0.5955899357795715;
        double actualDuration = 0.07762682437896729;
        int hallSensorCount = 6;
        double[] timestampHallSensor = new double[]{0.8872032761573792, 0.3791808f, 0.8549120426177979, 0.041434288024902344, 0.4745718240737915, 0.8218094706535339, 0.8981080651283264, 0.6200982928276062, 0.841245710849762, 0.7808223366737366, 0.561198353767395, 0.11076831817626953, 0.0362359881401062, 0.2166774868965149, 0.5074688792228699, 0.2082958221435547, 0.5552515387535095, 0.19328314065933228, 0.6300828456878662, 0.84812f, 0.3188076615333557, 0.4344951f, 0.5914474725723267, 0.284894f, 0.5752735137939453, 0.2993737459182739, 0.9198556542396545, 0.8859411478042603, 0.284783f, 0.2468610405921936, 0.7000638246536255, 0.445568323135376, 0.18660366535186768, 0.3535655736923218, 0.2734687328338623, 0.7526744604110718, 0.791869044303894, 0.3327948f, 0.1259095f, 0.2006917f, 0.24213123321533203, 0.33841103315353394, 0.7800118327140808, 0.6705657839775085, 0.6142090559005737, 0.8862087726593018, 0.15819251537322998, 0.8272294402122498, 0.3811434f, 0.7041372656822205, 0.5663792490959167, 0.5089836716651917, 0.4212055802345276, 0.6497701406478882, 0.3321990370750427, 0.546629011631012, 0.03093355894088745, 0.8810170888900757, 0.770524263381958, 0.19247084856033325, 0.6888233423233032, 0.8093852400779724, 0.7401184439659119, 0.2639627f, 0.9439328908920288, 0.5324458479881287, 0.6846141219139099, 0.08638501167297363, 0.3942340612411499, 0.1649875044822693, 0.9467206597328186, 0.6553415060043335, 0.6646828651428223, 0.9512182474136353, 0.9245601296424866, 0.01287013292312622, 0.0018898248672485352, 0.13100403547286987, 0.5621614456176758, 0.348626971244812, 0.2438182234764099, 0.0923229455947876, 0.8818138241767883, 0.5860308408737183, 0.6875885128974915, 0.41382116079330444, 0.06423187255859375, 0.3067221f, 0.7203307151794434, 0.4826417565345764, 0.6439829468727112, 0.497566282749176, 0.9668222069740295, 0.663765013217926, 0.033656537532806396, 0.2932351231575012, 0.37873637676239014, 0.6512604355812073, 0.03273433446884155, 0.23275268077850342, 0.8946744203567505, 0.0055582523345947266, 0.5685842633247375, 0.4770635962486267, 0.5543696880340576, 0.7836690545082092, 0.40061742067337036, 0.4515455961227417, 0.786760687828064, 0.11390924453735352, 0.27820414304733276, 0.8154560327529907, 0.8078804016113281, 0.01894927f, 0.3528527021408081, 0.9307073354721069, 0.974181592464447, 0.41983598470687866, 0.9204593300819397, 0.844366192817688, 0.6191104650497437, 0.18111753463745117, 0.6157971620559692, 0.5302456617355347, 0.45018547773361206, 0.1085214f, 0.44511836767196655, 0.9004220366477966, 0.36087822914123535, 0.7641117572784424, 0.8607092499732971, 0.12108564376831055, 0.39221322536468506, 0.8009426593780518, 0.9310056567192078, 0.6005901098251343, 0.20480185747146606, 0.674481213092804, 0.40960294008255005, 0.7907758355140686, 0.450225293636322, 0.19921225309371948, 0.6649788618087769, 0.6136229634284973, 0.784142255783081, 0.5766582489013672, 0.3993929f, 0.9301658272743225, 0.380687f, 0.5195137858390808, 0.4002823829650879, 0.37163597345352173, 0.8927491903305054, 0.6827614307403564, 0.16119670867919922, 0.9963732957839966, 0.07531487941741943, 0.2367112f, 0.6531934142112732, 0.3906674385070801, 0.2345457673072815, 0.482200026512146, 0.2835758328437805, 0.8459919691085815, 0.2846637964248657, 0.5211543440818787, 0.7494170665740967, 0.29583287239074707, 0.25458717346191406, 0.2159196138381958, 0.07165837287902832, 0.53737473487854, 0.3688596487045288, 0.7609010338783264, 0.2154766321182251, 0.4796936511993408, 0.380581796169281, 0.8659494519233704, 0.8885037302970886, 0.4119594097137451, 0.2212618f, 0.7315186858177185, 0.02538210153579712, 0.5617164969444275, 0.5828642249107361, 0.05298245f, 0.17073094844818115, 0.08198577165603638, 0.10556250810623169, 0.300825834274292, 0.15915173292160034, 0.4622097f, 0.021161377429962158, 0.5130382180213928, 0.7473477721214294, 0.6755883693695068, 0.5228105187416077, 0.037378907203674316, 0.9072979688644409, 0.9558776617050171, 0.688093900680542, 0.7588313817977905, 0.4588811993598938, 0.3201286196708679, 0.3820696473121643, 0.7292030453681946, 0.36418086290359497, 0.02814584970474243, 0.382207453250885, 0.12228578329086304, 0.973324716091156, 0.38076627254486084, 0.6869021058082581, 0.6132139563560486, 0.5931679606437683, 0.22166311740875244, 0.04742974042892456, 0.6217074990272522, 0.1260806918144226, 0.41364985704421997, 0.6695913672447205, 0.06597131490707397, 0.01783144474029541, 0.4308992028236389, 0.5011999607086182, 4.4840574264526367E-4, 0.07299137115478516, 0.14174103736877441, 0.8059961199760437, 0.6128490567207336, 0.6959515810012817, 0.2795097231864929, 0.8401201963424683, 0.8434627056121826, 0.03871506452560425, 0.01616931f, 0.42615455389022827, 0.3754054307937622, 0.2668830156326294, 0.29815244674682617};
        int[] hallSensorID = new int[]{68, 333, 427, 605, 880, 253, 235, 553, 355, 719, 230, 441, 318, 679, 846, 89, 63, 348, 159, 874, 956, 722, 738, 242, 263, 694, 337, 178, 261, 133, 237, 380, 289, 625, 74, 622, 134, 962, 181, 615, 105, 277, 692, 813, 84, 219, 251, 913, 951, 512, 735, 600, 106, 485, 11, 870, 797, 525, 704, 681, 800, 202, 402, 519, 630, 865, 757, 341, 708, 144, 102, 22, 32, 802, 30, 868, 197, 509, 321, 254, 810, 177, 653, 21, 122, 540, 94, 133, 446, 206, 894, 269, 526, 839, 538, 746, 280, 448, 751, 342, 855, 949, 667, 129, 708, 804, 617, 249, 298, 706, 444, 164, 523, 251, 916, 655, 808, 299, 119, 625, 638, 270, 294, 401, 764, 89, 624, 32, 393, 715, 397, 309, 522, 771, 424, 388, 529, 175, 576, 10, 417, 598, 848, 79, 670, 235, 585, 208, 842, 38, 769, 239, 993, 496, 869, 682, 374, 476, 490, 557, 366, 525, 265, 565, 106, 583, 249, 267, 515, 222, 127, 800, 670, 429, 224, 819, 927, 868, 927, 780, 41, 185, 73, 772, 155, 81, 269, 956, 583, 371, 970, 582, 172, 314, 161, 235, 811, 53, 106, 546, 982, 69, 330, 210, 396, 554, 361, 76, 554, 594, 946, 784, 811, 775, 235, 187, 112, 68, 668, 274, 51, 332, 413, 941, 341, 711, 112, 427, 568, 25, 478, 757, 558, 177, 702, 402, 480, 627, 847, 791};
        double[] hallSensorPosition = new double[]{0.4517327547073364, 0.9946938753128052, 0.11279827356338501, 0.8843053579330444, 0.9963942170143127, 0.4767602f, 0.7324386835098267, 0.0687408447265625, 0.14175671339035034, 0.2010408f, 0.16168522834777832, 0.02596902847290039, 0.35271936655044556, 0.522193193435669, 0.05116891860961914, 0.8524715900421143, 0.677761971950531, 0.6856864094734192, 0.15195822715759277, 0.7192482352256775, 0.8364443778991699, 0.161748468875885, 0.6321895122528076, 0.10460102558135986, 0.7797408103942871, 0.7016832828521729, 0.0922970175743103, 0.8619933128356934, 0.3623538017272949, 0.33647865056991577, 0.10063028335571289, 0.710841f, 0.6896804571151733, 0.4579014182090759, 0.2700703740119934, 0.27534347772598267, 0.5729556679725647, 0.8949098587036133, 0.7206348180770874, 0.8623384237289429, 0.4858793616294861, 0.45777201652526855, 0.5911467671394348, 0.393549382686615, 0.6219715476036072, 0.40645831823349, 0.0836363434791565, 0.748494029045105, 0.5268413424491882, 0.29950016736984253, 0.24664908647537231, 0.767871618270874, 0.2619808316230774, 0.48851585388183594, 0.3681f, 0.177703857421875, 0.8507076501846313, 0.3890703320503235, 0.8853934407234192, 0.16424894332885742, 0.582197368144989, 0.5306582450866699, 0.2015218734741211, 0.5292513370513916, 0.5915347337722778, 0.17069f, 0.6826686859130859, 0.6330636143684387, 0.49333226680755615, 0.05587393045425415, 0.5080180764198303, 0.3663373f, 0.9903306365013123, 0.28888654708862305, 0.43917596340179443, 0.4342119097709656, 0.5887249112129211, 0.47140854597091675, 0.10862231254577637, 0.3732417821884155, 0.376612f, 0.562292f, 0.11836177110671997, 0.11182254552841187, 0.32439786195755005, 0.630763053894043, 0.2564527988433838, 0.018869996070861816, 0.5753469467163086, 0.7712225317955017, 0.03604203462600708, 0.3303477168083191, 0.5554215312004089, 0.4535815119743347, 0.7351964116096497, 0.49444258213043213, 0.5544989109039307, 0.03947758674621582, 0.2531300187110901, 0.307384f, 0.3419477939605713, 0.8316075205802917, 0.6268974542617798, 0.02484762668609619, 0.7699902057647705, 0.025355935096740723, 0.590442f, 0.808464765548706, 0.5955008864402771, 0.18658453226089478, 0.3638281226158142, 0.6111805438995361, 0.5877537727355957, 0.22770464420318604, 0.08397293090820312, 0.705195426940918, 0.5745881199836731, 0.3399214f, 0.2192559838294983, 0.6262549161911011, 0.3666437268257141, 0.45988816022872925, 0.6296939253807068, 0.040489912033081055, 0.45842164754867554, 0.8041380643844604, 0.963213324546814, 0.4553758502006531, 0.2713279128074646, 0.947884738445282, 0.0288409f, 0.39329564571380615, 0.22851771116256714, 0.21255344152450562, 0.011912405490875244, 0.5514242649078369, 0.6508852243423462, 0.568288266658783, 0.637826144695282, 0.09007900953292847, 0.8701666593551636, 0.36637115478515625, 0.03323858976364136, 0.8563101887702942, 0.8666839003562927, 0.45781224966049194, 0.3513185381889343, 0.4714767336845398, 0.46924442052841187, 0.2972654700279236, 0.6357949376106262, 0.5301083922386169, 0.7822174429893494, 0.5979655385017395, 0.7027034163475037, 0.9898995161056519, 0.12456047534942627, 0.8187646269798279, 0.4652571678161621, 0.3246997594833374, 0.7379271984100342, 0.006887316703796387, 0.4530452489852905, 0.3875085115432739, 0.721917450428009, 0.27117353677749634, 0.7593408823013306, 0.7404987812042236, 0.7256408929824829, 0.854900598526001, 0.157843f, 0.583867609500885, 0.5232800841331482, 0.5524739623069763, 0.17146915197372437, 0.312854528427124, 0.6501095294952393, 0.161163330078125, 0.8502786159515381, 0.1887073516845703, 0.21293115615844727, 0.07158505916595459, 0.4632687568664551, 0.9889718294143677, 0.019225597381591797, 0.7258667349815369, 0.16032713651657104, 0.747619f, 0.5122162699699402, 0.9605627059936523, 0.487312376499176, 0.576705813407898, 0.13985759019851685, 0.6057502627372742, 0.9010071754455566, 0.9271302223205566, 0.7254574298858643, 0.7387614846229553, 0.7340636253356934, 0.6733422875404358, 0.912837028503418, 0.7502734661102295, 0.3962177038192749, 0.8504967093467712, 0.6118409037590027, 0.6346777081489563, 0.6007689237594604, 0.3154820203781128, 0.6184857487678528, 0.3816053867340088, 0.5990188121795654, 0.7066761255264282, 0.7915622591972351, 0.9401387572288513, 0.4550822377204895, 0.8304072618484497, 0.6631735563278198, 0.3236621022224426, 0.3548798f, 0.5723358392715454, 0.48923712968826294, 0.09669744968414307, 0.512495f, 0.014815092086791992, 0.11774694919586182, 0.7637425661087036, 0.0013309121131896973, 0.1103748083114624, 0.7935634851455688, 0.695536732673645, 0.5241841077804565, 0.8185601234436035, 0.02027106285095215, 0.8648861050605774, 0.86362f, 0.4383272f, 0.7694481611251831, 0.20988517999649048, 0.28067994117736816, 0.16905808448791504};
        boolean[] hallSensorTransition = new boolean[]{true, false, false, true, true, false, true, false, false, true, true, true, false, true, true, false, true, false, false, true, false, true, false, true, true, true, false, false, true, false, true, false, false, true, false, true, true, true, true, false, true, true, true, false, false, false, true, true, true, false, false, false, true, false, true, false, true, false, true, true, false, false, false, false, false, false, true, false, false, true, false, false, true, false, false, false, true, true, false, false, true, false, false, false, true, false, false, false, true, true, true, true, true, true, false, true, false, false, false, false, false, false, false, true, true, false, false, true, true, false, false, true, false, false, false, false, false, false, true, false, true, false, false, true, true, false, true, true, true, true, false, false, true, true, true, true, false, false, false, true, true, false, true, false, true, false, false, false, true, true, false, true, true, true, false, false, false, false, false, true, false, true, false, false, false, true, false, true, true, true, true, false, true, true, false, true, false, true, false, false, false, false, true, true, false, true, false, true, true, false, false, false, false, false, true, false, false, true, true, false, true, false, true, true, false, true, true, true, false, true, true, false, true, true, false, false, true, true, false, false, true, true, false, false, true, true, false, false, true, true, true, false, true, true, true, true, false, true, false, true};
        int encoderCount = 445;
        double[] timestampEncoder = new double[]{0.06898140907287598, 0.13688474893569946, 0.4649277329444885, 0.32647645473480225, 0.6774181127548218, 0.07293188571929932, 0.2858484983444214, 0.1931876540184021, 0.042186856269836426, 0.2089687f, 0.3314070701599121, 0.8635f, 0.7868179678916931, 0.04214549f, 0.9800314903259277, 0.013203442096710205, 0.25569117069244385, 0.20352166891098022, 0.250063419342041, 0.3943629264831543, 0.9378864169120789, 0.9141576886177063, 0.8772063255310059, 0.3102787733078003, 0.8030017614364624, 0.7286413311958313, 0.5008583068847656, 0.4470691680908203, 0.28140032291412354, 0.7706174850463867, 0.47354668378829956, 0.7385295629501343, 0.7813725471496582, 0.24604082107543945, 0.2682746648788452, 0.7058215737342834, 0.1090155839920044, 0.46875715255737305, 0.8462410569190979, 0.9970532655715942, 0.25281256437301636, 0.1928073763847351, 0.6669959425926208, 0.6861705183982849, 0.7266314625740051, 0.600325345993042, 0.10764491558074951, 0.573624312877655, 0.9979845881462097, 0.6174829006195068, 0.8183566927909851, 0.07649964094161987, 0.6318298578262329, 0.23866015672683716, 0.2174096703529358, 0.8822810649871826, 0.27603602409362793, 0.5365505218505859, 0.7377258539199829, 0.9629201292991638, 0.8280600905418396, 0.969538688659668, 0.22378402948379517, 0.6647076606750488, 0.3317262530326843, 0.30432742834091187, 0.7666182518005371, 0.7806218862533569, 0.8396885991096497, 0.9289778470993042, 0.3070452809333801, 0.9169155359268188, 0.57578444480896, 0.907426655292511, 0.16321277618408203, 0.2419554591178894, 0.8797241449356079, 0.8299506306648254, 0.7060214877128601, 0.2755822539329529, 0.20525145530700684, 0.24436503648757935, 0.25108712911605835, 0.6799971461296082, 0.6659785509109497, 0.25002098083496094, 0.7229271531105042, 0.7525046467781067, 0.5276303291320801, 0.13155996799468994, 0.2183634638786316, 0.2160738706588745, 0.5816146731376648, 0.7731895446777344, 0.5222405195236206, 0.9409773945808411, 0.4059907793998718, 0.9888686537742615, 0.25809115171432495, 0.9107029438018799, 0.2324819564819336, 0.9317814707756042, 0.36610865592956543, 0.3345072269439697, 0.05174213647842407, 0.9009913802146912, 0.2455756664276123, 0.5896274447441101, 0.9663316607475281, 0.2779970169067383, 0.2617756724357605, 0.19612634181976318, 0.8576100468635559, 0.0254705548286438, 0.5594959259033203, 0.3501044511795044, 0.5879529118537903, 0.32978355884552, 0.735785186290741, 0.49566978216171265, 0.08542346954345703, 0.1236853f, 0.971034824848175, 0.8473304510116577, 0.3294628858566284, 0.5819786190986633, 0.5952181816101074, 0.7927321195602417, 0.0016371607780456543, 0.32815104722976685, 0.7488806247711182, 0.3368644118309021, 0.11643165349960327, 0.25121062994003296, 0.08798271417617798, 0.5846213102340698, 0.48808616399765015, 0.1276019811630249, 0.2578394412994385, 0.10613560676574707, 0.3082171082496643, 0.9318339228630066, 0.8321828842163086, 0.5614796280860901, 0.24628931283950806, 0.9507452249526978, 0.3649328351020813, 0.3665999174118042, 0.38482964038848877, 0.8802147507667542, 0.2488483190536499, 0.4148409366607666, 0.4606884f, 0.6602405309677124, 0.9092357754707336, 0.8978352546691895, 0.50284343957901, 0.21597141027450562, 0.002817809581756592, 0.33124858140945435, 0.1895303726196289, 0.7303743362426758, 0.34034425020217896, 0.735842227935791, 0.4493151903152466, 0.931314f, 0.1333240270614624, 0.06915563344955444, 0.8116698861122131, 0.8750594854354858, 0.38524436950683594, 0.9800442457199097, 0.28536665439605713, 0.2334151268005371, 0.1388377547264099, 0.5651848912239075, 0.5733909606933594, 0.41720718145370483, 0.26448744535446167, 0.35695648193359375, 0.8900324106216431, 0.4097848f, 0.2699854373931885, 0.3449241f, 0.6514145731925964, 0.7461811900138855, 0.5459582805633545, 0.5232203006744385, 0.690171480178833, 0.10290920734405518, 0.679862916469574, 0.6237860321998596, 0.17658203840255737, 0.7969587445259094, 0.1981566f, 0.2166767716407776, 0.09368312358856201, 0.6079548001289368, 0.8828257322311401, 0.8750627636909485, 0.3472723364830017, 0.6027861833572388, 0.7847954034805298, 0.2713779807090759, 0.5309661030769348, 0.566125750541687, 0.18084394931793213, 0.8151566982269287, 0.10243260860443115, 0.6225319504737854, 0.02865135669708252, 0.20091331005096436, 0.5535042881965637, 0.216303288936615, 0.33076733350753784, 0.21007037162780762, 0.8211714029312134, 0.724603533744812, 0.1649855375289917, 0.524152934551239, 0.1386559009552002, 0.18888407945632935, 0.746355f, 0.6425913572311401, 0.16918432712554932, 0.4212082624435425, 0.6034871339797974, 0.25848788022994995, 0.20617163181304932, 0.6782745122909546, 0.955681f, 0.3962072f, 0.5218521356582642, 0.1899036169052124, 0.4225732088088989, 0.03787273168563843, 0.3646594285964966, 0.7142853140830994, 0.8675350546836853, 0.9096395373344421};
        double[] encoderPosition = new double[]{0.3596722483634949, 0.4937942624092102, 0.1310117244720459, 0.12645351886749268, 0.0751606822013855, 0.1677112579345703, 0.6396954655647278, 0.8349857330322266, 0.6537532806396484, 0.41739994287490845, 0.9492185115814209, 0.1932897f, 0.74419766664505, 0.07167041301727295, 0.5874601602554321, 0.592810332775116, 0.5374249219894409, 0.67213f, 0.5862097144126892, 0.08965545892715454, 0.7400966882705688, 0.8178134560585022, 0.6225771307945251, 0.4591280221939087, 0.4945831894874573, 0.09346562623977661, 0.11807596683502197, 0.02763331f, 0.9640874862670898, 0.7953070998191833, 0.17072665691375732, 0.6420723795890808, 0.8862138390541077, 0.6513652205467224, 0.10997647047042847, 0.4971882104873657, 0.4016244411468506, 0.08052986860275269, 0.3799621f, 0.5101470947265625, 0.8836053609848022, 0.426071f, 0.5660336017608643, 0.978637158870697, 0.0295704f, 0.8567120432853699, 0.703027f, 0.11930537223815918, 0.7800835967063904, 0.9634101986885071, 0.6401426196098328, 0.00840681791305542, 0.5613293051719666, 0.3452872633934021, 0.6132214665412903, 0.452708f, 0.2126712203025818, 0.9168487787246704, 0.2955929f, 0.4381973147392273, 0.7747090458869934, 0.1645141839981079, 0.296500027179718, 0.3348594903945923, 0.04089456796646118, 0.9079667925834656, 0.26252996921539307, 0.7911467552185059, 0.5862413048744202, 0.19596493244171143, 0.6517412066459656, 0.8109247088432312, 0.5020307898521423, 0.09269309043884277, 0.7096713781356812, 0.4633186459541321, 0.610880970954895, 0.2357664704322815, 0.8266355991363525, 0.8923792243003845, 0.7904093265533447, 0.007546544075012207, 0.02032071352005005, 0.1448100209236145, 0.6774519681930542, 0.9350197315216064, 0.8183979392051697, 0.9617493748664856, 0.3929516673088074, 0.8882981538772583, 0.9426085352897644, 0.2420047f, 0.6579023599624634, 0.792611f, 0.3765166401863098, 0.8020473122596741, 0.3539528250694275, 0.8028817176818848, 0.17002063989639282, 0.2709732f, 0.012377262115478516, 0.2536681294441223, 0.5590114593505859, 0.17061054706573486, 0.13917946815490723, 0.6210432052612305, 0.10065692663192749, 0.1617475152015686, 0.6523122191429138, 0.2882046699523926, 0.8141778707504272, 0.0724054f, 0.9226796627044678, 0.055135905742645264, 0.12229812145233154, 0.16417354345321655, 0.0801962f, 0.17703211307525635, 0.38655567169189453, 0.404455304145813, 0.9292687773704529, 0.7496299147605896, 0.27523887157440186, 0.5782743096351624, 0.27734827995300293, 0.6158115863800049, 0.1788643f, 0.4409077763557434, 0.9314776659011841, 0.6713199019432068, 0.5559794902801514, 0.8455294370651245, 0.479996919631958, 0.6631540656089783, 0.9409094452857971, 0.7073533535003662, 0.1218177080154419, 0.8578788042068481, 0.4422512f, 0.6322062015533447, 0.8091465830802917, 0.5049675107002258, 0.8019691109657288, 0.1533641219139099, 0.3595404624938965, 0.9193195104598999, 0.4434826374053955, 0.4118521213531494, 0.7011619210243225, 0.4847882390022278, 0.7149277925491333, 0.17381781339645386, 0.22563612461090088, 0.5550898909568787, 0.6106980443000793, 0.7112863063812256, 0.22369462251663208, 0.3586241f, 0.33843398094177246, 0.9524278044700623, 0.41063958406448364, 0.7489414215087891, 0.9759699106216431, 0.6229037642478943, 0.655523f, 0.27287375926971436, 0.24761521816253662, 0.804999589920044, 0.7068792581558228, 0.23437517881393433, 0.8339337110519409, 0.4058322310447693, 0.15907102823257446, 0.5351780652999878, 0.13439089059829712, 0.6852855086326599, 0.2801274061203003, 0.285383403301239, 0.626501202583313, 0.999459f, 0.9808174967765808, 0.8505963683128357, 0.8351826071739197, 0.7829119563102722, 0.9551782011985779, 0.8803683519363403, 0.9467967748641968, 0.05507081747055054, 0.37750154733657837, 0.32929152250289917, 0.6068287491798401, 0.19070512056350708, 0.9657025337219238, 0.811535120010376, 0.839469f, 0.6548264026641846, 0.3849772810935974, 0.2369445562362671, 0.060768187046051025, 0.947840690612793, 0.9907975792884827, 0.3677181005477905, 0.1419163942337036, 0.23200958967208862, 0.621763288974762, 0.1554107666015625, 0.5610649585723877, 0.37559783458709717, 0.32896852493286133, 0.8055156469345093, 0.08459645509719849, 0.33248448371887207, 0.5507811307907104, 0.9486668705940247, 0.6936050653457642, 0.5140964984893799, 0.7448531985282898, 0.941771388053894, 0.7484720349311829, 0.7645028829574585, 0.010468602180480957, 0.6878884434700012, 0.6218031644821167, 0.6412501335144043, 0.8648171424865723, 0.8498541712760925, 0.26377958059310913, 0.3724910616874695, 0.37040263414382935, 0.47953593730926514, 0.7584148049354553, 0.3092666268348694, 0.9946192502975464, 0.8228532075881958, 0.8266887664794922, 0.140167236328125, 0.36675918102264404, 0.9616162776947021, 0.20355886220932007, 0.06938314437866211};
        SALEvent item = this.testSendReceive((SALEvent)new ShutterBladeMotionProfileEvent(priority, blade, direction, timestampStart, startPosition, targetDuration, targetPosition, endPosition, actualDuration, hallSensorCount, timestampHallSensor, hallSensorID, hallSensorPosition, hallSensorTransition, encoderCount, timestampEncoder, encoderPosition));
        Assert.assertTrue((boolean)(item instanceof ShutterBladeMotionProfileEvent));
        ShutterBladeMotionProfileEvent item_ = (ShutterBladeMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)blade, (Object)item_.getBlade());
        Assert.assertEquals((Object)direction, (Object)item_.getDirection());
        Assert.assertEquals((double)timestampStart, (double)item_.getTimestampStart(), (double)1.0E-6f);
        Assert.assertEquals((double)startPosition, (double)item_.getStartPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)targetDuration, (double)item_.getTargetDuration(), (double)1.0E-6f);
        Assert.assertEquals((double)targetPosition, (double)item_.getTargetPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)endPosition, (double)item_.getEndPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)actualDuration, (double)item_.getActualDuration(), (double)1.0E-6f);
        Assert.assertEquals((long)hallSensorCount, (long)item_.getHallSensorCount());
        Assert.assertArrayEquals((double[])timestampHallSensor, (double[])item_.getTimestampHallSensor(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])hallSensorID, (int[])item_.getHallSensorID());
        Assert.assertArrayEquals((double[])hallSensorPosition, (double[])item_.getHallSensorPosition(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])hallSensorTransition, (boolean[])item_.getHallSensorTransition());
        Assert.assertEquals((long)encoderCount, (long)item_.getEncoderCount());
        Assert.assertArrayEquals((double[])timestampEncoder, (double[])item_.getTimestampEncoder(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])encoderPosition, (double[])item_.getEncoderPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageStoredEvent() throws Exception {
        int priority = 598;
        String imageName = "jiqhkhlzxzryrppjgktyu";
        double timestampImageStored = 0.5943259000778198;
        SALEvent item = this.testSendReceive((SALEvent)new ImageStoredEvent(priority, imageName, timestampImageStored));
        Assert.assertTrue((boolean)(item instanceof ImageStoredEvent));
        ImageStoredEvent item_ = (ImageStoredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampImageStored, (double)item_.getTimestampImageStored(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFitsFilesWrittenEvent() throws Exception {
        int priority = 893;
        String imageName = "adlr";
        double timestampFilesWritten = 0.7916221618652344;
        String rootFileName = "";
        String relativeFileNames = "m";
        String fileNode = "";
        SALEvent item = this.testSendReceive((SALEvent)new FitsFilesWrittenEvent(priority, imageName, timestampFilesWritten, rootFileName, relativeFileNames, fileNode));
        Assert.assertTrue((boolean)(item instanceof FitsFilesWrittenEvent));
        FitsFilesWrittenEvent item_ = (FitsFilesWrittenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampFilesWritten, (double)item_.getTimestampFilesWritten(), (double)1.0E-6f);
        Assert.assertEquals((Object)rootFileName, (Object)item_.getRootFileName());
        Assert.assertEquals((Object)relativeFileNames, (Object)item_.getRelativeFileNames());
        Assert.assertEquals((Object)fileNode, (Object)item_.getFileNode());
    }

    @Test
    public void sendReceiveFileCommandExecutionEvent() throws Exception {
        int priority = 843;
        String imageName = "ugrhrwlveqejngcsnjnep";
        double timestampCommandComplete = 0.3044389f;
        String command = "t";
        int rc = 834;
        SALEvent item = this.testSendReceive((SALEvent)new FileCommandExecutionEvent(priority, imageName, timestampCommandComplete, command, rc));
        Assert.assertTrue((boolean)(item instanceof FileCommandExecutionEvent));
        FileCommandExecutionEvent item_ = (FileCommandExecutionEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampCommandComplete, (double)item_.getTimestampCommandComplete(), (double)1.0E-6f);
        Assert.assertEquals((Object)command, (Object)item_.getCommand());
        Assert.assertEquals((long)rc, (long)item_.getRc());
    }

    @Test
    public void sendReceiveImageVisualizationEvent() throws Exception {
        int priority = 68;
        String imageName = "iibgdriudkkgalhgs";
        double timestampVisualizationAvailable = 0.10707056522369385;
        String url = "s";
        String thumbnail = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageVisualizationEvent(priority, imageName, timestampVisualizationAvailable, url, thumbnail));
        Assert.assertTrue((boolean)(item instanceof ImageVisualizationEvent));
        ImageVisualizationEvent item_ = (ImageVisualizationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampVisualizationAvailable, (double)item_.getTimestampVisualizationAvailable(), (double)1.0E-6f);
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)thumbnail, (Object)item_.getThumbnail());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 572;
        String recommendedSettingsVersion = "z";
        String recommendedSettingsLabels = "";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 903;
        int errorCode = 990;
        String errorReport = "u";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 934;
        boolean appliedSettingsMatchStartIsTrue = true;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 352;
        int level = 587;
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 145;
        String name = "h";
        int level = 638;
        String message = "o";
        String traceback = "";
        String filePath = "e";
        String functionName = "";
        int lineNumber = 341;
        int process = 326;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 301;
        String settingsVersion = "ubdmhuyapritluircfwgqcvlfkmkxcpmsylccjokqqhxmncebblhkdblsqslavgmlnjxhoehsowscimqglhewdwngqrbehdscepwhxmvkmfzxby";
        String otherSettingsEvents = "z";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 466;
        int mode = 971;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 633;
        String salVersion = "wpdneimnnnsixrkvjbnlpnezxwubjqcttkadygrjzmarfgbbmfwpjagbpgydzuxqeadhsupppvdtuqnhujcmhhhsohdszawjbsjgdrjuebfzwbdmatcfqf";
        String xmlVersion = "mcjgbxmyihihxpsmy";
        String openSpliceVersion = "evkzlpvwvjtqmxjfrdjghvqyzdkbqolftkmqgbyctwbyltjtpojslrvqygvliyeusxsqvhxqmallgvbdariwdizmdsvaneypwtbyenawpytbxhivepqbdefckdrfcozgfanglnohyctjrzkxdjnzdsbmrjrckapmqzuhhkmmbxwypgnofrlqqqgquqmsygenfjxopcqrhqrccyewhzxmdehlhlmiwtd";
        String cscVersion = "k";
        String subsystemVersions = "";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 485;
        boolean heartbeat = false;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 590;
        String authorizedUsers = "";
        String nonAuthorizedCSCs = "";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }
}

