/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_CcdTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_RebTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_RebTotalPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_SegmentTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.7331953048706055;
        double freeSpace = 0.44190144538879395;
        double freeFraction = 0.8249333500862122;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeSpace, freeFraction));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_RebTelemetry() throws Exception {
        double anaI = 0.3438388705253601;
        double anaV = 0.6647447347640991;
        double aspicl_Temp0 = 0.09924596548080444;
        double aspicl_Temp1 = 0.388649046421051;
        double aspicl_Temp2 = 0.192366361618042;
        double aspicu_Temp0 = 0.3791356682777405;
        double aspicu_Temp1 = 0.6766318678855896;
        double aspicu_Temp2 = 0.4565402865409851;
        double clkHI = 0.5763600468635559;
        double clkHV = 0.8063295483589172;
        double clkLI = 0.20522820949554443;
        double clkLV = 0.04169929027557373;
        double digI = 0.5060730576515198;
        double digV = 0.4233966f;
        double htrV = 0.02714228630065918;
        double htrW = 0.20204466581344604;
        double hVBiasSwitch = 0.4414917230606079;
        String location = "x";
        double oDI = 0.4024495482444763;
        double oDV = 0.42289382219314575;
        double pClkL = 0.9662340879440308;
        double pClkU = 0.11944049596786499;
        double power = 0.7138491868972778;
        double ref05V = 0.15329605340957642;
        double ref125V = 0.3902401328086853;
        double ref15V = 0.1239391f;
        double ref25V = 0.8015385270118713;
        double refN12 = 0.03770667314529419;
        double refP12 = 0.2436668872833252;
        double rGL = 0.35733717679977417;
        double rGU = 0.6375284790992737;
        double rTDTemp = 0.9946182370185852;
        double sClkL = 0.3443509340286255;
        double sClkU = 0.8494451642036438;
        double temp1 = 0.7361348271369934;
        double temp10 = 0.4846060276031494;
        double temp2 = 0.9953231811523438;
        double temp3 = 0.08402401208877563;
        double temp4 = 0.3612545132637024;
        double temp5 = 0.6111468076705933;
        double temp6 = 0.046657443046569824;
        double temp7 = 0.7034997344017029;
        double temp8 = 0.6944841146469116;
        double temp9 = 0.4423891305923462;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, htrV, htrW, hVBiasSwitch, location, oDI, oDV, pClkL, pClkU, power, ref05V, ref125V, ref15V, ref25V, refN12, refP12, rGL, rGU, rTDTemp, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Fp_RebTelemetry));
        Fp_RebTelemetry item_ = (Fp_RebTelemetry)item;
        Assert.assertEquals((double)anaI, (double)item_.getAnaI(), (double)1.0E-6f);
        Assert.assertEquals((double)anaV, (double)item_.getAnaV(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicl_Temp0, (double)item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicl_Temp1, (double)item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicl_Temp2, (double)item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicu_Temp0, (double)item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicu_Temp1, (double)item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicu_Temp2, (double)item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertEquals((double)clkHI, (double)item_.getClkHI(), (double)1.0E-6f);
        Assert.assertEquals((double)clkHV, (double)item_.getClkHV(), (double)1.0E-6f);
        Assert.assertEquals((double)clkLI, (double)item_.getClkLI(), (double)1.0E-6f);
        Assert.assertEquals((double)clkLV, (double)item_.getClkLV(), (double)1.0E-6f);
        Assert.assertEquals((double)digI, (double)item_.getDigI(), (double)1.0E-6f);
        Assert.assertEquals((double)digV, (double)item_.getDigV(), (double)1.0E-6f);
        Assert.assertEquals((double)htrV, (double)item_.getHtrV(), (double)1.0E-6f);
        Assert.assertEquals((double)htrW, (double)item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((double)hVBiasSwitch, (double)item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((double)oDI, (double)item_.getODI(), (double)1.0E-6f);
        Assert.assertEquals((double)oDV, (double)item_.getODV(), (double)1.0E-6f);
        Assert.assertEquals((double)pClkL, (double)item_.getPClkL(), (double)1.0E-6f);
        Assert.assertEquals((double)pClkU, (double)item_.getPClkU(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)ref05V, (double)item_.getRef05V(), (double)1.0E-6f);
        Assert.assertEquals((double)ref125V, (double)item_.getRef125V(), (double)1.0E-6f);
        Assert.assertEquals((double)ref15V, (double)item_.getRef15V(), (double)1.0E-6f);
        Assert.assertEquals((double)ref25V, (double)item_.getRef25V(), (double)1.0E-6f);
        Assert.assertEquals((double)refN12, (double)item_.getRefN12(), (double)1.0E-6f);
        Assert.assertEquals((double)refP12, (double)item_.getRefP12(), (double)1.0E-6f);
        Assert.assertEquals((double)rGL, (double)item_.getRGL(), (double)1.0E-6f);
        Assert.assertEquals((double)rGU, (double)item_.getRGU(), (double)1.0E-6f);
        Assert.assertEquals((double)rTDTemp, (double)item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)sClkL, (double)item_.getSClkL(), (double)1.0E-6f);
        Assert.assertEquals((double)sClkU, (double)item_.getSClkU(), (double)1.0E-6f);
        Assert.assertEquals((double)temp1, (double)item_.getTemp1(), (double)1.0E-6f);
        Assert.assertEquals((double)temp10, (double)item_.getTemp10(), (double)1.0E-6f);
        Assert.assertEquals((double)temp2, (double)item_.getTemp2(), (double)1.0E-6f);
        Assert.assertEquals((double)temp3, (double)item_.getTemp3(), (double)1.0E-6f);
        Assert.assertEquals((double)temp4, (double)item_.getTemp4(), (double)1.0E-6f);
        Assert.assertEquals((double)temp5, (double)item_.getTemp5(), (double)1.0E-6f);
        Assert.assertEquals((double)temp6, (double)item_.getTemp6(), (double)1.0E-6f);
        Assert.assertEquals((double)temp7, (double)item_.getTemp7(), (double)1.0E-6f);
        Assert.assertEquals((double)temp8, (double)item_.getTemp8(), (double)1.0E-6f);
        Assert.assertEquals((double)temp9, (double)item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_CcdTelemetry() throws Exception {
        double gDV = 0.8195973038673401;
        String location = "o";
        double oDV = 0.3727429509162903;
        double oGV = 0.3365599f;
        double rDV = 0.2162773609161377;
        double temp = 0.08686792850494385;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_CcdTelemetry(gDV, location, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Fp_CcdTelemetry));
        Fp_CcdTelemetry item_ = (Fp_CcdTelemetry)item;
        Assert.assertEquals((double)gDV, (double)item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((double)oDV, (double)item_.getODV(), (double)1.0E-6f);
        Assert.assertEquals((double)oGV, (double)item_.getOGV(), (double)1.0E-6f);
        Assert.assertEquals((double)rDV, (double)item_.getRDV(), (double)1.0E-6f);
        Assert.assertEquals((double)temp, (double)item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_SegmentTelemetry() throws Exception {
        double[] i = new double[]{0.5236115455627441, 0.11660957336425781, 0.6386212110519409, 0.5465096235275269, 0.8977733850479126, 0.7412078380584717, 0.33134692907333374, 0.14201372861862183, 0.4168702960014343, 0.9587225317955017, 0.8275997042655945, 0.7852810621261597, 0.6418435573577881, 0.3457095f, 0.5672187209129333, 0.45319098234176636};
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Fp_SegmentTelemetry));
        Fp_SegmentTelemetry item_ = (Fp_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFp_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.37387335300445557;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Fp_RebTotalPowerTelemetry));
        Fp_RebTotalPowerTelemetry item_ = (Fp_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveWrebTelemetry() throws Exception {
        float temp1 = 0.32923257f;
        float temp2 = 0.2597543f;
        float temp3 = 0.78924304f;
        float temp4 = 0.11749369f;
        float temp5 = 0.90754586f;
        float temp6 = 0.839673f;
        float atemp0U = 0.90551865f;
        float atemp0L = 0.07874f;
        float ccdTemp0 = 0.1136139f;
        float digV = 0.8729338f;
        float digI = 0.5535797f;
        float anaV = 0.587564f;
        float anaI = 0.17806685f;
        float clkHV = 0.32693952f;
        float clkHI = 0.7770498f;
        float clkLV = 0.6567666f;
        float odV = 0.54603785f;
        float odI = 0.70812243f;
        float power = 0.3934918f;
        float pClkU = 0.82751906f;
        float pClkL = 0.10685265f;
        float sClkU = 0.34294152f;
        float sClkL = 0.49828714f;
        float rgU = 0.54033226f;
        float rgL = 0.02185011f;
        float pClk0 = 0.9457009f;
        float sClk0 = 0.5799922f;
        float rg0 = 0.6035947f;
        float od0V = 0.4841491f;
        float og0V = 0.6779427f;
        float rd0V = 0.36885625f;
        float gd0V = 0.9268538f;
        float od0I = 0.19651574f;
        float hvbiasSwitch = 0.71458113f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WrebTelemetry(temp1, temp2, temp3, temp4, temp5, temp6, atemp0U, atemp0L, ccdTemp0, digV, digI, anaV, anaI, clkHV, clkHI, clkLV, odV, odI, power, pClkU, pClkL, sClkU, sClkL, rgU, rgL, pClk0, sClk0, rg0, od0V, og0V, rd0V, gd0V, od0I, hvbiasSwitch));
        Assert.assertTrue((boolean)(item instanceof WrebTelemetry));
        WrebTelemetry item_ = (WrebTelemetry)item;
        Assert.assertEquals((float)temp1, (float)item_.getTemp1(), (float)1.0E-6f);
        Assert.assertEquals((float)temp2, (float)item_.getTemp2(), (float)1.0E-6f);
        Assert.assertEquals((float)temp3, (float)item_.getTemp3(), (float)1.0E-6f);
        Assert.assertEquals((float)temp4, (float)item_.getTemp4(), (float)1.0E-6f);
        Assert.assertEquals((float)temp5, (float)item_.getTemp5(), (float)1.0E-6f);
        Assert.assertEquals((float)temp6, (float)item_.getTemp6(), (float)1.0E-6f);
        Assert.assertEquals((float)atemp0U, (float)item_.getAtemp0U(), (float)1.0E-6f);
        Assert.assertEquals((float)atemp0L, (float)item_.getAtemp0L(), (float)1.0E-6f);
        Assert.assertEquals((float)ccdTemp0, (float)item_.getCcdTemp0(), (float)1.0E-6f);
        Assert.assertEquals((float)digV, (float)item_.getDigV(), (float)1.0E-6f);
        Assert.assertEquals((float)digI, (float)item_.getDigI(), (float)1.0E-6f);
        Assert.assertEquals((float)anaV, (float)item_.getAnaV(), (float)1.0E-6f);
        Assert.assertEquals((float)anaI, (float)item_.getAnaI(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHV, (float)item_.getClkHV(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHI, (float)item_.getClkHI(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLV, (float)item_.getClkLV(), (float)1.0E-6f);
        Assert.assertEquals((float)odV, (float)item_.getOdV(), (float)1.0E-6f);
        Assert.assertEquals((float)odI, (float)item_.getOdI(), (float)1.0E-6f);
        Assert.assertEquals((float)power, (float)item_.getPower(), (float)1.0E-6f);
        Assert.assertEquals((float)pClkU, (float)item_.getPClkU(), (float)1.0E-6f);
        Assert.assertEquals((float)pClkL, (float)item_.getPClkL(), (float)1.0E-6f);
        Assert.assertEquals((float)sClkU, (float)item_.getSClkU(), (float)1.0E-6f);
        Assert.assertEquals((float)sClkL, (float)item_.getSClkL(), (float)1.0E-6f);
        Assert.assertEquals((float)rgU, (float)item_.getRgU(), (float)1.0E-6f);
        Assert.assertEquals((float)rgL, (float)item_.getRgL(), (float)1.0E-6f);
        Assert.assertEquals((float)pClk0, (float)item_.getPClk0(), (float)1.0E-6f);
        Assert.assertEquals((float)sClk0, (float)item_.getSClk0(), (float)1.0E-6f);
        Assert.assertEquals((float)rg0, (float)item_.getRg0(), (float)1.0E-6f);
        Assert.assertEquals((float)od0V, (float)item_.getOd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)og0V, (float)item_.getOg0V(), (float)1.0E-6f);
        Assert.assertEquals((float)rd0V, (float)item_.getRd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)gd0V, (float)item_.getGd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)od0I, (float)item_.getOd0I(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbiasSwitch, (float)item_.getHvbiasSwitch(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.01391238f;
        float shutter36V = 0.43761688f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveWrebPowerTelemetry() throws Exception {
        float digital_V = 0.8390809f;
        float digital_I = 0.36190033f;
        float analog_V = 0.30676663f;
        float analog_I = 0.9353718f;
        float clkHigh_V = 0.8341261f;
        float clkHigh_I = 0.83161145f;
        float clkLow_V = 0.18507963f;
        float clkLow_I = 0.059637487f;
        float od_V = 0.8327114f;
        float od_I = 0.37604064f;
        float dphi_V = 0.03953767f;
        float dphi_I = 0.8931769f;
        float hvbias_V = 0.34542137f;
        float hvbias_I = 0.09803194f;
        float fan_V = 0.6892715f;
        float fan_I = 0.398157f;
        float otm_V = 0.13042718f;
        float otm_I = 0.034231484f;
        float aux_V = 0.69723445f;
        float aux_I = 0.63129085f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WrebPowerTelemetry(digital_V, digital_I, analog_V, analog_I, clkHigh_V, clkHigh_I, clkLow_V, clkLow_I, od_V, od_I, dphi_V, dphi_I, hvbias_V, hvbias_I, fan_V, fan_I, otm_V, otm_I, aux_V, aux_I));
        Assert.assertTrue((boolean)(item instanceof WrebPowerTelemetry));
        WrebPowerTelemetry item_ = (WrebPowerTelemetry)item;
        Assert.assertEquals((float)digital_V, (float)item_.getDigital_V(), (float)1.0E-6f);
        Assert.assertEquals((float)digital_I, (float)item_.getDigital_I(), (float)1.0E-6f);
        Assert.assertEquals((float)analog_V, (float)item_.getAnalog_V(), (float)1.0E-6f);
        Assert.assertEquals((float)analog_I, (float)item_.getAnalog_I(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHigh_V, (float)item_.getClkHigh_V(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHigh_I, (float)item_.getClkHigh_I(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLow_V, (float)item_.getClkLow_V(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLow_I, (float)item_.getClkLow_I(), (float)1.0E-6f);
        Assert.assertEquals((float)od_V, (float)item_.getOd_V(), (float)1.0E-6f);
        Assert.assertEquals((float)od_I, (float)item_.getOd_I(), (float)1.0E-6f);
        Assert.assertEquals((float)dphi_V, (float)item_.getDphi_V(), (float)1.0E-6f);
        Assert.assertEquals((float)dphi_I, (float)item_.getDphi_I(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbias_V, (float)item_.getHvbias_V(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbias_I, (float)item_.getHvbias_I(), (float)1.0E-6f);
        Assert.assertEquals((float)fan_V, (float)item_.getFan_V(), (float)1.0E-6f);
        Assert.assertEquals((float)fan_I, (float)item_.getFan_I(), (float)1.0E-6f);
        Assert.assertEquals((float)otm_V, (float)item_.getOtm_V(), (float)1.0E-6f);
        Assert.assertEquals((float)otm_I, (float)item_.getOtm_I(), (float)1.0E-6f);
        Assert.assertEquals((float)aux_V, (float)item_.getAux_V(), (float)1.0E-6f);
        Assert.assertEquals((float)aux_I, (float)item_.getAux_I(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumTelemetry() throws Exception {
        float tempCCD = 0.41550487f;
        float tempColdPlate = 0.19414717f;
        float tempCryoHead = 0.7746595f;
        float vacuum = 0.82122225f;
        float tempCCDSetPoint = 0.86134493f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumTelemetry(tempCCD, tempColdPlate, tempCryoHead, vacuum, tempCCDSetPoint));
        Assert.assertTrue((boolean)(item instanceof VacuumTelemetry));
        VacuumTelemetry item_ = (VacuumTelemetry)item;
        Assert.assertEquals((float)tempCCD, (float)item_.getTempCCD(), (float)1.0E-6f);
        Assert.assertEquals((float)tempColdPlate, (float)item_.getTempColdPlate(), (float)1.0E-6f);
        Assert.assertEquals((float)tempCryoHead, (float)item_.getTempCryoHead(), (float)1.0E-6f);
        Assert.assertEquals((float)vacuum, (float)item_.getVacuum(), (float)1.0E-6f);
        Assert.assertEquals((float)tempCCDSetPoint, (float)item_.getTempCCDSetPoint(), (float)1.0E-6f);
    }
}

