/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_CcdTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_RebTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_RebTotalPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_SegmentTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.7822176218032837;
        double freeSpace = 0.1674329f;
        double freeFraction = 0.8232903480529785;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeSpace, freeFraction));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_RebTelemetry() throws Exception {
        double anaI = 0.021574795246124268;
        double anaV = 0.5910191535949707;
        double aspicl_Temp0 = 0.829590380191803;
        double aspicl_Temp1 = 0.7152977585792542;
        double aspicl_Temp2 = 0.4998023509979248;
        double aspicu_Temp0 = 0.3440103f;
        double aspicu_Temp1 = 0.4326050877571106;
        double aspicu_Temp2 = 0.21062564849853516;
        double clkHI = 0.0792589783668518;
        double clkHV = 0.2721264958381653;
        double clkLI = 0.4227059f;
        double clkLV = 0.5238474011421204;
        double digI = 0.600369f;
        double digV = 0.7923102974891663;
        double htrV = 0.10167646408081055;
        double htrW = 0.5228962302207947;
        double hVBiasSwitch = 0.9924355149269104;
        String location = "";
        double oDI = 0.9987385272979736;
        double oDV = 0.47297781705856323;
        double pClkL = 0.9340545535087585;
        double pClkU = 0.48599404096603394;
        double power = 0.013784825801849365;
        double ref05V = 0.14531677961349487;
        double ref125V = 0.12934476137161255;
        double ref15V = 0.6772377490997314;
        double ref25V = 0.42665135860443115;
        double refN12 = 0.3735013008117676;
        double refP12 = 0.04779643f;
        double rGL = 0.2569039f;
        double rGU = 0.6709095239639282;
        double rTDTemp = 0.9702103137969971;
        double sClkL = 0.07868212461471558;
        double sClkU = 0.24574816226959229;
        double temp1 = 0.6333491206169128;
        double temp10 = 0.13586270809173584;
        double temp2 = 0.11974668502807617;
        double temp3 = 0.0889168381690979;
        double temp4 = 0.5261692404747009;
        double temp5 = 0.3023141026496887;
        double temp6 = 0.4013763666152954;
        double temp7 = 0.5835314989089966;
        double temp8 = 0.03028053045272827;
        double temp9 = 0.9788787961006165;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, htrV, htrW, hVBiasSwitch, location, oDI, oDV, pClkL, pClkU, power, ref05V, ref125V, ref15V, ref25V, refN12, refP12, rGL, rGU, rTDTemp, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Fp_RebTelemetry));
        Fp_RebTelemetry item_ = (Fp_RebTelemetry)item;
        Assert.assertEquals((double)anaI, (double)item_.getAnaI(), (double)1.0E-6f);
        Assert.assertEquals((double)anaV, (double)item_.getAnaV(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicl_Temp0, (double)item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicl_Temp1, (double)item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicl_Temp2, (double)item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicu_Temp0, (double)item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicu_Temp1, (double)item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicu_Temp2, (double)item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertEquals((double)clkHI, (double)item_.getClkHI(), (double)1.0E-6f);
        Assert.assertEquals((double)clkHV, (double)item_.getClkHV(), (double)1.0E-6f);
        Assert.assertEquals((double)clkLI, (double)item_.getClkLI(), (double)1.0E-6f);
        Assert.assertEquals((double)clkLV, (double)item_.getClkLV(), (double)1.0E-6f);
        Assert.assertEquals((double)digI, (double)item_.getDigI(), (double)1.0E-6f);
        Assert.assertEquals((double)digV, (double)item_.getDigV(), (double)1.0E-6f);
        Assert.assertEquals((double)htrV, (double)item_.getHtrV(), (double)1.0E-6f);
        Assert.assertEquals((double)htrW, (double)item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((double)hVBiasSwitch, (double)item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((double)oDI, (double)item_.getODI(), (double)1.0E-6f);
        Assert.assertEquals((double)oDV, (double)item_.getODV(), (double)1.0E-6f);
        Assert.assertEquals((double)pClkL, (double)item_.getPClkL(), (double)1.0E-6f);
        Assert.assertEquals((double)pClkU, (double)item_.getPClkU(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)ref05V, (double)item_.getRef05V(), (double)1.0E-6f);
        Assert.assertEquals((double)ref125V, (double)item_.getRef125V(), (double)1.0E-6f);
        Assert.assertEquals((double)ref15V, (double)item_.getRef15V(), (double)1.0E-6f);
        Assert.assertEquals((double)ref25V, (double)item_.getRef25V(), (double)1.0E-6f);
        Assert.assertEquals((double)refN12, (double)item_.getRefN12(), (double)1.0E-6f);
        Assert.assertEquals((double)refP12, (double)item_.getRefP12(), (double)1.0E-6f);
        Assert.assertEquals((double)rGL, (double)item_.getRGL(), (double)1.0E-6f);
        Assert.assertEquals((double)rGU, (double)item_.getRGU(), (double)1.0E-6f);
        Assert.assertEquals((double)rTDTemp, (double)item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)sClkL, (double)item_.getSClkL(), (double)1.0E-6f);
        Assert.assertEquals((double)sClkU, (double)item_.getSClkU(), (double)1.0E-6f);
        Assert.assertEquals((double)temp1, (double)item_.getTemp1(), (double)1.0E-6f);
        Assert.assertEquals((double)temp10, (double)item_.getTemp10(), (double)1.0E-6f);
        Assert.assertEquals((double)temp2, (double)item_.getTemp2(), (double)1.0E-6f);
        Assert.assertEquals((double)temp3, (double)item_.getTemp3(), (double)1.0E-6f);
        Assert.assertEquals((double)temp4, (double)item_.getTemp4(), (double)1.0E-6f);
        Assert.assertEquals((double)temp5, (double)item_.getTemp5(), (double)1.0E-6f);
        Assert.assertEquals((double)temp6, (double)item_.getTemp6(), (double)1.0E-6f);
        Assert.assertEquals((double)temp7, (double)item_.getTemp7(), (double)1.0E-6f);
        Assert.assertEquals((double)temp8, (double)item_.getTemp8(), (double)1.0E-6f);
        Assert.assertEquals((double)temp9, (double)item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_CcdTelemetry() throws Exception {
        double gDV = 0.29183292388916016;
        String location = "";
        double oDV = 0.19555652141571045;
        double oGV = 0.09001445770263672;
        double rDV = 0.33974742889404297;
        double temp = 0.6487502455711365;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_CcdTelemetry(gDV, location, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Fp_CcdTelemetry));
        Fp_CcdTelemetry item_ = (Fp_CcdTelemetry)item;
        Assert.assertEquals((double)gDV, (double)item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((double)oDV, (double)item_.getODV(), (double)1.0E-6f);
        Assert.assertEquals((double)oGV, (double)item_.getOGV(), (double)1.0E-6f);
        Assert.assertEquals((double)rDV, (double)item_.getRDV(), (double)1.0E-6f);
        Assert.assertEquals((double)temp, (double)item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_SegmentTelemetry() throws Exception {
        double[] i = new double[]{0.3559845f, 0.5149582624435425, 0.4933440685272217, 0.31671005487442017, 0.2512192726135254, 0.8260467648506165, 0.3513833284378052, 0.6892632842063904, 0.39591485261917114, 0.35660862922668457, 0.2112596035003662, 0.7523805499076843, 0.0874103307723999, 0.759048342704773, 0.300897f, 0.7185729146003723};
        String location = "f";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Fp_SegmentTelemetry));
        Fp_SegmentTelemetry item_ = (Fp_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFp_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.8319877982139587;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Fp_RebTotalPowerTelemetry));
        Fp_RebTotalPowerTelemetry item_ = (Fp_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveWrebTelemetry() throws Exception {
        float temp1 = 0.9392833f;
        float temp2 = 0.58948046f;
        float temp3 = 0.6364537f;
        float temp4 = 0.76479393f;
        float temp5 = 0.019551396f;
        float temp6 = 0.2518608f;
        float atemp0U = 0.9561854f;
        float atemp0L = 0.50437135f;
        float ccdTemp0 = 0.35633576f;
        float digV = 0.9818012f;
        float digI = 0.05957359f;
        float anaV = 0.18300074f;
        float anaI = 0.11738366f;
        float clkHV = 0.7109484f;
        float clkHI = 0.80618876f;
        float clkLV = 0.95526606f;
        float odV = 0.8954678f;
        float odI = 0.28225982f;
        float power = 0.67330027f;
        float pClkU = 0.5251776f;
        float pClkL = 0.031327665f;
        float sClkU = 0.5913362f;
        float sClkL = 0.35413134f;
        float rgU = 0.32669246f;
        float rgL = 0.65654963f;
        float pClk0 = 0.24897677f;
        float sClk0 = 0.8357329f;
        float rg0 = 0.7307541f;
        float od0V = 0.5143061f;
        float og0V = 0.6362953f;
        float rd0V = 0.81512636f;
        float gd0V = 0.8975062f;
        float od0I = 0.36139202f;
        float hvbiasSwitch = 0.56915474f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WrebTelemetry(temp1, temp2, temp3, temp4, temp5, temp6, atemp0U, atemp0L, ccdTemp0, digV, digI, anaV, anaI, clkHV, clkHI, clkLV, odV, odI, power, pClkU, pClkL, sClkU, sClkL, rgU, rgL, pClk0, sClk0, rg0, od0V, og0V, rd0V, gd0V, od0I, hvbiasSwitch));
        Assert.assertTrue((boolean)(item instanceof WrebTelemetry));
        WrebTelemetry item_ = (WrebTelemetry)item;
        Assert.assertEquals((float)temp1, (float)item_.getTemp1(), (float)1.0E-6f);
        Assert.assertEquals((float)temp2, (float)item_.getTemp2(), (float)1.0E-6f);
        Assert.assertEquals((float)temp3, (float)item_.getTemp3(), (float)1.0E-6f);
        Assert.assertEquals((float)temp4, (float)item_.getTemp4(), (float)1.0E-6f);
        Assert.assertEquals((float)temp5, (float)item_.getTemp5(), (float)1.0E-6f);
        Assert.assertEquals((float)temp6, (float)item_.getTemp6(), (float)1.0E-6f);
        Assert.assertEquals((float)atemp0U, (float)item_.getAtemp0U(), (float)1.0E-6f);
        Assert.assertEquals((float)atemp0L, (float)item_.getAtemp0L(), (float)1.0E-6f);
        Assert.assertEquals((float)ccdTemp0, (float)item_.getCcdTemp0(), (float)1.0E-6f);
        Assert.assertEquals((float)digV, (float)item_.getDigV(), (float)1.0E-6f);
        Assert.assertEquals((float)digI, (float)item_.getDigI(), (float)1.0E-6f);
        Assert.assertEquals((float)anaV, (float)item_.getAnaV(), (float)1.0E-6f);
        Assert.assertEquals((float)anaI, (float)item_.getAnaI(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHV, (float)item_.getClkHV(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHI, (float)item_.getClkHI(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLV, (float)item_.getClkLV(), (float)1.0E-6f);
        Assert.assertEquals((float)odV, (float)item_.getOdV(), (float)1.0E-6f);
        Assert.assertEquals((float)odI, (float)item_.getOdI(), (float)1.0E-6f);
        Assert.assertEquals((float)power, (float)item_.getPower(), (float)1.0E-6f);
        Assert.assertEquals((float)pClkU, (float)item_.getPClkU(), (float)1.0E-6f);
        Assert.assertEquals((float)pClkL, (float)item_.getPClkL(), (float)1.0E-6f);
        Assert.assertEquals((float)sClkU, (float)item_.getSClkU(), (float)1.0E-6f);
        Assert.assertEquals((float)sClkL, (float)item_.getSClkL(), (float)1.0E-6f);
        Assert.assertEquals((float)rgU, (float)item_.getRgU(), (float)1.0E-6f);
        Assert.assertEquals((float)rgL, (float)item_.getRgL(), (float)1.0E-6f);
        Assert.assertEquals((float)pClk0, (float)item_.getPClk0(), (float)1.0E-6f);
        Assert.assertEquals((float)sClk0, (float)item_.getSClk0(), (float)1.0E-6f);
        Assert.assertEquals((float)rg0, (float)item_.getRg0(), (float)1.0E-6f);
        Assert.assertEquals((float)od0V, (float)item_.getOd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)og0V, (float)item_.getOg0V(), (float)1.0E-6f);
        Assert.assertEquals((float)rd0V, (float)item_.getRd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)gd0V, (float)item_.getGd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)od0I, (float)item_.getOd0I(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbiasSwitch, (float)item_.getHvbiasSwitch(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.11711925f;
        float shutter36V = 0.4287027f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveWrebPowerTelemetry() throws Exception {
        float digital_V = 0.4200098f;
        float digital_I = 0.20275605f;
        float analog_V = 0.035132706f;
        float analog_I = 0.5027276f;
        float clkHigh_V = 0.7535496f;
        float clkHigh_I = 0.310475f;
        float clkLow_V = 0.96286094f;
        float clkLow_I = 0.34638035f;
        float od_V = 0.29910475f;
        float od_I = 0.7620957f;
        float dphi_V = 0.5705672f;
        float dphi_I = 0.5701176f;
        float hvbias_V = 0.45319545f;
        float hvbias_I = 0.33221525f;
        float fan_V = 0.12193096f;
        float fan_I = 0.37634134f;
        float otm_V = 0.8193006f;
        float otm_I = 0.89465934f;
        float aux_V = 0.35780776f;
        float aux_I = 0.9562797f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WrebPowerTelemetry(digital_V, digital_I, analog_V, analog_I, clkHigh_V, clkHigh_I, clkLow_V, clkLow_I, od_V, od_I, dphi_V, dphi_I, hvbias_V, hvbias_I, fan_V, fan_I, otm_V, otm_I, aux_V, aux_I));
        Assert.assertTrue((boolean)(item instanceof WrebPowerTelemetry));
        WrebPowerTelemetry item_ = (WrebPowerTelemetry)item;
        Assert.assertEquals((float)digital_V, (float)item_.getDigital_V(), (float)1.0E-6f);
        Assert.assertEquals((float)digital_I, (float)item_.getDigital_I(), (float)1.0E-6f);
        Assert.assertEquals((float)analog_V, (float)item_.getAnalog_V(), (float)1.0E-6f);
        Assert.assertEquals((float)analog_I, (float)item_.getAnalog_I(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHigh_V, (float)item_.getClkHigh_V(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHigh_I, (float)item_.getClkHigh_I(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLow_V, (float)item_.getClkLow_V(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLow_I, (float)item_.getClkLow_I(), (float)1.0E-6f);
        Assert.assertEquals((float)od_V, (float)item_.getOd_V(), (float)1.0E-6f);
        Assert.assertEquals((float)od_I, (float)item_.getOd_I(), (float)1.0E-6f);
        Assert.assertEquals((float)dphi_V, (float)item_.getDphi_V(), (float)1.0E-6f);
        Assert.assertEquals((float)dphi_I, (float)item_.getDphi_I(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbias_V, (float)item_.getHvbias_V(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbias_I, (float)item_.getHvbias_I(), (float)1.0E-6f);
        Assert.assertEquals((float)fan_V, (float)item_.getFan_V(), (float)1.0E-6f);
        Assert.assertEquals((float)fan_I, (float)item_.getFan_I(), (float)1.0E-6f);
        Assert.assertEquals((float)otm_V, (float)item_.getOtm_V(), (float)1.0E-6f);
        Assert.assertEquals((float)otm_I, (float)item_.getOtm_I(), (float)1.0E-6f);
        Assert.assertEquals((float)aux_V, (float)item_.getAux_V(), (float)1.0E-6f);
        Assert.assertEquals((float)aux_I, (float)item_.getAux_I(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumTelemetry() throws Exception {
        float tempCCD = 0.8701253f;
        float tempColdPlate = 0.43627113f;
        float tempCryoHead = 0.9899036f;
        float vacuum = 0.48584515f;
        float tempCCDSetPoint = 0.6284509f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumTelemetry(tempCCD, tempColdPlate, tempCryoHead, vacuum, tempCCDSetPoint));
        Assert.assertTrue((boolean)(item instanceof VacuumTelemetry));
        VacuumTelemetry item_ = (VacuumTelemetry)item;
        Assert.assertEquals((float)tempCCD, (float)item_.getTempCCD(), (float)1.0E-6f);
        Assert.assertEquals((float)tempColdPlate, (float)item_.getTempColdPlate(), (float)1.0E-6f);
        Assert.assertEquals((float)tempCryoHead, (float)item_.getTempCryoHead(), (float)1.0E-6f);
        Assert.assertEquals((float)vacuum, (float)item_.getVacuum(), (float)1.0E-6f);
        Assert.assertEquals((float)tempCCDSetPoint, (float)item_.getTempCCDSetPoint(), (float)1.0E-6f);
    }
}

