/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.event.Daq_monitorSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Daq_monitor_StatsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.Daq_monitor_StoreSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FileCommandExecutionEvent;
import org.lsst.sal.atcamera.event.FitsFilesWrittenEvent;
import org.lsst.sal.atcamera.event.FocalPlaneDAQSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneHardwareIdSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneRaftTempControlSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneRaftTempControlStatusSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneRebRaftsPowerSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneRebRaftsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneSequencerConfigSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.atcamera.event.ImageReadoutParametersEvent;
import org.lsst.sal.atcamera.event.ImageStoredEvent;
import org.lsst.sal.atcamera.event.ImageVisualizationEvent;
import org.lsst.sal.atcamera.event.ShutterBladeMotionProfileEvent;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 147;
        String additionalKeys = "";
        String additionalValues = "g";
        int imagesInSequence = 125;
        String imageName = "ehxuortnjimmdxoxtkqi";
        int imageIndex = 237;
        String imageSource = "p";
        String imageController = "n";
        String imageDate = "oiybb";
        int imageNumber = 940;
        double timestampAcquisitionStart = 0.764613151550293;
        double requestedExposureTime = 0.8012044429779053;
        double timestampEndOfReadout = 0.27334141731262207;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 314;
        double timestampTransition = 0.08786344528198242;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 379;
        double timestampTransition = 0.4715105891227722;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 617;
        double timestampTransition = 0.32091647386550903;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 836;
        double timestampTransition = 0.2283687f;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 321;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 770;
        String imageName = "wkoekwxqcrk";
        int imageIndex = 336;
        String imageSource = "";
        String imageController = "c";
        String imageDate = "udwlsjy";
        int imageNumber = 299;
        double timestampAcquisitionStart = 0.5973697304725647;
        double exposureTime = 0.5855571627616882;
        String imageTag = "jbmwlxormuieyagajcpmlj";
        double timestampDateObs = 0.6815060377120972;
        double timestampDateEnd = 0.8702144026756287;
        double measuredShutterOpenTime = 0.9384675025939941;
        double darkTime = 0.3314272165298462;
        String emulatedImage = "q";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 805;
        double timestampTransition = 0.7265490889549255;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 114;
        double timestampTransition = 0.40976113080978394;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 300;
        double timestampTransition = 0.929636538028717;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 237;
        String additionalKeys = "r";
        String additionalValues = "";
        int imagesInSequence = 335;
        String imageName = "nlkeqghnfuzovpreprkfuytkjuy";
        int imageIndex = 763;
        String imageSource = "";
        String imageController = "";
        String imageDate = "i";
        int imageNumber = 839;
        double timestampAcquisitionStart = 0.47505706548690796;
        double exposureTime = 0.9432885646820068;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 729;
        double timestampTransition = 0.44469577074050903;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 944;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 463;
        String imageName = "rzadpaeuerhlvukfvlof";
        int imageIndex = 44;
        String imageSource = "c";
        String imageController = "";
        String imageDate = "jp";
        int imageNumber = 167;
        double timestampAcquisitionStart = 0.6173826456069946;
        double exposureTime = 0.4313352704048157;
        double timestampStartOfReadout = 0.5078532695770264;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveShutterMotionProfileEvent() throws Exception {
        int priority = 787;
        double measuredExposureTime = 0.347290575504303;
        SALEvent item = this.testSendReceive((SALEvent)new ShutterMotionProfileEvent(priority, measuredExposureTime));
        Assert.assertTrue((boolean)(item instanceof ShutterMotionProfileEvent));
        ShutterMotionProfileEvent item_ = (ShutterMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)measuredExposureTime, (double)item_.getMeasuredExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 755;
        String imageName = "y";
        String ccdLocation = "";
        String raftBay = "";
        String ccdSlot = "";
        ImageReadoutParametersEvent.CcdType ccdType = ImageReadoutParametersEvent.CcdType.E2V;
        int overRows = 143;
        int overCols = 600;
        int readRows = 758;
        int readCols = 546;
        int readCols2 = 423;
        int preCols = 198;
        int preRows = 223;
        int postCols = 860;
        int underCols = 81;
        String daqFolder = "u";
        String daqAnnotation = "j";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 727;
        String ccdLocation = "";
        String raftBay = "i";
        String ccdSlot = "g";
        String rebSerialNumber = "h";
        String rebLSSTName = "r";
        String ccdLSSTName = "";
        String raftLSSTName = "q";
        String ccdManSerNum = "m";
        String ccdManufacturer = "n";
        FocalPlaneSummaryInfoEvent.CcdType ccdType = FocalPlaneSummaryInfoEvent.CcdType.E2V;
        double ccdTempSetPoint = 0.10950475931167603;
        String sequencerKey = "j";
        String sequencerChecksum = "s";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((double)ccdTempSetPoint, (double)item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveFocalPlaneHardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 134;
        int version = 529;
        String rebLocation = "d";
        String rebLSSTName = "e";
        String ccdLocation = "o";
        String ccdLSSTName = "";
        String ccdManSerNum = "x";
        String raftLocation = "r";
        String raftLSSTName = "m";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneHardwareIdSettingsAppliedEvent(priority, version, rebLocation, rebLSSTName, ccdLocation, ccdLSSTName, ccdManSerNum, raftLocation, raftLSSTName));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneHardwareIdSettingsAppliedEvent));
        FocalPlaneHardwareIdSettingsAppliedEvent item_ = (FocalPlaneHardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)rebLocation, (Object)item_.getRebLocation());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
    }

    @Test
    public void sendReceiveFocalPlaneRaftTempControlStatusSettingsAppliedEvent() throws Exception {
        int priority = 895;
        int version = 75;
        String raftLocation = "d";
        boolean raft_TempControl_active = false;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRaftTempControlStatusSettingsAppliedEvent(priority, version, raftLocation, raft_TempControl_active));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRaftTempControlStatusSettingsAppliedEvent));
        FocalPlaneRaftTempControlStatusSettingsAppliedEvent item_ = (FocalPlaneRaftTempControlStatusSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((Object)raft_TempControl_active, (Object)item_.isRaft_TempControl_active());
    }

    @Test
    public void sendReceiveFocalPlaneRaftTempControlSettingsAppliedEvent() throws Exception {
        int priority = 645;
        int version = 9;
        String raftLocation = "p";
        double raft_TempControl_awGain = 0.7247471213340759;
        double raft_TempControl_basePower = 0.9898342490196228;
        double raft_TempControl_gain = 0.2324674129486084;
        double raft_TempControl_maxInput = 0.896336019039154;
        double raft_TempControl_maxOutput = 0.41612714529037476;
        double raft_TempControl_minInput = 0.8566926717758179;
        double raft_TempControl_minOutput = 0.9921679496765137;
        String raft_TempControl_rebs = "u";
        double raft_TempControl_setTemp = 0.726557195186615;
        double raft_TempControl_smoothTime = 0.4349576234817505;
        String raft_TempControl_tempChans = "";
        double raft_TempControl_timeConst = 0.8832398653030396;
        double raft_TempControl_tolerance = 0.4246455430984497;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRaftTempControlSettingsAppliedEvent(priority, version, raftLocation, raft_TempControl_awGain, raft_TempControl_basePower, raft_TempControl_gain, raft_TempControl_maxInput, raft_TempControl_maxOutput, raft_TempControl_minInput, raft_TempControl_minOutput, raft_TempControl_rebs, raft_TempControl_setTemp, raft_TempControl_smoothTime, raft_TempControl_tempChans, raft_TempControl_timeConst, raft_TempControl_tolerance));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRaftTempControlSettingsAppliedEvent));
        FocalPlaneRaftTempControlSettingsAppliedEvent item_ = (FocalPlaneRaftTempControlSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((double)raft_TempControl_awGain, (double)item_.getRaft_TempControl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_basePower, (double)item_.getRaft_TempControl_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_gain, (double)item_.getRaft_TempControl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_maxInput, (double)item_.getRaft_TempControl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_maxOutput, (double)item_.getRaft_TempControl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_minInput, (double)item_.getRaft_TempControl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_minOutput, (double)item_.getRaft_TempControl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)raft_TempControl_rebs, (Object)item_.getRaft_TempControl_rebs());
        Assert.assertEquals((double)raft_TempControl_setTemp, (double)item_.getRaft_TempControl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_smoothTime, (double)item_.getRaft_TempControl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)raft_TempControl_tempChans, (Object)item_.getRaft_TempControl_tempChans());
        Assert.assertEquals((double)raft_TempControl_timeConst, (double)item_.getRaft_TempControl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_tolerance, (double)item_.getRaft_TempControl_tolerance(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocalPlaneDAQSettingsAppliedEvent() throws Exception {
        int priority = 360;
        int version = 73;
        String daqFolder = "o";
        String daqPartition = "c";
        boolean emulatedDAQ = true;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneDAQSettingsAppliedEvent(priority, version, daqFolder, daqPartition, emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneDAQSettingsAppliedEvent));
        FocalPlaneDAQSettingsAppliedEvent item_ = (FocalPlaneDAQSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
    }

    @Test
    public void sendReceiveFocalPlaneSequencerConfigSettingsAppliedEvent() throws Exception {
        int priority = 396;
        String clearCountParameter = "e";
        String clearMain = "";
        String idleFlushMain = "j";
        String integrateMain = "h";
        String metaDataRegisters = "";
        int overCols = 675;
        int overRows = 902;
        int postCols = 648;
        int postRows = 28;
        int preCols = 49;
        int preRows = 787;
        String pseudoReadMain = "";
        int readCols = 806;
        int readCols2 = 403;
        String readMain = "";
        int readRows = 564;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "";
        boolean scanMode = true;
        String sequencer = "";
        String sequencerChecksums = "s";
        String shiftCountParameter = "f";
        int transparentMode = 145;
        int underCols = 897;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSequencerConfigSettingsAppliedEvent(priority, clearCountParameter, clearMain, idleFlushMain, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, transparentMode, underCols));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSequencerConfigSettingsAppliedEvent));
        FocalPlaneSequencerConfigSettingsAppliedEvent item_ = (FocalPlaneSequencerConfigSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
    }

    @Test
    public void sendReceiveFocalPlaneRebRaftsSettingsAppliedEvent() throws Exception {
        int priority = 690;
        int version = 782;
        double bias0_csGateP = 0.3559340238571167;
        double bias0_gdP = 0.24237751960754395;
        double bias0_odP = 0.9880634546279907;
        double bias0_ogP = 0.313502f;
        double bias0_rdP = 0.9948939085006714;
        double bias1_csGateP = 0.24287128448486328;
        double bias1_gdP = 0.28981125354766846;
        double bias1_odP = 0.637981653213501;
        double bias1_ogP = 0.2291491f;
        double bias1_rdP = 0.9774193167686462;
        double bias2_csGateP = 0.9679872989654541;
        double bias2_gdP = 0.21056926250457764;
        double bias2_odP = 0.17396068572998047;
        double bias2_ogP = 0.7478382587432861;
        double bias2_rdP = 0.9909597039222717;
        double dac_pclkHighP = 0.18862158060073853;
        double dac_pclkLowP = 0.8657287359237671;
        double dac_rgHighP = 0.4734336733818054;
        double dac_rgLowP = 0.23562753200531006;
        double dac_sclkHighP = 0.816788911819458;
        double dac_sclkLowP = 0.1400158405303955;
        boolean disableRTDHardwareCheck = false;
        String location = "a";
        int serialNum = 210;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRebRaftsSettingsAppliedEvent(priority, version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRebRaftsSettingsAppliedEvent));
        FocalPlaneRebRaftsSettingsAppliedEvent item_ = (FocalPlaneRebRaftsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)bias0_csGateP, (double)item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_gdP, (double)item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_odP, (double)item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogP, (double)item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdP, (double)item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_csGateP, (double)item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdP, (double)item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_odP, (double)item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogP, (double)item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdP, (double)item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_csGateP, (double)item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdP, (double)item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_odP, (double)item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogP, (double)item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdP, (double)item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighP, (double)item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowP, (double)item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighP, (double)item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowP, (double)item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighP, (double)item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowP, (double)item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertEquals((Object)disableRTDHardwareCheck, (Object)item_.isDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((long)serialNum, (long)item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocalPlaneRebRaftsPowerSettingsAppliedEvent() throws Exception {
        int priority = 253;
        int version = 509;
        double bias0_gdCal = 0.8620482683181763;
        double bias0_gdTestVolts = 0.9991486668586731;
        double bias0_gdTol = 0.31942546367645264;
        double bias0_gdValueErr = 0.7304308414459229;
        double bias0_gdZeroErr = 0.41338562965393066;
        double bias0_odCal = 0.6669944524765015;
        double bias0_odIMax = 0.8893335461616516;
        double bias0_odTol = 0.5718086361885071;
        double bias0_odZeroErr = 0.9800564646720886;
        double bias0_ogCal = 0.9381328225135803;
        double bias0_ogTestVolts = 0.8460745811462402;
        double bias0_ogTol = 0.38652586936950684;
        double bias0_ogValueErr = 0.17574453353881836;
        double bias0_ogZeroErr = 0.12872028350830078;
        double bias0_rdCal = 0.31913596391677856;
        double bias0_rdTestVolts = 0.254697322845459;
        double bias0_rdTol = 0.8870211243629456;
        double bias0_rdValueErr = 0.7906055450439453;
        double bias0_rdZeroErr = 0.4746529f;
        double bias1_gdCal = 0.3959372639656067;
        double bias1_gdTestVolts = 0.39797717332839966;
        double bias1_gdTol = 0.2687937021255493;
        double bias1_gdValueErr = 0.8449721336364746;
        double bias1_gdZeroErr = 0.0364545f;
        double bias1_odCal = 0.16007602214813232;
        double bias1_odIMax = 0.09285646677017212;
        double bias1_odTol = 0.6404802799224854;
        double bias1_odZeroErr = 0.8353633284568787;
        double bias1_ogCal = 0.5162147283554077;
        double bias1_ogTestVolts = 0.5244204998016357;
        double bias1_ogTol = 0.9963333010673523;
        double bias1_ogValueErr = 0.8529219031333923;
        double bias1_ogZeroErr = 0.6539435982704163;
        double bias1_rdCal = 0.6832115650177002;
        double bias1_rdTestVolts = 0.3940030336380005;
        double bias1_rdTol = 0.46446192264556885;
        double bias1_rdValueErr = 0.6667547225952148;
        double bias1_rdZeroErr = 0.785281777381897;
        double bias2_gdCal = 0.05614161491394043;
        double bias2_gdTestVolts = 0.8354184627532959;
        double bias2_gdTol = 0.2241965f;
        double bias2_gdValueErr = 0.056224942207336426;
        double bias2_gdZeroErr = 0.3308407f;
        double bias2_odCal = 0.33388835191726685;
        double bias2_odIMax = 0.19930672645568848;
        double bias2_odTol = 0.002245903f;
        double bias2_odZeroErr = 0.29876023530960083;
        double bias2_ogCal = 0.21695858240127563;
        double bias2_ogTestVolts = 0.9616172313690186;
        double bias2_ogTol = 0.6213663816452026;
        double bias2_ogValueErr = 0.5977584719657898;
        double bias2_ogZeroErr = 0.8756877183914185;
        double bias2_rdCal = 0.5300258994102478;
        double bias2_rdTestVolts = 0.2699286937713623;
        double bias2_rdTol = 0.761646032333374;
        double bias2_rdValueErr = 0.04176253080368042;
        double bias2_rdZeroErr = 0.5845368504524231;
        double clkhiAmin = 0.7356207370758057;
        double clkhiQmax = 0.9127047061920166;
        double clkliAmin = 0.4677708148956299;
        double clkliQmax = 0.4797503352165222;
        double dac_clkhIMax = 0.3428477f;
        double dac_clklIMax = 0.08497792482376099;
        double dac_pclkHighCal = 0.4046521782875061;
        double dac_pclkHighTestV = 0.9846665859222412;
        double dac_pclkHighTol = 0.8803902864456177;
        double dac_pclkHighValueErr = 0.6435010433197021;
        double dac_pclkHighZeroErr = 0.5667428970336914;
        double dac_pclkLowCal = 0.9196158051490784;
        double dac_pclkLowTestV = 0.8115205764770508;
        double dac_pclkLowTol = 0.5131617784500122;
        double dac_pclkLowValueErr = 0.4400886297225952;
        double dac_pclkLowZeroErr = 0.17681902647018433;
        double dac_rgHighCal = 0.6353194117546082;
        double dac_rgHighTestV = 0.2524649500846863;
        double dac_rgHighTol = 0.637143075466156;
        double dac_rgHighValueErr = 0.6292307376861572;
        double dac_rgHighZeroErr = 0.7127071619033813;
        double dac_rgLowCal = 0.36793702840805054;
        double dac_rgLowTestV = 0.30502426624298096;
        double dac_rgLowTol = 0.06404852867126465;
        double dac_rgLowValueErr = 0.1651352047920227;
        double dac_rgLowZeroErr = 0.8331937789916992;
        double dac_sclkHighCal = 0.2701908349990845;
        double dac_sclkHighTestV = 0.76185f;
        double dac_sclkHighTol = 0.1770975f;
        double dac_sclkHighValueErr = 0.17487603425979614;
        double dac_sclkHighZeroErr = 0.9554026126861572;
        double dac_sclkLowCal = 0.4971234202384949;
        double dac_sclkLowTestV = 0.7803268432617188;
        double dac_sclkLowTol = 0.04092991352081299;
        double dac_sclkLowValueErr = 0.08142662048339844;
        double dac_sclkLowZeroErr = 0.20649641752243042;
        String location = "g";
        double maxDelta = 0.6030567288398743;
        double maxStep = 0.080874502658844;
        double minTol = 0.7584611773490906;
        int nPowerOnPub = 724;
        double odiAmin = 0.20417052507400513;
        double odiQmax = 0.4387333393096924;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRebRaftsPowerSettingsAppliedEvent(priority, version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRebRaftsPowerSettingsAppliedEvent));
        FocalPlaneRebRaftsPowerSettingsAppliedEvent item_ = (FocalPlaneRebRaftsPowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)bias0_gdCal, (double)item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_gdTestVolts, (double)item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_gdTol, (double)item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_gdValueErr, (double)item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_gdZeroErr, (double)item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_odCal, (double)item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_odIMax, (double)item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_odTol, (double)item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_odZeroErr, (double)item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogCal, (double)item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogTestVolts, (double)item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogTol, (double)item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogValueErr, (double)item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_ogZeroErr, (double)item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdCal, (double)item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdTestVolts, (double)item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdTol, (double)item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdValueErr, (double)item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias0_rdZeroErr, (double)item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdCal, (double)item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdTestVolts, (double)item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdTol, (double)item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdValueErr, (double)item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_gdZeroErr, (double)item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_odCal, (double)item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_odIMax, (double)item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_odTol, (double)item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_odZeroErr, (double)item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogCal, (double)item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogTestVolts, (double)item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogTol, (double)item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogValueErr, (double)item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_ogZeroErr, (double)item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdCal, (double)item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdTestVolts, (double)item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdTol, (double)item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdValueErr, (double)item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias1_rdZeroErr, (double)item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdCal, (double)item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdTestVolts, (double)item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdTol, (double)item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdValueErr, (double)item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_gdZeroErr, (double)item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_odCal, (double)item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_odIMax, (double)item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_odTol, (double)item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_odZeroErr, (double)item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogCal, (double)item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogTestVolts, (double)item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogTol, (double)item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogValueErr, (double)item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_ogZeroErr, (double)item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdCal, (double)item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdTestVolts, (double)item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdTol, (double)item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdValueErr, (double)item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)bias2_rdZeroErr, (double)item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhiAmin, (double)item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertEquals((double)clkhiQmax, (double)item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertEquals((double)clkliAmin, (double)item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertEquals((double)clkliQmax, (double)item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_clkhIMax, (double)item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_clklIMax, (double)item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighCal, (double)item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighTestV, (double)item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighTol, (double)item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighValueErr, (double)item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkHighZeroErr, (double)item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowCal, (double)item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowTestV, (double)item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowTol, (double)item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowValueErr, (double)item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_pclkLowZeroErr, (double)item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighCal, (double)item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighTestV, (double)item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighTol, (double)item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighValueErr, (double)item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgHighZeroErr, (double)item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowCal, (double)item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowTestV, (double)item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowTol, (double)item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowValueErr, (double)item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_rgLowZeroErr, (double)item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighCal, (double)item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighTestV, (double)item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighTol, (double)item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighValueErr, (double)item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkHighZeroErr, (double)item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowCal, (double)item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowTestV, (double)item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowTol, (double)item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowValueErr, (double)item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertEquals((double)dac_sclkLowZeroErr, (double)item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((double)maxDelta, (double)item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertEquals((double)maxStep, (double)item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertEquals((double)minTol, (double)item_.getMinTol(), (double)1.0E-6f);
        Assert.assertEquals((long)nPowerOnPub, (long)item_.getNPowerOnPub());
        Assert.assertEquals((double)odiAmin, (double)item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertEquals((double)odiQmax, (double)item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitorSettingsAppliedEvent() throws Exception {
        int priority = 453;
        int version = 598;
        String daqPartition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitorSettingsAppliedEvent(priority, version, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitorSettingsAppliedEvent));
        Daq_monitorSettingsAppliedEvent item_ = (Daq_monitorSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_StatsSettingsAppliedEvent() throws Exception {
        int priority = 660;
        int version = 720;
        boolean enablePeriodicPublication = false;
        int minDiffAlertWarning = 404;
        int minDiffLogWarning = 478;
        String sumDriverChecks = "u";
        String sumDriverStats = "r";
        String sumFirmwareChecks = "";
        String sumFirmwareStats = "";
        String sumRdsChecks = "d";
        String sumRdsStats = "";
        String sumRmsChecks = "q";
        String sumRmsStats = "v";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StatsSettingsAppliedEvent(priority, version, enablePeriodicPublication, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StatsSettingsAppliedEvent));
        Daq_monitor_StatsSettingsAppliedEvent item_ = (Daq_monitor_StatsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)enablePeriodicPublication, (Object)item_.isEnablePeriodicPublication());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreSettingsAppliedEvent() throws Exception {
        int priority = 908;
        int version = 396;
        String daqFolder = "";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.19236081838607788;
        double purgeThreshold = 0.7246916890144348;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreSettingsAppliedEvent(priority, version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreSettingsAppliedEvent));
        Daq_monitor_StoreSettingsAppliedEvent item_ = (Daq_monitor_StoreSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveShutterBladeMotionProfileEvent() throws Exception {
        int priority = 280;
        ShutterBladeMotionProfileEvent.Blade blade = ShutterBladeMotionProfileEvent.Blade.PLUS_X;
        ShutterBladeMotionProfileEvent.Direction direction = ShutterBladeMotionProfileEvent.Direction.CLOSE;
        double timestampStart = 0.7313113808631897;
        double startPosition = 0.14355623722076416;
        double targetDuration = 0.39347296953201294;
        double targetPosition = 0.020060718059539795;
        double endPosition = 0.07311499118804932;
        double actualDuration = 0.9141726493835449;
        int hallSensorCount = 587;
        double[] timestampHallSensor = new double[]{0.017766296863555908, 0.2598305344581604, 0.03238457441329956, 0.4474249f, 0.9313623905181885, 0.745053f, 0.6806038618087769, 0.6685231328010559, 0.11932981014251709, 0.21813362836837769, 0.3648768663406372, 0.37483012676239014, 0.8401934504508972, 0.9367903470993042, 0.36026543378829956, 0.9548732042312622, 0.846602737903595, 0.7819063067436218, 0.6360480785369873, 0.7582656741142273, 0.6699661016464233, 0.09156733751296997, 0.8263404965400696, 0.577224612236023, 0.4162448048591614, 0.910647451877594, 0.6598370671272278, 0.40720945596694946, 0.08686012029647827, 0.6933475732803345, 0.5346096754074097, 0.671680748462677, 0.9472615718841553, 0.9778167009353638, 0.3282786011695862, 0.8898637294769287, 0.13036507368087769, 0.263749361038208, 0.8565203547477722, 0.6208995580673218, 0.5267452597618103, 0.5557001829147339, 0.7480601668357849, 0.3869706988334656, 0.575219452381134, 0.4674455523490906, 0.5843941569328308, 0.1316300630569458, 0.026497721672058105, 0.7373479604721069, 0.4780054f, 0.8429917097091675, 0.2622036933898926, 0.6932491064071655, 0.43241333961486816, 0.015633821487426758, 0.6682465672492981, 0.9804776906967163, 0.7677831649780273, 0.15662521123886108, 0.6948150396347046, 0.47126704454421997, 0.11190629005432129, 0.09223568439483643, 0.09786117076873779, 0.09202694892883301, 0.2811485528945923, 0.20048797130584717, 0.9146711230278015, 0.6109184622764587, 0.22058796882629395, 0.1942228078842163, 0.6479204297065735, 0.6370763778686523, 0.7762812376022339, 0.7888868451118469, 0.0405619740486145, 2.7757883071899414E-4, 0.752791702747345, 0.6035393476486206, 0.5431790947914124, 0.7521548271179199, 0.611293613910675, 0.3229595422744751, 0.8843878507614136, 0.5941145420074463, 0.5113627910614014, 0.3691990375518799, 0.0349254f, 0.07047587633132935, 0.744737982749939, 0.734065055847168, 0.741792f, 0.23617452383041382, 0.08176732063293457, 0.8670662641525269, 0.837917685508728, 0.22544550895690918, 0.10895282030105591, 0.5191545486450195, 0.7961177229881287, 0.6106455326080322, 0.3151012659072876, 0.6496312618255615, 0.7875327467918396, 0.18881899118423462, 0.8483423590660095, 0.11595678329467773, 0.571389f, 0.7984322309494019, 0.4590691328048706, 0.10363179445266724, 0.3349548f, 0.5211735963821411, 0.9351938366889954, 0.6011621952056885, 0.5233348608016968, 0.6257666945457458, 0.17463302612304688, 0.6843522191047668, 0.3546783924102783, 0.46490478515625, 0.10239458084106445, 0.711392879486084, 0.16704648733139038, 0.2358495593070984, 0.6809166073799133, 0.5276538729667664, 0.7512941360473633, 0.6937392950057983, 0.8654171228408813, 0.4845951795578003, 0.1056789755821228, 0.08863133192062378, 0.1820812225341797, 0.05427068471908569, 0.5214723944664001, 0.4478017f, 0.6452009081840515, 0.3985958695411682, 0.9466773271560669, 0.8995060920715332, 0.5472736358642578, 0.7756286859512329, 0.2522529363632202, 0.7295560836791992, 0.6490641236305237, 0.7439114451408386, 0.37032806873321533, 0.8646038174629211, 0.9383781552314758, 0.8864242434501648, 0.5181974172592163, 0.21348637342453003, 0.2185397744178772, 0.10950464010238647, 0.5500080585479736, 0.8885334730148315, 0.710189f, 0.3864247798919678, 0.2776535749435425, 0.5311670303344727, 0.8110361695289612, 0.283031165599823, 0.7143215537071228, 0.4298403859138489, 0.4437502f, 0.4124288558959961, 0.16232693195343018, 0.6334140300750732, 0.6464796662330627, 0.5712229609489441, 0.8883883357048035, 0.010107755661010742, 0.4159959554672241, 0.18105238676071167, 0.5045515298843384, 0.002496778964996338, 0.3206069f, 0.5314055681228638, 0.7548640966415405, 0.3945449f, 0.15745294094085693, 0.443982f, 0.05309480428695679, 0.5899285674095154, 0.3633301258087158, 0.3717476f, 0.1348469853401184, 0.9450693726539612, 0.004653573036193848, 0.6395641565322876, 0.5910294055938721, 0.4891449213027954, 0.8036074638366699, 0.8256937861442566, 0.8046416640281677, 0.6713044047355652, 0.7150382399559021, 0.9880751371383667, 0.0881474f, 0.5174156427383423, 0.2915079f, 0.13513261079788208, 0.2364257f, 0.06057637929916382, 0.2795097231864929, 0.6227433681488037, 0.5955899357795715, 0.07762682437896729, 0.22366827726364136, 0.8872032761573792, 0.3791808f, 0.8549120426177979, 0.041434288024902344, 0.4745718240737915, 0.8218094706535339, 0.8981080651283264, 0.6200982928276062, 0.841245710849762, 0.7808223366737366, 0.561198353767395, 0.11076831817626953, 0.0362359881401062, 0.2166774868965149, 0.5074688792228699, 0.2082958221435547, 0.5552515387535095, 0.19328314065933228, 0.6300828456878662, 0.84812f, 0.3188076615333557, 0.4344951f, 0.5914474725723267, 0.284894f, 0.5752735137939453, 0.2993737459182739, 0.9198556542396545, 0.8859411478042603, 0.284783f};
        int[] hallSensorID = new int[]{170, 743, 788, 434, 291, 638, 127, 852, 378, 652, 186, 947, 281, 691, 84, 12, 881, 910, 770, 293, 275, 187, 202, 216, 849, 20, 965, 398, 848, 356, 72, 943, 669, 302, 560, 485, 873, 705, 495, 264, 58, 201, 271, 604, 759, 767, 498, 398, 95, 584, 756, 662, 135, 859, 677, 215, 255, 979, 711, 529, 351, 900, 496, 0, 619, 931, 700, 301, 216, 566, 611, 786, 306, 419, 330, 891, 523, 413, 905, 736, 258, 960, 545, 71, 358, 526, 815, 94, 934, 434, 617, 630, 46, 449, 971, 43, 968, 480, 678, 128, 596, 121, 535, 591, 309, 439, 528, 726, 458, 729, 261, 517, 78, 300, 316, 732, 229, 760, 986, 106, 435, 996, 254, 336, 114, 390, 421, 563, 463, 219, 25, 248, 786, 492, 926, 899, 529, 977, 371, 824, 912, 184, 561, 178, 630, 614, 324, 185, 367, 262, 138, 166, 418, 759, 84, 451, 982, 983, 193, 853, 662, 750, 801, 795, 285, 149, 989, 81, 688, 637, 713, 453, 79, 908, 18, 346, 640, 571, 770, 362, 816, 963, 373, 143, 22, 533, 39, 690, 798, 312, 332, 581, 351, 821, 59, 764, 954, 799, 664, 533, 391, 671, 676, 440, 478, 3, 340, 962, 86, 14, 619, 68, 333, 427, 605, 880, 253, 235, 553, 355, 719, 230, 441, 318, 679, 846, 89, 63, 348, 159, 874, 956, 722, 738, 242, 263, 694, 337, 178, 261};
        double[] hallSensorPosition = new double[]{0.8349572420120239, 0.05315440893173218, 0.8198965191841125, 0.5077343583106995, 0.7708647847175598, 0.2524857521057129, 0.9283267855644226, 0.4557059407234192, 0.08200287818908691, 0.8293628096580505, 0.8970068693161011, 0.2322337031364441, 0.659993f, 0.9325717687606812, 0.4854145050048828, 0.18520653247833252, 0.35989898443222046, 0.22506767511367798, 0.14500826597213745, 0.10195744037628174, 0.7472650408744812, 0.7284701466560364, 0.5455885529518127, 0.8110129237174988, 0.19291293621063232, 0.7421621084213257, 0.09804767370223999, 0.4464316964149475, 0.3112324f, 0.15415281057357788, 0.6058251857757568, 0.10584050416946411, 0.8688523173332214, 0.05147433280944824, 0.7004167437553406, 0.6102726459503174, 0.16373854875564575, 0.2257222f, 0.6810241937637329, 0.1661999225616455, 0.9088693857192993, 0.11945706605911255, 0.2741441f, 0.766837f, 0.7217692732810974, 0.5272254347801208, 0.7229553461074829, 0.9956062436103821, 0.9965223670005798, 0.14721661806106567, 0.4042872190475464, 0.6199347376823425, 0.746765673160553, 0.9629706144332886, 0.8263643383979797, 0.6142929196357727, 0.6880226731300354, 0.6466214656829834, 0.6851903200149536, 0.41917216777801514, 0.5601454377174377, 0.33406996726989746, 0.5312292575836182, 0.7347690463066101, 0.36329346895217896, 0.4870149f, 0.22898507118225098, 0.6373441815376282, 0.6345996856689453, 0.276350736618042, 0.5662907958030701, 0.4810322f, 0.17140984535217285, 0.2860983610153198, 0.2018665075302124, 0.8623965978622437, 0.2078021764755249, 0.027436554431915283, 0.3213622570037842, 0.8489788770675659, 0.17418742179870605, 0.08984065055847168, 0.4241867661476135, 0.9418308734893799, 0.9684880375862122, 0.9527187347412109, 0.18455815315246582, 0.6065274477005005, 0.4981291890144348, 0.8888053894042969, 0.24716395139694214, 0.18402493000030518, 0.9244294762611389, 0.7530982494354248, 0.6354634165763855, 0.11419862508773804, 0.06763821840286255, 0.15208107233047485, 0.502015f, 0.4687958359718323, 0.2776569128036499, 0.8017957806587219, 0.646397590637207, 0.11037266254425049, 0.4113478f, 0.2250347137451172, 0.3065752387046814, 0.4486308693885803, 0.5043429136276245, 0.11318850517272949, 0.511311f, 0.8501695990562439, 0.10861527919769287, 0.13340067863464355, 0.909978985786438, 0.632366418838501, 0.8650884032249451, 0.033549726009368896, 0.6954838037490845, 0.11287665367126465, 0.674673318862915, 0.06375402212142944, 0.5577300786972046, 0.0346936f, 0.25591927766799927, 0.861728f, 0.6790806651115417, 0.500071f, 0.0706256628036499, 0.5492081046104431, 0.5675011873245239, 0.2477231f, 0.6511227488517761, 0.25721925497055054, 0.053745925426483154, 0.13506555557250977, 0.5684199333190918, 0.1792144775390625, 0.420258f, 0.24494272470474243, 0.3861231803894043, 0.47374796867370605, 0.32380956411361694, 0.34402942657470703, 0.40112733840942383, 0.4736320972442627, 0.6918114423751831, 0.963251531124115, 0.18191653490066528, 0.16838771104812622, 0.9623038172721863, 0.15011334419250488, 0.48530107736587524, 0.4137721657752991, 0.0766598f, 0.7253578305244446, 0.1221545934677124, 0.779416024684906, 0.2768756151199341, 0.4441349506378174, 0.5148841738700867, 0.00691455602645874, 0.5889905095100403, 0.862678587436676, 0.759788f, 0.24051225185394287, 0.5518115162849426, 0.5088573098182678, 0.8950796723365784, 0.17582905292510986, 0.26496803760528564, 0.4779793620109558, 0.15224981307983398, 0.10457044839859009, 0.7497748136520386, 0.1686194f, 0.30979394912719727, 0.21112632751464844, 0.3359434f, 0.147347092628479, 0.9024807214736938, 0.9873150587081909, 0.7804882526397705, 0.21205365657806396, 0.19770705699920654, 0.0017998814582824707, 0.893978476524353, 0.5026865005493164, 0.2176659107208252, 0.6090694069862366, 0.9734766483306885, 0.8928537964820862, 0.0497211217880249, 0.2681116461753845, 0.529084324836731, 0.05878615379333496, 0.5883772969245911, 0.6124424338340759, 0.928119f, 0.25203055143356323, 0.23448187112808228, 0.06101113557815552, 0.2818338871002197, 0.35309863090515137, 0.937881f, 0.7643618583679199, 0.35663992166519165, 0.7248210906982422, 0.00886458158493042, 0.8635683059692383, 0.525514f, 0.4517327547073364, 0.9946938753128052, 0.11279827356338501, 0.8843053579330444, 0.9963942170143127, 0.4767602f, 0.7324386835098267, 0.0687408447265625, 0.14175671339035034, 0.2010408f, 0.16168522834777832, 0.02596902847290039, 0.35271936655044556, 0.522193193435669, 0.05116891860961914, 0.8524715900421143, 0.677761971950531, 0.6856864094734192, 0.15195822715759277, 0.7192482352256775, 0.8364443778991699, 0.161748468875885, 0.6321895122528076, 0.10460102558135986, 0.7797408103942871, 0.7016832828521729, 0.0922970175743103, 0.8619933128356934, 0.3623538017272949};
        boolean[] hallSensorTransition = new boolean[]{false, false, true, true, false, false, false, true, true, true, true, false, false, true, false, true, false, false, true, true, false, false, true, false, false, false, false, true, false, true, false, true, true, false, true, true, false, true, true, false, false, true, false, true, false, false, false, true, false, false, false, false, true, false, false, false, true, false, false, true, true, false, false, true, false, true, false, true, false, false, false, false, true, true, false, true, false, true, true, true, false, false, true, true, false, false, true, true, false, false, true, false, false, true, false, false, true, true, false, false, true, false, false, false, false, false, true, true, true, true, false, true, false, false, true, true, false, false, false, false, false, true, true, true, true, true, true, false, true, false, false, true, false, false, false, true, false, true, true, true, true, false, true, true, true, false, false, true, false, true, false, false, false, false, true, false, true, false, true, true, true, false, true, false, true, true, true, true, true, true, true, true, true, false, true, true, true, true, false, true, false, true, true, true, true, false, true, true, false, false, true, false, false, true, false, false, true, false, false, true, true, true, true, false, true, true, false, true, false, false, false, true, false, false, true, true, false, true, false, false, true, true, true, false, true, true, false, true, false, false, true, false, true, false, true, true, true, false, false, true};
        int encoderCount = 799;
        double[] timestampEncoder = new double[]{0.6503531336784363, 0.00792855f, 0.03374302387237549, 0.9140632152557373, 0.3034737f, 0.5301044583320618, 0.8447704315185547, 0.5800148248672485, 0.9197233319282532, 0.3724360466003418, 0.7258525490760803, 0.5308462977409363, 0.689347505569458, 0.4999144673347473, 0.15168523788452148, 0.3233150839805603, 0.6739442944526672, 0.8003124594688416, 0.8840603828430176, 0.1999720335006714, 0.3641918897628784, 0.1045953f, 0.586685299873352, 0.07568937540054321, 0.6804636716842651, 0.4218956232070923, 0.5800520777702332, 0.306423f, 0.7984023094177246, 0.549782395362854, 0.45498377084732056, 0.08471924066543579, 0.4435202479362488, 0.1747344732284546, 0.4860857129096985, 0.20062655210494995, 0.5253089070320129, 0.49706172943115234, 0.1789099f, 0.922715425491333, 0.21220701932907104, 0.16325223445892334, 0.5513094067573547, 0.13890838623046875, 0.21476882696151733, 0.3092518448829651, 0.6099345684051514, 0.600970983505249, 0.21676874160766602, 0.08100646734237671, 0.9224645495414734, 0.04314148426055908, 0.03470128774642944, 0.45235252380371094, 0.7059468626976013, 0.2009183168411255, 0.29771554470062256, 0.1817813515663147, 0.7181359529495239, 0.9000556468963623, 0.7156334519386292, 0.5936198234558105, 0.7342118620872498, 0.6810342669487, 0.476121723651886, 0.6187577247619629, 0.06356239318847656, 0.08649373054504395, 0.007741868495941162, 0.3463588356971741, 0.47391778230667114, 0.18728214502334595, 0.4285205602645874, 0.7102625370025635, 0.8721213340759277, 0.028969526290893555, 0.025536537170410156, 0.929409384727478, 0.9869453310966492, 0.020075678825378418, 0.276092529296875, 0.8361074328422546, 0.21995443105697632, 0.38420385122299194, 0.31224966049194336, 0.23293238878250122, 0.40147173404693604, 0.39219456911087036, 0.5753852725028992, 0.22028517723083496, 0.8018012642860413, 0.36188453435897827, 0.3241550326347351, 0.9119870662689209, 0.8102445602416992, 0.24977731704711914, 0.9065913558006287, 0.813798725605011, 0.8789604902267456, 0.9017178416252136, 0.4344574213027954, 0.1655225157737732, 0.8238404393196106, 0.7224611043930054, 0.995449960231781, 0.8556565046310425, 0.3343989849090576, 0.16390752792358398, 0.4870567321777344, 0.8007899522781372, 0.5389488339424133, 0.21893548965454102, 0.8761265277862549, 0.46057581901550293, 0.9353818297386169, 0.19551920890808105, 0.39240384101867676, 0.0318138f, 0.6826966404914856, 0.7906205654144287, 0.2049654722213745, 0.7586924433708191, 0.6705963611602783, 0.6947575211524963, 0.250831663608551, 0.21544432640075684, 0.47625845670700073, 0.14887607097625732, 0.4687969f, 0.6955842971801758, 0.0765959620475769, 0.511004f, 0.013155996799468994, 0.389645516872406, 0.3244718313217163, 0.6400936245918274, 0.4965214133262634, 0.5901732444763184, 0.797491f, 0.8905333876609802, 0.7440076470375061, 0.04605609178543091, 0.7829034328460693, 0.5582185387611389, 0.3789821267127991, 0.9435774087905884, 0.23216503858566284, 0.5061484575271606, 0.1402691f, 0.04249382019042969, 0.37979036569595337, 0.40569454431533813, 0.6296751499176025, 0.7937451601028442, 0.014896035194396973, 0.9935399293899536, 0.0751552f, 0.940955400466919, 0.7775058150291443, 0.10151857137680054, 0.1776370406150818, 0.11870795488357544, 0.24811553955078125, 0.058002352714538574, 0.5878888368606567, 0.34279865026474, 0.446674644947052, 0.6790383458137512, 0.5738877654075623, 0.4055485725402832, 0.8601377010345459, 0.21220511198043823, 0.9195892214775085, 0.9851754307746887, 0.4957928f, 0.7163221836090088, 0.6140961050987244, 0.5226884484291077, 0.19604378938674927, 0.8590373396873474, 0.9079030752182007, 0.4614155888557434, 0.5501790642738342, 0.5983737707138062, 0.4326738715171814, 0.4598551392555237, 0.9665083885192871, 0.743118405342102, 0.29607248306274414, 0.43294817209243774, 0.6063153743743896, 0.7231611609458923, 0.00729447603225708, 0.33310025930404663, 0.977205f, 0.760383f, 0.2865495f, 0.11147481203079224, 0.6011083126068115, 0.9323744773864746, 0.9278703927993774, 0.2914939522743225, 0.6405305862426758, 0.7372221946716309, 0.9749284982681274, 0.6074967980384827, 0.030330181121826172, 0.7730217576026917, 0.23031193017959595, 0.6076322197914124, 0.13174086809158325, 0.06898140907287598, 0.13688474893569946, 0.4649277329444885, 0.32647645473480225, 0.6774181127548218, 0.07293188571929932, 0.2858484983444214, 0.1931876540184021, 0.042186856269836426, 0.2089687f, 0.3314070701599121, 0.8635f, 0.7868179678916931, 0.04214549f, 0.9800314903259277, 0.013203442096710205, 0.25569117069244385, 0.20352166891098022, 0.250063419342041, 0.3943629264831543, 0.9378864169120789, 0.9141576886177063, 0.8772063255310059, 0.3102787733078003, 0.8030017614364624, 0.7286413311958313, 0.5008583068847656, 0.4470691680908203, 0.28140032291412354};
        double[] encoderPosition = new double[]{0.7706174850463867, 0.47354668378829956, 0.7385295629501343, 0.7813725471496582, 0.24604082107543945, 0.2682746648788452, 0.7058215737342834, 0.1090155839920044, 0.46875715255737305, 0.8462410569190979, 0.9970532655715942, 0.25281256437301636, 0.1928073763847351, 0.6669959425926208, 0.6861705183982849, 0.7266314625740051, 0.600325345993042, 0.10764491558074951, 0.573624312877655, 0.9979845881462097, 0.6174829006195068, 0.8183566927909851, 0.07649964094161987, 0.6318298578262329, 0.23866015672683716, 0.2174096703529358, 0.8822810649871826, 0.27603602409362793, 0.5365505218505859, 0.7377258539199829, 0.9629201292991638, 0.8280600905418396, 0.969538688659668, 0.22378402948379517, 0.6647076606750488, 0.3317262530326843, 0.30432742834091187, 0.7666182518005371, 0.7806218862533569, 0.8396885991096497, 0.9289778470993042, 0.3070452809333801, 0.9169155359268188, 0.57578444480896, 0.907426655292511, 0.16321277618408203, 0.2419554591178894, 0.8797241449356079, 0.8299506306648254, 0.7060214877128601, 0.2755822539329529, 0.20525145530700684, 0.24436503648757935, 0.25108712911605835, 0.6799971461296082, 0.6659785509109497, 0.25002098083496094, 0.7229271531105042, 0.7525046467781067, 0.5276303291320801, 0.13155996799468994, 0.2183634638786316, 0.2160738706588745, 0.5816146731376648, 0.7731895446777344, 0.5222405195236206, 0.9409773945808411, 0.4059907793998718, 0.9888686537742615, 0.25809115171432495, 0.9107029438018799, 0.2324819564819336, 0.9317814707756042, 0.36610865592956543, 0.3345072269439697, 0.05174213647842407, 0.9009913802146912, 0.2455756664276123, 0.5896274447441101, 0.9663316607475281, 0.2779970169067383, 0.2617756724357605, 0.19612634181976318, 0.8576100468635559, 0.0254705548286438, 0.5594959259033203, 0.3501044511795044, 0.5879529118537903, 0.32978355884552, 0.735785186290741, 0.49566978216171265, 0.08542346954345703, 0.1236853f, 0.971034824848175, 0.8473304510116577, 0.3294628858566284, 0.5819786190986633, 0.5952181816101074, 0.7927321195602417, 0.0016371607780456543, 0.32815104722976685, 0.7488806247711182, 0.3368644118309021, 0.11643165349960327, 0.25121062994003296, 0.08798271417617798, 0.5846213102340698, 0.48808616399765015, 0.1276019811630249, 0.2578394412994385, 0.10613560676574707, 0.3082171082496643, 0.9318339228630066, 0.8321828842163086, 0.5614796280860901, 0.24628931283950806, 0.9507452249526978, 0.3649328351020813, 0.3665999174118042, 0.38482964038848877, 0.8802147507667542, 0.2488483190536499, 0.4148409366607666, 0.4606884f, 0.6602405309677124, 0.9092357754707336, 0.8978352546691895, 0.50284343957901, 0.21597141027450562, 0.002817809581756592, 0.33124858140945435, 0.1895303726196289, 0.7303743362426758, 0.34034425020217896, 0.735842227935791, 0.4493151903152466, 0.931314f, 0.1333240270614624, 0.06915563344955444, 0.8116698861122131, 0.8750594854354858, 0.38524436950683594, 0.9800442457199097, 0.28536665439605713, 0.2334151268005371, 0.1388377547264099, 0.5651848912239075, 0.5733909606933594, 0.41720718145370483, 0.26448744535446167, 0.35695648193359375, 0.8900324106216431, 0.4097848f, 0.2699854373931885, 0.3449241f, 0.6514145731925964, 0.7461811900138855, 0.5459582805633545, 0.5232203006744385, 0.690171480178833, 0.10290920734405518, 0.679862916469574, 0.6237860321998596, 0.17658203840255737, 0.7969587445259094, 0.1981566f, 0.2166767716407776, 0.09368312358856201, 0.6079548001289368, 0.8828257322311401, 0.8750627636909485, 0.3472723364830017, 0.6027861833572388, 0.7847954034805298, 0.2713779807090759, 0.5309661030769348, 0.566125750541687, 0.18084394931793213, 0.8151566982269287, 0.10243260860443115, 0.6225319504737854, 0.02865135669708252, 0.20091331005096436, 0.5535042881965637, 0.216303288936615, 0.33076733350753784, 0.21007037162780762, 0.8211714029312134, 0.724603533744812, 0.1649855375289917, 0.524152934551239, 0.1386559009552002, 0.18888407945632935, 0.746355f, 0.6425913572311401, 0.16918432712554932, 0.4212082624435425, 0.6034871339797974, 0.25848788022994995, 0.20617163181304932, 0.6782745122909546, 0.955681f, 0.3962072f, 0.5218521356582642, 0.1899036169052124, 0.4225732088088989, 0.03787273168563843, 0.3646594285964966, 0.7142853140830994, 0.8675350546836853, 0.9096395373344421, 0.3596722483634949, 0.4937942624092102, 0.1310117244720459, 0.12645351886749268, 0.0751606822013855, 0.1677112579345703, 0.6396954655647278, 0.8349857330322266, 0.6537532806396484, 0.41739994287490845, 0.9492185115814209, 0.1932897f, 0.74419766664505, 0.07167041301727295, 0.5874601602554321, 0.592810332775116, 0.5374249219894409, 0.67213f, 0.5862097144126892, 0.08965545892715454, 0.7400966882705688, 0.8178134560585022, 0.6225771307945251, 0.4591280221939087, 0.4945831894874573, 0.09346562623977661, 0.11807596683502197, 0.02763331f, 0.9640874862670898};
        SALEvent item = this.testSendReceive((SALEvent)new ShutterBladeMotionProfileEvent(priority, blade, direction, timestampStart, startPosition, targetDuration, targetPosition, endPosition, actualDuration, hallSensorCount, timestampHallSensor, hallSensorID, hallSensorPosition, hallSensorTransition, encoderCount, timestampEncoder, encoderPosition));
        Assert.assertTrue((boolean)(item instanceof ShutterBladeMotionProfileEvent));
        ShutterBladeMotionProfileEvent item_ = (ShutterBladeMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)blade, (Object)item_.getBlade());
        Assert.assertEquals((Object)direction, (Object)item_.getDirection());
        Assert.assertEquals((double)timestampStart, (double)item_.getTimestampStart(), (double)1.0E-6f);
        Assert.assertEquals((double)startPosition, (double)item_.getStartPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)targetDuration, (double)item_.getTargetDuration(), (double)1.0E-6f);
        Assert.assertEquals((double)targetPosition, (double)item_.getTargetPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)endPosition, (double)item_.getEndPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)actualDuration, (double)item_.getActualDuration(), (double)1.0E-6f);
        Assert.assertEquals((long)hallSensorCount, (long)item_.getHallSensorCount());
        Assert.assertArrayEquals((double[])timestampHallSensor, (double[])item_.getTimestampHallSensor(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])hallSensorID, (int[])item_.getHallSensorID());
        Assert.assertArrayEquals((double[])hallSensorPosition, (double[])item_.getHallSensorPosition(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])hallSensorTransition, (boolean[])item_.getHallSensorTransition());
        Assert.assertEquals((long)encoderCount, (long)item_.getEncoderCount());
        Assert.assertArrayEquals((double[])timestampEncoder, (double[])item_.getTimestampEncoder(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])encoderPosition, (double[])item_.getEncoderPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageStoredEvent() throws Exception {
        int priority = 73;
        String imageName = "zoqlplwaljyjzrnavkzkpecckd";
        double timestampImageStored = 0.9168487787246704;
        SALEvent item = this.testSendReceive((SALEvent)new ImageStoredEvent(priority, imageName, timestampImageStored));
        Assert.assertTrue((boolean)(item instanceof ImageStoredEvent));
        ImageStoredEvent item_ = (ImageStoredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampImageStored, (double)item_.getTimestampImageStored(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFitsFilesWrittenEvent() throws Exception {
        int priority = 955;
        String imageName = "wsspqdhxsrhhzcjfsgzljzdbejtqh";
        double timestampFilesWritten = 0.8882981538772583;
        String rootFileName = "x";
        String relativeFileNames = "r";
        String fileNode = "";
        SALEvent item = this.testSendReceive((SALEvent)new FitsFilesWrittenEvent(priority, imageName, timestampFilesWritten, rootFileName, relativeFileNames, fileNode));
        Assert.assertTrue((boolean)(item instanceof FitsFilesWrittenEvent));
        FitsFilesWrittenEvent item_ = (FitsFilesWrittenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampFilesWritten, (double)item_.getTimestampFilesWritten(), (double)1.0E-6f);
        Assert.assertEquals((Object)rootFileName, (Object)item_.getRootFileName());
        Assert.assertEquals((Object)relativeFileNames, (Object)item_.getRelativeFileNames());
        Assert.assertEquals((Object)fileNode, (Object)item_.getFileNode());
    }

    @Test
    public void sendReceiveFileCommandExecutionEvent() throws Exception {
        int priority = 538;
        String imageName = "liwuqzuglcmmagvqpkc";
        double timestampCommandComplete = 0.0801962f;
        String command = "";
        int rc = 2;
        SALEvent item = this.testSendReceive((SALEvent)new FileCommandExecutionEvent(priority, imageName, timestampCommandComplete, command, rc));
        Assert.assertTrue((boolean)(item instanceof FileCommandExecutionEvent));
        FileCommandExecutionEvent item_ = (FileCommandExecutionEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampCommandComplete, (double)item_.getTimestampCommandComplete(), (double)1.0E-6f);
        Assert.assertEquals((Object)command, (Object)item_.getCommand());
        Assert.assertEquals((long)rc, (long)item_.getRc());
    }

    @Test
    public void sendReceiveImageVisualizationEvent() throws Exception {
        int priority = 243;
        String imageName = "ijxkadmahkdaswumkakrxjiy";
        double timestampVisualizationAvailable = 0.9193195104598999;
        String url = "";
        String thumbnail = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageVisualizationEvent(priority, imageName, timestampVisualizationAvailable, url, thumbnail));
        Assert.assertTrue((boolean)(item instanceof ImageVisualizationEvent));
        ImageVisualizationEvent item_ = (ImageVisualizationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampVisualizationAvailable, (double)item_.getTimestampVisualizationAvailable(), (double)1.0E-6f);
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)thumbnail, (Object)item_.getThumbnail());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 842;
        String recommendedSettingsVersion = "";
        String recommendedSettingsLabels = "z";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 487;
        int errorCode = 75;
        String errorReport = "y";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 521;
        boolean appliedSettingsMatchStartIsTrue = true;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 834;
        int level = 462;
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 550;
        String name = "b";
        int level = 40;
        String message = "";
        String traceback = "x";
        String filePath = "";
        String functionName = "w";
        int lineNumber = 529;
        int process = 187;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 292;
        String settingsVersion = "bydhcqlgeapbvsgxkhyzcyctfskkygismzzzgwqqnubltxijrcbkwyyktoniqxoiiejiqhkhlzxzryrppjgktyuidsadlrqycmwzfugrhrwlveqejngcsnj";
        String otherSettingsEvents = "e";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 847;
        int mode = 599;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 448;
        String salVersion = "gmsiibgdriudkkgalhgsvpsvezzhsjwhuwstkppshewoap";
        String xmlVersion = "nvgtmubdmhuyapritluircfwgqcvlfkmkxcpmsylccjokqqhxmncebblhkdblsqslavgmlnjxhoehsowscimqglhewdwngqrbehdscepwhxmvkmfzxbywzkvvdwpdneimnnnsixrkvjbnlpnezxwubjqcttkadygrjzmarfgbbmfwpjagbp";
        String openSpliceVersion = "ydzuxqeadhsupppvdtuqnhujcmhhhsohdszawjbsjgdrjuebfzwbdmatcfqfcmcjgbxmyihihxpsmyievkzlpvwvjtqmxjfrdjghvqyzdkbqolftkmqgbyctwbyltjtpojslrvqygvliyeusxsqvhxqmallgvbdariwdizmdsv";
        String cscVersion = "neypwtbyenawpytbxh";
        String subsystemVersions = "v";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 68;
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 132;
        String authorizedUsers = "";
        String nonAuthorizedCSCs = "e";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }

    @Test
    public void sendReceiveLargeFileObjectAvailableEvent() throws Exception {
        int priority = 645;
        String url = "kdrfcozgfanglnohyctjrzkxdjnzdsbmrjrckapmqzuhhkmmbxwypgnofrlqqqgquq";
        String generator = "sygenfjxopcqrhqrccyewhzxmdehlhlmiwtdxkzrfomsurydqxqozczofzqdggsjnxvpszaitezrfzkvrdhfkeetaxqziiovpskmlwnjnoiawtuhibihxbvpovachsqojgomkvavxjz";
        float version = 0.49828714f;
        int byteSize = 734;
        String checkSum = "ttqkigmaslshbykwcsezaahoocmquqfwmvrdbfeynqgwjzutjtmiyxpissbjddrmakxmojjdtbbzotfrlryprfqrguaogxhsahtelupqwmsvgajfmwfnumigypsarrrkxbyzisqsbcumlkunzntlqkozzteykzmlxingxgntzwjdexucfshqoqmubaqjgvonhclnycssainytyqauucnsfckvdpshelccrmtoirzxqyoopzziiswvnrfolwdt";
        String mimeType = "gkeleuhhbztttdrsfjbgqdfsneofxskfdzvsqrtwmkxgioicdkgcpziuossdxmcxmlcxrosfkxcodszzakszruqckzqj";
        String id = "wiovgnykacsgwxhlgvhxrnqlwqlejqqincqyaheyukoixjxrficebtxgewpomwrufkjqfrgndwfaycrneiehwmdnkemwkgpehebirroscmsbtbwmgstsefxwruvrdbodloqasmdcokepctsdwlymchhttylhhxwrlwkcpyijysskjxrrbjnryaliwz";
        SALEvent item = this.testSendReceive((SALEvent)new LargeFileObjectAvailableEvent(priority, url, generator, version, byteSize, checkSum, mimeType, id));
        Assert.assertTrue((boolean)(item instanceof LargeFileObjectAvailableEvent));
        LargeFileObjectAvailableEvent item_ = (LargeFileObjectAvailableEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)generator, (Object)item_.getGenerator());
        Assert.assertEquals((float)version, (float)item_.getVersion(), (float)1.0E-6f);
        Assert.assertEquals((long)byteSize, (long)item_.getByteSize());
        Assert.assertEquals((Object)checkSum, (Object)item_.getCheckSum());
        Assert.assertEquals((Object)mimeType, (Object)item_.getMimeType());
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }
}

