package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class FocalPlaneRaftTempControlStatusSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final String raftLocation;

  private final boolean raft_TempControl_active;

  public FocalPlaneRaftTempControlStatusSettingsAppliedEvent(int priority, int version,
      String raftLocation, boolean raft_TempControl_active) {
    super (priority);
    this.version = version;
    this.raftLocation = raftLocation;
    this.raft_TempControl_active = raft_TempControl_active;
  }

  public int getVersion() {
    return version;
  }

  public String getRaftLocation() {
    return raftLocation;
  }

  public boolean isRaft_TempControl_active() {
    return raft_TempControl_active;
  }

  @Override
  public String toString() {
    return "FocalPlaneRaftTempControlStatusSettingsAppliedEvent{" + "version=" + version +
        ", raftLocation=" + raftLocation +", raft_TempControl_active=" + raft_TempControl_active +
        "}";
  }
}
