/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_CcdTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_RebTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_RebTotalPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_SegmentTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.3417816758155823;
        double freeSpace = 0.8262566924095154;
        double freeFraction = 0.1373441219329834;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeSpace, freeFraction));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_RebTelemetry() throws Exception {
        double anaI = 0.7531834840774536;
        double anaV = 0.917516827583313;
        double aspicl_Temp0 = 0.5608363747596741;
        double aspicl_Temp1 = 0.5418193340301514;
        double aspicl_Temp2 = 0.5804728865623474;
        double aspicu_Temp0 = 0.2977433204650879;
        double aspicu_Temp1 = 0.764141857624054;
        double aspicu_Temp2 = 0.8136701583862305;
        double clkHI = 0.8727527260780334;
        double clkHV = 0.18094027042388916;
        double clkLI = 0.976333737373352;
        double clkLV = 0.2161724f;
        double digI = 0.09665262699127197;
        double digV = 0.14348101615905762;
        double htrV = 0.7611824870109558;
        double htrW = 0.7056794166564941;
        double hVBiasSwitch = 0.13147515058517456;
        String location = "";
        double oDI = 0.8099966645240784;
        double oDV = 0.8740232586860657;
        double pClkL = 0.14178311824798584;
        double pClkU = 0.17586815357208252;
        double power = 0.3382815718650818;
        double ref05V = 0.6187385320663452;
        double ref125V = 0.545904278755188;
        double ref15V = 0.40586984157562256;
        double ref25V = 0.8204331398010254;
        double refN12 = 0.4479323f;
        double refP12 = 0.3169436454772949;
        double rGL = 0.07807135581970215;
        double rGU = 0.07647973299026489;
        double rTDTemp = 0.44509416818618774;
        double sClkL = 0.45981645584106445;
        double sClkU = 0.9981975555419922;
        double temp1 = 0.17241257429122925;
        double temp10 = 0.1978340744972229;
        double temp2 = 0.17217093706130981;
        double temp3 = 0.6790739297866821;
        double temp4 = 0.10500502586364746;
        double temp5 = 0.4812912344932556;
        double temp6 = 0.6346797943115234;
        double temp7 = 0.16317439079284668;
        double temp8 = 0.47433704137802124;
        double temp9 = 0.7452647686004639;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, htrV, htrW, hVBiasSwitch, location, oDI, oDV, pClkL, pClkU, power, ref05V, ref125V, ref15V, ref25V, refN12, refP12, rGL, rGU, rTDTemp, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Fp_RebTelemetry));
        Fp_RebTelemetry item_ = (Fp_RebTelemetry)item;
        Assert.assertEquals((double)anaI, (double)item_.getAnaI(), (double)1.0E-6f);
        Assert.assertEquals((double)anaV, (double)item_.getAnaV(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicl_Temp0, (double)item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicl_Temp1, (double)item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicl_Temp2, (double)item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicu_Temp0, (double)item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicu_Temp1, (double)item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertEquals((double)aspicu_Temp2, (double)item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertEquals((double)clkHI, (double)item_.getClkHI(), (double)1.0E-6f);
        Assert.assertEquals((double)clkHV, (double)item_.getClkHV(), (double)1.0E-6f);
        Assert.assertEquals((double)clkLI, (double)item_.getClkLI(), (double)1.0E-6f);
        Assert.assertEquals((double)clkLV, (double)item_.getClkLV(), (double)1.0E-6f);
        Assert.assertEquals((double)digI, (double)item_.getDigI(), (double)1.0E-6f);
        Assert.assertEquals((double)digV, (double)item_.getDigV(), (double)1.0E-6f);
        Assert.assertEquals((double)htrV, (double)item_.getHtrV(), (double)1.0E-6f);
        Assert.assertEquals((double)htrW, (double)item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((double)hVBiasSwitch, (double)item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((double)oDI, (double)item_.getODI(), (double)1.0E-6f);
        Assert.assertEquals((double)oDV, (double)item_.getODV(), (double)1.0E-6f);
        Assert.assertEquals((double)pClkL, (double)item_.getPClkL(), (double)1.0E-6f);
        Assert.assertEquals((double)pClkU, (double)item_.getPClkU(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)ref05V, (double)item_.getRef05V(), (double)1.0E-6f);
        Assert.assertEquals((double)ref125V, (double)item_.getRef125V(), (double)1.0E-6f);
        Assert.assertEquals((double)ref15V, (double)item_.getRef15V(), (double)1.0E-6f);
        Assert.assertEquals((double)ref25V, (double)item_.getRef25V(), (double)1.0E-6f);
        Assert.assertEquals((double)refN12, (double)item_.getRefN12(), (double)1.0E-6f);
        Assert.assertEquals((double)refP12, (double)item_.getRefP12(), (double)1.0E-6f);
        Assert.assertEquals((double)rGL, (double)item_.getRGL(), (double)1.0E-6f);
        Assert.assertEquals((double)rGU, (double)item_.getRGU(), (double)1.0E-6f);
        Assert.assertEquals((double)rTDTemp, (double)item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)sClkL, (double)item_.getSClkL(), (double)1.0E-6f);
        Assert.assertEquals((double)sClkU, (double)item_.getSClkU(), (double)1.0E-6f);
        Assert.assertEquals((double)temp1, (double)item_.getTemp1(), (double)1.0E-6f);
        Assert.assertEquals((double)temp10, (double)item_.getTemp10(), (double)1.0E-6f);
        Assert.assertEquals((double)temp2, (double)item_.getTemp2(), (double)1.0E-6f);
        Assert.assertEquals((double)temp3, (double)item_.getTemp3(), (double)1.0E-6f);
        Assert.assertEquals((double)temp4, (double)item_.getTemp4(), (double)1.0E-6f);
        Assert.assertEquals((double)temp5, (double)item_.getTemp5(), (double)1.0E-6f);
        Assert.assertEquals((double)temp6, (double)item_.getTemp6(), (double)1.0E-6f);
        Assert.assertEquals((double)temp7, (double)item_.getTemp7(), (double)1.0E-6f);
        Assert.assertEquals((double)temp8, (double)item_.getTemp8(), (double)1.0E-6f);
        Assert.assertEquals((double)temp9, (double)item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_CcdTelemetry() throws Exception {
        double gDV = 0.5059914588928223;
        String location = "m";
        double oDV = 0.8130668997764587;
        double oGV = 0.3917103409767151;
        double rDV = 0.19739621877670288;
        double temp = 0.2953476905822754;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_CcdTelemetry(gDV, location, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Fp_CcdTelemetry));
        Fp_CcdTelemetry item_ = (Fp_CcdTelemetry)item;
        Assert.assertEquals((double)gDV, (double)item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((double)oDV, (double)item_.getODV(), (double)1.0E-6f);
        Assert.assertEquals((double)oGV, (double)item_.getOGV(), (double)1.0E-6f);
        Assert.assertEquals((double)rDV, (double)item_.getRDV(), (double)1.0E-6f);
        Assert.assertEquals((double)temp, (double)item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFp_SegmentTelemetry() throws Exception {
        double[] i = new double[]{0.004425227642059326, 0.8903229236602783, 0.5085130333900452, 0.04353010654449463, 0.7548102736473083, 0.3203164339065552, 0.4175090789794922, 0.1067974f, 0.8453167080879211, 0.13330018520355225, 0.49629926681518555, 0.6743577122688293, 0.47228187322616577, 0.0023023486137390137, 0.3940557837486267, 0.22270601987838745};
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Fp_SegmentTelemetry));
        Fp_SegmentTelemetry item_ = (Fp_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFp_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.030275821685791016;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Fp_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Fp_RebTotalPowerTelemetry));
        Fp_RebTotalPowerTelemetry item_ = (Fp_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveWrebTelemetry() throws Exception {
        float temp1 = 0.4710425f;
        float temp2 = 0.7597308f;
        float temp3 = 0.3401355f;
        float temp4 = 0.7920232f;
        float temp5 = 0.43584937f;
        float temp6 = 0.8499469f;
        float atemp0U = 0.5127871f;
        float atemp0L = 0.54719085f;
        float ccdTemp0 = 0.5348251f;
        float digV = 0.7569962f;
        float digI = 0.28988987f;
        float anaV = 0.9397529f;
        float anaI = 0.6208029f;
        float clkHV = 0.80129427f;
        float clkHI = 0.27542263f;
        float clkLV = 0.5307065f;
        float odV = 0.7597888f;
        float odI = 0.44411218f;
        float power = 0.38934582f;
        float pClkU = 0.24884725f;
        float pClkL = 0.63105905f;
        float sClkU = 0.77309716f;
        float sClkL = 0.6482425f;
        float rgU = 0.14593339f;
        float rgL = 0.6906233f;
        float pClk0 = 0.4050159f;
        float sClk0 = 0.16104901f;
        float rg0 = 0.016855478f;
        float od0V = 0.14342546f;
        float og0V = 0.34422547f;
        float rd0V = 0.75183296f;
        float gd0V = 0.50528896f;
        float od0I = 0.08975345f;
        float hvbiasSwitch = 0.8730582f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WrebTelemetry(temp1, temp2, temp3, temp4, temp5, temp6, atemp0U, atemp0L, ccdTemp0, digV, digI, anaV, anaI, clkHV, clkHI, clkLV, odV, odI, power, pClkU, pClkL, sClkU, sClkL, rgU, rgL, pClk0, sClk0, rg0, od0V, og0V, rd0V, gd0V, od0I, hvbiasSwitch));
        Assert.assertTrue((boolean)(item instanceof WrebTelemetry));
        WrebTelemetry item_ = (WrebTelemetry)item;
        Assert.assertEquals((float)temp1, (float)item_.getTemp1(), (float)1.0E-6f);
        Assert.assertEquals((float)temp2, (float)item_.getTemp2(), (float)1.0E-6f);
        Assert.assertEquals((float)temp3, (float)item_.getTemp3(), (float)1.0E-6f);
        Assert.assertEquals((float)temp4, (float)item_.getTemp4(), (float)1.0E-6f);
        Assert.assertEquals((float)temp5, (float)item_.getTemp5(), (float)1.0E-6f);
        Assert.assertEquals((float)temp6, (float)item_.getTemp6(), (float)1.0E-6f);
        Assert.assertEquals((float)atemp0U, (float)item_.getAtemp0U(), (float)1.0E-6f);
        Assert.assertEquals((float)atemp0L, (float)item_.getAtemp0L(), (float)1.0E-6f);
        Assert.assertEquals((float)ccdTemp0, (float)item_.getCcdTemp0(), (float)1.0E-6f);
        Assert.assertEquals((float)digV, (float)item_.getDigV(), (float)1.0E-6f);
        Assert.assertEquals((float)digI, (float)item_.getDigI(), (float)1.0E-6f);
        Assert.assertEquals((float)anaV, (float)item_.getAnaV(), (float)1.0E-6f);
        Assert.assertEquals((float)anaI, (float)item_.getAnaI(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHV, (float)item_.getClkHV(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHI, (float)item_.getClkHI(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLV, (float)item_.getClkLV(), (float)1.0E-6f);
        Assert.assertEquals((float)odV, (float)item_.getOdV(), (float)1.0E-6f);
        Assert.assertEquals((float)odI, (float)item_.getOdI(), (float)1.0E-6f);
        Assert.assertEquals((float)power, (float)item_.getPower(), (float)1.0E-6f);
        Assert.assertEquals((float)pClkU, (float)item_.getPClkU(), (float)1.0E-6f);
        Assert.assertEquals((float)pClkL, (float)item_.getPClkL(), (float)1.0E-6f);
        Assert.assertEquals((float)sClkU, (float)item_.getSClkU(), (float)1.0E-6f);
        Assert.assertEquals((float)sClkL, (float)item_.getSClkL(), (float)1.0E-6f);
        Assert.assertEquals((float)rgU, (float)item_.getRgU(), (float)1.0E-6f);
        Assert.assertEquals((float)rgL, (float)item_.getRgL(), (float)1.0E-6f);
        Assert.assertEquals((float)pClk0, (float)item_.getPClk0(), (float)1.0E-6f);
        Assert.assertEquals((float)sClk0, (float)item_.getSClk0(), (float)1.0E-6f);
        Assert.assertEquals((float)rg0, (float)item_.getRg0(), (float)1.0E-6f);
        Assert.assertEquals((float)od0V, (float)item_.getOd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)og0V, (float)item_.getOg0V(), (float)1.0E-6f);
        Assert.assertEquals((float)rd0V, (float)item_.getRd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)gd0V, (float)item_.getGd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)od0I, (float)item_.getOd0I(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbiasSwitch, (float)item_.getHvbiasSwitch(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.69524837f;
        float shutter36V = 0.22655219f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveWrebPowerTelemetry() throws Exception {
        float digital_V = 0.5505385f;
        float digital_I = 0.014067888f;
        float analog_V = 0.03614205f;
        float analog_I = 0.37096113f;
        float clkHigh_V = 0.34957397f;
        float clkHigh_I = 0.7331953f;
        float clkLow_V = 0.44190145f;
        float clkLow_I = 0.82493335f;
        float od_V = 0.34383887f;
        float od_I = 0.66474473f;
        float dphi_V = 0.099245965f;
        float dphi_I = 0.38864905f;
        float hvbias_V = 0.19236636f;
        float hvbias_I = 0.37913567f;
        float fan_V = 0.67663187f;
        float fan_I = 0.4565403f;
        float otm_V = 0.57636005f;
        float otm_I = 0.80632955f;
        float aux_V = 0.20522821f;
        float aux_I = 0.04169929f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WrebPowerTelemetry(digital_V, digital_I, analog_V, analog_I, clkHigh_V, clkHigh_I, clkLow_V, clkLow_I, od_V, od_I, dphi_V, dphi_I, hvbias_V, hvbias_I, fan_V, fan_I, otm_V, otm_I, aux_V, aux_I));
        Assert.assertTrue((boolean)(item instanceof WrebPowerTelemetry));
        WrebPowerTelemetry item_ = (WrebPowerTelemetry)item;
        Assert.assertEquals((float)digital_V, (float)item_.getDigital_V(), (float)1.0E-6f);
        Assert.assertEquals((float)digital_I, (float)item_.getDigital_I(), (float)1.0E-6f);
        Assert.assertEquals((float)analog_V, (float)item_.getAnalog_V(), (float)1.0E-6f);
        Assert.assertEquals((float)analog_I, (float)item_.getAnalog_I(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHigh_V, (float)item_.getClkHigh_V(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHigh_I, (float)item_.getClkHigh_I(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLow_V, (float)item_.getClkLow_V(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLow_I, (float)item_.getClkLow_I(), (float)1.0E-6f);
        Assert.assertEquals((float)od_V, (float)item_.getOd_V(), (float)1.0E-6f);
        Assert.assertEquals((float)od_I, (float)item_.getOd_I(), (float)1.0E-6f);
        Assert.assertEquals((float)dphi_V, (float)item_.getDphi_V(), (float)1.0E-6f);
        Assert.assertEquals((float)dphi_I, (float)item_.getDphi_I(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbias_V, (float)item_.getHvbias_V(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbias_I, (float)item_.getHvbias_I(), (float)1.0E-6f);
        Assert.assertEquals((float)fan_V, (float)item_.getFan_V(), (float)1.0E-6f);
        Assert.assertEquals((float)fan_I, (float)item_.getFan_I(), (float)1.0E-6f);
        Assert.assertEquals((float)otm_V, (float)item_.getOtm_V(), (float)1.0E-6f);
        Assert.assertEquals((float)otm_I, (float)item_.getOtm_I(), (float)1.0E-6f);
        Assert.assertEquals((float)aux_V, (float)item_.getAux_V(), (float)1.0E-6f);
        Assert.assertEquals((float)aux_I, (float)item_.getAux_I(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumTelemetry() throws Exception {
        float tempCCD = 0.50607306f;
        float tempColdPlate = 0.4233966f;
        float tempCryoHead = 0.027142286f;
        float vacuum = 0.20204467f;
        float tempCCDSetPoint = 0.44149172f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumTelemetry(tempCCD, tempColdPlate, tempCryoHead, vacuum, tempCCDSetPoint));
        Assert.assertTrue((boolean)(item instanceof VacuumTelemetry));
        VacuumTelemetry item_ = (VacuumTelemetry)item;
        Assert.assertEquals((float)tempCCD, (float)item_.getTempCCD(), (float)1.0E-6f);
        Assert.assertEquals((float)tempColdPlate, (float)item_.getTempColdPlate(), (float)1.0E-6f);
        Assert.assertEquals((float)tempCryoHead, (float)item_.getTempCryoHead(), (float)1.0E-6f);
        Assert.assertEquals((float)vacuum, (float)item_.getVacuum(), (float)1.0E-6f);
        Assert.assertEquals((float)tempCCDSetPoint, (float)item_.getTempCCDSetPoint(), (float)1.0E-6f);
    }
}

