package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class FileCommandExecutionEvent extends CameraEvent {
  private final String imageName;

  private final double timestampCommandComplete;

  private final String command;

  private final int rc;

  public FileCommandExecutionEvent(int priority, String imageName, double timestampCommandComplete,
      String command, int rc) {
    super (priority);
    this.imageName = imageName;
    this.timestampCommandComplete = timestampCommandComplete;
    this.command = command;
    this.rc = rc;
  }

  public String getImageName() {
    return imageName;
  }

  public double getTimestampCommandComplete() {
    return timestampCommandComplete;
  }

  public String getCommand() {
    return command;
  }

  public int getRc() {
    return rc;
  }

  @Override
  public String toString() {
    return "FileCommandExecutionEvent{" + "imageName=" + imageName +
        ", timestampCommandComplete=" + timestampCommandComplete +", command=" + command +
        ", rc=" + rc +"}";
  }
}
