package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class SettingsAppliedLegacyEvent extends CameraEvent {
  private final String settings;

  private final int version;

  private final String wrebSettingsVersion;

  private final String bonnShutterSettingsVersion;

  public SettingsAppliedLegacyEvent(int priority, String settings, int version,
      String wrebSettingsVersion, String bonnShutterSettingsVersion) {
    super (priority);
    this.settings = settings;
    this.version = version;
    this.wrebSettingsVersion = wrebSettingsVersion;
    this.bonnShutterSettingsVersion = bonnShutterSettingsVersion;
  }

  public String getSettings() {
    return settings;
  }

  public int getVersion() {
    return version;
  }

  public String getWrebSettingsVersion() {
    return wrebSettingsVersion;
  }

  public String getBonnShutterSettingsVersion() {
    return bonnShutterSettingsVersion;
  }

  @Override
  public String toString() {
    return "SettingsAppliedLegacyEvent{" + "settings=" + settings +", version=" + version +
        ", wrebSettingsVersion=" + wrebSettingsVersion +
        ", bonnShutterSettingsVersion=" + bonnShutterSettingsVersion +"}";
  }
}
