package org.lsst.sal.atcamera.command;

import org.lsst.sal.camera.CameraCommand;

public class StartImageCommand extends CameraCommand {
  private final boolean shutter;

  private final String sensors;

  private final String keyValueMap;

  private final String obsNote;

  private final double timeout;

  private final String imageType;

  private final String groupId;

  public StartImageCommand(boolean shutter, String sensors, String keyValueMap, String obsNote,
      double timeout, String imageType, String groupId) {
    this.shutter = shutter;
    this.sensors = sensors;
    this.keyValueMap = keyValueMap;
    this.obsNote = obsNote;
    this.timeout = timeout;
    this.imageType = imageType;
    this.groupId = groupId;
  }

  public boolean isShutter() {
    return shutter;
  }

  public String getSensors() {
    return sensors;
  }

  public String getKeyValueMap() {
    return keyValueMap;
  }

  public String getObsNote() {
    return obsNote;
  }

  public double getTimeout() {
    return timeout;
  }

  public String getImageType() {
    return imageType;
  }

  public String getGroupId() {
    return groupId;
  }

  @Override
  public String toString() {
    return "StartImageCommand{" + "shutter=" + shutter +", sensors=" + sensors +
        ", keyValueMap=" + keyValueMap +", obsNote=" + obsNote +", timeout=" + timeout +
        ", imageType=" + imageType +", groupId=" + groupId +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private boolean shutter;

    private String sensors;

    private String keyValueMap;

    private String obsNote;

    private double timeout;

    private String imageType;

    private String groupId;

    private Builder() {
    }

    public Builder shutter(boolean shutter) {
      this.shutter = shutter;
      return this;
    }

    public Builder sensors(String sensors) {
      this.sensors = sensors;
      return this;
    }

    public Builder keyValueMap(String keyValueMap) {
      this.keyValueMap = keyValueMap;
      return this;
    }

    public Builder obsNote(String obsNote) {
      this.obsNote = obsNote;
      return this;
    }

    public Builder timeout(double timeout) {
      this.timeout = timeout;
      return this;
    }

    public Builder imageType(String imageType) {
      this.imageType = imageType;
      return this;
    }

    public Builder groupId(String groupId) {
      this.groupId = groupId;
      return this;
    }

    public StartImageCommand build() {
      return new StartImageCommand(shutter, sensors, keyValueMap, obsNote, timeout, imageType, groupId);
    }
  }
}
