/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveWrebTelemetry() throws Exception {
        float temp1 = 0.57578444f;
        float temp2 = 0.90742666f;
        float temp3 = 0.16321278f;
        float temp4 = 0.24195546f;
        float temp5 = 0.87972414f;
        float temp6 = 0.82995063f;
        float atemp0U = 0.7060215f;
        float atemp0L = 0.27558225f;
        float ccdTemp0 = 0.20525146f;
        float digV = 0.24436504f;
        float digI = 0.25108713f;
        float anaV = 0.67999715f;
        float anaI = 0.66597855f;
        float clkHV = 0.25002098f;
        float clkHI = 0.72292715f;
        float clkLV = 0.75250465f;
        float odV = 0.5276303f;
        float odI = 0.13155997f;
        float power = 0.21836346f;
        float pClkU = 0.21607387f;
        float pClkL = 0.5816147f;
        float sClkU = 0.77318954f;
        float sClkL = 0.5222405f;
        float rgU = 0.9409774f;
        float rgL = 0.40599078f;
        float pClk0 = 0.98886865f;
        float sClk0 = 0.25809115f;
        float rg0 = 0.91070294f;
        float od0V = 0.23248196f;
        float og0V = 0.9317815f;
        float rd0V = 0.36610866f;
        float gd0V = 0.33450723f;
        float od0I = 0.051742136f;
        float hvbiasSwitch = 0.9009914f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WrebTelemetry(temp1, temp2, temp3, temp4, temp5, temp6, atemp0U, atemp0L, ccdTemp0, digV, digI, anaV, anaI, clkHV, clkHI, clkLV, odV, odI, power, pClkU, pClkL, sClkU, sClkL, rgU, rgL, pClk0, sClk0, rg0, od0V, og0V, rd0V, gd0V, od0I, hvbiasSwitch));
        Assert.assertTrue((boolean)(item instanceof WrebTelemetry));
        WrebTelemetry item_ = (WrebTelemetry)item;
        Assert.assertEquals((float)temp1, (float)item_.getTemp1(), (float)1.0E-6f);
        Assert.assertEquals((float)temp2, (float)item_.getTemp2(), (float)1.0E-6f);
        Assert.assertEquals((float)temp3, (float)item_.getTemp3(), (float)1.0E-6f);
        Assert.assertEquals((float)temp4, (float)item_.getTemp4(), (float)1.0E-6f);
        Assert.assertEquals((float)temp5, (float)item_.getTemp5(), (float)1.0E-6f);
        Assert.assertEquals((float)temp6, (float)item_.getTemp6(), (float)1.0E-6f);
        Assert.assertEquals((float)atemp0U, (float)item_.getAtemp0U(), (float)1.0E-6f);
        Assert.assertEquals((float)atemp0L, (float)item_.getAtemp0L(), (float)1.0E-6f);
        Assert.assertEquals((float)ccdTemp0, (float)item_.getCcdTemp0(), (float)1.0E-6f);
        Assert.assertEquals((float)digV, (float)item_.getDigV(), (float)1.0E-6f);
        Assert.assertEquals((float)digI, (float)item_.getDigI(), (float)1.0E-6f);
        Assert.assertEquals((float)anaV, (float)item_.getAnaV(), (float)1.0E-6f);
        Assert.assertEquals((float)anaI, (float)item_.getAnaI(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHV, (float)item_.getClkHV(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHI, (float)item_.getClkHI(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLV, (float)item_.getClkLV(), (float)1.0E-6f);
        Assert.assertEquals((float)odV, (float)item_.getOdV(), (float)1.0E-6f);
        Assert.assertEquals((float)odI, (float)item_.getOdI(), (float)1.0E-6f);
        Assert.assertEquals((float)power, (float)item_.getPower(), (float)1.0E-6f);
        Assert.assertEquals((float)pClkU, (float)item_.getPClkU(), (float)1.0E-6f);
        Assert.assertEquals((float)pClkL, (float)item_.getPClkL(), (float)1.0E-6f);
        Assert.assertEquals((float)sClkU, (float)item_.getSClkU(), (float)1.0E-6f);
        Assert.assertEquals((float)sClkL, (float)item_.getSClkL(), (float)1.0E-6f);
        Assert.assertEquals((float)rgU, (float)item_.getRgU(), (float)1.0E-6f);
        Assert.assertEquals((float)rgL, (float)item_.getRgL(), (float)1.0E-6f);
        Assert.assertEquals((float)pClk0, (float)item_.getPClk0(), (float)1.0E-6f);
        Assert.assertEquals((float)sClk0, (float)item_.getSClk0(), (float)1.0E-6f);
        Assert.assertEquals((float)rg0, (float)item_.getRg0(), (float)1.0E-6f);
        Assert.assertEquals((float)od0V, (float)item_.getOd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)og0V, (float)item_.getOg0V(), (float)1.0E-6f);
        Assert.assertEquals((float)rd0V, (float)item_.getRd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)gd0V, (float)item_.getGd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)od0I, (float)item_.getOd0I(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbiasSwitch, (float)item_.getHvbiasSwitch(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.24557567f;
        float shutter36V = 0.58962744f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveWrebPowerTelemetry() throws Exception {
        float digital_V = 0.96633166f;
        float digital_I = 0.27799702f;
        float analog_V = 0.26177567f;
        float analog_I = 0.19612634f;
        float clkHigh_V = 0.85761005f;
        float clkHigh_I = 0.025470555f;
        float clkLow_V = 0.5594959f;
        float clkLow_I = 0.35010445f;
        float od_V = 0.5879529f;
        float od_I = 0.32978356f;
        float dphi_V = 0.7357852f;
        float dphi_I = 0.49566978f;
        float hvbias_V = 0.08542347f;
        float hvbias_I = 0.1236853f;
        float fan_V = 0.9710348f;
        float fan_I = 0.84733045f;
        float otm_V = 0.3294629f;
        float otm_I = 0.5819786f;
        float aux_V = 0.5952182f;
        float aux_I = 0.7927321f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WrebPowerTelemetry(digital_V, digital_I, analog_V, analog_I, clkHigh_V, clkHigh_I, clkLow_V, clkLow_I, od_V, od_I, dphi_V, dphi_I, hvbias_V, hvbias_I, fan_V, fan_I, otm_V, otm_I, aux_V, aux_I));
        Assert.assertTrue((boolean)(item instanceof WrebPowerTelemetry));
        WrebPowerTelemetry item_ = (WrebPowerTelemetry)item;
        Assert.assertEquals((float)digital_V, (float)item_.getDigital_V(), (float)1.0E-6f);
        Assert.assertEquals((float)digital_I, (float)item_.getDigital_I(), (float)1.0E-6f);
        Assert.assertEquals((float)analog_V, (float)item_.getAnalog_V(), (float)1.0E-6f);
        Assert.assertEquals((float)analog_I, (float)item_.getAnalog_I(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHigh_V, (float)item_.getClkHigh_V(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHigh_I, (float)item_.getClkHigh_I(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLow_V, (float)item_.getClkLow_V(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLow_I, (float)item_.getClkLow_I(), (float)1.0E-6f);
        Assert.assertEquals((float)od_V, (float)item_.getOd_V(), (float)1.0E-6f);
        Assert.assertEquals((float)od_I, (float)item_.getOd_I(), (float)1.0E-6f);
        Assert.assertEquals((float)dphi_V, (float)item_.getDphi_V(), (float)1.0E-6f);
        Assert.assertEquals((float)dphi_I, (float)item_.getDphi_I(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbias_V, (float)item_.getHvbias_V(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbias_I, (float)item_.getHvbias_I(), (float)1.0E-6f);
        Assert.assertEquals((float)fan_V, (float)item_.getFan_V(), (float)1.0E-6f);
        Assert.assertEquals((float)fan_I, (float)item_.getFan_I(), (float)1.0E-6f);
        Assert.assertEquals((float)otm_V, (float)item_.getOtm_V(), (float)1.0E-6f);
        Assert.assertEquals((float)otm_I, (float)item_.getOtm_I(), (float)1.0E-6f);
        Assert.assertEquals((float)aux_V, (float)item_.getAux_V(), (float)1.0E-6f);
        Assert.assertEquals((float)aux_I, (float)item_.getAux_I(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumTelemetry() throws Exception {
        float tempCCD = 0.0016371608f;
        float tempColdPlate = 0.32815105f;
        float tempCryoHead = 0.7488806f;
        float vacuum = 0.3368644f;
        float tempCCDSetPoint = 0.11643165f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumTelemetry(tempCCD, tempColdPlate, tempCryoHead, vacuum, tempCCDSetPoint));
        Assert.assertTrue((boolean)(item instanceof VacuumTelemetry));
        VacuumTelemetry item_ = (VacuumTelemetry)item;
        Assert.assertEquals((float)tempCCD, (float)item_.getTempCCD(), (float)1.0E-6f);
        Assert.assertEquals((float)tempColdPlate, (float)item_.getTempColdPlate(), (float)1.0E-6f);
        Assert.assertEquals((float)tempCryoHead, (float)item_.getTempCryoHead(), (float)1.0E-6f);
        Assert.assertEquals((float)vacuum, (float)item_.getVacuum(), (float)1.0E-6f);
        Assert.assertEquals((float)tempCCDSetPoint, (float)item_.getTempCCDSetPoint(), (float)1.0E-6f);
    }
}

