/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.event.BonnShutterSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.ImageReadoutParametersEvent;
import org.lsst.sal.atcamera.event.SettingsAppliedLegacyEvent;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.atcamera.event.SoftwareVersionsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.WrebSettingsAppliedEvent;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 836;
        String imageType = "";
        String groupId = "a";
        String additionalKeys = "z";
        String additionalValues = "";
        int imagesInSequence = 632;
        String imageName = "auhnnootuhjusprpmldi";
        int imageIndex = 862;
        String imageSource = "xs";
        String imageController = "c";
        String imageDate = "age";
        int imageNumber = 236;
        double timeStampAcquisitionStart = 0.6832115650177002;
        double exposureTime = 0.3940030336380005;
        double timeStampEndOfReadout = 0.46446192264556885;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampEndOfReadout, (double)item_.getTimeStampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 906;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 859;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 268;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 498;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 377;
        String imageType = "";
        String groupId = "";
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 163;
        String imageName = "nlfaodrmazjfkyewrpjmw";
        int imageIndex = 995;
        String imageSource = "ka";
        String imageController = "";
        String imageDate = "zuaqyzm";
        int imageNumber = 204;
        double timeStampAcquisitionStart = 0.8331937789916992;
        double exposureTime = 0.2701908349990845;
        String imageTag = "podojhymuggil";
        double timestampDateObs = 0.4493764638900757;
        double timestampDateEnd = 0.20417052507400513;
        double expTime = 0.4387333393096924;
        double darkTime = 0.03698349f;
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, expTime, darkTime));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)expTime, (double)item_.getExpTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 598;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 989;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 660;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 720;
        String imageType = "";
        String groupId = "";
        String additionalKeys = "";
        String additionalValues = "u";
        int imagesInSequence = 140;
        String imageName = "lojdhzqovea";
        int imageIndex = 314;
        String imageSource = "j";
        String imageController = "m";
        String imageDate = "xnuioaor";
        int imageNumber = 899;
        double timeStampAcquisitionStart = 0.2598305344581604;
        double exposureTime = 0.03238457441329956;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 717;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 607;
        String imageType = "o";
        String groupId = "q";
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 693;
        String imageName = "uovvualrabkzcm";
        int imageIndex = 683;
        String imageSource = "ad";
        String imageController = "m";
        String imageDate = "bel";
        int imageNumber = 512;
        double timeStampAcquisitionStart = 0.8565203547477722;
        double exposureTime = 0.6208995580673218;
        double timeStampStartOfReadout = 0.5267452597618103;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampStartOfReadout, (double)item_.getTimeStampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveShutterMotionProfileEvent() throws Exception {
        int priority = 93;
        double measuredExposureTime = 0.7480601668357849;
        SALEvent item = this.testSendReceive((SALEvent)new ShutterMotionProfileEvent(priority, measuredExposureTime));
        Assert.assertTrue((boolean)(item instanceof ShutterMotionProfileEvent));
        ShutterMotionProfileEvent item_ = (ShutterMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)measuredExposureTime, (double)item_.getMeasuredExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 265;
        String imageName = "arsgmdvjvekeuiuydtesolnht";
        int imageIndex = 171;
        String ccdNames = "evpdyypbtxoocfivmsgrsfuvgtpclhgfkkmzaxdlilkirgkocdikkwpvrrtxwoodkupplkollcjrpomewlsbnekplueqilpcjekrkrzoxdddmstgamvxepfhnbalwbbvpjjlkmgjgegwjxarixcbliiqhlcuvyeokvqfqyopyzkchujmsoynpdaobosbnvaqpqbwcwopreybzpbsajryjnegvmcstfbbblnhz";
        String raftBay = "w";
        String ccdSlot = "v";
        ImageReadoutParametersEvent.CcdType ccdType = ImageReadoutParametersEvent.CcdType.E2V;
        int overRows = 700;
        int overCols = 301;
        int readRows = 216;
        int readCols = 566;
        int readCols2 = 611;
        int preCols = 786;
        int preRows = 306;
        int postCols = 419;
        int underCols = 330;
        String daqFolder = "p";
        String daqAnnotation = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, imageIndex, ccdNames, raftBay, ccdSlot, ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)ccdNames, (Object)item_.getCcdNames());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveSettingsAppliedLegacyEvent() throws Exception {
        int priority = 905;
        String settings = "oozlesdckkxaufzjksuaglzfdnugafnvmueolsyotiiwwktnbppqswarjdvmqyjsggyhpeieyhmxsthjqexhvrnvehtzzyacghyievhzqndcmiedpvlosnkjzjuuelccashwbzlwlvxlrubehevrqjukuesnyzotxvwbpeikmvlpfktaxpdxmlyolrslvuhwmyfmtnpkaiuymsozvlmwvp";
        int version = 21;
        String wrebSettingsVersion = "sczyygfqxmcaepcvjtfeydnqcekdxmbehtlyeu";
        String bonnShutterSettingsVersion = "qviofvbjifmszhikj";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedLegacyEvent(priority, settings, version, wrebSettingsVersion, bonnShutterSettingsVersion));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedLegacyEvent));
        SettingsAppliedLegacyEvent item_ = (SettingsAppliedLegacyEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settings, (Object)item_.getSettings());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)wrebSettingsVersion, (Object)item_.getWrebSettingsVersion());
        Assert.assertEquals((Object)bonnShutterSettingsVersion, (Object)item_.getBonnShutterSettingsVersion());
    }

    @Test
    public void sendReceiveBonnShutterSettingsAppliedEvent() throws Exception {
        int priority = 598;
        int version = 848;
        float startA = 0.909979f;
        float startB = 0.6323664f;
        float travelDistance = 0.8650884f;
        float startVelocity = 0.033549726f;
        float acceleration = 0.6954838f;
        float maxVelocity = 0.11287665f;
        float threshold = 0.6746733f;
        String shutterVersion = "ffipgumgxuxbpunhjralcafgnlydoxlpmrfpqxrgygazxxzkwwneoogvaqaqwbdxpekigtoptrbizuvelqbeqaztjdwyysopgkrcfzmbojfboddazlbejnzmrgoqsnypfrtnqtmoqgwhdfjgfblquwnporwzppfwqkbngkuzdwzidmnqjbswmaywayy";
        String firmwareVersion = "owtrwnulfacxhnmwrnxivxmzbatnddascitozxtcfkvyqfaajdyphkrogiabrydtauvlrcbin";
        SALEvent item = this.testSendReceive((SALEvent)new BonnShutterSettingsAppliedEvent(priority, version, startA, startB, travelDistance, startVelocity, acceleration, maxVelocity, threshold, shutterVersion, firmwareVersion));
        Assert.assertTrue((boolean)(item instanceof BonnShutterSettingsAppliedEvent));
        BonnShutterSettingsAppliedEvent item_ = (BonnShutterSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((float)startA, (float)item_.getStartA(), (float)1.0E-6f);
        Assert.assertEquals((float)startB, (float)item_.getStartB(), (float)1.0E-6f);
        Assert.assertEquals((float)travelDistance, (float)item_.getTravelDistance(), (float)1.0E-6f);
        Assert.assertEquals((float)startVelocity, (float)item_.getStartVelocity(), (float)1.0E-6f);
        Assert.assertEquals((float)acceleration, (float)item_.getAcceleration(), (float)1.0E-6f);
        Assert.assertEquals((float)maxVelocity, (float)item_.getMaxVelocity(), (float)1.0E-6f);
        Assert.assertEquals((float)threshold, (float)item_.getThreshold(), (float)1.0E-6f);
        Assert.assertEquals((Object)shutterVersion, (Object)item_.getShutterVersion());
        Assert.assertEquals((Object)firmwareVersion, (Object)item_.getFirmwareVersion());
    }

    @Test
    public void sendReceiveWrebSettingsAppliedEvent() throws Exception {
        int priority = 536;
        int version = 875;
        String sequencerKey = "jubbdnysrmhrewmxjjnfoobpzsy";
        int sequencerChecksum = 133;
        int daqVersion = 784;
        int firmwareVersion = 397;
        int aspic0_af1 = 10;
        int aspic0_clamp = 441;
        int aspic0_gain = 562;
        int aspic0_rc = 56;
        int aspic0_tm = 455;
        int aspic1_af1 = 223;
        int aspic1_clamp = 542;
        int aspic1_gain = 89;
        int aspic1_rc = 659;
        int aspic1_tm = 719;
        int bias0_csGate = 98;
        int bias0_csGateP = 484;
        int bias0_gd = 102;
        int bias0_gdP = 647;
        int bias0_od = 925;
        int bias0_odP = 749;
        int bias0_og = 249;
        int bias0_ogP = 687;
        int bias0_ogSh = 193;
        int bias0_rd = 730;
        int bias0_rdP = 793;
        int dac_csGate = 168;
        int dac_pclkHigh = 110;
        int dac_pclkHighP = 704;
        int dac_pclkHighSh = 865;
        int dac_pclkLow = 867;
        int dac_pclkLowP = 607;
        int dac_pclkLowSh = 806;
        int dac_rgHigh = 867;
        int dac_rgHighP = 799;
        int dac_rgHighSh = 531;
        int dac_rgLow = 406;
        int dac_rgLowP = 98;
        int dac_rgLowSh = 586;
        int dac_sclkHigh = 539;
        int dac_sclkHighP = 394;
        int dac_sclkHighSh = 599;
        int dac_sclkLow = 904;
        int dac_sclkLowP = 27;
        int dac_sclkLowSh = 219;
        String ccdManufacturer = "vaab";
        String ccdType = "gnhxtvojhrb";
        String ccdSerialNumber = "batioozeju";
        String ccdName = "jdcygrtsr";
        String rebName = "ekkmppba";
        String rebSerialNumber = "q";
        SALEvent item = this.testSendReceive((SALEvent)new WrebSettingsAppliedEvent(priority, version, sequencerKey, sequencerChecksum, daqVersion, firmwareVersion, aspic0_af1, aspic0_clamp, aspic0_gain, aspic0_rc, aspic0_tm, aspic1_af1, aspic1_clamp, aspic1_gain, aspic1_rc, aspic1_tm, bias0_csGate, bias0_csGateP, bias0_gd, bias0_gdP, bias0_od, bias0_odP, bias0_og, bias0_ogP, bias0_ogSh, bias0_rd, bias0_rdP, dac_csGate, dac_pclkHigh, dac_pclkHighP, dac_pclkHighSh, dac_pclkLow, dac_pclkLowP, dac_pclkLowSh, dac_rgHigh, dac_rgHighP, dac_rgHighSh, dac_rgLow, dac_rgLowP, dac_rgLowSh, dac_sclkHigh, dac_sclkHighP, dac_sclkHighSh, dac_sclkLow, dac_sclkLowP, dac_sclkLowSh, ccdManufacturer, ccdType, ccdSerialNumber, ccdName, rebName, rebSerialNumber));
        Assert.assertTrue((boolean)(item instanceof WrebSettingsAppliedEvent));
        WrebSettingsAppliedEvent item_ = (WrebSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((long)sequencerChecksum, (long)item_.getSequencerChecksum());
        Assert.assertEquals((long)daqVersion, (long)item_.getDaqVersion());
        Assert.assertEquals((long)firmwareVersion, (long)item_.getFirmwareVersion());
        Assert.assertEquals((long)aspic0_af1, (long)item_.getAspic0_af1());
        Assert.assertEquals((long)aspic0_clamp, (long)item_.getAspic0_clamp());
        Assert.assertEquals((long)aspic0_gain, (long)item_.getAspic0_gain());
        Assert.assertEquals((long)aspic0_rc, (long)item_.getAspic0_rc());
        Assert.assertEquals((long)aspic0_tm, (long)item_.getAspic0_tm());
        Assert.assertEquals((long)aspic1_af1, (long)item_.getAspic1_af1());
        Assert.assertEquals((long)aspic1_clamp, (long)item_.getAspic1_clamp());
        Assert.assertEquals((long)aspic1_gain, (long)item_.getAspic1_gain());
        Assert.assertEquals((long)aspic1_rc, (long)item_.getAspic1_rc());
        Assert.assertEquals((long)aspic1_tm, (long)item_.getAspic1_tm());
        Assert.assertEquals((long)bias0_csGate, (long)item_.getBias0_csGate());
        Assert.assertEquals((long)bias0_csGateP, (long)item_.getBias0_csGateP());
        Assert.assertEquals((long)bias0_gd, (long)item_.getBias0_gd());
        Assert.assertEquals((long)bias0_gdP, (long)item_.getBias0_gdP());
        Assert.assertEquals((long)bias0_od, (long)item_.getBias0_od());
        Assert.assertEquals((long)bias0_odP, (long)item_.getBias0_odP());
        Assert.assertEquals((long)bias0_og, (long)item_.getBias0_og());
        Assert.assertEquals((long)bias0_ogP, (long)item_.getBias0_ogP());
        Assert.assertEquals((long)bias0_ogSh, (long)item_.getBias0_ogSh());
        Assert.assertEquals((long)bias0_rd, (long)item_.getBias0_rd());
        Assert.assertEquals((long)bias0_rdP, (long)item_.getBias0_rdP());
        Assert.assertEquals((long)dac_csGate, (long)item_.getDac_csGate());
        Assert.assertEquals((long)dac_pclkHigh, (long)item_.getDac_pclkHigh());
        Assert.assertEquals((long)dac_pclkHighP, (long)item_.getDac_pclkHighP());
        Assert.assertEquals((long)dac_pclkHighSh, (long)item_.getDac_pclkHighSh());
        Assert.assertEquals((long)dac_pclkLow, (long)item_.getDac_pclkLow());
        Assert.assertEquals((long)dac_pclkLowP, (long)item_.getDac_pclkLowP());
        Assert.assertEquals((long)dac_pclkLowSh, (long)item_.getDac_pclkLowSh());
        Assert.assertEquals((long)dac_rgHigh, (long)item_.getDac_rgHigh());
        Assert.assertEquals((long)dac_rgHighP, (long)item_.getDac_rgHighP());
        Assert.assertEquals((long)dac_rgHighSh, (long)item_.getDac_rgHighSh());
        Assert.assertEquals((long)dac_rgLow, (long)item_.getDac_rgLow());
        Assert.assertEquals((long)dac_rgLowP, (long)item_.getDac_rgLowP());
        Assert.assertEquals((long)dac_rgLowSh, (long)item_.getDac_rgLowSh());
        Assert.assertEquals((long)dac_sclkHigh, (long)item_.getDac_sclkHigh());
        Assert.assertEquals((long)dac_sclkHighP, (long)item_.getDac_sclkHighP());
        Assert.assertEquals((long)dac_sclkHighSh, (long)item_.getDac_sclkHighSh());
        Assert.assertEquals((long)dac_sclkLow, (long)item_.getDac_sclkLow());
        Assert.assertEquals((long)dac_sclkLowP, (long)item_.getDac_sclkLowP());
        Assert.assertEquals((long)dac_sclkLowSh, (long)item_.getDac_sclkLowSh());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((Object)ccdSerialNumber, (Object)item_.getCcdSerialNumber());
        Assert.assertEquals((Object)ccdName, (Object)item_.getCcdName());
        Assert.assertEquals((Object)rebName, (Object)item_.getRebName());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
    }

    @Test
    public void sendReceiveSoftwareVersionsSettingsAppliedEvent() throws Exception {
        int priority = 697;
        String mcmVersion = "wcaumtxwnnhx";
        String ocsbridgeVersion = "";
        String rebPowerVersion = "ousukjpd";
        String rebVersion = "iujcivovaqkmutsjsdwutk";
        String pduVersion = "";
        String bonnShutterVersion = "xnkmcaokqncaqvhcnrspiof";
        String vacuumVersion = "rptratbkajdbywwqebd";
        String wrebFirmwareVersion = "snjlsc";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsSettingsAppliedEvent(priority, mcmVersion, ocsbridgeVersion, rebPowerVersion, rebVersion, pduVersion, bonnShutterVersion, vacuumVersion, wrebFirmwareVersion));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsSettingsAppliedEvent));
        SoftwareVersionsSettingsAppliedEvent item_ = (SoftwareVersionsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)mcmVersion, (Object)item_.getMcmVersion());
        Assert.assertEquals((Object)ocsbridgeVersion, (Object)item_.getOcsbridgeVersion());
        Assert.assertEquals((Object)rebPowerVersion, (Object)item_.getRebPowerVersion());
        Assert.assertEquals((Object)rebVersion, (Object)item_.getRebVersion());
        Assert.assertEquals((Object)pduVersion, (Object)item_.getPduVersion());
        Assert.assertEquals((Object)bonnShutterVersion, (Object)item_.getBonnShutterVersion());
        Assert.assertEquals((Object)vacuumVersion, (Object)item_.getVacuumVersion());
        Assert.assertEquals((Object)wrebFirmwareVersion, (Object)item_.getWrebFirmwareVersion());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 538;
        String recommendedSettingsVersion = "";
        String recommendedSettingsLabels = "";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 44;
        int errorCode = 774;
        String errorReport = "t";
        String traceback = "x";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 407;
        boolean appliedSettingsMatchStartIsTrue = false;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 652;
        int level = 723;
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 472;
        String name = "k";
        int level = 291;
        String message = "";
        String traceback = "u";
        String filePath = "";
        String functionName = "s";
        int lineNumber = 597;
        int process = 719;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 863;
        String settingsVersion = "kkhnlmimbwcdzkopkhrdbeqjbjivltqcbvksqdwsrdkragxankbzfmqwccmlofjzmiztzpbnfpgmqupgyxtuvgsklntesqjwhetavdyx";
        String otherSettingsEvents = "d";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 800;
        int mode = 898;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 648;
        String salVersion = "ymct";
        String xmlVersion = "fo";
        String openSpliceVersion = "";
        String cscVersion = "alssscajw";
        String subsystemVersions = "w";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 807;
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }
}

