/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALException;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.command.StartImageCommand;
import org.lsst.sal.camera.command.AbortCommand;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.DisableCalibrationCommand;
import org.lsst.sal.camera.command.DisableCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.SetLogLevelCommand;
import org.lsst.sal.camera.command.SetSimulationModeCommand;
import org.lsst.sal.camera.command.SetValueCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StopCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;

public class CommandSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALCommand testSendReceive(SALCommand item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALReceivedCommand> future = executor.submit(() -> sal.getNextCommand(Duration.ofSeconds(10L)));
        try {
            SALCommandResponse response = sal.issueCommand(item);
            SALReceivedCommand result = future.get(10L, TimeUnit.SECONDS);
            result.acknowledgeCommand(Duration.ofSeconds(3L));
            result.reportComplete();
            int rc = response.waitForCompletion(Duration.ofSeconds(1L));
            Assert.assertEquals((long)303L, (long)rc);
            SALCommand sALCommand = result.getCommand();
            return sALCommand;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveDiscardRowsCommand() throws Exception {
        int nRows = 251;
        SALCommand item = this.testSendReceive((SALCommand)new DiscardRowsCommand(nRows));
        Assert.assertTrue((boolean)(item instanceof DiscardRowsCommand));
        DiscardRowsCommand item_ = (DiscardRowsCommand)item;
        Assert.assertEquals((long)nRows, (long)item_.getNRows());
    }

    @Test
    public void sendReceiveStartImageCommand() throws Exception {
        boolean shutter = true;
        String sensors = "i";
        String keyValueMap = "q";
        String obsNote = "";
        double timeout = 0.12466812133789062;
        String imageType = "xbsikkmfrupntmmanfxxzprxbdbmrieacbccccdwasqkqkja";
        String groupId = "qpurfghhwtexgjykaqvcmjrqcktmdhqqrlbzrtrailuqnxcbyrumurgiceercnibqdfkpblbyqtupjchxfuwvcyqbqmxempreiwvykbcoctqq";
        SALCommand item = this.testSendReceive((SALCommand)new StartImageCommand(shutter, sensors, keyValueMap, obsNote, timeout, imageType, groupId));
        Assert.assertTrue((boolean)(item instanceof StartImageCommand));
        StartImageCommand item_ = (StartImageCommand)item;
        Assert.assertEquals((Object)shutter, (Object)item_.isShutter());
        Assert.assertEquals((Object)sensors, (Object)item_.getSensors());
        Assert.assertEquals((Object)keyValueMap, (Object)item_.getKeyValueMap());
        Assert.assertEquals((Object)obsNote, (Object)item_.getObsNote());
        Assert.assertEquals((double)timeout, (double)item_.getTimeout(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
    }

    @Test
    public void sendReceiveDisableCalibrationCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new DisableCalibrationCommand());
        Assert.assertTrue((boolean)(item instanceof DisableCalibrationCommand));
        DisableCalibrationCommand item_ = (DisableCalibrationCommand)item;
    }

    @Test
    public void sendReceiveInitGuidersCommand() throws Exception {
        String roiSpec = "phgmozhbvogrutlnfutaeicjgpqqzngepvkoozsxfdgnvehxuortnjimmdxoxtkqilzpfnvoiybbydygmabfrjukpffmnwkoekwx";
        SALCommand item = this.testSendReceive((SALCommand)new InitGuidersCommand(roiSpec));
        Assert.assertTrue((boolean)(item instanceof InitGuidersCommand));
        InitGuidersCommand item_ = (InitGuidersCommand)item;
        Assert.assertEquals((Object)roiSpec, (Object)item_.getRoiSpec());
    }

    @Test
    public void sendReceiveEnableCalibrationCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new EnableCalibrationCommand());
        Assert.assertTrue((boolean)(item instanceof EnableCalibrationCommand));
        EnableCalibrationCommand item_ = (EnableCalibrationCommand)item;
    }

    @Test
    public void sendReceiveInitImageCommand() throws Exception {
        double deltaT = 0.11408388614654541;
        SALCommand item = this.testSendReceive((SALCommand)new InitImageCommand(deltaT));
        Assert.assertTrue((boolean)(item instanceof InitImageCommand));
        InitImageCommand item_ = (InitImageCommand)item;
        Assert.assertEquals((double)deltaT, (double)item_.getDeltaT(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndImageCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new EndImageCommand());
        Assert.assertTrue((boolean)(item instanceof EndImageCommand));
        EndImageCommand item_ = (EndImageCommand)item;
    }

    @Test
    public void sendReceiveClearCommand() throws Exception {
        int nClears = 714;
        SALCommand item = this.testSendReceive((SALCommand)new ClearCommand(nClears));
        Assert.assertTrue((boolean)(item instanceof ClearCommand));
        ClearCommand item_ = (ClearCommand)item;
        Assert.assertEquals((long)nClears, (long)item_.getNClears());
    }

    @Test
    public void sendReceiveTakeImagesCommand() throws Exception {
        int numImages = 361;
        double expTime = 0.8289845585823059;
        boolean shutter = false;
        String sensors = "";
        String keyValueMap = "c";
        String obsNote = "u";
        SALCommand item = this.testSendReceive((SALCommand)new TakeImagesCommand(numImages, expTime, shutter, sensors, keyValueMap, obsNote));
        Assert.assertTrue((boolean)(item instanceof TakeImagesCommand));
        TakeImagesCommand item_ = (TakeImagesCommand)item;
        Assert.assertEquals((long)numImages, (long)item_.getNumImages());
        Assert.assertEquals((double)expTime, (double)item_.getExpTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)shutter, (Object)item_.isShutter());
        Assert.assertEquals((Object)sensors, (Object)item_.getSensors());
        Assert.assertEquals((Object)keyValueMap, (Object)item_.getKeyValueMap());
        Assert.assertEquals((Object)obsNote, (Object)item_.getObsNote());
    }

    @Test
    public void sendReceiveStopCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new StopCommand());
        Assert.assertTrue((boolean)(item instanceof StopCommand));
        StopCommand item_ = (StopCommand)item;
    }

    @Test
    public void sendReceiveAbortCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new AbortCommand());
        Assert.assertTrue((boolean)(item instanceof AbortCommand));
        AbortCommand item_ = (AbortCommand)item;
    }

    @Test
    public void sendReceiveEnableCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new EnableCommand());
        Assert.assertTrue((boolean)(item instanceof EnableCommand));
        EnableCommand item_ = (EnableCommand)item;
    }

    @Test
    public void sendReceiveDisableCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new DisableCommand());
        Assert.assertTrue((boolean)(item instanceof DisableCommand));
        DisableCommand item_ = (DisableCommand)item;
    }

    @Test
    public void sendReceiveStandbyCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new StandbyCommand());
        Assert.assertTrue((boolean)(item instanceof StandbyCommand));
        StandbyCommand item_ = (StandbyCommand)item;
    }

    @Test
    public void sendReceiveExitControlCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new ExitControlCommand());
        Assert.assertTrue((boolean)(item instanceof ExitControlCommand));
        ExitControlCommand item_ = (ExitControlCommand)item;
    }

    @Test
    public void sendReceiveStartCommand() throws Exception {
        String settingsToApply = "wlsjyvjxwjbmwlxormuieyagajcpmljekwkiqzeetslvdrdpynlkeqghnfuzovpreprkfuytkjuyhyzwirzilyc";
        SALCommand item = this.testSendReceive((SALCommand)new StartCommand(settingsToApply));
        Assert.assertTrue((boolean)(item instanceof StartCommand));
        StartCommand item_ = (StartCommand)item;
        Assert.assertEquals((Object)settingsToApply, (Object)item_.getSettingsToApply());
    }

    @Test
    public void sendReceiveEnterControlCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new EnterControlCommand());
        Assert.assertTrue((boolean)(item instanceof EnterControlCommand));
        EnterControlCommand item_ = (EnterControlCommand)item;
    }

    @Test
    public void sendReceiveSetLogLevelCommand() throws Exception {
        int level = 97;
        SALCommand item = this.testSendReceive((SALCommand)new SetLogLevelCommand(level));
        Assert.assertTrue((boolean)(item instanceof SetLogLevelCommand));
        SetLogLevelCommand item_ = (SetLogLevelCommand)item;
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveSetSimulationModeCommand() throws Exception {
        int mode = 30;
        SALCommand item = this.testSendReceive((SALCommand)new SetSimulationModeCommand(mode));
        Assert.assertTrue((boolean)(item instanceof SetSimulationModeCommand));
        SetSimulationModeCommand item_ = (SetSimulationModeCommand)item;
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSetValueCommand() throws Exception {
        String parametersAndValues = "lrzadpaeuerhlvukfvlofeyceijpjijblghnyjpffbcksxwvwdpuhjtouisgxhtrvwqnmenqiyjgsyfqdeelosixirsmhnddyrhmpolaatatguejjmwmfeoaclwuexojmhlpkystpmanwcangdisqfvxuqwqysiafomtyjrzxwfucn";
        SALCommand item = this.testSendReceive((SALCommand)new SetValueCommand(parametersAndValues));
        Assert.assertTrue((boolean)(item instanceof SetValueCommand));
        SetValueCommand item_ = (SetValueCommand)item;
        Assert.assertEquals((Object)parametersAndValues, (Object)item_.getParametersAndValues());
    }
}

