package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class SoftwareVersionsSettingsAppliedEvent extends CameraEvent {
  private final String mcmVersion;

  private final String ocsbridgeVersion;

  private final String rebPowerVersion;

  private final String rebVersion;

  private final String pduVersion;

  private final String bonnShutterVersion;

  private final String vacuumVersion;

  private final String wrebFirmwareVersion;

  public SoftwareVersionsSettingsAppliedEvent(int priority, String mcmVersion,
      String ocsbridgeVersion, String rebPowerVersion, String rebVersion, String pduVersion,
      String bonnShutterVersion, String vacuumVersion, String wrebFirmwareVersion) {
    super (priority);
    this.mcmVersion = mcmVersion;
    this.ocsbridgeVersion = ocsbridgeVersion;
    this.rebPowerVersion = rebPowerVersion;
    this.rebVersion = rebVersion;
    this.pduVersion = pduVersion;
    this.bonnShutterVersion = bonnShutterVersion;
    this.vacuumVersion = vacuumVersion;
    this.wrebFirmwareVersion = wrebFirmwareVersion;
  }

  public String getMcmVersion() {
    return mcmVersion;
  }

  public String getOcsbridgeVersion() {
    return ocsbridgeVersion;
  }

  public String getRebPowerVersion() {
    return rebPowerVersion;
  }

  public String getRebVersion() {
    return rebVersion;
  }

  public String getPduVersion() {
    return pduVersion;
  }

  public String getBonnShutterVersion() {
    return bonnShutterVersion;
  }

  public String getVacuumVersion() {
    return vacuumVersion;
  }

  public String getWrebFirmwareVersion() {
    return wrebFirmwareVersion;
  }

  @Override
  public String toString() {
    return "SoftwareVersionsSettingsAppliedEvent{" + "mcmVersion=" + mcmVersion +
        ", ocsbridgeVersion=" + ocsbridgeVersion +", rebPowerVersion=" + rebPowerVersion +
        ", rebVersion=" + rebVersion +", pduVersion=" + pduVersion +
        ", bonnShutterVersion=" + bonnShutterVersion +", vacuumVersion=" + vacuumVersion +
        ", wrebFirmwareVersion=" + wrebFirmwareVersion +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String mcmVersion;

    private String ocsbridgeVersion;

    private String rebPowerVersion;

    private String rebVersion;

    private String pduVersion;

    private String bonnShutterVersion;

    private String vacuumVersion;

    private String wrebFirmwareVersion;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder mcmVersion(String mcmVersion) {
      this.mcmVersion = mcmVersion;
      return this;
    }

    public Builder ocsbridgeVersion(String ocsbridgeVersion) {
      this.ocsbridgeVersion = ocsbridgeVersion;
      return this;
    }

    public Builder rebPowerVersion(String rebPowerVersion) {
      this.rebPowerVersion = rebPowerVersion;
      return this;
    }

    public Builder rebVersion(String rebVersion) {
      this.rebVersion = rebVersion;
      return this;
    }

    public Builder pduVersion(String pduVersion) {
      this.pduVersion = pduVersion;
      return this;
    }

    public Builder bonnShutterVersion(String bonnShutterVersion) {
      this.bonnShutterVersion = bonnShutterVersion;
      return this;
    }

    public Builder vacuumVersion(String vacuumVersion) {
      this.vacuumVersion = vacuumVersion;
      return this;
    }

    public Builder wrebFirmwareVersion(String wrebFirmwareVersion) {
      this.wrebFirmwareVersion = wrebFirmwareVersion;
      return this;
    }

    public SoftwareVersionsSettingsAppliedEvent build() {
      return new SoftwareVersionsSettingsAppliedEvent(priority, mcmVersion, ocsbridgeVersion, rebPowerVersion, rebVersion, pduVersion, bonnShutterVersion, vacuumVersion, wrebFirmwareVersion);
    }
  }
}
