package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class SoftwareVersionsSettingsAppliedEvent extends CameraEvent {
  private final String mcmVersion;

  private final String ocsbridgeVersion;

  private final String rebPowerVersion;

  private final String rebVersion;

  private final String pduVersion;

  private final String bonnShutterVersion;

  private final String vacuumVersion;

  private final String wrebFirmwareVersion;

  public SoftwareVersionsSettingsAppliedEvent(int priority, String mcmVersion,
      String ocsbridgeVersion, String rebPowerVersion, String rebVersion, String pduVersion,
      String bonnShutterVersion, String vacuumVersion, String wrebFirmwareVersion) {
    super (priority);
    this.mcmVersion = mcmVersion;
    this.ocsbridgeVersion = ocsbridgeVersion;
    this.rebPowerVersion = rebPowerVersion;
    this.rebVersion = rebVersion;
    this.pduVersion = pduVersion;
    this.bonnShutterVersion = bonnShutterVersion;
    this.vacuumVersion = vacuumVersion;
    this.wrebFirmwareVersion = wrebFirmwareVersion;
  }

  public String getMcmVersion() {
    return mcmVersion;
  }

  public String getOcsbridgeVersion() {
    return ocsbridgeVersion;
  }

  public String getRebPowerVersion() {
    return rebPowerVersion;
  }

  public String getRebVersion() {
    return rebVersion;
  }

  public String getPduVersion() {
    return pduVersion;
  }

  public String getBonnShutterVersion() {
    return bonnShutterVersion;
  }

  public String getVacuumVersion() {
    return vacuumVersion;
  }

  public String getWrebFirmwareVersion() {
    return wrebFirmwareVersion;
  }

  @Override
  public String toString() {
    return "SoftwareVersionsSettingsAppliedEvent{" + "mcmVersion=" + mcmVersion +
        ", ocsbridgeVersion=" + ocsbridgeVersion +", rebPowerVersion=" + rebPowerVersion +
        ", rebVersion=" + rebVersion +", pduVersion=" + pduVersion +
        ", bonnShutterVersion=" + bonnShutterVersion +", vacuumVersion=" + vacuumVersion +
        ", wrebFirmwareVersion=" + wrebFirmwareVersion +"}";
  }
}
