/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALException;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.camera.command.Command_abortCommand;
import org.lsst.sal.camera.command.Command_clearCommand;
import org.lsst.sal.camera.command.Command_disableCalibrationCommand;
import org.lsst.sal.camera.command.Command_disableCommand;
import org.lsst.sal.camera.command.Command_discardRowsCommand;
import org.lsst.sal.camera.command.Command_enableCalibrationCommand;
import org.lsst.sal.camera.command.Command_enableCommand;
import org.lsst.sal.camera.command.Command_endImageCommand;
import org.lsst.sal.camera.command.Command_enterControlCommand;
import org.lsst.sal.camera.command.Command_exitControlCommand;
import org.lsst.sal.camera.command.Command_initGuidersCommand;
import org.lsst.sal.camera.command.Command_initImageCommand;
import org.lsst.sal.camera.command.Command_setLogLevelCommand;
import org.lsst.sal.camera.command.Command_setSimulationModeCommand;
import org.lsst.sal.camera.command.Command_setValueCommand;
import org.lsst.sal.camera.command.Command_standbyCommand;
import org.lsst.sal.camera.command.Command_startCommand;
import org.lsst.sal.camera.command.Command_startImageCommand;
import org.lsst.sal.camera.command.Command_takeImagesCommand;

public class CommandSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALCommand testSendReceive(SALCommand item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALReceivedCommand> future = executor.submit(() -> sal.getNextCommand(Duration.ofSeconds(10L)));
        try {
            SALCommandResponse response = sal.issueCommand(item);
            SALReceivedCommand result = future.get(10L, TimeUnit.SECONDS);
            result.acknowledgeCommand(Duration.ofSeconds(3L));
            result.reportComplete();
            int rc = response.waitForCompletion(Duration.ofSeconds(1L));
            Assert.assertEquals((long)303L, (long)rc);
            SALCommand sALCommand = result.getCommand();
            return sALCommand;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveCommand_discardRowsCommand() throws Exception {
        int nRows = 251;
        SALCommand item = this.testSendReceive((SALCommand)new Command_discardRowsCommand(nRows));
        Assert.assertTrue((boolean)(item instanceof Command_discardRowsCommand));
        Command_discardRowsCommand item_ = (Command_discardRowsCommand)item;
        Assert.assertEquals((long)nRows, (long)item_.getNRows());
    }

    @Test
    public void sendReceiveCommand_startImageCommand() throws Exception {
        boolean shutter = true;
        boolean science = true;
        boolean guide = true;
        boolean wfs = true;
        double timeout = 0.03767293691635132;
        String imageType = "wpxbsikkmfrupntmmanfxxzprxbdbmrieacbccccdwasqkqkjapqpurfghhwtexgjykaqvcmjrqcktmdhqq";
        String groupId = "lbzrtrailuqnxcbyrumurgiceercnibqdfkpblbyqtupjchxfuwvcyqbqmxempreiwvykbcoctqqvphgmozhbvogrutlnfutaeicjgpqqzngepvkoozsxfdgnve";
        SALCommand item = this.testSendReceive((SALCommand)new Command_startImageCommand(shutter, science, guide, wfs, timeout, imageType, groupId));
        Assert.assertTrue((boolean)(item instanceof Command_startImageCommand));
        Command_startImageCommand item_ = (Command_startImageCommand)item;
        Assert.assertEquals((Object)shutter, (Object)item_.isShutter());
        Assert.assertEquals((Object)science, (Object)item_.isScience());
        Assert.assertEquals((Object)guide, (Object)item_.isGuide());
        Assert.assertEquals((Object)wfs, (Object)item_.isWfs());
        Assert.assertEquals((double)timeout, (double)item_.getTimeout(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
    }

    @Test
    public void sendReceiveCommand_disableCalibrationCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new Command_disableCalibrationCommand());
        Assert.assertTrue((boolean)(item instanceof Command_disableCalibrationCommand));
        Command_disableCalibrationCommand item_ = (Command_disableCalibrationCommand)item;
    }

    @Test
    public void sendReceiveCommand_initGuidersCommand() throws Exception {
        String roiSpec = "xuortnjimmdxoxtkqilzpfnvoiybbydygmabfrjukpffmnwkoekwxqcrkmftcfudwlsjyvjxwjbmwlxormuieyagajcpmljekwkiqzeetslvdrdpynlkeqghnfuzovpreprkfuytkjuyhyzwirzilycbyllrzadpaeuerhlvukfvlofeyceijpjijblghnyjpffbcksxwv";
        SALCommand item = this.testSendReceive((SALCommand)new Command_initGuidersCommand(roiSpec));
        Assert.assertTrue((boolean)(item instanceof Command_initGuidersCommand));
        Command_initGuidersCommand item_ = (Command_initGuidersCommand)item;
        Assert.assertEquals((Object)roiSpec, (Object)item_.getRoiSpec());
    }

    @Test
    public void sendReceiveCommand_enableCalibrationCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new Command_enableCalibrationCommand());
        Assert.assertTrue((boolean)(item instanceof Command_enableCalibrationCommand));
        Command_enableCalibrationCommand item_ = (Command_enableCalibrationCommand)item;
    }

    @Test
    public void sendReceiveCommand_initImageCommand() throws Exception {
        double deltaT = 0.2302335500717163;
        SALCommand item = this.testSendReceive((SALCommand)new Command_initImageCommand(deltaT));
        Assert.assertTrue((boolean)(item instanceof Command_initImageCommand));
        Command_initImageCommand item_ = (Command_initImageCommand)item;
        Assert.assertEquals((double)deltaT, (double)item_.getDeltaT(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCommand_endImageCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new Command_endImageCommand());
        Assert.assertTrue((boolean)(item instanceof Command_endImageCommand));
        Command_endImageCommand item_ = (Command_endImageCommand)item;
    }

    @Test
    public void sendReceiveCommand_clearCommand() throws Exception {
        int nClears = 81;
        SALCommand item = this.testSendReceive((SALCommand)new Command_clearCommand(nClears));
        Assert.assertTrue((boolean)(item instanceof Command_clearCommand));
        Command_clearCommand item_ = (Command_clearCommand)item;
        Assert.assertEquals((long)nClears, (long)item_.getNClears());
    }

    @Test
    public void sendReceiveCommand_takeImagesCommand() throws Exception {
        int numImages = 213;
        double expTime = 0.08849042654037476;
        boolean shutter = true;
        boolean science = false;
        boolean guide = false;
        boolean wfs = false;
        String imageType = "isgxhtrvwqnmenqiyjgsyfqdeelosixirsmhnddyrhmpolaatatguejjmwmfeoaclwuexojmhlpkystpmanwcangdisqfvxuqwqysiafomtyjrzxwfucnamoaezfanauhnnootuhjusprpmldiu";
        String groupId = "xsqcaageu";
        SALCommand item = this.testSendReceive((SALCommand)new Command_takeImagesCommand(numImages, expTime, shutter, science, guide, wfs, imageType, groupId));
        Assert.assertTrue((boolean)(item instanceof Command_takeImagesCommand));
        Command_takeImagesCommand item_ = (Command_takeImagesCommand)item;
        Assert.assertEquals((long)numImages, (long)item_.getNumImages());
        Assert.assertEquals((double)expTime, (double)item_.getExpTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)shutter, (Object)item_.isShutter());
        Assert.assertEquals((Object)science, (Object)item_.isScience());
        Assert.assertEquals((Object)guide, (Object)item_.isGuide());
        Assert.assertEquals((Object)wfs, (Object)item_.isWfs());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
    }

    @Test
    public void sendReceiveCommand_abortCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new Command_abortCommand());
        Assert.assertTrue((boolean)(item instanceof Command_abortCommand));
        Command_abortCommand item_ = (Command_abortCommand)item;
    }

    @Test
    public void sendReceiveCommand_enableCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new Command_enableCommand());
        Assert.assertTrue((boolean)(item instanceof Command_enableCommand));
        Command_enableCommand item_ = (Command_enableCommand)item;
    }

    @Test
    public void sendReceiveCommand_disableCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new Command_disableCommand());
        Assert.assertTrue((boolean)(item instanceof Command_disableCommand));
        Command_disableCommand item_ = (Command_disableCommand)item;
    }

    @Test
    public void sendReceiveCommand_standbyCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new Command_standbyCommand());
        Assert.assertTrue((boolean)(item instanceof Command_standbyCommand));
        Command_standbyCommand item_ = (Command_standbyCommand)item;
    }

    @Test
    public void sendReceiveCommand_exitControlCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new Command_exitControlCommand());
        Assert.assertTrue((boolean)(item instanceof Command_exitControlCommand));
        Command_exitControlCommand item_ = (Command_exitControlCommand)item;
    }

    @Test
    public void sendReceiveCommand_startCommand() throws Exception {
        String settingsToApply = "vdyvuwxmpzbhnnlfaodrmazjfkyewrpjmwrtkaigzuaqyzmyymnpodojhymuggilkxlhgpseuuibuyrlojdhzqoveaoljumwxnuioaorfjzvnqofqitxyuovvualrabkzcmdpadrmgbelsctwtzrcarsgmdvjvekeuiuydtesolnht";
        SALCommand item = this.testSendReceive((SALCommand)new Command_startCommand(settingsToApply));
        Assert.assertTrue((boolean)(item instanceof Command_startCommand));
        Command_startCommand item_ = (Command_startCommand)item;
        Assert.assertEquals((Object)settingsToApply, (Object)item_.getSettingsToApply());
    }

    @Test
    public void sendReceiveCommand_enterControlCommand() throws Exception {
        SALCommand item = this.testSendReceive((SALCommand)new Command_enterControlCommand());
        Assert.assertTrue((boolean)(item instanceof Command_enterControlCommand));
        Command_enterControlCommand item_ = (Command_enterControlCommand)item;
    }

    @Test
    public void sendReceiveCommand_setLogLevelCommand() throws Exception {
        int level = 171;
        SALCommand item = this.testSendReceive((SALCommand)new Command_setLogLevelCommand(level));
        Assert.assertTrue((boolean)(item instanceof Command_setLogLevelCommand));
        Command_setLogLevelCommand item_ = (Command_setLogLevelCommand)item;
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveCommand_setSimulationModeCommand() throws Exception {
        int mode = 412;
        SALCommand item = this.testSendReceive((SALCommand)new Command_setSimulationModeCommand(mode));
        Assert.assertTrue((boolean)(item instanceof Command_setSimulationModeCommand));
        Command_setSimulationModeCommand item_ = (Command_setSimulationModeCommand)item;
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveCommand_setValueCommand() throws Exception {
        String parametersAndValues = "vpdyypbtxoocfivmsgrsfuvgtpclhgfkkmzaxdlilkirgkocdikkwpvrrtxwoodkupplkollcjrpomewlsbnekplueqilpcjekrkrzoxdddmstgamvxepfhnbalwbbvpjjlkmgjgegwjxarixcbliiqhlcuvyeokvqfqy";
        SALCommand item = this.testSendReceive((SALCommand)new Command_setValueCommand(parametersAndValues));
        Assert.assertTrue((boolean)(item instanceof Command_setValueCommand));
        Command_setValueCommand item_ = (Command_setValueCommand)item;
        Assert.assertEquals((Object)parametersAndValues, (Object)item_.getParametersAndValues());
    }
}

