package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class ShutterMotionProfileEvent extends CameraEvent {
  private final double measuredExposureTime;

  public ShutterMotionProfileEvent(int priority, double measuredExposureTime) {
    super (priority);
    this.measuredExposureTime = measuredExposureTime;
  }

  public double getMeasuredExposureTime() {
    return measuredExposureTime;
  }

  @Override
  public String toString() {
    return "ShutterMotionProfileEvent{" + "measuredExposureTime=" + measuredExposureTime +"}";
  }
}
