package org.lsst.sal.atcamera.event;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraEvent;

public class ImageReadoutParametersEvent extends CameraEvent {
  private final String imageName;

  private final int imageIndex;

  private final String ccdNames;

  private final CcdType ccdType;

  private final int overRows;

  private final int overCols;

  private final int readRows;

  private final int readCols;

  private final int readCols2;

  private final int preCols;

  private final int preRows;

  private final int postCols;

  public ImageReadoutParametersEvent(int priority, String imageName, int imageIndex,
      String ccdNames, CcdType ccdType, int overRows, int overCols, int readRows, int readCols,
      int readCols2, int preCols, int preRows, int postCols) {
    super (priority);
    this.imageName = imageName;
    this.imageIndex = imageIndex;
    this.ccdNames = ccdNames;
    this.ccdType = ccdType;
    this.overRows = overRows;
    this.overCols = overCols;
    this.readRows = readRows;
    this.readCols = readCols;
    this.readCols2 = readCols2;
    this.preCols = preCols;
    this.preRows = preRows;
    this.postCols = postCols;
  }

  public String getImageName() {
    return imageName;
  }

  public int getImageIndex() {
    return imageIndex;
  }

  public String getCcdNames() {
    return ccdNames;
  }

  public CcdType getCcdType() {
    return ccdType;
  }

  public int getOverRows() {
    return overRows;
  }

  public int getOverCols() {
    return overCols;
  }

  public int getReadRows() {
    return readRows;
  }

  public int getReadCols() {
    return readCols;
  }

  public int getReadCols2() {
    return readCols2;
  }

  public int getPreCols() {
    return preCols;
  }

  public int getPreRows() {
    return preRows;
  }

  public int getPostCols() {
    return postCols;
  }

  @Override
  public String toString() {
    return "ImageReadoutParametersEvent{" + "imageName=" + imageName +", imageIndex=" + imageIndex +
        ", ccdNames=" + ccdNames +", ccdType=" + ccdType +", overRows=" + overRows +
        ", overCols=" + overCols +", readRows=" + readRows +", readCols=" + readCols +
        ", readCols2=" + readCols2 +", preCols=" + preCols +", preRows=" + preRows +
        ", postCols=" + postCols +"}";
  }

  public enum CcdType implements SALEnum {
    E2V,

    ITL
  }
}
