/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.telemetry.BonnShutterTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebTelemetry;
import org.lsst.sal.camera.telemetry.HeartbeatTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveHeartbeatTelemetry() throws Exception {
        boolean heartbeat = true;
        int priority = 878;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new HeartbeatTelemetry(heartbeat, priority));
        Assert.assertTrue((boolean)(item instanceof HeartbeatTelemetry));
        HeartbeatTelemetry item_ = (HeartbeatTelemetry)item;
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveWrebTelemetry() throws Exception {
        float ckPSH_V = 0.09803194f;
        float ckPOV = 0.6892715f;
        float ogoV = 0.398157f;
        float temp1 = 0.13042718f;
        float temp2 = 0.034231484f;
        float temp3 = 0.69723445f;
        float temp4 = 0.63129085f;
        float temp5 = 0.41550487f;
        float temp6 = 0.19414717f;
        float atemp0U = 0.7746595f;
        float atemp0L = 0.82122225f;
        float ccdTemp0 = 0.86134493f;
        float digPS_V = 0.9449492f;
        float digPS_I = 0.8186742f;
        float anaPS_V = 0.06312513f;
        float anaPS_I = 0.731778f;
        float clkHPS_V = 0.24170566f;
        float clkHPS_I = 0.9763653f;
        float odPS_V = 0.81531787f;
        float odPS_I = 0.8984127f;
        float htrPS_V = 0.6960816f;
        float htrPS_I = 0.50960386f;
        float power = 0.122396946f;
        float sckU_V = 0.7142266f;
        float sckL_V = 0.78804517f;
        float rgU_V = 0.015918374f;
        float rgL_V = 0.6688567f;
        float cks0V = 0.10010642f;
        float rg0V = 0.7925052f;
        float od0V = 0.25043708f;
        float rd0V = 0.3443914f;
        float gd0V = 0.32303882f;
        float od0I = 0.30688143f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WrebTelemetry(ckPSH_V, ckPOV, ogoV, temp1, temp2, temp3, temp4, temp5, temp6, atemp0U, atemp0L, ccdTemp0, digPS_V, digPS_I, anaPS_V, anaPS_I, clkHPS_V, clkHPS_I, odPS_V, odPS_I, htrPS_V, htrPS_I, power, sckU_V, sckL_V, rgU_V, rgL_V, cks0V, rg0V, od0V, rd0V, gd0V, od0I));
        Assert.assertTrue((boolean)(item instanceof WrebTelemetry));
        WrebTelemetry item_ = (WrebTelemetry)item;
        Assert.assertEquals((float)ckPSH_V, (float)item_.getCkPSH_V(), (float)1.0E-6f);
        Assert.assertEquals((float)ckPOV, (float)item_.getCkPOV(), (float)1.0E-6f);
        Assert.assertEquals((float)ogoV, (float)item_.getOgoV(), (float)1.0E-6f);
        Assert.assertEquals((float)temp1, (float)item_.getTemp1(), (float)1.0E-6f);
        Assert.assertEquals((float)temp2, (float)item_.getTemp2(), (float)1.0E-6f);
        Assert.assertEquals((float)temp3, (float)item_.getTemp3(), (float)1.0E-6f);
        Assert.assertEquals((float)temp4, (float)item_.getTemp4(), (float)1.0E-6f);
        Assert.assertEquals((float)temp5, (float)item_.getTemp5(), (float)1.0E-6f);
        Assert.assertEquals((float)temp6, (float)item_.getTemp6(), (float)1.0E-6f);
        Assert.assertEquals((float)atemp0U, (float)item_.getAtemp0U(), (float)1.0E-6f);
        Assert.assertEquals((float)atemp0L, (float)item_.getAtemp0L(), (float)1.0E-6f);
        Assert.assertEquals((float)ccdTemp0, (float)item_.getCcdTemp0(), (float)1.0E-6f);
        Assert.assertEquals((float)digPS_V, (float)item_.getDigPS_V(), (float)1.0E-6f);
        Assert.assertEquals((float)digPS_I, (float)item_.getDigPS_I(), (float)1.0E-6f);
        Assert.assertEquals((float)anaPS_V, (float)item_.getAnaPS_V(), (float)1.0E-6f);
        Assert.assertEquals((float)anaPS_I, (float)item_.getAnaPS_I(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHPS_V, (float)item_.getClkHPS_V(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHPS_I, (float)item_.getClkHPS_I(), (float)1.0E-6f);
        Assert.assertEquals((float)odPS_V, (float)item_.getOdPS_V(), (float)1.0E-6f);
        Assert.assertEquals((float)odPS_I, (float)item_.getOdPS_I(), (float)1.0E-6f);
        Assert.assertEquals((float)htrPS_V, (float)item_.getHtrPS_V(), (float)1.0E-6f);
        Assert.assertEquals((float)htrPS_I, (float)item_.getHtrPS_I(), (float)1.0E-6f);
        Assert.assertEquals((float)power, (float)item_.getPower(), (float)1.0E-6f);
        Assert.assertEquals((float)sckU_V, (float)item_.getSckU_V(), (float)1.0E-6f);
        Assert.assertEquals((float)sckL_V, (float)item_.getSckL_V(), (float)1.0E-6f);
        Assert.assertEquals((float)rgU_V, (float)item_.getRgU_V(), (float)1.0E-6f);
        Assert.assertEquals((float)rgL_V, (float)item_.getRgL_V(), (float)1.0E-6f);
        Assert.assertEquals((float)cks0V, (float)item_.getCks0V(), (float)1.0E-6f);
        Assert.assertEquals((float)rg0V, (float)item_.getRg0V(), (float)1.0E-6f);
        Assert.assertEquals((float)od0V, (float)item_.getOd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)rd0V, (float)item_.getRd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)gd0V, (float)item_.getGd0V(), (float)1.0E-6f);
        Assert.assertEquals((float)od0I, (float)item_.getOd0I(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveBonnShutterTelemetry() throws Exception {
        float shutter5V = 0.7918167f;
        float shutter36V = 0.01320219f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new BonnShutterTelemetry(shutter5V, shutter36V));
        Assert.assertTrue((boolean)(item instanceof BonnShutterTelemetry));
        BonnShutterTelemetry item_ = (BonnShutterTelemetry)item;
        Assert.assertEquals((float)shutter5V, (float)item_.getShutter5V(), (float)1.0E-6f);
        Assert.assertEquals((float)shutter36V, (float)item_.getShutter36V(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveWrebPowerTelemetry() throws Exception {
        float digital_V = 0.34309655f;
        float digital_I = 0.9203204f;
        float analog_V = 0.6411802f;
        float analog_I = 0.9889153f;
        float clkHigh_V = 0.47263974f;
        float clkHigh_I = 0.3076918f;
        float clkLow_V = 0.4680584f;
        float clkLow_I = 0.26654428f;
        float od_V = 0.6449888f;
        float od_I = 0.31182122f;
        float dphi_V = 0.19246304f;
        float dphi_I = 0.62379634f;
        float heater_V = 0.3165757f;
        float heater_I = 0.7989621f;
        float hvbias_V = 0.37942272f;
        float hvbias_I = 0.12457782f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WrebPowerTelemetry(digital_V, digital_I, analog_V, analog_I, clkHigh_V, clkHigh_I, clkLow_V, clkLow_I, od_V, od_I, dphi_V, dphi_I, heater_V, heater_I, hvbias_V, hvbias_I));
        Assert.assertTrue((boolean)(item instanceof WrebPowerTelemetry));
        WrebPowerTelemetry item_ = (WrebPowerTelemetry)item;
        Assert.assertEquals((float)digital_V, (float)item_.getDigital_V(), (float)1.0E-6f);
        Assert.assertEquals((float)digital_I, (float)item_.getDigital_I(), (float)1.0E-6f);
        Assert.assertEquals((float)analog_V, (float)item_.getAnalog_V(), (float)1.0E-6f);
        Assert.assertEquals((float)analog_I, (float)item_.getAnalog_I(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHigh_V, (float)item_.getClkHigh_V(), (float)1.0E-6f);
        Assert.assertEquals((float)clkHigh_I, (float)item_.getClkHigh_I(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLow_V, (float)item_.getClkLow_V(), (float)1.0E-6f);
        Assert.assertEquals((float)clkLow_I, (float)item_.getClkLow_I(), (float)1.0E-6f);
        Assert.assertEquals((float)od_V, (float)item_.getOd_V(), (float)1.0E-6f);
        Assert.assertEquals((float)od_I, (float)item_.getOd_I(), (float)1.0E-6f);
        Assert.assertEquals((float)dphi_V, (float)item_.getDphi_V(), (float)1.0E-6f);
        Assert.assertEquals((float)dphi_I, (float)item_.getDphi_I(), (float)1.0E-6f);
        Assert.assertEquals((float)heater_V, (float)item_.getHeater_V(), (float)1.0E-6f);
        Assert.assertEquals((float)heater_I, (float)item_.getHeater_I(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbias_V, (float)item_.getHvbias_V(), (float)1.0E-6f);
        Assert.assertEquals((float)hvbias_I, (float)item_.getHvbias_I(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuumTelemetry() throws Exception {
        float tempCCD = 0.9272175f;
        float tempColdPlate = 0.8417255f;
        float tempCryoHead = 0.12413114f;
        float vacuum = 0.51453984f;
        float tempCCDSetPoint = 0.6842864f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new VacuumTelemetry(tempCCD, tempColdPlate, tempCryoHead, vacuum, tempCCDSetPoint));
        Assert.assertTrue((boolean)(item instanceof VacuumTelemetry));
        VacuumTelemetry item_ = (VacuumTelemetry)item;
        Assert.assertEquals((float)tempCCD, (float)item_.getTempCCD(), (float)1.0E-6f);
        Assert.assertEquals((float)tempColdPlate, (float)item_.getTempColdPlate(), (float)1.0E-6f);
        Assert.assertEquals((float)tempCryoHead, (float)item_.getTempCryoHead(), (float)1.0E-6f);
        Assert.assertEquals((float)vacuum, (float)item_.getVacuum(), (float)1.0E-6f);
        Assert.assertEquals((float)tempCCDSetPoint, (float)item_.getTempCCDSetPoint(), (float)1.0E-6f);
    }
}

