/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atcamera.event.BonnShutterSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.ImageReadoutParametersEvent;
import org.lsst.sal.atcamera.event.SettingsAppliedEvent;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.atcamera.event.SoftwareVersionsSettingsAppliedEvent;
import org.lsst.sal.atcamera.event.WrebSettingsAppliedEvent;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = ATCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 190;
        String imageType = "yzkchujmsoynpdaobosbnvaqpqbwcwopreybzpbsajryjnegvmcstfbbblnhzowivzorqcfe";
        String groupId = "d";
        int imagesInSequence = 330;
        String imageName = "pffyoozlesdckkxau";
        int imageIndex = 449;
        String imageSource = "j";
        String imageController = "";
        String imageDate = "uag";
        int imageNumber = 121;
        double timeStampAcquisitionStart = 0.12108564376831055;
        double exposureTime = 0.39221322536468506;
        double timeStampEndOfReadout = 0.8009426593780518;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampEndOfReadout, (double)item_.getTimeStampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 439;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 528;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 726;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 458;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 729;
        String imageType = "vmueolsyotiiwwktnbppqswarjdvmqyjsggyhpeieyhmxsthjqexhvrnvehtzzyacghyievhzqndcmiedpvlosnkjzjuuelccashwbzlwlvxlrubehevrqjukuesnyzotxvwbpeikmvlpfktaxpdxmlyolrslvuhwmyfmtnpkaiuymsozvlmwvpvwsczyygfqxmcaepcvj";
        String groupId = "feydnqcekdxmbehtlyeunqviofvbjifmszhikjkwjedzeimvffipgumgxuxbpunhjralcafgn";
        int imagesInSequence = 927;
        String imageName = "doxlp";
        int imageIndex = 772;
        String imageSource = "f";
        String imageController = "";
        String imageDate = "xr";
        int imageNumber = 970;
        double timeStampAcquisitionStart = 0.5889905095100403;
        double exposureTime = 0.862678587436676;
        String imageTag = "zxxzkwwneoogvaqaqwbdxpekigtoptrbizuvelqbeqaztjdw";
        double timestampDateObs = 0.11279827356338501;
        double timestampDateEnd = 0.8843053579330444;
        double expTime = 0.9963942170143127;
        double darkTime = 0.4767602f;
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, expTime, darkTime));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)expTime, (double)item_.getExpTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 123;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 920;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 308;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 941;
        String imageType = "fzmbojfboddazlbejnzmrgoqsnypfrtnqtmoqgwhd";
        String groupId = "jgfblquwnporwzppfwqkbngkuzdwzidmnqjbswmaywayynowtrwnulfacxhnmwrnxiv";
        int imagesInSequence = 481;
        String imageName = "zbatnddascitoz";
        int imageIndex = 483;
        String imageSource = "c";
        String imageController = "";
        String imageDate = "vyqfaa";
        int imageNumber = 629;
        double timeStampAcquisitionStart = 0.46924442052841187;
        double exposureTime = 0.2972654700279236;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 257;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 113;
        String imageType = "rogiabrydtauvlrcbinovajubbdnysrmhrewmxjjnfoobpzsyvmzwrgadvcldlwmkltbvrhgvouipdzgrdpesevgjslvnvaabfgnhxtvojhrbbbatioozejufjdcygrtsrcekkmppbabqpewcaumtxwnnhxdxousukjpdoiujcivovaqkmutsjsdwutkucxnkmcaokqn";
        String groupId = "aqvhcnrspiofdrptratbkajdbywwqebdasnjlscwtzrsustgxfzgxavknpsuwcsxplckkhnlmimbwcdzkopkhrdbeqjbjivltq";
        int imagesInSequence = 556;
        String imageName = "vksqdwsrdkragxankbz";
        int imageIndex = 609;
        String imageSource = "q";
        String imageController = "";
        String imageDate = "cmlofj";
        int imageNumber = 895;
        double timeStampAcquisitionStart = 0.6774181127548218;
        double exposureTime = 0.07293188571929932;
        double timeStampStartOfReadout = 0.2858484983444214;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampStartOfReadout, (double)item_.getTimeStampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveShutterMotionProfileEvent() throws Exception {
        int priority = 381;
        double measuredExposureTime = 0.042186856269836426;
        SALEvent item = this.testSendReceive((SALEvent)new ShutterMotionProfileEvent(priority, measuredExposureTime));
        Assert.assertTrue((boolean)(item instanceof ShutterMotionProfileEvent));
        ShutterMotionProfileEvent item_ = (ShutterMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)measuredExposureTime, (double)item_.getMeasuredExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 947;
        String imageName = "nfpgmqupgyxtuvgsklntesqjwhetavdyxrdiukvymcttfohealssscajwuwnukbfxsomuctoauuxmjjgnwqp";
        int imageIndex = 683;
        String ccdNames = "dpctesikdvbkudtgpjdpmotwmouafgbkkjjgxccdyvuoherhkxhnkkckkfqeyvmoyupmrcntbzfyselziwzdafualjcejeewreankfo";
        ImageReadoutParametersEvent.CcdType ccdType = ImageReadoutParametersEvent.CcdType.E2V;
        int overRows = 580;
        int overCols = 397;
        int readRows = 819;
        int readCols = 129;
        int readCols2 = 897;
        int preCols = 525;
        int preRows = 729;
        int postCols = 449;
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, imageIndex, ccdNames, ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)ccdNames, (Object)item_.getCcdNames());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 297;
        String settings = "kfuqlpt";
        int version = 784;
        String wrebSettingsVersion = "hqwocmidhftfrbbvuqffcgfrzdbygnrqkkvbbieyykwpejjulnyzoqlplwaljyjzrnavkzkpecckdjdgwsspqdhxsrhhzcjfsgzljzdbejtqhztxvrgspliwuqzuglcmmagvqp";
        String bonnShutterSettingsVersion = "corirrijxkadmahkdaswumkakrxjiyc";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settings, version, wrebSettingsVersion, bonnShutterSettingsVersion));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settings, (Object)item_.getSettings());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)wrebSettingsVersion, (Object)item_.getWrebSettingsVersion());
        Assert.assertEquals((Object)bonnShutterSettingsVersion, (Object)item_.getBonnShutterSettingsVersion());
    }

    @Test
    public void sendReceiveBonnShutterSettingsAppliedEvent() throws Exception {
        int priority = 827;
        int version = 749;
        float startA = 0.7011619f;
        float startB = 0.48478824f;
        float travelDistance = 0.7149278f;
        float startVelocity = 0.17381781f;
        float acceleration = 0.22563612f;
        float maxVelocity = 0.5550899f;
        float threshold = 0.61069804f;
        String shutterVersion = "ydlaqcyvbkexxkzwvxeobydhcqlgeapbvsgxkhyzcyctfskkygismzzzgwqqnubltxijrcbkwyyktoniqxoiiejiqhkhlzxzryrppjgktyuidsadlrqycmwzfugrhrwlveqejngcsnjnephetgmsiibgdriudkkgalhgsvpsvezzhsjwhuwstk";
        String firmwareVersion = "pshewoapenvgtmubdmhuyapritluircfwgqcvlfkmkxcpmsylccjokqqhxmncebblhkdblsqslavgmlnjxhoehsowscimqglhewdwngqrbehdscepwhxmvkmfzxbywzkvvdwpdneimnnnsixrkvjbnlpnezxwubjqcttkadygrjzmarfgbbmfwpjagbpgydzuxqeadhsupppvdtuq";
        SALEvent item = this.testSendReceive((SALEvent)new BonnShutterSettingsAppliedEvent(priority, version, startA, startB, travelDistance, startVelocity, acceleration, maxVelocity, threshold, shutterVersion, firmwareVersion));
        Assert.assertTrue((boolean)(item instanceof BonnShutterSettingsAppliedEvent));
        BonnShutterSettingsAppliedEvent item_ = (BonnShutterSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((float)startA, (float)item_.getStartA(), (float)1.0E-6f);
        Assert.assertEquals((float)startB, (float)item_.getStartB(), (float)1.0E-6f);
        Assert.assertEquals((float)travelDistance, (float)item_.getTravelDistance(), (float)1.0E-6f);
        Assert.assertEquals((float)startVelocity, (float)item_.getStartVelocity(), (float)1.0E-6f);
        Assert.assertEquals((float)acceleration, (float)item_.getAcceleration(), (float)1.0E-6f);
        Assert.assertEquals((float)maxVelocity, (float)item_.getMaxVelocity(), (float)1.0E-6f);
        Assert.assertEquals((float)threshold, (float)item_.getThreshold(), (float)1.0E-6f);
        Assert.assertEquals((Object)shutterVersion, (Object)item_.getShutterVersion());
        Assert.assertEquals((Object)firmwareVersion, (Object)item_.getFirmwareVersion());
    }

    @Test
    public void sendReceiveWrebSettingsAppliedEvent() throws Exception {
        int priority = 439;
        int version = 275;
        String sequencerKey = "jcmhhhsohdszawjbsjgdrjuebfzwbdmatcfqfcmcjgbxmyihihxpsmyievkzlpvwvjtqmxjfrdjghvqyzdkbqolftkmqgbyctwbyltjtpojslrvqygvliyeusxsqvhxqmallgvbdariwdizmdsvane";
        int sequencerChecksum = 842;
        int daqVersion = 665;
        int firmwareVersion = 6;
        int aspic0_af1 = 161;
        int aspic0_clamp = 345;
        int aspic0_gain = 972;
        int aspic0_rc = 118;
        int aspic0_tm = 189;
        int aspic1_af1 = 10;
        int aspic1_clamp = 608;
        int aspic1_gain = 125;
        int aspic1_rc = 324;
        int aspic1_tm = 753;
        int bias0_csGate = 435;
        int bias0_csGateP = 313;
        int bias0_gd = 325;
        int bias0_gdP = 604;
        int bias0_od = 67;
        int bias0_odP = 68;
        int bias0_og = 867;
        int bias0_ogP = 132;
        int bias0_ogSh = 591;
        int bias0_rd = 161;
        int bias0_rdP = 806;
        int dac_csGate = 645;
        int dac_pclkHigh = 784;
        int dac_pclkHighP = 374;
        int dac_pclkHighSh = 239;
        int dac_pclkLow = 453;
        int dac_pclkLowP = 955;
        int dac_pclkLowSh = 258;
        int dac_rgHigh = 104;
        int dac_rgHighP = 993;
        int dac_rgHighSh = 206;
        int dac_rgLow = 421;
        int dac_rgLowP = 246;
        int dac_rgLowSh = 347;
        int dac_sclkHigh = 780;
        int dac_sclkHighP = 735;
        int dac_sclkHighSh = 989;
        int dac_sclkLow = 232;
        int dac_sclkLowP = 975;
        int dac_sclkLowSh = 88;
        String ccdManufacturer = "t";
        String ccdType = "rzkxdjnzdsbm";
        String ccdSerialNumber = "jrckapm";
        String ccdName = "zuhhkmm";
        String rebName = "xwypgnofrlqqq";
        String rebSerialNumber = "quqmsyg";
        SALEvent item = this.testSendReceive((SALEvent)new WrebSettingsAppliedEvent(priority, version, sequencerKey, sequencerChecksum, daqVersion, firmwareVersion, aspic0_af1, aspic0_clamp, aspic0_gain, aspic0_rc, aspic0_tm, aspic1_af1, aspic1_clamp, aspic1_gain, aspic1_rc, aspic1_tm, bias0_csGate, bias0_csGateP, bias0_gd, bias0_gdP, bias0_od, bias0_odP, bias0_og, bias0_ogP, bias0_ogSh, bias0_rd, bias0_rdP, dac_csGate, dac_pclkHigh, dac_pclkHighP, dac_pclkHighSh, dac_pclkLow, dac_pclkLowP, dac_pclkLowSh, dac_rgHigh, dac_rgHighP, dac_rgHighSh, dac_rgLow, dac_rgLowP, dac_rgLowSh, dac_sclkHigh, dac_sclkHighP, dac_sclkHighSh, dac_sclkLow, dac_sclkLowP, dac_sclkLowSh, ccdManufacturer, ccdType, ccdSerialNumber, ccdName, rebName, rebSerialNumber));
        Assert.assertTrue((boolean)(item instanceof WrebSettingsAppliedEvent));
        WrebSettingsAppliedEvent item_ = (WrebSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((long)sequencerChecksum, (long)item_.getSequencerChecksum());
        Assert.assertEquals((long)daqVersion, (long)item_.getDaqVersion());
        Assert.assertEquals((long)firmwareVersion, (long)item_.getFirmwareVersion());
        Assert.assertEquals((long)aspic0_af1, (long)item_.getAspic0_af1());
        Assert.assertEquals((long)aspic0_clamp, (long)item_.getAspic0_clamp());
        Assert.assertEquals((long)aspic0_gain, (long)item_.getAspic0_gain());
        Assert.assertEquals((long)aspic0_rc, (long)item_.getAspic0_rc());
        Assert.assertEquals((long)aspic0_tm, (long)item_.getAspic0_tm());
        Assert.assertEquals((long)aspic1_af1, (long)item_.getAspic1_af1());
        Assert.assertEquals((long)aspic1_clamp, (long)item_.getAspic1_clamp());
        Assert.assertEquals((long)aspic1_gain, (long)item_.getAspic1_gain());
        Assert.assertEquals((long)aspic1_rc, (long)item_.getAspic1_rc());
        Assert.assertEquals((long)aspic1_tm, (long)item_.getAspic1_tm());
        Assert.assertEquals((long)bias0_csGate, (long)item_.getBias0_csGate());
        Assert.assertEquals((long)bias0_csGateP, (long)item_.getBias0_csGateP());
        Assert.assertEquals((long)bias0_gd, (long)item_.getBias0_gd());
        Assert.assertEquals((long)bias0_gdP, (long)item_.getBias0_gdP());
        Assert.assertEquals((long)bias0_od, (long)item_.getBias0_od());
        Assert.assertEquals((long)bias0_odP, (long)item_.getBias0_odP());
        Assert.assertEquals((long)bias0_og, (long)item_.getBias0_og());
        Assert.assertEquals((long)bias0_ogP, (long)item_.getBias0_ogP());
        Assert.assertEquals((long)bias0_ogSh, (long)item_.getBias0_ogSh());
        Assert.assertEquals((long)bias0_rd, (long)item_.getBias0_rd());
        Assert.assertEquals((long)bias0_rdP, (long)item_.getBias0_rdP());
        Assert.assertEquals((long)dac_csGate, (long)item_.getDac_csGate());
        Assert.assertEquals((long)dac_pclkHigh, (long)item_.getDac_pclkHigh());
        Assert.assertEquals((long)dac_pclkHighP, (long)item_.getDac_pclkHighP());
        Assert.assertEquals((long)dac_pclkHighSh, (long)item_.getDac_pclkHighSh());
        Assert.assertEquals((long)dac_pclkLow, (long)item_.getDac_pclkLow());
        Assert.assertEquals((long)dac_pclkLowP, (long)item_.getDac_pclkLowP());
        Assert.assertEquals((long)dac_pclkLowSh, (long)item_.getDac_pclkLowSh());
        Assert.assertEquals((long)dac_rgHigh, (long)item_.getDac_rgHigh());
        Assert.assertEquals((long)dac_rgHighP, (long)item_.getDac_rgHighP());
        Assert.assertEquals((long)dac_rgHighSh, (long)item_.getDac_rgHighSh());
        Assert.assertEquals((long)dac_rgLow, (long)item_.getDac_rgLow());
        Assert.assertEquals((long)dac_rgLowP, (long)item_.getDac_rgLowP());
        Assert.assertEquals((long)dac_rgLowSh, (long)item_.getDac_rgLowSh());
        Assert.assertEquals((long)dac_sclkHigh, (long)item_.getDac_sclkHigh());
        Assert.assertEquals((long)dac_sclkHighP, (long)item_.getDac_sclkHighP());
        Assert.assertEquals((long)dac_sclkHighSh, (long)item_.getDac_sclkHighSh());
        Assert.assertEquals((long)dac_sclkLow, (long)item_.getDac_sclkLow());
        Assert.assertEquals((long)dac_sclkLowP, (long)item_.getDac_sclkLowP());
        Assert.assertEquals((long)dac_sclkLowSh, (long)item_.getDac_sclkLowSh());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertEquals((Object)ccdType, (Object)item_.getCcdType());
        Assert.assertEquals((Object)ccdSerialNumber, (Object)item_.getCcdSerialNumber());
        Assert.assertEquals((Object)ccdName, (Object)item_.getCcdName());
        Assert.assertEquals((Object)rebName, (Object)item_.getRebName());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
    }

    @Test
    public void sendReceiveSoftwareVersionsSettingsAppliedEvent() throws Exception {
        int priority = 160;
        String mcmVersion = "fjxopcqrhqrccyewhzxmdehl";
        String ocsbridgeVersion = "lmiwt";
        String rebPowerVersion = "xk";
        String rebVersion = "rfomsur";
        String pduVersion = "dqxqozczofzqdggsjnxvpszait";
        String bonnShutterVersion = "zrf";
        String vacuumVersion = "kvrdhfkeeta";
        String wrebFirmwareVersion = "qziiovpskmlwnjnoiawtuh";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsSettingsAppliedEvent(priority, mcmVersion, ocsbridgeVersion, rebPowerVersion, rebVersion, pduVersion, bonnShutterVersion, vacuumVersion, wrebFirmwareVersion));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsSettingsAppliedEvent));
        SoftwareVersionsSettingsAppliedEvent item_ = (SoftwareVersionsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)mcmVersion, (Object)item_.getMcmVersion());
        Assert.assertEquals((Object)ocsbridgeVersion, (Object)item_.getOcsbridgeVersion());
        Assert.assertEquals((Object)rebPowerVersion, (Object)item_.getRebPowerVersion());
        Assert.assertEquals((Object)rebVersion, (Object)item_.getRebVersion());
        Assert.assertEquals((Object)pduVersion, (Object)item_.getPduVersion());
        Assert.assertEquals((Object)bonnShutterVersion, (Object)item_.getBonnShutterVersion());
        Assert.assertEquals((Object)vacuumVersion, (Object)item_.getVacuumVersion());
        Assert.assertEquals((Object)wrebFirmwareVersion, (Object)item_.getWrebFirmwareVersion());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 568;
        String recommendedSettingsVersion = "";
        String recommendedSettingsLabels = "";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 991;
        int errorCode = 641;
        String errorReport = "";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 818;
        boolean appliedSettingsMatchStartIsTrue = true;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 6;
        int level = 594;
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 905;
        int level = 96;
        String message = "";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, level, message, traceback));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 143;
        int mode = 734;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 306;
        String salVersion = "kvavxjzzgbtt";
        String xmlVersion = "kigmaslsh";
        String openSpliceVersion = "ykwcs";
        String cscVersion = "";
        String subsystemVersions = "";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 150;
        boolean heartbeat = false;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }
}

