/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.sequencer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.web.sequencer.WaveformHistory;

class WaveformHistory {
    private static final int MAX_HISTORY_SIZE = 10000000;
    private final List<WaveformHistoryEntry> history = new ArrayList();

    WaveformHistory() {
    }

    void add(WaveformHistoryEntry entry) {
        if (this.history.size() > 10000000) {
            throw new RuntimeException("Max History size exceeded");
        }
        this.history.add(entry);
    }

    private int computeBinningFactor(int totalBins) {
        return totalBins > 10000000 ? 10000 : (totalBins > 1000000 ? 1000 : (totalBins > 100000 ? 100 : (totalBins > 10000 ? 10 : (totalBins > 2000 ? 2 : 1))));
    }

    Map<String, Object> possiblySparsify(Map<String, Integer> labels) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int binning = this.computeBinningFactor(this.history.size());
        if (binning > 1) {
            List sparsifiedData = this.sparsifyData(this.history, labels, binning);
            result.put("binning", binning);
            result.put("sparsified", sparsifiedData);
        } else {
            result.put("data", this.history);
        }
        return result;
    }

    List<TransmogrifiedHistoryEntry> zoom(Map<String, Integer> labels, int min, int max, int binFactor) {
        List subList = this.history.subList(min, Math.min(max, this.history.size()));
        return this.sparsifyData(subList, labels, binFactor);
    }

    private List<TransmogrifiedHistoryEntry> sparsifyData(List<WaveformHistoryEntry> data, Map<String, Integer> labels, int binFactor) {
        ArrayList<TransmogrifiedHistoryEntry> sparsifiedData = new ArrayList<TransmogrifiedHistoryEntry>();
        int[] bitOrder = new int[labels.size()];
        int l = 0;
        for (int bit : labels.values()) {
            bitOrder[l++] = bit;
        }
        long binStart = 0L;
        int bins = 0;
        int[] sum = new int[32];
        for (int i = 0; i < data.size(); ++i) {
            WaveformHistoryEntry h = data.get(i);
            if (bins == 0) {
                binStart = h.getTime();
            }
            int bit = 0;
            for (int out = h.getOut(); bit < 32 && out != 0; out >>= 1) {
                int n = bit++;
                sum[n] = sum[n] + (out & 1);
            }
            if (++bins != binFactor && i < data.size() - 2) continue;
            float[] averages = new float[bitOrder.length];
            for (int k = 0; k < bitOrder.length; ++k) {
                int bit2 = bitOrder[k];
                averages[k] = (float)(k * 2) + (float)sum[bit2] / (float)bins;
            }
            TransmogrifiedHistoryEntry tw = new TransmogrifiedHistoryEntry(binStart, averages);
            sparsifiedData.add(tw);
            Arrays.fill(sum, 0);
            bins = 0;
        }
        return sparsifiedData;
    }
}

