package org.lsst.ccs.web.sequencer;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.media.multipart.FormDataParam;

/**
 * The restful interface for the sequencer server, implemented using Jersey and Jackson
 * (which make it pretty trivial).
 * @author tonyj
 */
@Path("/")
@Produces(MediaType.APPLICATION_JSON)
public class SequencerWebInterface {

    private static final SequencerEncapsulation encapsulation = new SequencerEncapsulation();

    @Path("zoom")
    @GET
    public Object zoom(@QueryParam("min") int min, @QueryParam("max") int max, @QueryParam("bins") int bins) throws IOException {
        return encapsulation.zoom(min, max, bins);
    }

    @Path("set")
    @GET
    public Object set(@Context UriInfo uriInfo) throws IOException, InterruptedException, ExecutionException {
        return encapsulation.set(uriInfo.getQueryParameters());
    }

    @Path("run/{id}/{address}")
    @GET
    public Object run(@PathParam("id") String  key, @PathParam("address") int  address) throws IOException, InterruptedException, ExecutionException {
        return encapsulation.run(key, address);
    }

    @Path("upload")
    @POST
    @Consumes(MediaType.MULTIPART_FORM_DATA)
    public Object upload(@FormDataParam("file") InputStream in) throws IOException {
        return encapsulation.read(in);
    }
}
