/* global Dygraph */

var data = [['a', 'b', 'c', 'd']];
var transmogrifiedData;
var sparsifiedData;
var sparsificationFactor;
var zoomed = false;
var rangeSelectorActive = false;
var graph;
var labels;
var labelData;
function setupGraph(element) {
    graph = new Dygraph(element,
            // For possible data formats, see http://dygraphs.com/data.html
            // The x-values could also be dates, e.g. "2012/03/1
            data,
            {
                // options go here. See http://dygraphs.com/options.html
                legend: 'always',
                animatedZooms: true,
                title: 'Waveforms',
                stepPlot: true,
                showRangeSelector: true,
                ylabel: 'Outputs',
                xlabel: 'Time since start (nS)',
                interactionModel: Dygraph.Interaction.defaultModel,
                customBars: true,
                axes: {
                    y: {
                        valueFormatter: function (y, opts, series_name) {
                            return y % 2;
                        }
                    },
                    x: {
                        axisLabelFormatter: function (x) {
                            return x;
                        }
                    }
                },
                zoomCallback: function (min, max, yRanges) {
                    console.log("zoom " + min + " " + max + " " + yRanges);
                    if (!rangeSelectorActive)
                        handleZoom(min, max);
                },
                labelsDivWidth: 800
            });
    // Element used for tracking mouse up events
    var mouseUpEventEl = $(window);
    if ($.support.cssFloat === false) { //IE<=8, doesn't support mouse events on window
        mouseUpEventEl = $(document.body);
    }

    // Find the range selector, and add mouse buttons
    var rangeEl = $("#graph").find('.dygraph-rangesel-fgcanvas, .dygraph-rangesel-zoomhandle');
    console.log("rangeEL=" + rangeEl);
    rangeEl.off("mousedown.jgs touchstart.jgs");
    rangeEl.on("mousedown.jgs touchstart.jgs", function (evt) {
        rangeSelectorActive = true;
        console.log("Mousedown");
        mouseUpEventEl.off('mouseup.jgs touchend.jgs');
        mouseUpEventEl.on('mouseup.jgs touchend.jgs', function (evt) {
            mouseUpEventEl.off('mouseup.jgs touchend.jgs');
            console.log("Mouseup");
            rangeSelectorActive = false;
            //Get the new detail window extents
            var graphAxisX = graph.xAxisRange();
            handleZoom(graphAxisX[0], graphAxisX[1]);
        });
    });
    //Save original endPan function
    var origEndPan = Dygraph.Interaction.endPan;
    //Replace built-in handling with our own function
    Dygraph.Interaction.endPan = function (event, g, context) {

        //Call the original to let it do it's magic
        origEndPan(event, g, context);
        //Extract new start/end from the x-axis

        console.log("End pan");
        //Get the new detail window extents
        var graphAxisX = g.xAxisRange();
        handleZoom(graphAxisX[0], graphAxisX[1]);
    };
    Dygraph.endPan = Dygraph.Interaction.endPan; //see dygraph-interaction-model.js
}

function handleZoom(min, max) {
    console.log("handleZoom " + min + " " + max);
    if (sparsifiedData !== undefined) {
        var minMax = binEdges(sparsifiedData, min, max);
        var binsInZoom = (minMax[1] - minMax[0]) * sparsificationFactor;
        var zoomRegionSparsification = computeBinningFactor(binsInZoom);
        console.log(minMax + " " + binsInZoom + " " + zoomRegionSparsification);
        if (sparsificationFactor !== zoomRegionSparsification) {
            var minBin = minMax[0] * sparsificationFactor;
            var maxBin = minMax[1] * sparsificationFactor;
            if (transmogrifiedData) {
                var resparsify = resparsifyData(transmogrifiedData, minBin, maxBin, zoomRegionSparsification);
                console.log("I resparsified " + resparsify.length);
                var zoomData = sparsifiedData.slice(0, minMax[0]);
                zoomData = zoomData.concat(resparsify);
                zoomData = zoomData.concat(sparsifiedData.slice(minMax[1]));
                console.log("I zoomed " + zoomData.length + " " + zoomData[0][0] + " " + zoomData[zoomData.length - 1][0]);
                graph.updateOptions({file: zoomData});
                zoomed = true;
            } else {
                // We need to go back to the server for more data!
                var args = {"min": minBin, "max": maxBin, "bins": zoomRegionSparsification};
                $.get('rest/zoom',args, function (res) {
                    console.log(res);
                    resparsify = res;
                    var zoomData = sparsifiedData.slice(0, minMax[0]);
                    zoomData = zoomData.concat(resparsify);
                    zoomData = zoomData.concat(sparsifiedData.slice(minMax[1]));
                    console.log("I zoomed " + zoomData.length + " " + zoomData[0][0] + " " + zoomData[zoomData.length - 1][0]);
                    graph.updateOptions({file: zoomData});
                    zoomed = true;
                }, "json");
            }

        } else if (zoomed) {
            graph.updateOptions({file: sparsifiedData});
            zoomed = false;
            console.log("I am unzooming");
        }
    }
}

function setLabels(data) {
    labelData = data;
    labels = [];
    labels.push("time");
    for (var key in labelData) {
        console.log("key=" + key);
        labels.push(key);
    }
    graph.updateOptions({labels: labels, axes: {y: {ticker: tickerFunction}}});
}

function handleResponseData(res) {
    if (res.data) {
        handleWaveformData(res.data);
    } else if (res.sparsified) {
        handleSparsifiedData(res);
    }
}

function handleWaveformData(data) {

    transmogrifiedData = transmogrify(data, labelData);
    console.log("I transmogified the data " + transmogrifiedData.length);
    sparsificationFactor = computeBinningFactor(data.length);
    console.log("Factor=" + sparsificationFactor + " " + data.length);
    sparsifiedData = sparsifyData(transmogrifiedData, sparsificationFactor);
    console.log("I sparsified the data " + sparsifiedData.length + " " + sparsifiedData[0][0] + " " + sparsifiedData[sparsifiedData.length - 1][0]);
    graph.updateOptions({file: sparsifiedData, labels: labels});
    graph.resetZoom();
}

function handleSparsifiedData(data) {
    transmogrifiedData = undefined;
    sparsificationFactor = data.binning;
    sparsifiedData = data.sparsified;
    console.log("I got sparsified data " + sparsifiedData.length + " " + sparsifiedData[0][0] + " " + sparsifiedData[sparsifiedData.length - 1][0]);
    graph.updateOptions({file: sparsifiedData, labels: labels});
    graph.resetZoom();
}

function binEdges(data, min, max) {
    var firstBin, lastBin;
    for (var i in sparsifiedData) {
        var x = data[i][0];
        if (x > min && firstBin === undefined) {
            firstBin = i - 1;
        } else if (x > max && lastBin === undefined) {
            lastBin = i;
        }
    }
    if (lastBin === undefined)
        lastBin = data.length;
    return [firstBin, lastBin];
}

function transmogrify(rawData, labelData) {
    var processedData = [];
    var totalBins = rawData.length;
    for (var i = 0; i < totalBins; i++) {
        var d = rawData[i];
        var row = [d[0]];
        var out = d[2];
        var j = 0;
        for (var key in labelData) {
            rowValue = (out & 1 << labelData[key]) !== 0 ? j * 2 + 1 : j * 2;
            row.push([rowValue, rowValue, rowValue]);
            j++;
        }
        processedData.push(row);
    }
    return processedData;
}

function resparsifyData(data, minBin, maxBin, binFactor) {
    var slicedData = data.slice(minBin, maxBin);
    return sparsifyData(slicedData, binFactor);
}

function sparsifyData(data, binFactor) {
    if (binFactor === 1)
        return data;
    else {
        // Currently we are sparsifying based on # bins, not binWidth
        var processedData = [];
        var avg = new Array(data[0].length);
        avg.fill(0);
        var bins = 0;
        for (var i = 0; i < data.length; i++) {
            var d = data[i];
            for (var j = 0; j < d.length; j++) {
                if (j === 0) {
                    if (bins === 0)
                        avg[j] = d[j];
                } else {
                    avg[j] += d[j][0];
                }
            }
            bins += 1;
            // Note, this ensures we keep the last point unmodified
            if (bins === binFactor || i >= data.length - 2) {
                for (var j = 0; j < avg.length; j++) {
                    if (j !== 0)
                        avg[j] /= bins;
                }
                var row = new Array(avg.length);
                for (var k = 0; k < avg.length; k++) {
                    if (k === 0) {
                        row[k] = avg[k];
                    } else {
                        row[k] = [Math.floor(avg[k]), avg[k], Math.ceil(avg[k])];
                    }
                }
                processedData.push(row);
                bins = 0;
                avg.fill(0);
            }
        }
        return processedData;
    }
}
function computeBinningFactor(totalBins) {
    return totalBins > 10000000 ? 10000
            : totalBins > 1000000 ? 1000
            : totalBins > 100000 ? 100
            : totalBins > 10000 ? 10
            : totalBins > 2000 ? 2 : 1;
}

function tickerFunction(min, max, pixels, opts, dygraph, vals) {
    var result = [];
    for (var i in labels) {
        if (i > 0) {
            result.push({v: (i - 1) * 2, label: graph.getLabels()[i]});
        }
    }
    return result;
}
