package org.lsst.ccs.web.sequencer;

import com.sun.net.httpserver.HttpServer;
import org.glassfish.jersey.jdkhttp.JdkHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

/**
 * This class allows the Jersey application to be run as a standalone
 * application, or embedded within a Java program.
 *
 */
public class Main {

    // Base URI the HTTP server will listen on
    public static final String BASE_URI = "http://localhost:8888/seq/";

    /**
     * Starts HTTP server exposing JAX-RS resources defined in this application.
     *
     * @return HTTP server.
     * @throws java.io.IOException
     */
    public static HttpServer startServer() throws IOException {
        // create a resource config 
        final ResourceConfig rc = new MyConfiguration();

        // create and start a new instance of http server
        // exposing the Jersey application at BASE_URI
        return JdkHttpServerFactory.createHttpServer(URI.create(BASE_URI), rc);
    }

    /**
     * Main method.
     *
     * @param args
     * @throws IOException
     * @throws java.net.URISyntaxException
     */
    public static void main(String[] args) throws IOException, URISyntaxException {
        final HttpServer server = startServer();
        System.out.println(String.format("Jersey app started with WADL available at "
                + "%sapplication.wadl\nHit enter to stop it...", BASE_URI));
        System.in.read();
        server.stop(0);
    }
}

