package org.lsst.ccs.web.sequencer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

/**
 * Register custom jackson serializers for Waveform histories.
 * @author tonyj
 */
@Provider
@Produces("application/json")
public class JacksonConfigurator implements ContextResolver<ObjectMapper> {

    private final ObjectMapper mapper = new ObjectMapper();

    public JacksonConfigurator() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(WaveformHistory.WaveformHistoryEntry.class, new WaveformHistoryEntrySerializer());
        module.addSerializer(WaveformHistory.TransmogrifiedHistoryEntry.class, new TransmogrifiedHistoryEntrySerializer());
        mapper.registerModule(module);
    }

    @Override
    public ObjectMapper getContext(Class<?> type) {
        return mapper;
    }

    private static class WaveformHistoryEntrySerializer extends JsonSerializer<WaveformHistory.WaveformHistoryEntry> {

        @Override
        public void serialize(WaveformHistory.WaveformHistoryEntry value, JsonGenerator jgen, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            jgen.writeStartArray();
            jgen.writeNumber(value.getTime());
            jgen.writeNumber(value.getCurrentFunction());
            jgen.writeNumber(value.getOut());
            jgen.writeEndArray();
        }
    }

    private static class TransmogrifiedHistoryEntrySerializer extends JsonSerializer<WaveformHistory.TransmogrifiedHistoryEntry> {

        @Override
        public void serialize(WaveformHistory.TransmogrifiedHistoryEntry value, JsonGenerator jgen, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            jgen.writeStartArray();
            jgen.writeNumber(value.getBinStart());
            for (float a : value.getAverages()) {
                jgen.writeStartArray();
                jgen.writeNumber(Math.floor(a));
                jgen.writeNumber(a);
                jgen.writeNumber(Math.ceil(a));
                jgen.writeEndArray();
            }
            jgen.writeEndArray();
        }
    }
}
