/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.sequencer;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.core.MultivaluedMap;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulation;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;
import org.lsst.ccs.web.sequencer.SequencerEncapsulation;
import org.lsst.ccs.web.sequencer.WaveformHistory;

class SequencerEncapsulation {
    private AddressSpace addressSpace;
    private SequencerSimulation sequencer;
    private FPGA2Model model;
    private boolean sequencerReady = false;
    private int max_repetitions = 3;
    private WaveformHistory history;

    SequencerEncapsulation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> runSequencer() throws InterruptedException, ExecutionException {
        WaveformHistoryListener listener = new WaveformHistoryListener();
        this.sequencer.addWaveformListener((SequencerSimulation.WaveformListener)listener);
        this.sequencer.addFunctionListener((SequencerSimulation.FunctionListener)listener);
        this.sequencer.setMaxFunctionRepetitions(this.max_repetitions);
        this.sequencer.setMaxSubroutineRepetitions(this.max_repetitions);
        this.sequencer.setRenormalization(this.max_repetitions);
        this.addressSpace.write(3735553, 1);
        try {
            Future future = this.sequencer.start();
            SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
            System.out.println("State=" + state.getStateAtEnd());
        }
        finally {
            this.sequencer.removeWaveformListener((SequencerSimulation.WaveformListener)listener);
            this.sequencer.removeFunctionListener((SequencerSimulation.FunctionListener)listener);
        }
        this.history = listener.getHistory();
        return this.history.possiblySparsify(this.model.getChannels());
    }

    Map<String, Object> read(InputStream in) throws IOException {
        FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
        this.addressSpace = new AddressSpace();
        this.sequencer = new SequencerSimulation(this.addressSpace);
        this.model = builder.compileFile(in);
        this.model.getMemoryMap().stream().forEach(data -> this.addressSpace.write(data.getAddress(), data.getValue()));
        this.sequencerReady = false;
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("constants", this.model.getMetadata());
        response.put("channels", this.model.getChannels());
        response.put("functions", this.model.getFunctionAddresses());
        response.put("subroutines", this.model.getSubroutineAddresses());
        response.put("mains", this.model.getMainAddresses());
        response.put("pointers", this.model.getPointers());
        return response;
    }

    Map<String, Object> run(String key, int address) throws InterruptedException, ExecutionException {
        switch (key) {
            case "function": {
                int function = address;
                int program = 3146750;
                this.addressSpace.write(program++, 0x10000000 | function << 24 | 1);
                this.addressSpace.write(program++, -268435456);
                this.addressSpace.write(0x340000, 1022);
                break;
            }
            case "subroutine": {
                int subroutine = address;
                int program = 3146750;
                this.addressSpace.write(program++, 0x50000000 | subroutine << 16 | 1);
                this.addressSpace.write(program++, -268435456);
                this.addressSpace.write(0x340000, 1022);
                break;
            }
            case "main": {
                this.addressSpace.write(0x340000, address);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized key " + key);
            }
        }
        this.sequencerReady = true;
        return this.runSequencer();
    }

    Map<String, Object> set(MultivaluedMap<String, String> parameters) throws InterruptedException, ExecutionException {
        String message = "?";
        String max = (String)parameters.getFirst((Object)"max-repetitions");
        if (max != null) {
            this.max_repetitions = Integer.parseInt(max);
            message = "OK";
        }
        if (this.model != null) {
            for (FPGA2Model.PointerInfo pointer : this.model.getPointers()) {
                String value = (String)parameters.getFirst((Object)pointer.getName());
                if (value == null) continue;
                this.addressSpace.write(pointer.getAddress(), Integer.parseInt(value));
                message = "OK";
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("message", message);
        if (this.sequencerReady) {
            result.putAll(this.runSequencer());
        }
        return result;
    }

    Object zoom(int min, int max, int bins) {
        return this.history.zoom(this.model.getChannels(), min, max, bins);
    }
}

