/*
 * associated an image with many clickable zones. Each zone is associated to a JPAnel 
 * witch appears when a zone (Shape) is mouseclicked
 */
package org.lsst.ccs.utilities.zonesui;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;

/**
 *
 * @author Pascal Durieu
 */
public class ImageZones extends JPanel implements MouseListener, MouseMotionListener {

    /**
	 * 
	 */
	private static final long serialVersionUID = 8019109714890653849L;

	//Map whith the Shapes define the clickables zones (key)
    private List<Zone> tableShape;
    
    //description of the image & clickable zones
    private ImageDescription description;
    private ImageIcon icon;
    private Image img;
    private Dimension dim;
    private Stroke stroke = new BasicStroke(3.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER, 5.0f, new float[] {5.0f}, 0.0f);
    private Color color = Color.BLACK ;

    //associating the key (clickable zones) with a JPanel
    private InteractionProducer interaction;
    private PositionListener posListener ;

    //display mousecoords
    private String message = "";
    int messageX = 0, messageY = 0; 
       
    public ImageZones(ImageDescription id, InteractionProducer ip, PositionListener posListener) {
        this.description = id;
        this.interaction = ip;
        this.posListener = posListener ;
        
        icon = id.getIcon();
        tableShape = id.getShapeDescription();
        img = icon.getImage();
        dim = new Dimension(icon.getIconWidth(),icon.getIconHeight());        

        addMouseListener(this);
        addMouseMotionListener(this);
    }
    @Override
    public Dimension getMinimumSize() {
        Dimension dim2 = new Dimension(icon.getIconWidth()/2,icon.getIconHeight()/2);
        return dim2;
    }
    @Override
    public Dimension getMaximumSize() {return dim;}
    @Override
    public Dimension getPreferredSize() {return dim;}

    public Stroke getStroke() {
        return stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setDashedLineWidth(int points){
        float width = (float) points ;
        this.setStroke( new BasicStroke(width, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER, 5.0f, new float[] {5.0f}, 0.0f));
    }

    public Color getDashedLineColor() {
        return color;
    }

    public void setDashedLineColor(Color color) {
        this.color = color;
    }

    //drawing the image and clickable zones
    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g2);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        
        //drawn image
        g2.drawImage(img, 0, 0, img.getWidth(this), img.getHeight(this), this);
        
        //drawn the clickable zones
        g2.setColor(getDashedLineColor());
        g2.setStroke(getStroke());
        for(Zone zone: tableShape) {
            g2.draw(zone.getShape());
        }

        //TODO: get this out and put it in a different JLAbel
        //simple mouse coords
        g2.setColor(Color.BLACK);
        messageY = g2.getFont().getSize();
        g2.drawString(message, messageX, messageY); 
    }

    //when clicked on a shape identified as a clickable zone,
    //a JDialog is loading, displayed a JPanel
    @Override
    public void mouseClicked(MouseEvent e) {
        Point pt = e.getPoint();
        for(Zone zone : tableShape) {
            if (zone.getShape().contains(pt)) {
                String key = zone.getKey();
                JPanel jpan = interaction.getInteraction(key);
                if (jpan != null) {
                    ClickDialog cd = new ClickDialog(SwingUtilities.windowForComponent(this),key, false, jpan);   
                    //System.out.println(interaction.getInteraction(key).toString()+" [key = "+key+"]");
                    cd.setLocation(e.getXOnScreen(), e.getYOnScreen());  
                }
                else {
                    JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this),
                        "JPanel not found for the key \""+key+"\"",
                         "JPanel error",
                         JOptionPane.ERROR_MESSAGE);
                }
                break;
            }
        }
    }
    
    @Override
    public void mouseMoved(MouseEvent me) {
        Point pt = me.getPoint();
        String tooltipText="" ;
        for(Zone zone : tableShape) {
            if (zone.getShape().contains(pt)) {
                tooltipText = zone.getTipText();
                break ;
            }
        }
        this.setToolTipText(tooltipText);
        //: put message in a different JLabel : do not call repaint!
        if(posListener != null) {
            posListener.currentCoords(me.getX(), me.getY());
        }
        //message= "("+me.getX()+", "+me.getY()+")";
        // repaint();
    }
   
    @Override
    public void mousePressed(MouseEvent e) {}
    @Override
    public void mouseReleased(MouseEvent e) {}
    @Override
    public void mouseEntered(MouseEvent me) {}
    @Override
    public void mouseExited(MouseEvent me) {}
    @Override
    public void mouseDragged(MouseEvent me) {}

}

