/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.conv;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;

public class TypeUtilsTest {
    Map emptyMap = new HashMap();
    Map<String, String> map = new HashMap<String, String>();
    Map<String, Integer> mapIntegers = new HashMap<String, Integer>();

    @Test
    public void testTypeUtils() throws Exception {
        String s = "astring";
        String res = TypeUtils.stringify((Object)s);
        Assert.assertEquals((Object)s, (Object)res);
        this.map.put("1", "abc");
        this.map.put("2", "def");
        this.map.put("3", "2");
        res = TypeUtils.stringify(this.map);
        Assert.assertEquals((Object)"[1:abc,2:def,3:2]", (Object)res);
        Map map2 = (Map)InputConversionEngine.convertArgToType((String)res, (Type)this.getClass().getDeclaredField("map").getGenericType());
        Assert.assertEquals(this.map, (Object)map2);
        this.mapIntegers.put("one", 1);
        this.mapIntegers.put("two", 2);
        this.mapIntegers.put("three", 3);
        res = TypeUtils.stringify(this.mapIntegers);
        Assert.assertEquals((Object)"[one:1,three:3,two:2]", (Object)res);
        Map mapIntegers2 = (Map)InputConversionEngine.convertArgToType((String)res, (Type)this.getClass().getDeclaredField("mapIntegers").getGenericType());
        Assert.assertEquals(this.mapIntegers, (Object)mapIntegers2);
        Object[] arrayObj = new Object[]{1, "2", 3.14, null};
        ArrayList<Object> listObj = new ArrayList<Object>();
        listObj.addAll(Arrays.asList(arrayObj));
        LinkedHashMap<String, Object> mapObj = new LinkedHashMap<String, Object>();
        mapObj.put("asArray", arrayObj);
        mapObj.put("asList", listObj);
        mapObj.put("null", null);
        res = TypeUtils.stringify(mapObj);
        Assert.assertEquals((Object)"[asArray:[1,2,3.14,_null_],asList:[1,2,3.14,_null_],null:_null_]", (Object)res);
        res = TypeUtils.stringify((Object)this.emptyMap);
        Assert.assertEquals((Object)"[]", (Object)res);
        Map m = (Map)InputConversionEngine.convertArgToType((String)res, (Type)this.getClass().getDeclaredField("emptyMap").getGenericType());
        Assert.assertTrue((boolean)m.isEmpty());
        m = (Map)InputConversionEngine.convertArgToType((String)"[    ]", (Type)this.getClass().getDeclaredField("emptyMap").getGenericType());
        Assert.assertTrue((boolean)m.isEmpty());
    }

    @Test
    public void testArraySaving() throws Exception {
        Object[] strArray = new String[]{"a", "b", "c", "1", "2", "3"};
        String res = TypeUtils.stringify((Object)strArray);
        Assert.assertEquals((Object)"[a,b,c,1,2,3]", (Object)res);
        Object[] rebuilt = (String[])InputConversionEngine.convertArgToType((String)res, String[].class);
        Assert.assertArrayEquals((Object[])strArray, (Object[])rebuilt);
        String res2 = TypeUtils.stringify((Object)rebuilt);
        Assert.assertEquals((Object)res, (Object)res2);
    }
}

