package org.lsst.ccs.utilities.logging;

/**
 * manages formatting of stackTrace.
 * @implNote
 * For the time being there is a global depth of StackTrace for all formatters that use
 * the static <TT>toString</TT> method.
 * HTis could be changed in the future and we my have a different depth for each <TT>Formatter</TT>
 * @author bamade
 */
// Date: 15/04/2014

public class StackTraceFormats {
    private static int depth = -1;
    private static volatile boolean modified = false;

    public static int getDepth() {
        return depth;
    }

    public static void setDepth(int depth) {
        StackTraceFormats.depth = depth;
        modified = true;
    }

    public static void setDepthFromInitialProperties() {
        if (modified) return;
        int depth = LogPropertiesLoader.loaderGetIntProperty("org.lsst.ccs.logging.StackTraceFormats.depth", -1);
        setDepth(depth);

    }

    /**
     * formats the StackTrace of a <TT>Throwable</TT>.
     * @param throwable
     * @return
     */
    public static String toString(Throwable throwable) {
        return toString(throwable,1) ;
    }

    /**
     * recursive method to format a <TT>Throwable</TT>
     * @param throwable
     * @param level is 1 the first time then incremented each time an additional level of recursion is added
     * @return
     */
    public static String toString(Throwable throwable, int level) {
        StringBuilder stb = new StringBuilder(String.valueOf(throwable)).append('\n');
        StackTraceElement[] traces = throwable.getStackTrace();
        for (StackTraceElement trace : traces) {
            indent(stb, level).append(trace).append('\n');
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            indent(stb, level - 1).append("caused by : ").append(toString(cause, level + 1));
        }
        return stb.toString();
    }

    private static StringBuilder indent(StringBuilder stb, int level) {
        for (int ix = 0; ix <= level; ix++) {
            stb.append("  ");
        }
        return stb;
    }
}
