package org.lsst.ccs.utilities.logging;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

import java.util.logging.ErrorManager;

/**
 * simple bridge from Log4J to JUL.
 * (some code copied from Apache but adapted to our needs)
 *
 * @author bamade
 */
// Date: 03/06/13

public class JULAppender  extends AppenderSkeleton{

    static enum Levelz {
         ALL (java.util.logging.Level.ALL),
         	DEBUG (java.util.logging.Level.FINE),
        	ERROR (java.util.logging.Level.SEVERE),
        	FATAL (java.util.logging.Level.SEVERE),
         	INFO (java.util.logging.Level.INFO),
         	OFF (java.util.logging.Level.OFF),
         	TRACE (java.util.logging.Level.FINER),
         	WARN  (java.util.logging.Level.WARNING);

        java.util.logging.Level julLevel ;
        Levelz(java.util.logging.Level julLevel) {
            this.julLevel = julLevel ;
        }
        public java.util.logging.Level getJulLevel() {
            return this.julLevel ;
        }
    }
    /** Creates a new appender with no special layout */
    public JULAppender() {
    }

    /** Creates a new appender with the specified layout */
    public JULAppender(Layout layout) {
        setLayout(layout);
    }

    @Override
    protected void append(LoggingEvent loggingEvent) {
        org.lsst.ccs.utilities.logging.Logger logger = Logger
                .getLogger(loggingEvent.getLoggerName());
        if(logger == null) {
            new ErrorManager().error("cannot link log4J code for "+ loggingEvent.getLoggerName(), null, ErrorManager.GENERIC_FAILURE);
            return ;
        }
        String msg;
        if (layout != null) {
            msg = layout.format(loggingEvent);
        } else {
            msg = loggingEvent.getRenderedMessage();
        }
        String log4jLevelName = loggingEvent.getLevel().toString();
        Levelz levelz = Levelz.valueOf(log4jLevelName) ;
        ThrowableInformation ti = loggingEvent.getThrowableInformation();
        if (ti == null) {
            logger.logMessage(levelz.getJulLevel(), msg);
        }
        else {
            logger.logSimpleThrowable(levelz.getJulLevel(), msg,
                                      ti.getThrowable());
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }
}
