/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.conv;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;

public class ConversionConsistensyTest {
    private final Map<String, Integer> aMap = new HashMap<String, Integer>();
    private final List<Double> aList = new ArrayList<Double>();

    @Test
    public void testMapConversion() throws Exception {
        this.aMap.put("first", 1);
        this.aMap.put("second", 2);
        this.aMap.put("first", 3);
        Type mapType = this.getClass().getDeclaredField("aMap").getGenericType();
        new InputConversionEngine();
        Object res = InputConversionEngine.convertArgToType((String)TypeUtils.stringify(this.aMap), (Type)mapType);
        Assert.assertTrue((boolean)Map.class.isAssignableFrom(res.getClass()));
        Assert.assertEquals(this.aMap, (Object)res);
        Assert.assertEquals((Object)this.aMap.get("first"), ((Map)res).get("first"));
        Assert.assertEquals((Object)this.aMap.get("second"), ((Map)res).get("second"));
        Assert.assertEquals((Object)this.aMap.get("third"), ((Map)res).get("third"));
    }

    @Test
    public void testArrayConversion() throws Exception {
        double[] array = new double[]{1.0, 10.0, 3.14};
        new InputConversionEngine();
        Object res = InputConversionEngine.convertArgToType((String)TypeUtils.stringify((Object)array), array.getClass());
        Assert.assertArrayEquals((double[])array, (double[])((double[])res), (double)0.1);
    }

    @Test
    public void testListConversion() throws Exception {
        this.aList.add(3.14);
        this.aList.add(98.0);
        Type listType = this.getClass().getDeclaredField("aList").getGenericType();
        new InputConversionEngine();
        Object res = InputConversionEngine.convertArgToType((String)TypeUtils.stringify(this.aList), (Type)listType);
        Assert.assertTrue((boolean)List.class.isAssignableFrom(res.getClass()));
        Assert.assertEquals(this.aList, (Object)res);
    }
}

